/*
 * Decompiled with CFR 0.152.
 */
package groove.prolog;

import gnu.prolog.database.PrologTextLoaderError;
import gnu.prolog.io.ParseException;
import gnu.prolog.io.ReadOptions;
import gnu.prolog.io.TermReader;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.Environment;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import groove.grammar.model.FormatErrorSet;
import groove.grammar.model.FormatException;
import groove.prolog.GrooveEnvironment;
import groove.prolog.GrooveState;
import groove.prolog.QueryResult;
import groove.prolog.QueryReturnValue;
import groove.prolog.util.TermConverter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PrologEngine {
    private final GrooveEnvironment env;
    private Interpreter interpreter;
    private InternalQueryResult currentResult;

    public PrologEngine(GrooveEnvironment environment) throws FormatException {
        this.env = environment;
        this.init();
    }

    public void setGrooveState(GrooveState grooveState) {
        this.getEnvironment().setGrooveState(grooveState);
    }

    private void init() throws FormatException {
        this.currentResult = null;
        this.interpreter = this.getEnvironment().createInterpreter();
        this.getEnvironment().runInitialization(this.interpreter);
        FormatErrorSet errors = new FormatErrorSet();
        for (PrologTextLoaderError error : this.getEnvironment().getLoadingErrors()) {
            errors.add("%s", error.getMessage(), error.getLine(), error.getColumn());
        }
        errors.throwException();
    }

    public QueryResult newQuery(String term) throws FormatException, PrologException {
        if (this.currentResult != null && this.currentResult.getReturnValue() == QueryReturnValue.SUCCESS) {
            this.interpreter.stop(this.currentResult.getGoal());
        }
        ReadOptions readOpts = new ReadOptions(this.getEnvironment().getOperatorSet());
        TermReader termReader = new TermReader((Reader)new StringReader(term), (Environment)this.getEnvironment());
        try {
            Term goalTerm = termReader.readTermEof(readOpts);
            Interpreter.Goal goal = this.interpreter.prepareGoal(goalTerm);
            this.currentResult = new InternalQueryResult(goal, term);
            this.currentResult.rawVars = readOpts.variableNames;
            termReader.close();
            return this.next();
        }
        catch (ParseException e) {
            throw new FormatException("Parse error in Prolog program: %s", e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public QueryResult current() {
        return this.currentResult;
    }

    public QueryResult next() throws PrologException {
        if (this.currentResult == null) {
            return null;
        }
        if (this.currentResult.isLastResult()) {
            return null;
        }
        long startTime = System.nanoTime();
        int rc = this.interpreter.execute(this.currentResult.goal);
        long stopTime = System.nanoTime();
        if (this.currentResult.getReturnValue() != QueryReturnValue.NOT_RUN) {
            this.currentResult = new InternalQueryResult(this.currentResult);
        }
        this.currentResult.setReturnValue(QueryReturnValue.fromInt(rc));
        this.currentResult.setExecutionTime(stopTime - startTime);
        if (this.currentResult.getReturnValue() != QueryReturnValue.FAIL && this.currentResult.getReturnValue() != QueryReturnValue.HALT) {
            this.currentResult.setVariables(TermConverter.convert(this.currentResult.rawVars));
        }
        return this.currentResult;
    }

    public boolean hasNext() {
        return this.currentResult != null && !this.currentResult.isLastResult();
    }

    public QueryReturnValue lastReturnValue() {
        if (this.currentResult != null) {
            return this.currentResult.getReturnValue();
        }
        return QueryReturnValue.NOT_RUN;
    }

    public GrooveEnvironment getEnvironment() {
        return this.env;
    }

    protected static class InternalQueryResult
    implements QueryResult {
        protected Interpreter.Goal goal;
        protected String query = "";
        protected QueryReturnValue returnValue = QueryReturnValue.NOT_RUN;
        protected long executionTime = -1L;
        protected InternalQueryResult previousResult;
        protected InternalQueryResult nextResult;
        protected Map<String, Object> variables = new HashMap<String, Object>();
        protected Map<String, VariableTerm> rawVars;

        protected InternalQueryResult(Interpreter.Goal goal, String query) {
            this.goal = goal;
            this.query = query;
        }

        protected InternalQueryResult(InternalQueryResult previous) {
            this.previousResult = previous;
            this.previousResult.nextResult = this;
            this.goal = this.previousResult.goal;
            this.query = this.previousResult.query;
            this.rawVars = this.previousResult.rawVars;
        }

        protected Interpreter.Goal getGoal() {
            return this.goal;
        }

        protected void setExecutionTime(long value) {
            this.executionTime = value;
        }

        protected void setReturnValue(QueryReturnValue value) {
            this.returnValue = value;
        }

        @Override
        public long getExecutionTime() {
            return this.executionTime;
        }

        public void setVariables(Map<String, Object> values) {
            this.variables = new HashMap<String, Object>(values);
        }

        @Override
        public QueryReturnValue getReturnValue() {
            return this.returnValue;
        }

        @Override
        public Map<String, Object> getVariables() {
            return Collections.unmodifiableMap(this.variables);
        }

        @Override
        public boolean isLastResult() {
            return this.returnValue == QueryReturnValue.SUCCESS_LAST || this.returnValue == QueryReturnValue.FAIL || this.returnValue == QueryReturnValue.HALT;
        }

        @Override
        public QueryResult getNextResult() {
            return this.nextResult;
        }

        @Override
        public QueryResult getPreviousResult() {
            return this.previousResult;
        }

        @Override
        public String getQuery() {
            return this.query;
        }
    }
}

