/*
 * Decompiled with CFR 0.152.
 */
package groove.prolog.builtin.algebra;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.FloatTerm;
import gnu.prolog.term.IntegerTerm;
import gnu.prolog.term.JavaObjectTerm;
import gnu.prolog.term.Term;
import gnu.prolog.vm.Environment;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import groove.algebra.Algebra;
import groove.algebra.Constant;
import groove.grammar.host.ValueNode;
import groove.prolog.builtin.algebra.AlgebraPrologCode;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Predicate_convert_valuenode
extends AlgebraPrologCode {
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        try {
            JavaObjectTerm result;
            ValueNode node = Predicate_convert_valuenode.getValueNode(args[0]);
            Algebra<?> alg = node.getAlgebra();
            Object value = node.getValue();
            switch (alg.getKind()) {
                case BOOL: {
                    result = new JavaObjectTerm(value);
                    break;
                }
                case INT: {
                    Integer intValue;
                    switch (alg.getFamily()) {
                        case DEFAULT: {
                            intValue = (Integer)value;
                            break;
                        }
                        case BIG: {
                            intValue = ((BigInteger)value).intValue();
                            break;
                        }
                        case POINT: {
                            intValue = Integer.parseInt((String)value);
                            break;
                        }
                        case TERM: {
                            intValue = Integer.parseInt(((Constant)value).getSymbol());
                            break;
                        }
                        default: {
                            intValue = null;
                            assert (false);
                            break;
                        }
                    }
                    result = IntegerTerm.get((int)intValue);
                    break;
                }
                case REAL: {
                    Double realValue;
                    switch (alg.getFamily()) {
                        case DEFAULT: {
                            realValue = (Double)value;
                            break;
                        }
                        case BIG: {
                            realValue = ((BigDecimal)value).doubleValue();
                            break;
                        }
                        case POINT: {
                            realValue = Double.parseDouble((String)value);
                            break;
                        }
                        case TERM: {
                            realValue = Double.parseDouble(((Constant)value).getSymbol());
                            break;
                        }
                        default: {
                            realValue = null;
                            assert (false);
                            break;
                        }
                    }
                    result = new FloatTerm(realValue.doubleValue());
                    break;
                }
                case STRING: {
                    String stringValue;
                    switch (alg.getFamily()) {
                        case DEFAULT: 
                        case POINT: 
                        case BIG: {
                            stringValue = (String)value;
                            break;
                        }
                        case TERM: {
                            stringValue = ((Constant)value).getSymbol();
                            break;
                        }
                        default: {
                            stringValue = null;
                            assert (false);
                            break;
                        }
                    }
                    result = AtomTerm.get((String)stringValue);
                    break;
                }
                default: {
                    result = null;
                    assert (false);
                    break;
                }
            }
            return interpreter.unify(args[1], (Term)result);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    @Override
    public void install(Environment env) {
    }

    @Override
    public void uninstall(Environment env) {
    }
}

