/*
 * Decompiled with CFR 0.152.
 */
package groove.sts;

import groove.sts.InteractionVariable;
import groove.sts.Variable;
import java.util.Set;

public class Gate {
    private String label;
    private Set<InteractionVariable> iVars;

    public Gate(String label, Set<InteractionVariable> iVars) {
        this.label = label;
        this.iVars = iVars;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Gate)) {
            return false;
        }
        Gate other = (Gate)o;
        return other.getLabel() == this.getLabel();
    }

    public int hashCode() {
        return this.getLabel().hashCode();
    }

    public String toJSON() {
        String type = "!";
        if (this.label.contains("?")) {
            type = "?";
        }
        String json = "\"" + this.getStrippedLabel() + "\":{\"type\":\"" + type + "\",\"iVars\":[";
        for (Variable variable : this.iVars) {
            json = String.valueOf(json) + "\"" + variable.getLabel() + "\",";
        }
        if (!this.iVars.isEmpty()) {
            json = json.substring(0, json.length() - 1);
        }
        return String.valueOf(json) + "]}";
    }

    public String getStrippedLabel() {
        if (this.label.startsWith("?") || this.label.startsWith("!")) {
            return this.label.substring(1, this.label.length());
        }
        return this.label;
    }
}

