/*
 * Decompiled with CFR 0.152.
 */
package groove.sts;

import groove.algebra.Operator;
import groove.algebra.SignatureKind;
import groove.grammar.Rule;
import groove.grammar.rule.OperatorNode;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleGraph;
import groove.grammar.rule.RuleLabel;
import groove.grammar.rule.RuleNode;
import groove.grammar.rule.VariableNode;
import groove.graph.Node;
import groove.sts.InteractionVariable;
import groove.sts.LocationVariable;
import groove.sts.Variable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RuleInspector {
    private static RuleInspector instance;

    private RuleInspector() {
    }

    public static RuleInspector getInstance() {
        if (instance == null) {
            instance = new RuleInspector();
        }
        return instance;
    }

    public String parseGuardExpression(Rule rule, VariableNode vn, Variable v, Map<VariableNode, InteractionVariable> iVarMap, Map<VariableNode, LocationVariable> lVarMap) {
        RuleGraph lhs = rule.lhs();
        String guard = "";
        if (vn.hasConstant()) {
            return String.valueOf(v.getLabel()) + " == " + this.getSymbol(vn.getConstant().getSymbol());
        }
        List<String> results = this.parseAlgebraicExpression(rule, lhs, vn, iVarMap, lVarMap);
        for (String s : results) {
            guard = String.valueOf(guard) + v.getLabel() + " == " + s + " && ";
        }
        results = this.parseBooleanExpression(rule, lhs, vn, iVarMap, lVarMap);
        for (String s : results) {
            guard = String.valueOf(guard) + v.getLabel() + s + " && ";
        }
        if (!guard.isEmpty()) {
            guard = guard.substring(0, guard.length() - 4);
        }
        return guard;
    }

    public List<String> parseAlgebraicExpression(Rule rule, RuleGraph pattern, VariableNode variableResult, Map<VariableNode, InteractionVariable> iVarMap, Map<VariableNode, LocationVariable> lVarMap) {
        ArrayList<String> result = new ArrayList<String>();
        for (RuleNode node : pattern.nodeSet()) {
            OperatorNode opNode;
            if (!(node instanceof OperatorNode) || !(opNode = (OperatorNode)node).getTarget().equals(variableResult)) continue;
            List<VariableNode> arguments = opNode.getArguments();
            String[] subExpressions = new String[arguments.size()];
            int i = 0;
            while (i < arguments.size()) {
                String newResult = this.parseExpression(rule, pattern, arguments.get(i), iVarMap, lVarMap);
                subExpressions[i] = newResult.toString();
                ++i;
            }
            Operator op = opNode.getOperator();
            result.add("(" + subExpressions[0] + this.getOperator(op.getSymbol()) + subExpressions[1] + ")");
        }
        return result;
    }

    public List<String> parseArgumentExpression(Rule rule, RuleGraph pattern, Map<VariableNode, InteractionVariable> iVarMap, Map<VariableNode, LocationVariable> lVarMap) {
        ArrayList<String> result = new ArrayList<String>();
        for (RuleNode node : pattern.nodeSet()) {
            OperatorNode opNode;
            if (!(node instanceof OperatorNode) || !(opNode = (OperatorNode)node).getTarget().hasConstant()) continue;
            String value = opNode.getTarget().getConstant().getSymbol();
            List<VariableNode> arguments = opNode.getArguments();
            String[] subExpressions = new String[arguments.size()];
            int i = 0;
            while (i < arguments.size()) {
                String newResult = this.parseExpression(rule, pattern, arguments.get(i), iVarMap, lVarMap);
                subExpressions[i] = newResult.toString();
                ++i;
            }
            Operator op = opNode.getOperator();
            String expr = "(" + subExpressions[0] + " " + op.getSymbol() + " " + subExpressions[1] + ")";
            if (!op.getResultType().equals((Object)SignatureKind.BOOL)) {
                expr = "(" + expr + "== " + value + ")";
            }
            result.add(expr);
        }
        return result;
    }

    public List<String> parseBooleanExpression(Rule rule, RuleGraph pattern, VariableNode variableResult, Map<VariableNode, InteractionVariable> iVarMap, Map<VariableNode, LocationVariable> lVarMap) {
        ArrayList<String> result = new ArrayList<String>();
        for (RuleEdge e : pattern.inEdgeSet(variableResult)) {
            if (!this.isBooleanEdge(e)) continue;
            String expr = this.parseExpression(rule, pattern, (Node)e.source(), iVarMap, lVarMap);
            result.add(" " + this.getOperator(((RuleLabel)e.label()).text()) + " " + expr);
        }
        return result;
    }

    public String getSymbol(String symbol) {
        if (symbol.startsWith("\"")) {
            return "\\\"" + symbol.substring(1, symbol.length() - 1) + "\\\"";
        }
        if (symbol == "S") {
            return "\"S\"";
        }
        return symbol;
    }

    public String parseExpression(Rule rule, RuleGraph pattern, Node resultValue, Map<VariableNode, InteractionVariable> iVarMap, Map<VariableNode, LocationVariable> lVarMap) {
        VariableNode variableResult = (VariableNode)resultValue;
        if (variableResult.hasConstant()) {
            return variableResult.getConstant().getSymbol();
        }
        InteractionVariable iVar = iVarMap.get(variableResult);
        if (iVar != null) {
            return iVar.getLabel();
        }
        Variable lVar = lVarMap.get(variableResult);
        if (lVar != null) {
            return lVar.getLabel();
        }
        List<String> result = this.parseAlgebraicExpression(rule, pattern, variableResult, iVarMap, lVarMap);
        if (result.isEmpty()) {
            return "";
        }
        return result.get(0);
    }

    private boolean isBooleanEdge(RuleEdge edge) {
        return edge.getType() == null;
    }

    private String getOperator(String operator) {
        if (operator == "=") {
            return "==";
        }
        if (operator == "|") {
            return "||";
        }
        if (operator == "&") {
            return "&&";
        }
        return operator;
    }
}

