/*
 * Decompiled with CFR 0.152.
 */
package groove.sts;

import groove.grammar.Condition;
import groove.grammar.Rule;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.host.ValueNode;
import groove.grammar.rule.AnchorKey;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleGraph;
import groove.grammar.rule.RuleLabel;
import groove.grammar.rule.RuleNode;
import groove.grammar.rule.RuleToHostMap;
import groove.grammar.rule.VariableNode;
import groove.grammar.type.TypeLabel;
import groove.graph.EdgeRole;
import groove.lts.MatchResult;
import groove.sts.Gate;
import groove.sts.GeneralizedGraph;
import groove.sts.InteractionVariable;
import groove.sts.Location;
import groove.sts.LocationVariable;
import groove.sts.RuleInspector;
import groove.sts.STSException;
import groove.sts.SwitchRelation;
import groove.sts.Variable;
import groove.transform.RuleEvent;
import groove.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class STS {
    protected Map<HostGraph, Location> locationMap = new HashMap<HostGraph, Location>();
    protected Map<Object, SwitchRelation> switchRelationMap = new HashMap<Object, SwitchRelation>();
    protected Map<Pair<VariableNode, Rule>, InteractionVariable> interactionVariables;
    protected Set<Gate> gates = new HashSet<Gate>();
    private Location start;
    private Location current;
    private final Map<Pair<Integer, TypeLabel>, LocationVariable> locationVariables;
    private RuleInspector ruleInspector;

    public STS() {
        this.interactionVariables = new HashMap<Pair<VariableNode, Rule>, InteractionVariable>();
        this.locationVariables = new HashMap<Pair<Integer, TypeLabel>, LocationVariable>();
        this.ruleInspector = RuleInspector.getInstance();
    }

    public LocationVariable getLocationVariable(HostEdge edge) {
        return this.locationVariables.get(new Pair<Integer, TypeLabel>(edge.source().getNumber(), edge.label()));
    }

    public LocationVariable addLocationVariable(HostEdge edge, Object init) {
        ValueNode node = (ValueNode)edge.target();
        String label = LocationVariable.createLocationVariableLabel(edge);
        LocationVariable v = new LocationVariable(label, node.getSignature(), init);
        this.locationVariables.put(new Pair<Integer, TypeLabel>(edge.source().getNumber(), edge.label()), v);
        return v;
    }

    public Location getCurrentLocation() {
        return this.current;
    }

    public Location getStartLocation() {
        return this.start;
    }

    public Set<LocationVariable> getLocationVariables() {
        return new HashSet<LocationVariable>(this.locationVariables.values());
    }

    public void toLocation(Location l) {
        this.current = l;
    }

    public SwitchRelation getSwitchRelation(Object obj) {
        return this.switchRelationMap.get(obj);
    }

    public InteractionVariable getInteractionVariable(VariableNode node, Rule rule) {
        return this.interactionVariables.get(new Pair<VariableNode, Rule>(node, rule));
    }

    public void setStartLocation(Location start) {
        this.start = start;
        this.toLocation(start);
    }

    public InteractionVariable addInteractionVariable(VariableNode node, Rule rule) {
        String label = InteractionVariable.createInteractionVariableLabel(rule, node);
        InteractionVariable v = new InteractionVariable(label, node.getSignature());
        this.interactionVariables.put(new Pair<VariableNode, Rule>(node, rule), v);
        return v;
    }

    public Gate addGate(String label, Set<InteractionVariable> iVars) {
        Gate gate = new Gate(label, iVars);
        this.gates.add(gate);
        return gate;
    }

    public void removeSwitchRelation(SwitchRelation relation) {
        this.switchRelationMap.remove(SwitchRelation.getSwitchIdentifier(relation.getGate(), relation.getGuard(), relation.getUpdate()));
    }

    public Location hostGraphToLocation(HostGraph graph) {
        GeneralizedGraph locationGraph = new GeneralizedGraph(graph);
        Location location = this.locationMap.get(locationGraph);
        if (location == null) {
            location = new Location("s" + this.locationMap.size());
            this.locationMap.put(locationGraph, location);
        }
        return location;
    }

    public Location hostGraphToStartLocation(HostGraph graph) {
        Location location = this.hostGraphToLocation(graph);
        this.setStartLocation(location);
        this.initializeLocationVariables(graph);
        return location;
    }

    public SwitchRelation ruleMatchToSwitchRelation(HostGraph sourceGraph, MatchResult match, Set<SwitchRelation> higherPriorityRelations) throws STSException {
        RuleEvent event = match.getEvent();
        HashMap<VariableNode, InteractionVariable> iVarMap = new HashMap<VariableNode, InteractionVariable>();
        this.mapInteractionVariables(event, iVarMap);
        HashMap<VariableNode, LocationVariable> lVarMap = new HashMap<VariableNode, LocationVariable>();
        HashMap<VariableNode, LocationVariable> lValueMap = new HashMap<VariableNode, LocationVariable>();
        this.mapLocationVariables(event, sourceGraph, lVarMap, lValueMap);
        String guard = this.createGuard(event, iVarMap, lVarMap, lValueMap, higherPriorityRelations);
        String update = this.createUpdate(event, iVarMap, lVarMap);
        Gate gate = this.addGate(event.getRule().getTransitionLabel(), new HashSet<InteractionVariable>(iVarMap.values()));
        Object obj = SwitchRelation.getSwitchIdentifier(gate, guard, update);
        SwitchRelation switchRelation = this.switchRelationMap.get(obj);
        if (switchRelation == null) {
            switchRelation = new SwitchRelation(gate, guard, update);
            this.switchRelationMap.put(obj, switchRelation);
        }
        return switchRelation;
    }

    public String toJSON() {
        String json = "{\"_json\":{\"start\":" + this.getStartLocation().toJSON() + ",\"lVars\":{";
        Set<LocationVariable> lVars = this.getLocationVariables();
        for (LocationVariable locationVariable : lVars) {
            json = String.valueOf(json) + locationVariable.toJSON() + ",";
        }
        if (!lVars.isEmpty()) {
            json = json.substring(0, json.length() - 1);
        }
        json = String.valueOf(json) + "},\"relations\":[";
        for (Location location : this.locationMap.values()) {
            for (SwitchRelation r : location.getSwitchRelations()) {
                for (Location target : location.getRelationTargets(r)) {
                    json = String.valueOf(json) + r.toJSON(location, target) + ",";
                }
            }
        }
        json = String.valueOf(json.substring(0, json.length() - 1)) + "],\"gates\":{";
        for (Gate gate : this.gates) {
            json = String.valueOf(json) + gate.toJSON() + ",";
        }
        json = String.valueOf(json.substring(0, json.length() - 1)) + "},\"iVars\":{";
        for (InteractionVariable interactionVariable : this.interactionVariables.values()) {
            json = String.valueOf(json) + interactionVariable.toJSON() + ",";
        }
        if (!this.interactionVariables.isEmpty()) {
            json = json.substring(0, json.length() - 1);
        }
        return String.valueOf(json) + "}}}";
    }

    private void initializeLocationVariables(HostGraph graph) {
        for (HostEdge edge : graph.edgeSet()) {
            HostNode node = edge.target();
            if (!node.getType().isDataType() || this.isFinal(graph, edge.source())) continue;
            ValueNode valueNode = (ValueNode)node;
            this.addLocationVariable(edge, this.ruleInspector.getSymbol(valueNode.getSymbol()));
        }
    }

    private boolean isFinal(HostGraph graph, HostNode node) {
        for (HostEdge e : graph.edgeSet(node)) {
            if (!e.getRole().equals((Object)EdgeRole.FLAG) || !e.label().text().equals("final")) continue;
            return true;
        }
        return false;
    }

    private boolean isFinal(RuleGraph graph, RuleNode node) {
        for (RuleEdge e : graph.edgeSet(node)) {
            if (!e.getRole().equals((Object)EdgeRole.FLAG) || !((RuleLabel)e.label()).text().equals("final")) continue;
            return true;
        }
        return false;
    }

    private void mapLocationVariables(RuleEvent event, HostGraph sourceGraph, Map<VariableNode, LocationVariable> lVarMap, Map<VariableNode, LocationVariable> lValueMap) throws STSException {
        RuleGraph lhs = event.getRule().lhs();
        RuleToHostMap ruleMap = event.getMatch(sourceGraph).getPatternMap();
        for (RuleEdge le : lhs.edgeSet()) {
            if (le.getType() == null || !(le.target() instanceof VariableNode)) continue;
            HostEdge hostEdge = (HostEdge)ruleMap.mapEdge(le);
            LocationVariable var = this.getLocationVariable(hostEdge);
            if (var == null && !this.isFinal(sourceGraph, hostEdge.source())) {
                throw new STSException("ERROR: Data edge found not mapped by any variable: " + hostEdge);
            }
            if (lVarMap.containsKey(le.target())) continue;
            lVarMap.put((VariableNode)le.target(), var);
        }
        for (RuleNode node : lhs.nodeSet()) {
            VariableNode n;
            if (!(node instanceof VariableNode) || (n = (VariableNode)node).getConstant() == null) continue;
            for (RuleEdge re : lhs.inEdgeSet(node)) {
                LocationVariable var;
                HostEdge hostEdge;
                if (!((RuleLabel)re.label()).isAtom() && !((RuleLabel)re.label()).isSharp() || (hostEdge = (HostEdge)ruleMap.mapEdge(re)) == null || (var = this.getLocationVariable(hostEdge)) == null) continue;
                lValueMap.put(n, var);
            }
        }
    }

    private void mapInteractionVariables(RuleEvent event, Map<VariableNode, InteractionVariable> iVarMap) throws STSException {
        Rule rule = event.getRule();
        int end = rule.getSignature().size();
        int i = 0;
        while (i < end) {
            int index = rule.getParBinding(i);
            AnchorKey k = (AnchorKey)rule.getAnchor().get(index);
            if (!(k instanceof VariableNode)) {
                throw new STSException("ERROR: non-variable node " + k.toString() + " listed as parameter");
            }
            VariableNode v = (VariableNode)k;
            InteractionVariable iVar = this.addInteractionVariable(v, rule);
            iVarMap.put(v, iVar);
            ++i;
        }
    }

    private String createGuard(RuleEvent event, Map<VariableNode, InteractionVariable> iVarMap, Map<VariableNode, LocationVariable> lVarMap, Map<VariableNode, LocationVariable> lValueMap, Set<SwitchRelation> higherPriorityRelations) {
        Rule rule = event.getRule();
        RuleGraph lhs = rule.lhs();
        String guard = "";
        for (VariableNode v : iVarMap.keySet()) {
            guard = String.valueOf(guard) + this.ruleInspector.parseGuardExpression(rule, v, iVarMap.get(v), iVarMap, lVarMap);
        }
        for (VariableNode v : lVarMap.keySet()) {
            if (iVarMap.containsKey(v)) continue;
            guard = String.valueOf(guard) + this.ruleInspector.parseGuardExpression(rule, v, lVarMap.get(v), iVarMap, lVarMap);
        }
        if (!guard.isEmpty()) {
            guard = String.valueOf(guard) + " && ";
        }
        List<String> results = this.ruleInspector.parseArgumentExpression(rule, lhs, iVarMap, lVarMap);
        for (String s : results) {
            guard = String.valueOf(guard) + s + " && ";
        }
        String combinedGuard = "";
        for (SwitchRelation higherPriorityRelation : higherPriorityRelations) {
            combinedGuard = String.valueOf(combinedGuard) + higherPriorityRelation.getGuard() + " && ";
        }
        if (!combinedGuard.isEmpty()) {
            guard = String.valueOf(guard) + "!(" + combinedGuard.substring(0, combinedGuard.length() - 4) + ") && ";
        }
        for (VariableNode v : lValueMap.keySet()) {
            guard = String.valueOf(guard) + lValueMap.get(v).getLabel() + " == " + this.ruleInspector.getSymbol(v.getConstant().getSymbol()) + " && ";
        }
        if (guard.endsWith(" && ")) {
            guard = guard.substring(0, guard.length() - 4);
        }
        return guard;
    }

    private String createUpdate(RuleEvent event, Map<VariableNode, InteractionVariable> iVarMap, Map<VariableNode, LocationVariable> lVarMap) throws STSException {
        Rule rule = event.getRule();
        String name = rule.getFullName();
        Condition nac = rule.getCondition();
        String update = "";
        HashMap<Pair<RuleNode, RuleLabel>, RuleEdge> possibleUpdates = new HashMap<Pair<RuleNode, RuleLabel>, RuleEdge>();
        RuleEdge[] ruleEdgeArray = rule.getEraserEdges();
        int n = ruleEdgeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RuleEdge e = ruleEdgeArray[n2];
            if (((RuleNode)e.target()).getType().isDataType() && !this.isFinal(rule.lhs(), (RuleNode)e.source())) {
                possibleUpdates.put(new Pair<RuleNode, RuleLabel>((RuleNode)e.source(), (RuleLabel)e.label()), e);
            }
            ++n2;
        }
        ruleEdgeArray = rule.getCreatorEdges();
        n = ruleEdgeArray.length;
        n2 = 0;
        while (n2 < n) {
            RuleEdge creatorEdge = ruleEdgeArray[n2];
            if (((RuleNode)creatorEdge.target()).getType().isDataType() && !this.isFinal(rule.lhs(), (RuleNode)creatorEdge.source())) {
                RuleEdge eraserEdge = (RuleEdge)possibleUpdates.remove(new Pair<RuleNode, RuleLabel>((RuleNode)creatorEdge.source(), (RuleLabel)creatorEdge.label()));
                if (eraserEdge == null) {
                    throw new STSException("ERROR: no eraser edge found for created location variable " + creatorEdge + "; location variables have to be declared in start location and reference must be deleted");
                }
                Variable var = lVarMap.get(eraserEdge.target());
                if (var == null) {
                    throw new STSException("ERROR: no location variable found referenced by " + ((RuleNode)eraserEdge.target()).toString() + " in the LHS or Condition of rule " + name);
                }
                RuleNode node = (RuleNode)creatorEdge.target();
                String updateValue = this.ruleInspector.parseExpression(rule, nac.getPattern(), node, iVarMap, lVarMap);
                if (updateValue.length() == 0) {
                    throw new STSException("ERROR: Update of " + var.toString() + " in rule " + rule.getFullName() + " is empty where it shouldn't be.");
                }
                update = String.valueOf(update) + var.getLabel() + " = " + updateValue + "; ";
            }
            ++n2;
        }
        if (!possibleUpdates.isEmpty()) {
            throw new STSException("ERROR: eraser edge found without creator: " + possibleUpdates.values().iterator().next());
        }
        return update;
    }
}

