/*
 * Decompiled with CFR 0.152.
 */
package groove.transform;

import groove.grammar.host.HostEdge;
import groove.grammar.host.HostEdgeSet;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.host.HostNodeSet;
import groove.grammar.rule.RuleNode;
import groove.transform.MergeMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RuleEffect {
    private final Set<? extends HostNode> sourceNodes;
    private final Fragment fragment;
    private HostNodeSet erasedNodes;
    private boolean erasedNodesAliased;
    private HostEdgeSet erasedEdges;
    private boolean erasedEdgesAliased;
    private Map<RuleNode, HostNode> createdNodeMap;
    private HostNodeSet createdNodeSet;
    private HostNode[] createdNodeArray;
    private int createdNodeIndex;
    private HostEdgeSet createdEdges;
    private boolean createdEdgesAliased;
    private MergeMap mergeMap;
    private boolean mergeMapAliased;

    public RuleEffect(HostGraph host) {
        this(host, Fragment.ALL);
    }

    public RuleEffect(HostGraph host, Fragment fragment) {
        this.sourceNodes = host.nodeSet();
        this.fragment = fragment;
        this.createdNodeArray = null;
        this.createdNodeIndex = -1;
    }

    public RuleEffect(HostNode[] createdNodes) {
        this(createdNodes, Fragment.ALL);
    }

    public RuleEffect(HostNode[] createdNodes, Fragment fragment) {
        this.sourceNodes = null;
        this.fragment = fragment;
        this.createdNodeArray = createdNodes;
        this.createdNodeIndex = 0;
    }

    Set<? extends HostNode> getSourceNodes() {
        return this.sourceNodes;
    }

    final Fragment getFragment() {
        return this.fragment;
    }

    final boolean isNodesInitialised() {
        return this.createdNodeIndex >= 0;
    }

    Map<RuleNode, HostNode> getCreatedNodeMap() {
        return this.createdNodeMap;
    }

    void addCreatorNodes(RuleNode[] creatorNodes) {
        assert (this.isNodesInitialised());
        HostNode[] createdNodes = this.createdNodeArray;
        Map<RuleNode, HostNode> createdNodeMap = this.createdNodeMap;
        if (createdNodeMap == null) {
            this.createdNodeMap = createdNodeMap = new HashMap<RuleNode, HostNode>();
        }
        int createdNodeStart = this.createdNodeIndex;
        int creatorCount = creatorNodes.length;
        int i = 0;
        while (i < creatorCount) {
            createdNodeMap.put(creatorNodes[i], createdNodes[createdNodeStart + i]);
            ++i;
        }
        this.createdNodeIndex = createdNodeStart + creatorCount;
    }

    void addCreatedNodes(RuleNode[] creatorNodes, HostNode[] createdNodes) {
        assert (!this.isNodesInitialised());
        int createdNodeCount = createdNodes.length;
        if (createdNodeCount > 0) {
            Map<RuleNode, HostNode> oldCreatedNodeMap = this.createdNodeMap;
            HostNodeSet oldCreatedNodes = this.createdNodeSet;
            if (oldCreatedNodes == null) {
                int size = createdNodeCount * 2;
                oldCreatedNodeMap = new HashMap<RuleNode, HostNode>(size);
                oldCreatedNodes = new HostNodeSet(size);
            }
            int i = 0;
            while (i < createdNodeCount) {
                HostNode createdNode = createdNodes[i];
                oldCreatedNodes.add(createdNode);
                oldCreatedNodeMap.put(creatorNodes[i], createdNode);
                ++i;
            }
            this.createdNodeMap = oldCreatedNodeMap;
            this.createdNodeSet = oldCreatedNodes;
        }
    }

    void addErasedNodes(HostNodeSet erasedNodes) {
        if (!erasedNodes.isEmpty()) {
            HostNodeSet newErasedNodes;
            HostNodeSet oldErasedNodes = this.erasedNodes;
            if (oldErasedNodes == null) {
                newErasedNodes = erasedNodes;
                this.erasedNodesAliased = true;
            } else {
                if (this.erasedNodesAliased) {
                    newErasedNodes = new HostNodeSet((oldErasedNodes.size() + erasedNodes.size()) * 2);
                    newErasedNodes.addAll(oldErasedNodes);
                    this.erasedNodesAliased = false;
                } else {
                    newErasedNodes = oldErasedNodes;
                }
                newErasedNodes.addAll(erasedNodes);
            }
            this.erasedNodes = newErasedNodes;
        }
    }

    void addErasedEdges(HostEdgeSet erasedEdges) {
        HostEdgeSet newErasedEdges;
        HostEdgeSet oldErasedEdges = this.erasedEdges;
        if (erasedEdges.isEmpty()) {
            newErasedEdges = null;
        } else if (oldErasedEdges == null) {
            newErasedEdges = erasedEdges;
            this.erasedEdgesAliased = true;
        } else {
            if (this.erasedEdgesAliased) {
                newErasedEdges = new HostEdgeSet((oldErasedEdges.size() + erasedEdges.size()) * 2);
                newErasedEdges.addAll(oldErasedEdges);
                this.erasedEdgesAliased = false;
            } else {
                newErasedEdges = oldErasedEdges;
            }
            newErasedEdges.addAll(erasedEdges);
        }
        this.erasedEdges = newErasedEdges;
    }

    void addCreatedEdges(HostEdgeSet createdEdges) {
        HostEdgeSet newCreatedEdges;
        HostEdgeSet oldCreatedEdges = this.createdEdges;
        if (createdEdges.isEmpty()) {
            newCreatedEdges = oldCreatedEdges;
        } else if (oldCreatedEdges == null) {
            newCreatedEdges = createdEdges;
            this.createdEdgesAliased = true;
        } else {
            if (this.createdEdgesAliased) {
                newCreatedEdges = new HostEdgeSet((oldCreatedEdges.size() + createdEdges.size()) * 2);
                newCreatedEdges.addAll(oldCreatedEdges);
                this.createdEdgesAliased = false;
            } else {
                newCreatedEdges = oldCreatedEdges;
            }
            newCreatedEdges.addAll(createdEdges);
        }
        this.createdEdges = newCreatedEdges;
    }

    void addCreatedEdge(HostEdge edge) {
        HostEdgeSet newCreatedEdges;
        HostEdgeSet oldCreatedEdges = this.createdEdges;
        if (oldCreatedEdges == null) {
            newCreatedEdges = new HostEdgeSet();
        } else if (this.createdEdgesAliased) {
            newCreatedEdges = new HostEdgeSet(this.createdEdges.size() * 2);
            newCreatedEdges.addAll(oldCreatedEdges);
            this.createdEdgesAliased = false;
        } else {
            newCreatedEdges = oldCreatedEdges;
        }
        newCreatedEdges.add(edge);
        this.createdEdges = newCreatedEdges;
    }

    void addMergeMap(MergeMap mergeMap) {
        MergeMap newMergeMap;
        MergeMap oldMergeMap = this.mergeMap;
        if (oldMergeMap == null) {
            newMergeMap = mergeMap;
            this.mergeMapAliased = true;
        } else {
            if (this.mergeMapAliased) {
                newMergeMap = new MergeMap(oldMergeMap.getFactory());
                newMergeMap.putAll(oldMergeMap);
                this.mergeMapAliased = false;
            } else {
                newMergeMap = oldMergeMap;
            }
            newMergeMap.putAll(mergeMap);
        }
        this.mergeMap = newMergeMap;
    }

    public final HostNodeSet getErasedNodes() {
        return this.erasedNodes;
    }

    public final boolean hasErasedNodes() {
        return this.erasedNodes != null;
    }

    public final Collection<HostEdge> getErasedEdges() {
        return this.erasedEdges;
    }

    public final boolean hasErasedEdges() {
        return this.erasedEdges != null;
    }

    public final boolean isErasedEdge(HostEdge edge) {
        return this.hasErasedEdges() && this.getErasedEdges().contains(edge);
    }

    public final HostNode[] getCreatedNodeArray() {
        if (this.createdNodeArray == null && this.createdNodeSet != null) {
            this.createdNodeArray = this.createdNodeSet.toArray(new HostNode[this.createdNodeSet.size()]);
        }
        return this.createdNodeArray;
    }

    public final Collection<HostNode> getCreatedNodes() {
        return this.isNodesInitialised() ? Arrays.asList(this.createdNodeArray) : this.createdNodeSet;
    }

    public final boolean hasCreatedNodes() {
        return this.isNodesInitialised() ? this.createdNodeArray.length > 0 : this.createdNodeSet != null;
    }

    public final Iterable<HostEdge> getCreatedTargetEdges() {
        final HostEdgeSet createdEdges = this.createdEdges;
        if (createdEdges == null) {
            return null;
        }
        if (this.hasMergeMap()) {
            return new Iterable<HostEdge>(){

                @Override
                public Iterator<HostEdge> iterator() {
                    return new Iterator<HostEdge>(createdEdges){
                        private HostEdge next;
                        private final Iterator<HostEdge> createdEdgeIter;
                        private final HostEdgeSet mergedEdges;
                        {
                            this.createdEdgeIter = collection.iterator();
                            this.mergedEdges = new HostEdgeSet();
                        }

                        @Override
                        public boolean hasNext() {
                            HostEdge next = this.next;
                            HostEdgeSet previous = this.mergedEdges;
                            MergeMap mergeMap = RuleEffect.this.getMergeMap();
                            Iterator<HostEdge> inner = this.createdEdgeIter;
                            while (next == null && inner.hasNext()) {
                                next = mergeMap.mapEdge(inner.next());
                                if (next == null || previous.add(next)) continue;
                                next = null;
                            }
                            this.next = next;
                            return next != null;
                        }

                        @Override
                        public HostEdge next() {
                            if (this.hasNext()) {
                                HostEdge result = this.next;
                                this.next = null;
                                return result;
                            }
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }
        if (this.hasErasedNodes()) {
            return new Iterable<HostEdge>(){

                @Override
                public Iterator<HostEdge> iterator() {
                    return new Iterator<HostEdge>(createdEdges){
                        private HostEdge next;
                        private final Iterator<HostEdge> createdEdgeIter;
                        {
                            this.createdEdgeIter = collection.iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            HostEdge next = this.next;
                            HostNodeSet erasedNodes = RuleEffect.this.getErasedNodes();
                            Iterator<HostEdge> inner = this.createdEdgeIter;
                            while (next == null && inner.hasNext()) {
                                next = inner.next();
                                if (next == null || !erasedNodes.contains(next.source()) && !erasedNodes.contains(next.target())) continue;
                                next = null;
                            }
                            this.next = next;
                            return next != null;
                        }

                        @Override
                        public HostEdge next() {
                            if (this.hasNext()) {
                                HostEdge result = this.next;
                                this.next = null;
                                return result;
                            }
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }
        return createdEdges;
    }

    public final boolean hasCreatedEdges() {
        return this.createdEdges != null;
    }

    public final MergeMap getMergeMap() {
        return this.mergeMap;
    }

    public final boolean hasMergeMap() {
        return this.mergeMap != null;
    }

    public static enum Fragment {
        NODE_CREATION,
        NODE_ALL,
        ALL;

    }
}

