/*
 * Decompiled with CFR 0.152.
 */
package groove.util;

import groove.graph.Node;
import groove.util.Dispenser;
import java.util.Arrays;
import java.util.Collection;

public class FreeNumberDispenser
implements Dispenser {
    private final int[] numbers;
    private int currIdx;
    private int lastVal;

    public FreeNumberDispenser(int[] numbers) {
        this.numbers = numbers;
        this.currIdx = 0;
        this.lastVal = -1;
        Arrays.sort(this.numbers);
    }

    public FreeNumberDispenser(Collection<? extends Node> nodeSet) {
        this(FreeNumberDispenser.getArray(nodeSet));
    }

    private static int[] getArray(Collection<? extends Node> nodeSet) {
        int[] numbers = new int[nodeSet.size()];
        int i = 0;
        for (Node node : nodeSet) {
            numbers[i] = node.getNumber();
            ++i;
        }
        return numbers;
    }

    @Override
    public int getNext() {
        ++this.lastVal;
        if (this.currIdx < this.numbers.length && this.lastVal != this.numbers[this.currIdx]) {
            return this.lastVal;
        }
        do {
            ++this.currIdx;
            ++this.lastVal;
        } while (this.currIdx < this.numbers.length && this.lastVal == this.numbers[this.currIdx]);
        if (this.currIdx < this.numbers.length) {
            return this.lastVal;
        }
        return -1;
    }

    public int getMaxNumber() {
        if (this.numbers.length == 0) {
            return 0;
        }
        return this.numbers[this.numbers.length - 1];
    }
}

