/*
 * Decompiled with CFR 0.152.
 */
package groove.util;

import groove.graph.Edge;
import groove.graph.Graph;
import groove.util.CommandLineTool;
import groove.util.Groove;
import groove.util.collect.TreeBag;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class GraphReporter
extends CommandLineTool {
    private GraphReporter(String ... args) {
        super(args);
    }

    private GraphReporter() {
        super(new String[0]);
    }

    public void start() {
        this.processArguments();
        List<String> argsList = this.getArgs();
        if (argsList.size() > 0) {
            String graphLocation = argsList.remove(0);
            if (argsList.size() > 0) {
                this.printError(String.format("Spurious parameters '%s'", argsList.toString()), true);
            }
            try {
                this.report(Groove.loadGraph(graphLocation));
            }
            catch (IOException e) {
                this.printError(e.getMessage(), true);
            }
        } else {
            this.printError("No graph specified", true);
        }
    }

    @Override
    protected boolean supportsLogOption() {
        return false;
    }

    @Override
    protected boolean supportsOutputOption() {
        return false;
    }

    @Override
    protected boolean supportsVerbosityOption() {
        return false;
    }

    @Override
    protected String getUsageMessage() {
        return String.valueOf(super.getUsageMessage()) + " graph-file";
    }

    public void report(Graph graph) {
        this.println(this.getReport(graph).toString());
    }

    public StringBuilder getReport(Graph graph) {
        StringBuilder result = new StringBuilder();
        TreeBag labels = new TreeBag();
        for (Edge edge : graph.edgeSet()) {
            labels.add(edge.label());
        }
        for (Map.Entry entry : labels.multiplicityMap().entrySet()) {
            result.append(String.format("%s\t%s%n", entry.getKey(), entry.getValue()));
        }
        return result;
    }

    public static void main(String[] args) {
        new GraphReporter(args).start();
    }

    public static GraphReporter createInstance() {
        return new GraphReporter();
    }
}

