/*
 * Decompiled with CFR 0.152.
 */
package groove.util;

import groove.util.Property;
import java.util.Collection;

public abstract class Visitor<T, R> {
    private R result;
    private boolean disposed;
    private boolean cont = true;
    private static final Collector prototypeCollector = new Collector(null);
    private static final Finder prototypeFinder = new Finder(null);

    protected Visitor() {
    }

    protected Visitor(R result) {
        this.result = result;
    }

    protected abstract boolean process(T var1);

    public final boolean visit(T object) {
        assert (!this.isDisposed() && this.isContinue());
        if (!this.process(object)) {
            this.finish();
        }
        return this.isContinue();
    }

    public final R getResult() {
        return this.result;
    }

    protected final boolean hasResult() {
        return this.result != null;
    }

    protected final void setResult(R result) {
        this.result = result;
    }

    public void dispose() {
        this.disposed = true;
        this.result = null;
    }

    protected final boolean isDisposed() {
        return this.disposed;
    }

    protected final void resurrect() {
        this.disposed = false;
        this.cont = true;
    }

    public final boolean isContinue() {
        return this.cont;
    }

    private void finish() {
        this.cont = false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + '[' + this.getResult() + ']';
    }

    public static <T> Finder<T> newFinder(Property<T> property) {
        return prototypeFinder.newInstance(property);
    }

    public static <T, C extends Collection<T>> Collector<T, C> newCollector(C collection, Property<T> property) {
        if (property == null) {
            return prototypeCollector.newInstance(collection, property);
        }
        return new Collector<T, C>(collection, property);
    }

    public static <T, C extends Collection<T>> Collector<T, C> newCollector(C collection) {
        return prototypeCollector.newInstance(collection);
    }

    public static <T, C extends Collection<T>> Collector<T, C> newCollector() {
        Collector result = prototypeCollector.newInstance(null);
        result.dispose();
        return result;
    }

    public static class Collector<T, C extends Collection<T>>
    extends Visitor<T, C> {
        private Property<T> property;

        public Collector(C collection, Property<T> property) {
            super(collection);
            if (collection == null) {
                this.dispose();
            }
            this.property = property;
        }

        public Collector(C collection) {
            this(collection, null);
        }

        @Override
        protected boolean process(T object) {
            assert (!this.isDisposed());
            if (this.property == null || this.property.isSatisfied(object)) {
                ((Collection)this.getResult()).add(object);
            }
            return true;
        }

        public Collector<T, C> newInstance(C collection) {
            if (this.isDisposed()) {
                this.setResult(collection);
                this.resurrect();
                return this;
            }
            return this.createInstance(collection, this.property);
        }

        public Collector<T, C> newInstance(C collection, Property<T> property) {
            if (this.isDisposed()) {
                this.setResult(collection);
                this.property = property;
                this.resurrect();
                return this;
            }
            return this.createInstance(collection, property);
        }

        protected Collector<T, C> createInstance(C collection, Property<T> property) {
            return new Collector<T, C>(collection, property);
        }
    }

    public static class Finder<T>
    extends Visitor<T, T> {
        private Property<T> property;

        public Finder(Property<T> property) {
            this.property = property;
        }

        @Override
        protected boolean process(T object) {
            if (!this.hasResult() && (this.property == null || this.property.isSatisfied(object))) {
                this.setResult(object);
            }
            return !this.hasResult();
        }

        public boolean found() {
            return this.hasResult();
        }

        public Finder<T> newInstance(Property<T> property) {
            if (this.isDisposed()) {
                this.property = property;
                this.resurrect();
                return this;
            }
            return new Finder<T>(property);
        }

        public Finder<T> newInstance() {
            return this.newInstance(null);
        }
    }
}

