/*
 * Decompiled with CFR 0.152.
 */
package groove.util.collect;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class FilterIterator<T>
implements Iterator<T> {
    private final Iterator<?> inner;
    private T next = null;
    private boolean removeAllowed = false;
    private static final boolean ITERATE_DEBUG = false;

    public FilterIterator(Iterator<?> inner) {
        this.inner = inner;
    }

    @Override
    public boolean hasNext() {
        Object next = this.next;
        Iterator<?> inner = this.inner;
        while (next == null && inner.hasNext()) {
            next = inner.next();
            if (this.approves(next)) continue;
            next = null;
            this.removeAllowed = false;
        }
        this.next = next;
        return next != null;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            T result = this.next;
            this.next = null;
            this.removeAllowed = true;
            return result;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        if (!this.removeAllowed) {
            throw new IllegalStateException();
        }
        this.inner.remove();
        this.removeAllowed = false;
    }

    public T latest() {
        if (!this.removeAllowed) {
            throw new IllegalStateException();
        }
        return this.next;
    }

    protected abstract boolean approves(Object var1);
}

