/*
 * Decompiled with CFR 0.152.
 */
package groove.util.collect;

import groove.util.collect.Bag;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class HashBag<T>
extends AbstractCollection<T>
implements Cloneable,
Bag<T> {
    protected final Map<T, MyMultiplicity> bag = new HashMap<T, MyMultiplicity>();
    private int size;

    public HashBag() {
    }

    public HashBag(Collection<T> input) {
        this.addAll(input);
    }

    @Override
    public boolean contains(Object key) {
        return this.bag.containsKey(key);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private final Iterator<Map.Entry<T, MyMultiplicity>> entryIter;
            private Map.Entry<T, MyMultiplicity> entry;
            private MyMultiplicity mult;
            private int count;
            private boolean removed;
            {
                this.entryIter = HashBag.this.bag.entrySet().iterator();
                this.removed = true;
            }

            @Override
            public boolean hasNext() {
                if (this.count == 0) {
                    return this.entryIter.hasNext();
                }
                return true;
            }

            @Override
            public T next() {
                if (this.count == 0) {
                    this.nextEntry();
                }
                --this.count;
                this.removed = false;
                return this.entry.getKey();
            }

            @Override
            public void remove() {
                if (this.removed) {
                    throw new IllegalStateException();
                }
                try {
                    if (this.mult.dec() == 0) {
                        this.entryIter.remove();
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    this.entryIter.remove();
                }
                this.removed = true;
            }

            private void nextEntry() {
                this.entry = this.entryIter.next();
                this.mult = this.entry.getValue();
                this.count = this.mult.getValue();
            }
        };
    }

    @Override
    public int size() {
        assert (this.size == this.computeSize()) : "Stored size " + this.size + " differs from actual size " + this.computeSize();
        return this.size;
    }

    @Override
    public Set<T> elementSet() {
        return this.bag.keySet();
    }

    @Override
    public int multiplicity(Object elem) {
        Bag.Multiplicity mult = this.bag.get(elem);
        if (mult == null) {
            return 0;
        }
        return mult.getValue();
    }

    @Override
    public Map<T, ? extends Bag.Multiplicity> multiplicityMap() {
        return Collections.unmodifiableMap(this.bag);
    }

    @Override
    public boolean add(T elem) {
        MyMultiplicity mult = this.bag.get(elem);
        if (mult == null) {
            this.bag.put(elem, this.newMultiplicity());
        } else {
            mult.inc();
        }
        return true;
    }

    @Override
    public void clear() {
        this.bag.clear();
        this.size = 0;
    }

    @Override
    public boolean remove(Object elem) {
        return this.removeGetCount(elem) >= 0;
    }

    @Override
    public boolean removeWasLast(Object elem) {
        return this.removeGetCount(elem) == 0;
    }

    @Override
    public boolean minus(Collection<?> c) {
        boolean result = false;
        for (Object element : c) {
            result |= this.remove(element);
        }
        return result;
    }

    @Override
    public int hashCode() {
        int result = 0;
        for (Map.Entry<T, MyMultiplicity> entry : this.bag.entrySet()) {
            result += entry.getKey().hashCode() * entry.getValue().getValue();
        }
        return result;
    }

    public Object clone() {
        HashBag<T> result = new HashBag<T>();
        for (Map.Entry<T, MyMultiplicity> entry : this.bag.entrySet()) {
            result.bag.put(entry.getKey(), entry.getValue().clone());
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof HashBag && ((HashBag)obj).bag.equals(this.bag);
    }

    @Override
    public String toString() {
        return this.bag.toString();
    }

    protected MyMultiplicity newMultiplicity() {
        return new MyMultiplicity();
    }

    @Override
    public int removeGetCount(Object elem) {
        MyMultiplicity mult = this.bag.remove(elem);
        if (mult == null) {
            return -1;
        }
        int value = mult.dec();
        if (value > 0) {
            this.bag.put(elem, mult);
        }
        return value;
    }

    private int computeSize() {
        int result = 0;
        for (Map.Entry<T, MyMultiplicity> entry : this.bag.entrySet()) {
            MyMultiplicity mult = entry.getValue();
            result += mult.getValue();
        }
        return result;
    }

    final void incSize() {
        ++this.size;
    }

    final void decSize() {
        --this.size;
    }

    protected class MyMultiplicity
    implements Bag.Multiplicity,
    Cloneable,
    Comparable<Object> {
        private int value = 1;

        protected MyMultiplicity() {
            HashBag.this.incSize();
        }

        @Override
        public int getValue() {
            assert (this.value >= 0);
            return this.value;
        }

        public String toString() {
            return "" + this.value;
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(Object obj) {
            return obj instanceof MyMultiplicity && ((MyMultiplicity)obj).value == this.value;
        }

        public MyMultiplicity clone() {
            try {
                return (MyMultiplicity)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                assert (false);
                return null;
            }
        }

        @Override
        public int compareTo(Object o) {
            return this.hashCode() - o.hashCode();
        }

        protected int inc() {
            ++this.value;
            HashBag.this.incSize();
            assert (this.value > 0);
            return this.value;
        }

        protected int dec() {
            assert (this.value > 0);
            --this.value;
            HashBag.this.decSize();
            return this.value;
        }
    }
}

