/*
 * Decompiled with CFR 0.152.
 */
package groove.util.collect;

import groove.util.collect.FilterIterator;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class SetView<T>
extends AbstractSet<T> {
    protected final Set<?> set;

    public SetView() {
        this.set = new HashSet();
    }

    public SetView(Set<?> set) {
        this.set = set;
    }

    @Override
    public int size() {
        int result = 0;
        for (Object elem : this.set) {
            if (!this.approves(elem)) continue;
            ++result;
        }
        return result;
    }

    @Override
    public boolean contains(Object elem) {
        return this.approves(elem) && this.set.contains(elem);
    }

    @Override
    public Iterator<T> iterator() {
        return new FilterIterator<T>(this.set.iterator()){

            @Override
            protected boolean approves(Object obj) {
                return SetView.this.approves(obj);
            }
        };
    }

    @Override
    public boolean add(T elem) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object elem) {
        if (this.approves(elem)) {
            return this.set.remove(elem);
        }
        return false;
    }

    public abstract boolean approves(Object var1);
}

