/*
 * Decompiled with CFR 0.152.
 */
package groove.util.collect;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class SmallCollection<E>
extends AbstractCollection<E> {
    private E singleton;
    private Collection<E> inner;

    public SmallCollection() {
    }

    public SmallCollection(E obj) {
        this.singleton = obj;
    }

    @Override
    public boolean add(E obj) {
        if (this.inner != null) {
            return this.inner.add(obj);
        }
        if (this.singleton == null) {
            this.singleton = obj;
            return true;
        }
        this.inner = this.createCollection();
        this.inner.add(this.singleton);
        this.singleton = null;
        return this.inner.add(obj);
    }

    @Override
    public void clear() {
        this.inner = null;
        this.singleton = null;
    }

    @Override
    public boolean contains(Object obj) {
        if (this.inner != null) {
            return this.inner.contains(obj);
        }
        return this.singleton != null && this.singleton.equals(obj);
    }

    @Override
    public boolean isEmpty() {
        return this.inner == null && this.singleton == null || this.inner.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        if (this.inner != null) {
            return this.inner.iterator();
        }
        if (this.singleton == null) {
            return Collections.emptyList().iterator();
        }
        return Collections.singleton(this.singleton).iterator();
    }

    @Override
    public boolean remove(Object obj) {
        boolean result;
        if (this.inner == null) {
            boolean bl = result = this.singleton != null && this.singleton.equals(obj);
            if (result) {
                this.singleton = null;
            }
        } else {
            result = this.inner.remove(obj);
            if (result && this.inner.size() == 1) {
                this.singleton = this.inner.iterator().next();
                this.inner = null;
            }
        }
        return result;
    }

    @Override
    public int size() {
        if (this.inner == null) {
            return this.singleton == null ? 0 : 1;
        }
        return this.inner.size();
    }

    public boolean isSingleton() {
        return this.singleton != null || this.inner != null && this.inner.size() == 1;
    }

    public E getSingleton() {
        E result = this.singleton;
        if (result == null && this.inner != null && this.inner.size() == 1) {
            result = this.inner.iterator().next();
        }
        return result;
    }

    protected Collection<E> createCollection() {
        return new ArrayList();
    }
}

