/*
 * Decompiled with CFR 0.152.
 */
package groove.util.collect;

import groove.util.collect.IntSet;
import java.util.Arrays;

public final class TreeIntSet
implements IntSet {
    private static final int ROOT_RESOLUTION = 7;
    private static final int ROOT_WIDTH = 128;
    private static final int ROOT_MASK = 127;
    private int storeSize;
    private int size;
    private int[] keys;
    private int[] store;
    private final int resolution;
    private final int width;
    private final int mask;

    public TreeIntSet(int resolution) {
        if (resolution < 1) {
            throw new IllegalArgumentException("Resolution should be at least 1");
        }
        this.resolution = resolution;
        this.width = 1 << resolution;
        this.mask = this.width - 1;
    }

    @Override
    public void clear(int capacity) {
        if (this.keys == null || this.keys.length <= capacity) {
            this.keys = new int[2 * capacity];
            this.store = new int[2 * this.width * capacity];
        }
        this.storeSize = 0;
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(int key) {
        int oldOffset;
        int newOffset;
        if (this.size == 0) {
            int indexPlusOffset = this.newBranchIndex() + (key & 0x7F);
            this.store[indexPlusOffset] = -this.newKeyIndex(key);
            return true;
        }
        int[] store = this.store;
        int resolution = this.resolution;
        int mask = this.mask;
        int indexPlusOffset = key & 0x7F;
        int index = store[indexPlusOffset];
        int search = key >>> 7;
        int depth = 7;
        while (index > 0) {
            indexPlusOffset = index + (search & mask);
            index = store[indexPlusOffset];
            search >>>= resolution;
            depth += resolution;
        }
        if (index == 0) {
            store[indexPlusOffset] = -this.newKeyIndex(key);
            return true;
        }
        int oldKey = this.keys[-index];
        if (oldKey == key) {
            return false;
        }
        int oldKeyIndex = index;
        int newIndex = this.newBranchIndex();
        store = this.store;
        index = this.store[indexPlusOffset] = newIndex;
        int oldSearch = oldKey >>> depth;
        while ((newOffset = search & mask) == (oldOffset = oldSearch & mask)) {
            newIndex = this.newBranchIndex();
            store = this.store;
            int n = newIndex;
            this.store[index + newOffset] = n;
            index = n;
            search >>>= resolution;
            oldSearch >>>= resolution;
        }
        store[index + oldOffset] = oldKeyIndex;
        store[index + newOffset] = -this.newKeyIndex(key);
        return true;
    }

    private int newBranchIndex() {
        int result;
        int storeSize = this.storeSize;
        if ((storeSize += (result = this.size == 0 ? 0 : storeSize) == 0 ? 128 : this.width) >= this.store.length) {
            int[] newStore = new int[(int)(1.5 * (double)storeSize)];
            System.arraycopy(this.store, 0, newStore, 0, this.store.length);
            this.store = newStore;
        } else {
            Arrays.fill(this.store, result, storeSize, 0);
        }
        this.storeSize = storeSize;
        return result;
    }

    private int newKeyIndex(int key) {
        ++this.size;
        this.keys[this.size] = key;
        return this.size;
    }
}

