/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.ate.syntax.generic;

import java.util.ArrayList;
import java.util.List;
import org.antlr.works.ate.syntax.misc.ATELine;
import org.antlr.works.ate.syntax.misc.ATEToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ATESyntaxLexer {
    public static final int TOKEN_SINGLE_QUOTE_STRING = 1;
    public static final int TOKEN_DOUBLE_QUOTE_STRING = 2;
    public static final int TOKEN_SINGLE_COMMENT = 3;
    public static final int TOKEN_COMPLEX_COMMENT = 4;
    public static final int TOKEN_ID = 5;
    public static final int TOKEN_CHAR = 6;
    public static final int TOKEN_LPAREN = 7;
    public static final int TOKEN_RPAREN = 8;
    public static final int TOKEN_LCURLY = 9;
    public static final int TOKEN_RCURLY = 10;
    public static final int TOKEN_LBRACK = 11;
    public static final int TOKEN_RBRACK = 12;
    public static final int TOKEN_COLON = 13;
    public static final int TOKEN_SEMI = 14;
    public static final int TOKEN_OTHER = 15;
    protected List<ATEToken> tokens;
    protected String text;
    protected int position;
    protected int lineNumber;
    protected int lineIndex;
    protected List<ATELine> lines = new ArrayList<ATELine>();
    protected boolean controlCharacter;
    protected char c0;
    protected char c1;

    public ATESyntaxLexer() {
        this.tokens = new ArrayList<ATEToken>();
    }

    public void close() {
        this.lines.clear();
        this.tokens.clear();
    }

    public List<ATEToken> getTokens() {
        return this.tokens;
    }

    public List<ATELine> getLines() {
        return this.lines;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void tokenize(String text) {
        this.text = text;
        this.position = -1;
        this.lineNumber = 0;
        this.lines.clear();
        this.lines.add(new ATELine(0));
        this.tokens.clear();
        this.tokenize();
    }

    protected void tokenize() {
        while (this.nextCharacter()) {
            ATEToken token = this.customMatch();
            if (token == null) {
                if (this.c0 == '\'') {
                    token = this.matchSingleQuoteString();
                } else if (this.c0 == '\"') {
                    token = this.matchDoubleQuoteString();
                } else if (this.c0 == '/' && this.c1 == '/') {
                    token = this.matchSingleComment();
                } else if (this.c0 == '/' && this.c1 == '*') {
                    token = this.matchComplexComment();
                } else if (this.isLetter()) {
                    token = this.matchID();
                } else if (this.c0 == '(') {
                    token = this.createNewToken(7);
                } else if (this.c0 == ')') {
                    token = this.createNewToken(8);
                } else if (this.c0 == '{') {
                    token = this.createNewToken(9);
                } else if (this.c0 == '}') {
                    token = this.createNewToken(10);
                } else if (this.c0 == '[') {
                    token = this.createNewToken(11);
                } else if (this.c0 == ']') {
                    token = this.createNewToken(12);
                } else if (this.c0 == ':') {
                    token = this.createNewToken(13);
                } else if (this.c0 == ';') {
                    token = this.createNewToken(14);
                } else if (!this.isWhitespace()) {
                    token = this.createNewToken(6);
                }
            }
            this.addToken(token);
        }
    }

    protected ATEToken customMatch() {
        return null;
    }

    public void addToken(ATEToken token) {
        if (token != null) {
            token.index = this.tokens.size();
            this.tokens.add(token);
        }
    }

    protected ATEToken matchID() {
        int sp = this.position;
        while (this.isID(this.c1) && this.nextCharacter()) {
        }
        return this.createNewToken(5, sp);
    }

    public ATEToken matchSingleQuoteString() {
        int sp = this.position;
        while (this.nextCharacter()) {
            if (this.c0 != '\'' && !this.matchNewLine() || this.controlCharacter) continue;
            return this.createNewToken(1, sp);
        }
        return null;
    }

    public ATEToken matchDoubleQuoteString() {
        int sp = this.position;
        while (this.nextCharacter()) {
            if (this.c0 != '\"' && !this.matchNewLine() || this.controlCharacter) continue;
            return this.createNewToken(2, sp);
        }
        return null;
    }

    public ATEToken matchSingleComment() {
        int sp = this.position;
        while (this.nextCharacter()) {
            if (!this.matchNewLine()) continue;
            return this.createNewToken(3, sp, this.position);
        }
        return this.createNewToken(3, sp, this.position);
    }

    public ATEToken matchComplexComment() {
        int sp = this.position;
        while (this.nextCharacter()) {
            if (this.c0 != '*' || this.c1 != '/') continue;
            this.nextCharacter();
            return this.createNewToken(4, sp, Math.min(this.position + 1, this.text.length()));
        }
        return this.createNewToken(4, sp, this.position);
    }

    public boolean nextCharacter() {
        boolean valid = false;
        int length = this.text.length();
        this.controlCharacter = false;
        this.c1 = '\u0000';
        this.c0 = '\u0000';
        ++this.position;
        if (this.position < length) {
            if (this.text.charAt(this.position) == '\\') {
                this.controlCharacter = true;
                ++this.position;
            }
            boolean bl = valid = this.position < length;
            if (valid) {
                this.c0 = this.text.charAt(this.position);
                if (this.position + 1 < length) {
                    this.c1 = this.text.charAt(this.position + 1);
                }
            }
            if (this.matchNewLine()) {
                ++this.lineNumber;
                this.lineIndex = this.position + 1;
                this.lines.add(new ATELine(this.lineIndex));
            }
        }
        return valid;
    }

    public boolean matchNewLine() {
        if (this.c0 == '\n') {
            return true;
        }
        if (this.c0 == '\r' && this.c1 == '\n') {
            return true;
        }
        return this.c0 == '\r';
    }

    public boolean isWhitespace() {
        return Character.isWhitespace(this.c0);
    }

    public boolean isLetter() {
        return Character.isLetter(this.c0);
    }

    public boolean isLetterOrDigit() {
        return this.isLetterOrDigit(this.c0);
    }

    public boolean isLetterOrDigit(char c) {
        return Character.isLetterOrDigit(c);
    }

    public boolean isID(char c) {
        if (Character.isLetterOrDigit(c)) {
            return true;
        }
        return c == '_' || c == '$';
    }

    public ATEToken createNewToken(int type) {
        return this.createNewToken(type, this.position);
    }

    public ATEToken createNewToken(int type, int start) {
        return this.createNewToken(type, start, this.position + 1);
    }

    public ATEToken createNewToken(int type, int start, int end) {
        return this.createNewToken(type, start, end, this.lineNumber, this.lineNumber, this.lineIndex, this.lineIndex);
    }

    public ATEToken createNewToken(int type, int start, int end, int startLineNumber, int endLineNumber, int startLineIndex, int endLineIndex) {
        return new ATEToken(type, start, end, startLineNumber, endLineNumber, startLineIndex, endLineIndex, this.text);
    }
}

