/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.editor.navigation;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.antlr.works.editor.navigation.GoToRuleDelegate;
import org.antlr.works.utils.OverlayObject;
import org.antlr.xjlib.appkit.frame.XJWindow;

public class GoToRule
extends OverlayObject {
    public JTextField ruleNameField;
    public JList matchingRuleList;
    public DefaultListModel matchingRuleListModel;
    public JScrollPane matchingRuleScrollPane;
    public GoToRuleDelegate delegate;
    public static final int VISIBLE_MATCHING_RULES = 15;

    public GoToRule(GoToRuleDelegate delegate, XJWindow window, JComponent parentComponent) {
        super(window, parentComponent);
        this.delegate = delegate;
    }

    public void close() {
        super.close();
    }

    public JComponent overlayCreateInterface() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel("Go To Rule:"), "North");
        this.ruleNameField = new JTextField();
        this.ruleNameField.addKeyListener(new TextFieldKeyAdapter());
        this.ruleNameField.getDocument().addDocumentListener(new TextFieldDocumentListener());
        this.matchingRuleListModel = new DefaultListModel();
        this.matchingRuleList = new JList(this.matchingRuleListModel);
        this.matchingRuleList.setSelectionMode(0);
        this.matchingRuleList.setBackground(new Color(235, 244, 254));
        this.matchingRuleList.setPrototypeCellValue("This is a rule name g");
        this.matchingRuleList.addKeyListener(new ListKeyAdapter());
        this.matchingRuleList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    GoToRule.this.goToRule();
                    GoToRule.this.hide();
                }
            }
        });
        this.matchingRuleScrollPane = new JScrollPane(this.matchingRuleList, 20, 31);
        this.matchingRuleScrollPane.setBorder(BorderFactory.createBevelBorder(0));
        this.matchingRuleScrollPane.setVisible(false);
        this.parentFrame.getLayeredPane().add((Component)this.matchingRuleScrollPane, JLayeredPane.MODAL_LAYER);
        panel.add((Component)this.ruleNameField, "South");
        return panel;
    }

    public boolean overlayWillDisplay() {
        this.ruleNameField.setText("");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GoToRule.this.ruleNameField.requestFocusInWindow();
            }
        });
        this.updateAutoCompletionList();
        return true;
    }

    public void hide() {
        super.hide();
        this.matchingRuleScrollPane.setVisible(false);
    }

    public void resize() {
        super.resize();
        this.resizeMatchingRules();
    }

    public void resizeMatchingRules() {
        Rectangle r = this.content.getBounds();
        int height = this.matchingRuleList.getFixedCellHeight();
        int size = this.matchingRuleListModel.size();
        if (size > 0) {
            height = height * Math.min(15, size) + 5;
            this.matchingRuleScrollPane.setBounds(r.x, r.y + r.height, r.width, height);
        }
    }

    public void updateAutoCompletionList() {
        this.matchingRuleListModel.removeAllElements();
        List<String> rules = this.delegate.getRulesStartingWith(this.ruleNameField.getText().toLowerCase());
        if (rules.isEmpty()) {
            this.matchingRuleScrollPane.setVisible(false);
            this.ruleNameField.setForeground(Color.red);
            return;
        }
        this.ruleNameField.setForeground(Color.black);
        for (String rule : rules) {
            this.matchingRuleListModel.addElement(rule);
        }
        this.matchingRuleList.setSelectedIndex(0);
        this.resizeMatchingRules();
        this.matchingRuleScrollPane.setVisible(true);
    }

    public void selectNextListElement(int direction) {
        int index = this.matchingRuleList.getSelectedIndex();
        index += direction;
        index = Math.min(Math.max(0, index), this.matchingRuleListModel.size() - 1);
        this.matchingRuleList.setSelectedIndex(index);
        this.matchingRuleList.scrollRectToVisible(this.matchingRuleList.getCellBounds(index, index));
    }

    public void goToRule() {
        if (this.matchingRuleListModel.isEmpty()) {
            return;
        }
        int index = this.matchingRuleList.getSelectedIndex();
        if (index >= 0) {
            this.delegate.goToRule((String)this.matchingRuleListModel.get(index));
        }
    }

    public class TextFieldDocumentListener
    implements DocumentListener {
        public void insertUpdate(DocumentEvent event) {
            GoToRule.this.updateAutoCompletionList();
        }

        public void removeUpdate(DocumentEvent event) {
            GoToRule.this.updateAutoCompletionList();
        }

        public void changedUpdate(DocumentEvent event) {
            GoToRule.this.updateAutoCompletionList();
        }
    }

    public class TextFieldKeyAdapter
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            if (e.isConsumed()) {
                return;
            }
            if (!GoToRule.this.content.isVisible()) {
                return;
            }
            switch (e.getKeyCode()) {
                case 27: {
                    GoToRule.this.hide();
                    e.consume();
                    break;
                }
                case 10: {
                    GoToRule.this.goToRule();
                    GoToRule.this.hide();
                    e.consume();
                    break;
                }
                case 38: {
                    GoToRule.this.selectNextListElement(-1);
                    e.consume();
                    break;
                }
                case 40: {
                    GoToRule.this.selectNextListElement(1);
                    e.consume();
                }
            }
        }
    }

    public class ListKeyAdapter
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            if (e.isConsumed()) {
                return;
            }
            if (!GoToRule.this.content.isVisible()) {
                return;
            }
            switch (e.getKeyCode()) {
                case 27: {
                    GoToRule.this.hide();
                    e.consume();
                    break;
                }
                case 10: {
                    GoToRule.this.goToRule();
                    GoToRule.this.hide();
                    e.consume();
                    break;
                }
                case 38: {
                    GoToRule.this.selectNextListElement(-1);
                    e.consume();
                    break;
                }
                case 40: {
                    GoToRule.this.selectNextListElement(1);
                    e.consume();
                }
            }
        }
    }
}

