/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.stringtemplate.element;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.antlr.works.ate.folding.ATEFoldingEntity;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.stringtemplate.element.ElementTemplateScopable;
import org.antlr.works.stringtemplate.syntax.ATEStringTemplateSyntaxParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementTemplateRule
extends ElementTemplateScopable
implements Comparable,
ATEFoldingEntity {
    public String name;
    public ATEToken start;
    public ATEToken definedToBe;
    public ATEToken end;
    public List<ATEToken> args;
    public boolean expanded = true;
    protected ATEStringTemplateSyntaxParser parser;

    public ElementTemplateRule(String name) {
        this.name = name;
    }

    public ElementTemplateRule(ATEStringTemplateSyntaxParser parser, String name, ATEToken start, ATEToken definedToBe, ATEToken end, List<ATEToken> args) {
        this.parser = parser;
        this.name = name;
        this.start = start;
        this.definedToBe = definedToBe;
        this.end = end;
        this.args = args;
    }

    public int getStartIndex() {
        return this.start.getStartIndex();
    }

    public int getEndIndex() {
        return this.end.getEndIndex();
    }

    public int getLength() {
        return this.getEndIndex() - this.getStartIndex();
    }

    public int getInternalTokensStartIndex() {
        Iterator<ATEToken> iter = this.getTokens().iterator();
        while (iter.hasNext()) {
            ATEToken token = iter.next();
            if (token.type != 101) continue;
            token = iter.next();
            return token.getStartIndex();
        }
        return -1;
    }

    public int getInternalTokensEndIndex() {
        ATEToken token = this.parser.getTokens().get(this.end.index - 1);
        return token.getEndIndex();
    }

    public List<ATEToken> getTokens() {
        ArrayList<ATEToken> t = new ArrayList<ATEToken>();
        for (int index = this.start.index; index < this.end.index; ++index) {
            t.add(this.parser.getTokens().get(index));
        }
        return t;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public String toString() {
        return this.name;
    }

    public boolean containsIndex(int index) {
        return index >= this.getStartIndex() && index <= this.getEndIndex();
    }

    public int compareTo(Object o) {
        ElementTemplateRule otherRule = (ElementTemplateRule)o;
        return this.name.compareTo(otherRule.name);
    }

    public int getUniqueIdentifier() {
        return this.name.hashCode();
    }

    public boolean canBeCollapsed() {
        return this.definedToBe.startLineNumber <= this.end.startLineNumber - 1;
    }

    @Override
    public void foldingEntitySetExpanded(boolean expanded) {
        this.setExpanded(expanded);
    }

    @Override
    public boolean foldingEntityIsExpanded() {
        return this.isExpanded();
    }

    @Override
    public boolean foldingEntityCanBeCollapsed() {
        return this.canBeCollapsed();
    }

    @Override
    public int foldingEntityGetStartParagraphIndex() {
        return this.getStartIndex();
    }

    @Override
    public int foldingEntityGetStartIndex() {
        return this.definedToBe.getStartIndex();
    }

    @Override
    public int foldingEntityGetEndIndex() {
        return this.getEndIndex();
    }

    @Override
    public int foldingEntityGetStartLine() {
        return this.definedToBe.startLineNumber;
    }

    @Override
    public int foldingEntityGetEndLine() {
        return this.end.endLineNumber;
    }

    @Override
    public String foldingEntityPlaceholderString() {
        return ": ... ;";
    }

    @Override
    public String foldingEntityID() {
        return String.valueOf(this.getUniqueIdentifier());
    }

    @Override
    public int foldingEntityLevel() {
        return 0;
    }

    public int getItemIndex() {
        return this.getStartIndex();
    }

    public void setItemIndex(int index) {
        this.start.start = index;
    }
}

