/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.image.BufferedImage;
import org.antlr.works.Console;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.components.GrammarWindow;
import org.antlr.works.editor.GrammarWindowTab;
import org.antlr.works.grammar.antlr.ANTLRGrammarEngine;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.works.grammar.syntax.GrammarSyntaxEngine;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.visualization.VisualDrawing;
import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.GContextProvider;
import org.antlr.works.visualization.graphics.GEngineGraphics;
import org.antlr.works.visualization.graphics.graph.GGraphAbstract;
import org.antlr.works.visualization.graphics.panel.GPanel;
import org.antlr.works.visualization.skin.Skin;
import org.antlr.works.visualization.skin.syntaxdiagram.SDSkin;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJFileChooser;

public class SyntaxDiagramTab
extends GrammarWindowTab
implements GContextProvider {
    protected VisualDrawing drawing;
    protected GContext context;
    protected Skin skin = new SDSkin();
    protected GPanel panel;
    protected boolean enable = true;

    public SyntaxDiagramTab(GrammarWindow editor) {
        super(editor);
        this.context = new GContext();
        this.context.setEngine(new GEngineGraphics());
        this.context.setSkin(this.skin);
        this.context.setProvider(this);
        this.panel = new GPanel(editor, this.context);
        this.drawing = new VisualDrawing(this);
    }

    public org.antlr.works.utils.Console getConsole() {
        return this.window.getConsoleTab();
    }

    public void close() {
        this.panel.close();
        this.drawing.stop();
        long t = System.currentTimeMillis();
        while (this.drawing.isRunning() && System.currentTimeMillis() - t < 5000L) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.context.setProvider(null);
    }

    public void setEnable(boolean flag) {
        this.enable = flag;
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public void toggleNFAOptimization() {
        this.drawing.toggleNFAOptimization();
    }

    public Color contextGetColorForLabel(String label) {
        if (label.charAt(0) == '\'' || label.charAt(0) == '\"') {
            return AWPrefs.getSyntaxColor("PREF_SYNTAX_STRING");
        }
        if (ATEToken.isLexerName(label)) {
            return GrammarSyntaxEngine.COLOR_LEXER;
        }
        return GrammarSyntaxEngine.COLOR_PARSER;
    }

    public void setText(String text, String filename) {
        if (this.isEnabled()) {
            this.drawing.setText(text);
        }
    }

    public void setRule(ElementRule rule, boolean immediate) {
        if (this.isEnabled()) {
            this.drawing.setRule(rule, immediate);
        }
    }

    public void setPlaceholder(String placeholder) {
        this.panel.setPlaceholder(placeholder);
        this.panel.setGraphs(null);
    }

    public void cancelDrawingProcess() {
        this.drawing.skip();
    }

    public void clearCacheGraphs() {
        this.drawing.clearCacheGraphs();
    }

    public void createGraphsForRule(ElementRule rule) throws Exception {
        this.drawing.createGraphsForRule(rule);
    }

    public boolean update() {
        this.panel.createPanel();
        return this.drawing.refresh();
    }

    public ANTLRGrammarEngine getEngineGrammar() {
        return this.window.getGrammarEngine().getRootEngine().getANTLRGrammarEngine();
    }

    public Container getContainer() {
        return this.panel.getContainer();
    }

    public GGraphAbstract getCurrentGraph() {
        return this.panel.getCurrentGraph();
    }

    public boolean canSaveImage() {
        return this.getImage() != null;
    }

    public BufferedImage getImage() {
        return this.panel.getImageOfView();
    }

    public boolean canExportToBitmap() {
        return true;
    }

    public boolean canExportToEPS() {
        return true;
    }

    public String getTabName() {
        return "Syntax Diagram";
    }

    public Component getTabComponent() {
        return this.getContainer();
    }

    public void serializeSyntaxDiagram() {
        XJFileChooser fc = XJFileChooser.shared();
        if (fc.displaySaveDialog(this.window.getJavaContainer(), "txt", "XML representation", false)) {
            String[] args = new String[]{"-f", this.window.getFilePath(), "-serialize", fc.getSelectedFilePath(), "-verbose"};
            try {
                Console.main(args);
            }
            catch (Exception e) {
                e.printStackTrace();
                XJAlert.display(this.window.getJavaContainer(), "Serialize Syntax Diagram", e.toString());
            }
        }
    }
}

