/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.analysis.NFAState;
import org.antlr.tool.Grammar;
import org.antlr.works.grammar.antlr.ANTLRGrammarEngine;
import org.antlr.works.grammar.antlr.GrammarError;
import org.antlr.works.utils.Console;
import org.antlr.works.visualization.fa.FAFactory;
import org.antlr.works.visualization.fa.FAState;
import org.antlr.works.visualization.graphics.GRenderer;
import org.antlr.works.visualization.graphics.graph.GGraph;
import org.antlr.works.visualization.graphics.graph.GGraphGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GFactory {
    protected GRenderer renderer = new GRenderer();
    protected boolean optimize = true;
    protected Console console = null;

    public void setOptimize(boolean flag) {
        this.optimize = flag;
    }

    public void toggleNFAOptimization() {
        this.optimize = !this.optimize;
    }

    public void setConsole(Console console) {
        this.console = console;
    }

    public List buildGraphsForRule(ANTLRGrammarEngine antlrEngineGrammar, String rule, List<GrammarError> errors) throws Exception {
        if (antlrEngineGrammar == null) {
            return null;
        }
        if (errors == null || errors.size() == 0) {
            return Collections.singletonList(this.buildGraphsForRule(antlrEngineGrammar, rule));
        }
        return this.buildGraphsForErrors(antlrEngineGrammar, rule, errors);
    }

    public GGraph buildGraphsForRule(ANTLRGrammarEngine antlrEngineGrammar, String rule) throws Exception {
        NFAState startState = antlrEngineGrammar.getRuleStartState(rule);
        if (startState == null) {
            return null;
        }
        FAState state = new FAFactory(antlrEngineGrammar.getGrammarForRule(rule)).buildNFA(startState, this.optimize);
        GGraph graph = this.renderer.render(state);
        graph.setName(rule);
        return graph;
    }

    public List<GGraphGroup> buildGraphsForErrors(ANTLRGrammarEngine antlrEngineGrammar, String rule, List<GrammarError> errors) throws Exception {
        ArrayList<GGraphGroup> graphs = new ArrayList<GGraphGroup>();
        for (GrammarError error : errors) {
            graphs.add(this.buildGraphGroup(antlrEngineGrammar.getGrammarForRule(rule), error));
        }
        return graphs;
    }

    private GGraphGroup buildGraphGroup(Grammar grammar, GrammarError error) {
        ArrayList<GGraph> graphs = new ArrayList<GGraph>();
        FAFactory factory = new FAFactory(grammar);
        for (String rule : error.rules) {
            NFAState startState = grammar.getRuleStartState(rule);
            FAState state = factory.buildNFA(startState, this.optimize);
            GGraph graph = this.renderer.render(state);
            graph.setName(rule);
            graphs.add(graph);
        }
        GGraphGroup gg = new GGraphGroup();
        for (GGraph graph : graphs) {
            if (!graph.containsAtLeastOneState(error.states)) continue;
            gg.add(graph);
        }
        for (int i = 0; i < error.paths.size(); ++i) {
            List states = error.paths.get(i);
            Boolean disabled = error.pathsDisabled.get(i);
            try {
                gg.addPath(states, disabled, factory.getSkippedStatesMap());
                continue;
            }
            catch (Exception e) {
                if (this.console == null) {
                    e.printStackTrace();
                    continue;
                }
                this.console.println(e);
            }
        }
        for (Object[] unreachableAlt : error.unreachableAlts) {
            gg.addUnreachableAlt((NFAState)unreachableAlt[0], (Integer)unreachableAlt[1]);
        }
        if (error.paths.size() > 0) {
            gg.getPathGroup().setPathVisible(0, true);
        }
        return gg;
    }
}

