/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.event;

import java.awt.Point;
import java.awt.event.MouseEvent;
import org.antlr.xjlib.appkit.gview.GView;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.appkit.gview.event.GAbstractEvent;
import org.antlr.xjlib.appkit.gview.event.GEventManager;
import org.antlr.xjlib.appkit.gview.object.GElement;

public class GEventDragElement
extends GAbstractEvent {
    public GElement dragElement = null;
    protected boolean dragging = false;
    protected Point p1 = null;
    protected Point p2 = null;
    protected Vector2D dragElementOffset = null;

    public GEventDragElement(GView view) {
        super(view);
    }

    public void mousePressed(MouseEvent e, Point mousePosition) {
        if (this.hasExclusiveValue(GEventManager.EXCLUSIVE_DRAG_VALUE)) {
            return;
        }
        if (this.hasExclusiveValue(GEventManager.EXCLUSIVE_CREATE_LINK_VALUE)) {
            return;
        }
        if (e.getClickCount() != 1) {
            return;
        }
        if ((e.getModifiersEx() & 0x40) == 64) {
            return;
        }
        this.dragElement = this.delegate.eventQueryElementAtPoint(mousePosition);
        if (this.dragElement != null && this.delegate.eventIsSelectedElement(this.dragElement)) {
            this.addExclusiveValue(GEventManager.EXCLUSIVE_DRAG_VALUE);
            this.dragging = true;
            this.p1 = mousePosition;
        } else if (this.dragElement != null && this.dragElement.isDraggable()) {
            this.addExclusiveValue(GEventManager.EXCLUSIVE_DRAG_VALUE);
            this.dragElement.beginDrag();
            this.dragElementOffset = Vector2D.vector(mousePosition).sub(this.dragElement.getPosition());
            return;
        }
        this.dragElement = null;
    }

    public void mouseReleased(MouseEvent e, Point mousePosition) {
        this.removeExclusiveValue(GEventManager.EXCLUSIVE_DRAG_VALUE);
        this.view.hideAllMagnetics();
        this.dragElement = null;
        this.dragging = false;
    }

    public void mouseDragged(MouseEvent e, Point mousePosition) {
        if (this.dragElement != null) {
            Vector2D mouse = Vector2D.vector(mousePosition);
            Vector2D position = mouse.sub(this.dragElementOffset);
            this.view.showAndAjustPositionToMagnetics(position);
            this.dragElement.moveToPosition(position);
            this.delegate.eventChangeDone();
            this.delegate.eventShouldRepaint();
        } else if (this.dragging) {
            this.p2 = mousePosition;
            this.delegate.eventMoveSelectedElements(this.p2.x - this.p1.x, this.p2.y - this.p1.y);
            this.p1 = this.p2;
            this.delegate.eventChangeDone();
            this.delegate.eventShouldRepaint();
        }
    }
}

