/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.w3c.dom.Element;

public class CodeSetEntry {
    private LinkedHashMap _codeset = null;
    private HashMap _codesetEntryParams = null;
    private HashMap _codesetEntryHelp = null;
    private String _label = null;
    private String _language = null;
    public static final CodeSetEntry _empty = new CodeSetEntry();
    public static final String[][] _emptyValues = new String[0][0];
    public static final String[] _emptyItems = new String[0];
    private Element _codeSetElement;

    public CodeSetEntry() {
    }

    public CodeSetEntry(String label, LinkedHashMap codeSetValues) {
        this._label = label;
        this._codeset = codeSetValues;
    }

    public CodeSetEntry(String label, LinkedHashMap codeSetValues, HashMap paramValues, HashMap helpValues) {
        this._label = label;
        this._codeset = codeSetValues;
        this._codesetEntryParams = paramValues != null && paramValues.size() > 0 ? paramValues : null;
        this._codesetEntryHelp = helpValues != null && helpValues.size() > 0 ? helpValues : null;
    }

    public String getLabel() {
        return this._label;
    }

    public LinkedHashMap getCodeset() {
        return this._codeset;
    }

    public String[][] getCodeItems() {
        if (this.getCodeset() == null) {
            return _emptyValues;
        }
        LinkedHashMap cs = this.getCodeset();
        Iterator keys = cs.keySet().iterator();
        String[][] codeItems = new String[cs.size()][1];
        String key = null;
        int counter = 0;
        while (keys.hasNext()) {
            key = (String)keys.next();
            codeItems[counter] = new String[]{key, (String)cs.get(key)};
            ++counter;
        }
        return codeItems;
    }

    public String[] getCodeItemKeys() {
        LinkedHashMap cs = this.getCodeset();
        if (cs == null) {
            return _emptyItems;
        }
        Iterator keys = cs.keySet().iterator();
        String[] codekeys = new String[cs.size()];
        String key = null;
        int counter = 0;
        while (keys.hasNext()) {
            codekeys[counter] = key = (String)keys.next();
            ++counter;
        }
        return codekeys;
    }

    public String getText(String id) {
        String text = null;
        if (this.getCodeset() != null) {
            text = (String)this.getCodeset().get(id);
        }
        return text;
    }

    public String[] getTextArray(String[] id) {
        Vector<String> found = new Vector<String>();
        String text = null;
        LinkedHashMap cs = this.getCodeset();
        if (cs != null) {
            for (int i = 0; i < id.length; ++i) {
                text = (String)cs.get(id[i]);
                if (text == null) continue;
                found.add(text);
            }
        }
        String[] foundId = new String[found.size()];
        int counter = 0;
        Iterator iterator = found.iterator();
        while (iterator.hasNext()) {
            foundId[counter] = (String)iterator.next();
            ++counter;
        }
        return foundId;
    }

    public String getId(String text) {
        String id = null;
        if (this.getCodeset() != null) {
            Iterator entryIterator = this.getCodeset().entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry entry = entryIterator.next();
                if (!entry.getValue().equals(text)) continue;
                id = (String)entry.getKey();
                break;
            }
        }
        return id;
    }

    public String getId(int pos) {
        String id = null;
        int counter = 0;
        if (this.getCodeset() != null) {
            Iterator entryIterator = this.getCodeset().entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry entry = entryIterator.next();
                if (pos == counter) {
                    id = (String)entry.getKey();
                    break;
                }
                ++counter;
            }
        }
        return id;
    }

    public String[] getItems() {
        String[] items = null;
        items = this.getCodeset() != null ? this._codeset.values().toArray(new String[0]) : _emptyItems;
        return items;
    }

    public String getEntryParameter(String id) {
        if (this._codesetEntryParams != null) {
            return (String)this._codesetEntryParams.get(id);
        }
        return null;
    }

    public String getEntryHelp(String id) {
        if (this._codesetEntryHelp != null) {
            return (String)this._codesetEntryHelp.get(id);
        }
        return null;
    }

    public String[][] getSelectableEntries(String[] ids) {
        String[][] res = null;
        if (ids == null || ids.length == 0) {
            return null;
        }
        if (this._codeset != null) {
            ArrayList<String[]> elems = new ArrayList<String[]>(this._codeset.size());
            for (int i = 0; i < ids.length; ++i) {
                String codeEntry;
                String key = ids[i];
                if (key == null || (codeEntry = (String)this._codeset.get(key)) == null) continue;
                elems.add(new String[]{key, codeEntry});
            }
            int eSize = elems.size();
            res = new String[eSize][];
            for (int e = 0; e < eSize; ++e) {
                res[e] = (String[])elems.get(e);
            }
        } else {
            res = new String[ids.length][2];
            for (int r = 0; r < res.length; ++r) {
                res[r][0] = ids[r];
                res[r][1] = ids[r];
            }
        }
        return res;
    }

    public void setHierarchical(Element codeSetElement) {
        this._codeSetElement = codeSetElement;
    }

    public Element getHierarchicalElement() {
        return this._codeSetElement;
    }

    public boolean isHierarchical() {
        return this._codeSetElement != null;
    }
}

