/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.dom;

import com.jaxfront.core.dom.CodeSetEntry;
import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.schema.XMLSchema;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.util.URLHelper;
import com.jaxfront.core.xui.CodeSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.xerces.util.XMLResourceIdentifierImpl;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CodeTables {
    private static final String ELEMENT_CODES = "codes";
    private static final String ELEMENT_CODE = "code";
    private static final String ELEMENT_LABEL = "label";
    private static final String ELEMENT_ALIAS = "alias";
    private static final String ELEMENT_CODESET = "codeSet";
    private static final String CODESET_NAME = "name";
    private static final String CODESET_ENTRY_STATUS = "status";
    private static final String CODESET_ENTRY_ID = "id";
    private static final String CODESET_ENTRY_INVALID = "invalid";
    private static final String CODESET_ENTRY_ATTR_PARAM = "param";
    private static final String CODESET_ENTRY_ATTR_HELP = "help";
    private Hashtable _cachedURLs;
    private Hashtable _codesets;
    private String _language;
    static /* synthetic */ Class class$com$jaxfront$core$dom$CodeTables;

    public CodeTables(XMLSchema schema) {
        if (schema.getRootType().getDOM() != null) {
            this._language = schema.getRootType().getDOM().getLanguage();
        }
    }

    public String getId(Type source, String codesetName, String text, String language) {
        return this.getIdByKey(source, codesetName, language, text);
    }

    public String getId(Type source, String codesetName, int pos, String language) {
        return this.getIdByKey(source, codesetName, language, pos);
    }

    public String getIdByKey(Type source, String codesetName, String language, String text) {
        String id = null;
        CodeSetEntry cEntry = this.getCodeSetEntry(true, source, codesetName, language);
        id = cEntry.getId(text);
        return id;
    }

    public String getIdByKey(Type source, String codesetName, String language, int pos) {
        String id = null;
        CodeSetEntry cEntry = this.getCodeSetEntry(true, source, codesetName, language);
        id = cEntry.getId(pos);
        return id;
    }

    public String[] getItems(boolean checkType, Type source, String codesetName, String language) {
        return this.getCodeSetEntry(checkType, source, codesetName, language).getItems();
    }

    public Map getAllItems(Type source, String codesetName, String language) {
        return this.getCodeSetEntry(true, source, codesetName, language).getCodeset();
    }

    public String getCodeSetLabel(String codeSetName, String language) {
        return this.getCodeSetEntry(true, null, codeSetName, language).getLabel();
    }

    public CodeSetEntry getCodeSetEntry(boolean checkType, Type source, String codesetName, String language) {
        CodeSetEntry cEntry = this.getCodeSetEntryInt(CodeTables.createKeyInt(checkType, source, codesetName, language));
        if (cEntry == CodeSetEntry._empty && source != null) {
            String[] languages = source.getDOM().getFingerPrint().getNLSReadingSequence(null);
            if (languages == null) {
                if (!checkType) {
                    cEntry = this.getCodeSetEntryInt(CodeTables.createKeyInt(true, source, codesetName, language));
                }
            } else {
                for (int i = 0; i < languages.length && (cEntry = this.getCodeSetEntryInt(CodeTables.createKeyInt(true, source, codesetName, languages[i]))) == CodeSetEntry._empty; ++i) {
                }
            }
        }
        return cEntry;
    }

    private CodeSetEntry getCodeSetEntryInt(String key) {
        CodeSetEntry entry = CodeSetEntry._empty;
        if (this._codesets != null && (entry = (CodeSetEntry)this._codesets.get(key)) == null) {
            entry = CodeSetEntry._empty;
        }
        return entry;
    }

    public String[][] getCodeItems(Type source, String codesetName) {
        return this.getCodeItems(true, source, codesetName, this.getLanguage());
    }

    public String[][] getCodeItems(boolean checkType, Type source, String codesetName, String language) {
        String[][] result = this.getCodeSetEntry(checkType, source, codesetName, language).getCodeItems();
        return result;
    }

    public String[] getCodeItemKeys(Type source, String codesetName) {
        CodeSetEntry cEntry = this.getCodeSetEntry(true, source, codesetName, this.getLanguage());
        return cEntry.getCodeItemKeys();
    }

    public void setLanguage(String language) {
        this._language = language;
    }

    public String getText(Type source, String codesetName, String id, String language) {
        return this.getCodeSetEntry(true, source, codesetName, language).getText(id);
    }

    public String getEntryHelp(Type source, String codesetName, String id, String language) {
        return this.getCodeSetEntry(true, source, codesetName, language).getEntryHelp(id);
    }

    public String getEntryParam(Type source, String codesetName, String id, String language) {
        return this.getCodeSetEntry(true, source, codesetName, language).getEntryParameter(id);
    }

    public String[] getTextArray(Type source, String name, String[] id, String language) {
        String codeSetName = name + "_" + language;
        if (id == null || id.length == 0) {
            return this.getItems(true, source, name, language);
        }
        return this.getCodeSetEntry(true, source, codeSetName, language).getTextArray(id);
    }

    public boolean initialize(XMLSchema schema, String url) {
        return this.initialize(schema, url, null, null);
    }

    public boolean initialize(XMLSchema schema, String url, URL xuiURL, XMLEntityResolver resolver) {
        return this.loadCodeSet(schema, url, xuiURL, resolver);
    }

    public void initialize(Document codeSetDocument) {
        this.getCodeSets().putAll(CodeTables.createCodeTable(null, codeSetDocument));
    }

    public static URL getCodeSetHelpURL(URL codeSetURL, String language, String codeSetName, String code) {
        String codeSetHelpLookupName = codeSetName + "_" + code + "_" + language + ".html";
        URL codeSetHelpUrl = URLHelper.getUserURL(codeSetURL, codeSetHelpLookupName);
        if (codeSetHelpUrl != null) {
            try {
                URLHelper.openStream(codeSetHelpUrl);
            }
            catch (Throwable t) {
                return null;
            }
        }
        return codeSetHelpUrl;
    }

    public String[] initialize(Type source, String classURL, String codeSetName) {
        String[] codes;
        block7: {
            codes = new String[]{};
            try {
                Class<?> c = Class.forName(classURL);
                if (c != null && CodeSet.class.isAssignableFrom(c)) {
                    Object obj = c.newInstance();
                    Reader reader = ((CodeSet)obj).getCodeSet(source, codeSetName, source.getDOM().getAppVersionNo());
                    codes = this.initialize(source, codeSetName, reader);
                }
            }
            catch (ClassNotFoundException e) {
                if (JAXFrontProperties.LOG_ENABLED) {
                    LogRegistry.getInstance().error(this.getClass(), "CodeSet-Class (" + classURL + ") not found for: " + source.getXPathLocation());
                }
            }
            catch (IllegalAccessException e) {
                if (JAXFrontProperties.LOG_ENABLED) {
                    LogRegistry.getInstance().error(this.getClass(), "Unable to access class: " + classURL);
                }
            }
            catch (InstantiationException e) {
                if (!JAXFrontProperties.LOG_ENABLED) break block7;
                LogRegistry.getInstance().error(this.getClass(), "Unable to instantiate class: " + classURL);
            }
        }
        return codes;
    }

    public String[][] initialize2(Type source, String classURL, String codeSetName) {
        String[][] codes;
        block7: {
            codes = new String[0][0];
            try {
                Class<?> c = Class.forName(classURL);
                if (c != null && CodeSet.class.isAssignableFrom(c)) {
                    Object obj = c.newInstance();
                    Reader reader = ((CodeSet)obj).getCodeSet(source, codeSetName, source.getDOM().getAppVersionNo());
                    codes = this.initialize2(source, codeSetName, reader);
                }
            }
            catch (ClassNotFoundException e) {
                if (JAXFrontProperties.LOG_ENABLED) {
                    LogRegistry.getInstance().error(this.getClass(), "CodeSet-Class (" + classURL + ") not found for: " + source.getXPathLocation());
                }
            }
            catch (IllegalAccessException e) {
                if (JAXFrontProperties.LOG_ENABLED) {
                    LogRegistry.getInstance().error(this.getClass(), "Unable to access class: " + classURL);
                }
            }
            catch (InstantiationException e) {
                if (!JAXFrontProperties.LOG_ENABLED) break block7;
                LogRegistry.getInstance().error(this.getClass(), "Unable to instantiate class: " + classURL);
            }
        }
        return codes;
    }

    public String[][] initialize2(Type source, String codeSetName, Reader reader) {
        String[][] codes = new String[0][0];
        if (source.getDOM().isRunningInXUIEditor()) {
            this.reloadCodeSet(source, reader);
        } else {
            this.loadCodeSet(source, reader);
        }
        String[] nlsLanguageSeq = (String[])source.getDOM().getApplicationProperty("NLS_LANGUAGE_SEQUENCE");
        if (nlsLanguageSeq == null) {
            nlsLanguageSeq = new String[]{source.getDOM().getLanguage()};
        }
        for (int i = 0; i < nlsLanguageSeq.length && (codes = this.getCodeItems(false, source, codeSetName, nlsLanguageSeq[i])).length <= 0; ++i) {
        }
        return codes;
    }

    public String[] initialize(Type source, String codeSetName, Reader reader) {
        String[] codes = new String[]{};
        if (source.getDOM().isRunningInXUIEditor()) {
            this.reloadCodeSet(source, reader);
        } else {
            this.loadCodeSet(source, reader);
        }
        codes = this.getItems(false, source, codeSetName, source.getDOM().getLanguage());
        return codes;
    }

    private void reloadCodeSet(Type source, Reader reader) {
        Document dom;
        block5: {
            dom = null;
            try {
                dom = DOMHelper.createDocument(reader);
            }
            catch (Exception e) {
                if (!JAXFrontProperties.LOG_ENABLED) break block5;
                LogRegistry.getInstance().error(this.getClass(), e.getMessage());
            }
        }
        if (dom == null) {
            if (JAXFrontProperties.LOG_ENABLED) {
                LogRegistry.getInstance().error(this.getClass(), "unable to create document");
            }
        } else {
            this.getCodeSets().putAll(CodeTables.createCodeTable(source, dom));
        }
    }

    private URL evaluateLodingURL(XMLSchema schema, String url, URL xuiURL) {
        URL codeSetURL;
        block7: {
            codeSetURL = null;
            try {
                codeSetURL = new URL(url);
                if (codeSetURL != null) {
                    URLHelper.openStream(codeSetURL);
                }
            }
            catch (MalformedURLException ex) {
            }
            catch (IOException ex) {
                codeSetURL = null;
            }
            if ((url.equals("default") || codeSetURL == null) && schema.getURL() != null && (codeSetURL = URLHelper.getUserURL(schema.getURL(), url)) != null && codeSetURL != null) {
                try {
                    URLHelper.openStream(codeSetURL);
                }
                catch (IOException ex) {
                    codeSetURL = null;
                    if (xuiURL == null) break block7;
                    codeSetURL = URLHelper.getUserURL(xuiURL, url);
                }
            }
        }
        return codeSetURL;
    }

    private boolean loadCodeSet(XMLSchema schema, String url, URL xuiURL, XMLEntityResolver resolver) {
        boolean couldLoadCodeSet;
        block20: {
            String lookupName = url;
            Document dom = null;
            couldLoadCodeSet = true;
            try {
                boolean foundInCache = this.isCached(CodeTables.createCacheKey(schema, url, xuiURL));
                URL codesURL = null;
                if (foundInCache) {
                    couldLoadCodeSet = true;
                    break block20;
                }
                InputStream is = null;
                if (resolver != null) {
                    try {
                        is = resolver.resolveEntity((XMLResourceIdentifier)new XMLResourceIdentifierImpl(null, url, null, null)).getByteStream();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if (is == null && (codesURL = this.evaluateLodingURL(schema, url, xuiURL)) != null) {
                    try {
                        is = JAXFrontProperties.getInstance().getURLResolver().resolveURL(codesURL);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (is == null) {
                    ClassLoader cl = this.getClass().getClassLoader();
                    is = cl.getResourceAsStream(lookupName);
                    String urlBase = JAXFrontProperties.getInstance().getURLBase();
                    if (is == null && urlBase != null) {
                        try {
                            URL baseURL = new URL(urlBase);
                            url = new URL(baseURL, url).toString();
                        }
                        catch (MalformedURLException ex) {
                            // empty catch block
                        }
                        if (LogRegistry.getInstance().logLogs()) {
                            LogRegistry.getInstance().log(this.getClass(), "try (" + url + ") to load codeSet from URL-Base: " + urlBase);
                        }
                        codesURL = new URL(url);
                        is = JAXFrontProperties.getInstance().getURLResolver().resolveURL(codesURL);
                    }
                }
                if (is != null) {
                    if (LogRegistry.getInstance().logLogs()) {
                        LogRegistry.getInstance().log(this.getClass(), "*** START initialize codeSet (" + lookupName + ") ...");
                    }
                    dom = DOMHelper.createDocument(is);
                    this.getCachedURLs().put(CodeTables.createCacheKey(schema, url, xuiURL), "");
                    if (LogRegistry.getInstance().logLogs()) {
                        LogRegistry.getInstance().log(this.getClass(), "*** END   initialize codeSet (" + lookupName + ") ...");
                    }
                }
                if (dom != null) {
                    this.getCodeSets().putAll(CodeTables.createCodeTable(null, dom));
                    couldLoadCodeSet = true;
                } else if (lookupName != null && !lookupName.equals("default") && LogRegistry.getInstance().logWarnings()) {
                    LogRegistry.getInstance().warn(this.getClass(), "Unable to create codeSet for (" + lookupName + ") from URL: " + url);
                }
            }
            catch (Exception e) {
                if (!LogRegistry.getInstance().logWarnings()) break block20;
                LogRegistry.getInstance().warn(this.getClass(), "Unable to create codeSet for (" + lookupName + ") from URL: " + url);
                LogRegistry.getInstance().warn(this.getClass(), "--> Reason: " + e.getMessage());
            }
        }
        return couldLoadCodeSet;
    }

    public Hashtable getCodeSets() {
        if (this._codesets == null) {
            this._codesets = new Hashtable();
        }
        return this._codesets;
    }

    public static String createCacheKey(XMLSchema schema, String url, URL xuiURL) {
        StringBuffer key = new StringBuffer();
        if (schema != null) {
            key.append(schema.hashCode());
        } else {
            key.append("no-schema");
        }
        key.append("_;_");
        key.append(url);
        key.append("_;_");
        key.append(xuiURL);
        return key.toString();
    }

    public static URL getCodeSetURL(XMLSchema schema, String url) {
        URL codeSetURL = null;
        if (url != null) {
            try {
                codeSetURL = new URL(url);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (url.equals("default") || codeSetURL == null) {
                codeSetURL = URLHelper.getUserURL(schema.getURL(), url);
            }
        }
        return codeSetURL;
    }

    private void loadCodeSet(Type source, Reader input) {
        boolean hasBeenInitialized = this.hasCodeSetBeenInitialized(source);
        if (!hasBeenInitialized) {
            Document dom;
            block6: {
                dom = null;
                try {
                    dom = DOMHelper.createDocument(input);
                }
                catch (Exception e) {
                    if (!JAXFrontProperties.LOG_ENABLED) break block6;
                    LogRegistry.getInstance().error(this.getClass(), e.getMessage());
                }
            }
            if (dom == null) {
                if (JAXFrontProperties.LOG_ENABLED) {
                    LogRegistry.getInstance().error(this.getClass(), "unable to create document");
                }
            } else {
                this.getCodeSets().putAll(CodeTables.createCodeTable(source, dom));
            }
        }
    }

    private boolean hasCodeSetBeenInitialized(Type source) {
        boolean hasBeenInitialized = false;
        if (this._codesets != null) {
            Enumeration keys = this._codesets.keys();
            String urlOrHashCode = null;
            String schemaLocation = DOMHelper.getRelativeXPathLocation(source);
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                urlOrHashCode = key.substring(key.indexOf("$_") + 2, key.lastIndexOf("$_"));
                if (urlOrHashCode == null || urlOrHashCode.equals("URL") || !urlOrHashCode.equals(schemaLocation)) continue;
                hasBeenInitialized = true;
                break;
            }
        }
        return hasBeenInitialized;
    }

    public static Hashtable createCodeTable(Type source, Document dom) {
        Hashtable<String, CodeSetEntry> createdCodesets = new Hashtable<String, CodeSetEntry>();
        Element root = dom.getDocumentElement();
        List codeSets = DOMHelper.getChildren(null, root);
        Iterator codeSetsIterator = codeSets.iterator();
        while (codeSetsIterator.hasNext()) {
            boolean isHierarchy = false;
            Element codeSet = (Element)codeSetsIterator.next();
            String codeSetName = codeSet.getAttribute(CODESET_NAME);
            String isHierarchyContent = codeSet.getAttribute("isHierarchy");
            isHierarchy = "true".equals(isHierarchyContent);
            if (codeSetName == null || codeSetName.length() == 0) {
                if (!LogRegistry.getInstance().logWarnings()) continue;
                LogRegistry.getInstance().warn(class$com$jaxfront$core$dom$CodeTables == null ? CodeTables.class$("com.jaxfront.core.dom.CodeTables") : class$com$jaxfront$core$dom$CodeTables, "no codeSet name defined in codeSet");
                continue;
            }
            LinkedHashMap languageEntries = new LinkedHashMap();
            HashMap paramEntries = new HashMap();
            HashMap helpEntries = new HashMap();
            LinkedHashMap<String, String> languageLabels = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> aliasLabels = new LinkedHashMap<String, String>();
            List items = DOMHelper.getAllChildren(codeSet, ELEMENT_CODE);
            Iterator itemsIterator = items.iterator();
            while (itemsIterator.hasNext()) {
                Element code = (Element)itemsIterator.next();
                String id = code.getAttribute(CODESET_ENTRY_ID);
                String status = code.getAttribute(CODESET_ENTRY_STATUS);
                Iterator codeLanguages = DOMHelper.getChildren(null, code).iterator();
                while (codeLanguages.hasNext()) {
                    String helpValue;
                    String paramValue;
                    String text;
                    Element language = (Element)codeLanguages.next();
                    LinkedHashMap<String, String> langHashtable = (LinkedHashMap<String, String>)languageEntries.get(language.getNodeName());
                    HashMap<String, String> entryParamHashtable = (HashMap<String, String>)paramEntries.get(language.getNodeName());
                    HashMap<String, String> entryHelpHashtable = (HashMap<String, String>)helpEntries.get(language.getNodeName());
                    if (langHashtable == null) {
                        langHashtable = new LinkedHashMap<String, String>();
                        languageEntries.put(language.getNodeName(), langHashtable);
                        entryParamHashtable = new HashMap<String, String>();
                        paramEntries.put(language.getNodeName(), entryParamHashtable);
                        entryHelpHashtable = new HashMap<String, String>();
                        helpEntries.put(language.getNodeName(), entryHelpHashtable);
                    }
                    if ((text = DOMHelper.getText(language)) != null) {
                        text = StringUtil.unEscapeXML(text);
                        if (status != null && status.equals(CODESET_ENTRY_INVALID)) {
                            text = CodeTables.markAsInvalid(text, language.getNodeName());
                        }
                        langHashtable.put(id, text);
                    }
                    if ((paramValue = language.getAttribute(CODESET_ENTRY_ATTR_PARAM)) != null && paramValue.length() > 0) {
                        paramValue = StringUtil.unEscapeXML(paramValue);
                        entryParamHashtable.put(id, paramValue);
                    }
                    if ((helpValue = language.getAttribute(CODESET_ENTRY_ATTR_HELP)) == null || helpValue.length() <= 0) continue;
                    helpValue = StringUtil.unEscapeXML(helpValue);
                    entryHelpHashtable.put(id, helpValue);
                }
            }
            Iterator labelDefinition = DOMHelper.getChildren(null, codeSet, ELEMENT_LABEL).iterator();
            while (labelDefinition.hasNext()) {
                Iterator labelLanguages = DOMHelper.getChildren(null, (Element)labelDefinition.next()).iterator();
                while (labelLanguages.hasNext()) {
                    Element label = (Element)labelLanguages.next();
                    String text = DOMHelper.getText(label);
                    if (text == null) continue;
                    languageLabels.put(label.getNodeName(), text);
                }
            }
            Iterator aliasDefinitions = DOMHelper.getChildren(null, codeSet, ELEMENT_ALIAS).iterator();
            while (aliasDefinitions.hasNext()) {
                String text = DOMHelper.getText((Element)aliasDefinitions.next());
                if (text == null) continue;
                aliasLabels.put(text, text);
            }
            Iterator langKeys = languageEntries.keySet().iterator();
            CodeSetEntry entry = null;
            String keyCode = null;
            while (langKeys.hasNext()) {
                String key = (String)langKeys.next();
                LinkedHashMap language = (LinkedHashMap)languageEntries.get(key);
                keyCode = CodeTables.createKeyInt(source == null, source, codeSetName, key);
                entry = new CodeSetEntry((String)languageLabels.get(key), language, (HashMap)paramEntries.get(key), (HashMap)helpEntries.get(key));
                if (isHierarchy) {
                    entry.setHierarchical(codeSet);
                }
                createdCodesets.put(keyCode, entry);
                Iterator aliasKeys = aliasLabels.keySet().iterator();
                while (aliasKeys.hasNext()) {
                    String alias = (String)aliasKeys.next();
                    keyCode = CodeTables.createKeyInt(source == null, source, alias, key);
                    createdCodesets.put(keyCode, entry);
                }
            }
        }
        return createdCodesets;
    }

    private static String markAsInvalid(String value, String language) {
        return value + CodeTables.getInvalidMarker(language);
    }

    private static String getInvalidMarker(String language) {
        return " [" + GUIComponentNLS.getInstance().getNLSText(language, "message_invalid", CODESET_ENTRY_INVALID) + "]";
    }

    private String createKeyInt(Type source, String codeSetName, String language) {
        return CodeTables.createKeyInt(true, source, codeSetName, language);
    }

    private static String getRelativeXPathLocation(Type type) {
        StringTokenizer st = new StringTokenizer(type.getXPathLocation(), "[]");
        String token = null;
        int counter = 0;
        String newXPath = null;
        while (st.hasMoreElements()) {
            token = st.nextToken();
            if (counter % 2 == 0) {
                newXPath = counter > 0 ? newXPath + token : token;
            }
            ++counter;
        }
        if (newXPath != null) {
            if (type.isList()) {
                newXPath = newXPath + "[" + token + "]";
            } else if (type.isSimple() && ((SimpleType)type).isSimpleContent()) {
                newXPath = newXPath + "[" + token + "]";
            } else if (type.isEditingType()) {
                String name = type.getName();
                newXPath = newXPath.substring(0, newXPath.lastIndexOf(name));
            }
        }
        return newXPath;
    }

    public static String createKeyInt(boolean checkType, Type source, String codeSetName, String language) {
        String key = codeSetName + "$_";
        if (source != null) {
            String schemaLocation = CodeTables.getRelativeXPathLocation(source);
            if (checkType) {
                if (source.getXUIDefinition().getStyle().getCodeSetClass() != null || source.getXUIDefinition().getStyle().isXLinkCodeset()) {
                    schemaLocation = CodeTables.getRelativeXPathLocation(source);
                    key = key + schemaLocation + "$_";
                } else {
                    key = key + "URL$_";
                }
            } else {
                key = key + schemaLocation + "$_";
            }
        } else {
            key = key + "URL$_";
        }
        key = key + language;
        return key;
    }

    public void release() {
        this.releaseCodeSets();
        this._language = null;
    }

    public void releaseCodeSets() {
        if (this._codesets != null) {
            this._codesets.clear();
        }
        this._codesets = null;
        if (this._cachedURLs != null) {
            this._cachedURLs.clear();
        }
    }

    public static boolean isValueInvalid(String value, String language) {
        if (value == null) {
            return false;
        }
        return value.endsWith(CodeTables.getInvalidMarker(language));
    }

    private String getLanguage() {
        return this._language;
    }

    public Hashtable getCachedURLs() {
        if (this._cachedURLs == null) {
            this._cachedURLs = new Hashtable();
        }
        return this._cachedURLs;
    }

    public void releaseCache() {
        this._cachedURLs = null;
    }

    public String toXML() {
        LinkedHashMap codeSets;
        StringBuffer result = new StringBuffer();
        if (this._codesets != null && (codeSets = CodeTables.transformHashtablesForXMLSerialization(this._codesets)).size() > 0) {
            result.append("<");
            result.append(ELEMENT_CODES);
            result.append(">");
            Iterator codeSetKeyKeySet = codeSets.entrySet().iterator();
            while (codeSetKeyKeySet.hasNext()) {
                Map.Entry keyElement = codeSetKeyKeySet.next();
                String codeSetName = keyElement.getKey().toString();
                result.append("<");
                result.append(ELEMENT_CODESET);
                result.append(" name=\"");
                result.append(codeSetName);
                result.append("\">");
                Object value = keyElement.getValue();
                if (value instanceof LinkedHashMap) {
                    LinkedHashMap aCodeSetEntry = (LinkedHashMap)value;
                    Iterator aCodeSetEntryKey = aCodeSetEntry.keySet().iterator();
                    while (aCodeSetEntryKey.hasNext()) {
                        boolean first = true;
                        String entryKey = aCodeSetEntryKey.next().toString();
                        result.append("<");
                        result.append(ELEMENT_CODE);
                        result.append(" ");
                        result.append(CODESET_ENTRY_ID);
                        result.append("=\"");
                        result.append(entryKey);
                        result.append("\"");
                        HashMap codeSetLanguageItems = (HashMap)aCodeSetEntry.get(entryKey);
                        Iterator codeSetEntryItemsI = codeSetLanguageItems.entrySet().iterator();
                        while (codeSetEntryItemsI.hasNext()) {
                            Map.Entry codeSetItemEntry = codeSetEntryItemsI.next();
                            String language = (String)codeSetItemEntry.getKey();
                            String entryValue = (String)codeSetItemEntry.getValue();
                            boolean isValueInvalid = CodeTables.isValueInvalid(entryValue, language);
                            if (isValueInvalid) {
                                entryValue = TextTools.replace(entryValue, CodeTables.getInvalidMarker(language), "");
                            }
                            if (first) {
                                if (isValueInvalid) {
                                    result.append(" ");
                                    result.append(CODESET_ENTRY_STATUS);
                                    result.append("=\"");
                                    result.append(CODESET_ENTRY_INVALID);
                                    result.append("\"");
                                }
                                result.append(">");
                                first = false;
                            }
                            result.append("<");
                            result.append(language);
                            result.append(">");
                            result.append(entryValue);
                            result.append("</");
                            result.append(language);
                            result.append(">");
                        }
                        result.append("</");
                        result.append(ELEMENT_CODE);
                        result.append(">");
                    }
                }
                result.append("</");
                result.append(ELEMENT_CODESET);
                result.append(">");
            }
            result.append("</");
            result.append(ELEMENT_CODES);
            result.append(">");
        }
        return result.toString();
    }

    public static LinkedHashMap transformHashtablesForXMLSerialization(Hashtable codeSets) {
        LinkedHashMap result = new LinkedHashMap();
        Enumeration loadedCodeSets = codeSets.keys();
        while (loadedCodeSets.hasMoreElements()) {
            CodeSetEntry aCodeSetEntry;
            LinkedHashMap aLanguageCodeSet;
            Object value;
            Object keyElement = loadedCodeSets.nextElement();
            String[] codeSetAttributes = CodeTables.extractFromKey(keyElement.toString());
            String codeSetName = codeSetAttributes[0];
            String codeSetURL = codeSetAttributes[1];
            String codeSetLanguage = codeSetAttributes[2];
            LinkedHashMap<String, HashMap<String, String>> codeSetNameHashTable = null;
            codeSetNameHashTable = (LinkedHashMap<String, HashMap<String, String>>)result.get(codeSetName);
            if (codeSetNameHashTable == null) {
                codeSetNameHashTable = new LinkedHashMap<String, HashMap<String, String>>();
                result.put(codeSetName, codeSetNameHashTable);
            }
            if (!((value = codeSets.get(keyElement)) instanceof CodeSetEntry) || (aLanguageCodeSet = (aCodeSetEntry = (CodeSetEntry)value).getCodeset()) == null) continue;
            Iterator aLanguageKeySet = aLanguageCodeSet.keySet().iterator();
            while (aLanguageKeySet.hasNext()) {
                String aelementKey = (String)aLanguageKeySet.next();
                String aelementValue = (String)aLanguageCodeSet.get(aelementKey);
                HashMap<String, String> keyEntries = null;
                keyEntries = (HashMap<String, String>)codeSetNameHashTable.get(aelementKey);
                if (keyEntries == null) {
                    keyEntries = new HashMap<String, String>();
                    codeSetNameHashTable.put(aelementKey, keyEntries);
                }
                keyEntries.put(codeSetLanguage, aelementValue);
            }
        }
        return result;
    }

    public static String[] extractFromKey(String key) {
        return TextTools.tokenize(key, "$_");
    }

    public boolean isCached(String aCodeSetUrl) {
        return JAXFrontProperties.isUsingCodesCacheGlobal() && this.getCachedURLs().get(aCodeSetUrl) != null;
    }
}

