/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.dom;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.dom.DocumentCreationException;
import com.jaxfront.core.dom.FingerPrint;
import com.jaxfront.core.dom.InitUIListener;
import com.jaxfront.core.dom.JAXFrontLSInput;
import com.jaxfront.core.dom.NodeImporter;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.schema.SchemaCreationException;
import com.jaxfront.core.schema.XMLSchema;
import com.jaxfront.core.schema.XMLSchemaBuilder;
import com.jaxfront.core.schema.impl.XMLSchemaBuilderImpl;
import com.jaxfront.core.schema.impl.XMLSchemaImpl;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.MapHelper;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.util.URLHelper;
import com.jaxfront.core.util.io.ZIPDeCompressor;
import com.jaxfront.core.util.io.cache.CountdownLockManager;
import com.jaxfront.core.util.io.cache.DomainedObjectCache;
import com.jaxfront.core.util.io.cache.XUICache;
import com.jaxfront.core.xpath.NodeList;
import com.jaxfront.core.xpath.W3CXPathExecuterImpl;
import com.jaxfront.core.xui.AbstractXUIElement;
import com.jaxfront.core.xui.NLS;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xerces.util.XMLResourceIdentifierImpl;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSInput;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class DOMBuilder {
    private static DOMBuilder _singleton;
    private URL _xuiXsdURL;
    private Document _xuiSchemaDOM;
    private static final String INCLUDED_XPATH_START_IDENTIFIER = "${";
    private static final String INCLUDED_XPATH_END_IDENTIFIER = "}";
    public static final String USE_XUI = "useXUI";

    private DOMBuilder() {
    }

    public Document build(String context, URL xsdURL) throws SchemaCreationException, DocumentCreationException {
        return this.build(context, xsdURL, null);
    }

    public Document build(String context, URL xsdURL, String rootName) throws SchemaCreationException, DocumentCreationException {
        return this.build(context, xsdURL, (URL)null, (URL)null, rootName);
    }

    public Document buildImplicit(String context, URL xmlURL, String rootName) throws SchemaCreationException, DocumentCreationException {
        return this.buildImplicit(context, xmlURL, null, rootName);
    }

    public Document buildImplicit(String context, URL xmlURL, URL xuiURL, String rootName) throws SchemaCreationException, DocumentCreationException {
        Document document = null;
        long start = System.currentTimeMillis();
        try {
            org.w3c.dom.Document xmlDOM = DOMHelper.createDocument(xmlURL);
            String xmlSchemaLocation = xmlDOM.getDocumentElement().getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation");
            String errorMessage = "Unable to resolve xmlSchemaLocation from xmlURL: " + xmlURL.toExternalForm();
            if (xmlSchemaLocation == null) {
                throw new DocumentCreationException(errorMessage);
            }
            URL xsdURL = null;
            xsdURL = this.isRunningOnWindows() && xmlSchemaLocation.indexOf(":") != -1 ? URLHelper.getUserURL(xmlSchemaLocation) : URLHelper.getUserURL(xmlURL, xmlSchemaLocation);
            if (xsdURL == null) {
                throw new DocumentCreationException(errorMessage);
            }
            document = this.build(context, xsdURL, xmlDOM, xuiURL, rootName);
        }
        catch (Exception ex) {
            throw new DocumentCreationException(ex);
        }
        long stop = System.currentTimeMillis();
        if (LogRegistry.getInstance().logWarnings()) {
            LogRegistry.getInstance().warn(this.getClass(), "time used to build implicit:" + xmlURL + " " + (stop - start) + " ms");
        }
        return document;
    }

    public Document build(String context, URL xsdURL, URL xmlURL, URL xuiURL, String rootName) throws SchemaCreationException, DocumentCreationException {
        return this.build(context, xsdURL, xmlURL, xuiURL, rootName, null);
    }

    public Document build(String context, URL xsdURL, URL xmlURL, URL xuiURL, String rootName, Hashtable domArgs) throws SchemaCreationException, DocumentCreationException {
        Document document;
        org.w3c.dom.Document w3CDOM;
        block4: {
            w3CDOM = null;
            document = null;
            try {
                if (xmlURL != null) {
                    w3CDOM = this.createFrom(context, null, xmlURL.toExternalForm(), URLHelper.openStream(xmlURL));
                }
            }
            catch (Throwable ex) {
                if (!JAXFrontProperties.LOG_ENABLED) break block4;
                LogRegistry.getInstance().warn(this.getClass(), "Can not create DOM from xml-Url (" + xmlURL.toExternalForm() + "). Reason: " + ex.getLocalizedMessage());
            }
        }
        document = this.build(context, xsdURL, w3CDOM, xuiURL, rootName, domArgs);
        if (xmlURL != null) {
            document.putClientProperty("xml", xmlURL);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.w3c.dom.Document createFrom(String context, FingerPrint fingerPrint, String cacheKey, InputStream is) throws IOException, XMLParseException, SAXException {
        org.w3c.dom.Document w3CDOM = null;
        try {
            if (this.isCached(context, cacheKey)) {
                w3CDOM = (org.w3c.dom.Document)DomainedObjectCache.getInstance("xml").getCached(cacheKey);
            } else {
                boolean zipped = false;
                zipped = cacheKey.endsWith(".zip");
                if (zipped) {
                    ZIPDeCompressor decomp = new ZIPDeCompressor(is);
                    decomp.getFirstZipEntry();
                    w3CDOM = DOMHelper.createDocument(decomp.getInputStream());
                } else {
                    w3CDOM = DOMHelper.createDocument(is, "UTF-8");
                }
                if (JAXFrontProperties.getInstance(context).isUsingXUICache()) {
                    DomainedObjectCache.getInstance("xml").cache(cacheKey, w3CDOM);
                }
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return w3CDOM;
    }

    private boolean isCached(String context, String cacheKey) {
        return JAXFrontProperties.getInstance(context).isUsingXUICache() && DomainedObjectCache.getInstance("xml").hasCached(cacheKey);
    }

    public Document build(String context, LSInput xsdInput, LSInput xmlInput, LSInput xuiInput, String rootName, Hashtable domArgs) throws SchemaCreationException, DocumentCreationException {
        org.w3c.dom.Document w3CDOM = null;
        if (xmlInput != null) {
            try {
                w3CDOM = DOMHelper.createDocument(xmlInput);
            }
            catch (Exception ex) {
                if (LogRegistry.getInstance().logWarnings()) {
                    LogRegistry.getInstance().warn(this.getClass(), "Can not create DOM (" + ex.getClass() + "). Reason: " + ex.getMessage());
                }
                ex.printStackTrace();
                throw new DocumentCreationException(ex);
            }
        }
        return this.build(context, xsdInput, w3CDOM, xuiInput, rootName, domArgs);
    }

    public Document build(String context, LSInput xsdInput, org.w3c.dom.Document w3CDOM, LSInput xuiInput, String rootName, Hashtable domArgs) throws SchemaCreationException, DocumentCreationException {
        XMLEntityResolver entityResolver = null;
        if (domArgs != null) {
            entityResolver = (XMLEntityResolver)domArgs.get(XMLEntityResolver.class.getName());
        }
        return this.build(context, xsdInput, w3CDOM, xuiInput, rootName, domArgs, entityResolver, false);
    }

    public Document build(String context, LSInput xsdInput, org.w3c.dom.Document w3CDOM, LSInput xuiInput, String rootName, Hashtable domArgs, XMLEntityResolver resolver, boolean keepSchemaInMemory) throws SchemaCreationException, DocumentCreationException {
        long start = System.currentTimeMillis();
        XMLSchemaBuilder builder = this.getSchemaBuilder();
        if (rootName != null && rootName.length() == 0) {
            rootName = null;
        }
        Document document = null;
        boolean useXUI = true;
        try {
            XMLSchema schema = builder.build(context, xsdInput, resolver, rootName, keepSchemaInMemory);
            document = schema.createDocument(domArgs);
            useXUI = MapHelper.istTrue(domArgs, USE_XUI, true);
            document.setAppContext(context);
            if (LogRegistry.getInstance().logInfos()) {
                LogRegistry.getInstance().info(this.getClass(), "*** (binding XML-Doc: " + w3CDOM + ") *** START ***");
            }
            document.bind(w3CDOM, false);
            if (LogRegistry.getInstance().logInfos()) {
                LogRegistry.getInstance().info(this.getClass(), "*** (binding XML-Doc) *** END ***");
            }
            if (w3CDOM == null) {
                document.getKeyKeyRefManager().registerAllKeyAndKeyRefs(document.getRootType());
            }
            document.getFingerPrint().setEntityResolver(resolver);
            document.getFingerPrint().setXSDInput(xsdInput);
            if (useXUI) {
                if (domArgs != null && domArgs.get(InitUIListener.class.getName()) != null) {
                    document.setInitUIListener((InitUIListener)domArgs.get(InitUIListener.class.getName()));
                }
                if (xuiInput != null) {
                    this.initializeXUI(context, document, xuiInput, true);
                } else if (xuiInput == null) {
                    document.initUISpecification(this.getXUISchemaDOM(context));
                } else {
                    this.initializeXUI(context, document, xuiInput, true);
                }
            }
            w3CDOM = null;
        }
        catch (Throwable ex) {
            if (LogRegistry.getInstance().logWarnings()) {
                LogRegistry.getInstance().warn(this.getClass(), "Can not create DOM (" + ex.getClass() + "). Reason: " + ex.getMessage());
            }
            ex.printStackTrace();
            throw new DocumentCreationException(ex);
        }
        long stop = System.currentTimeMillis();
        if (LogRegistry.getInstance().logInfos()) {
            LogRegistry.getInstance().info(this.getClass(), "time used to build:" + xsdInput + " " + (stop - start) + " ms");
        }
        return document;
    }

    public Document build(URL baseURL, String xsdString, String xmlString, String xuiString, String rootName, Hashtable domArgs) throws SchemaCreationException, DocumentCreationException {
        long start = System.currentTimeMillis();
        XMLSchemaBuilder builder = this.getSchemaBuilder();
        XMLSchema schema = builder.build(xsdString, rootName);
        schema.setBase(baseURL);
        Document document = schema.createDocument(domArgs);
        try {
            if (xmlString != null) {
                if (LogRegistry.getInstance().logInfos()) {
                    LogRegistry.getInstance().info(this.getClass(), "*** (binding XML-Doc from XML-String) *** START ***");
                }
                document.bind(DOMHelper.createDocument(xmlString), false);
                if (LogRegistry.getInstance().logInfos()) {
                    LogRegistry.getInstance().info(this.getClass(), "*** (binding XML-Doc) *** END ***");
                }
            }
            if (xuiString != null) {
                try {
                    org.w3c.dom.Document dom = DOMHelper.createDocument(xuiString);
                    this.initializeXUI(null, document, dom, null, true);
                }
                catch (Exception ex) {
                    if (LogRegistry.getInstance().logWarnings()) {
                        LogRegistry.getInstance().warn(this.getClass(), "unable to create XUI from xui-String");
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new DocumentCreationException(ex);
        }
        long stop = System.currentTimeMillis();
        if (LogRegistry.getInstance().logWarnings()) {
            LogRegistry.getInstance().warn(this.getClass(), "time used to build:" + xsdString + " " + (stop - start) + " ms");
        }
        return document;
    }

    public Document build(String context, URL xsdURL, org.w3c.dom.Document xmlDOM, URL xuiURL, String rootName) throws SchemaCreationException, DocumentCreationException {
        return this.build(context, xsdURL, xmlDOM, xuiURL, rootName, null);
    }

    public Document build(String context, URL xsdURL, org.w3c.dom.Document xmlDOM, URL xuiURL, String rootName, Hashtable domArgs) throws SchemaCreationException, DocumentCreationException {
        Document document;
        org.w3c.dom.Document w3CDOM;
        long start;
        block15: {
            start = System.currentTimeMillis();
            XMLSchemaBuilder builder = this.getSchemaBuilder();
            w3CDOM = xmlDOM;
            if (rootName != null && rootName.length() == 0) {
                rootName = null;
            }
            document = null;
            try {
                XMLSchema schema = builder.build(context, xsdURL, rootName, domArgs);
                document = schema.createDocument(domArgs);
                document.setAppContext(context);
                if (LogRegistry.getInstance().logInfos()) {
                    LogRegistry.getInstance().info(this.getClass(), "*** (binding XML-Doc: " + w3CDOM + ") *** START ***");
                }
                document.bind(w3CDOM, false);
                if (LogRegistry.getInstance().logInfos()) {
                    LogRegistry.getInstance().info(this.getClass(), "*** (binding XML-Doc) *** END ***");
                }
                if (w3CDOM == null) {
                    document.getKeyKeyRefManager().registerAllKeyAndKeyRefs(document.getRootType());
                }
                FingerPrint fingerPrint = new FingerPrint(document, w3CDOM, xsdURL, xuiURL);
                document.setFingerPrint(fingerPrint);
                if (domArgs != null) {
                    XMLEntityResolver resolver = (XMLEntityResolver)domArgs.get("XMLEntityResolver");
                    document.getFingerPrint().setEntityResolver(resolver);
                }
                if (xuiURL != null) {
                    this.initializeXUI(context, document, null, xuiURL, true);
                    break block15;
                }
                if (JAXFrontProperties.getInstance().isUsingXUINameLookup()) {
                    xuiURL = this.getDefaultXUILocationURL(xsdURL);
                    try {
                        if (xuiURL != null) {
                            JAXFrontProperties.getInstance().getURLResolver().resolveURL(xuiURL);
                        }
                    }
                    catch (IOException ex) {
                        xuiURL = null;
                    }
                }
                if (xuiURL == null) {
                    document.initUISpecification(this.getXUISchemaDOM(context));
                } else {
                    this.initializeXUI(context, document, null, xuiURL, true);
                }
            }
            catch (Throwable ex) {
                LogRegistry.getInstance().warn(this.getClass(), "Can not create DOM (" + ex.getClass() + "). Reason: " + ex.getMessage());
                ex.printStackTrace();
                throw new DocumentCreationException(ex);
            }
        }
        w3CDOM = null;
        long stop = System.currentTimeMillis();
        if (LogRegistry.getInstance().logWarnings()) {
            LogRegistry.getInstance().warn(this.getClass(), "time used to build:" + xsdURL + " " + (stop - start) + " ms");
        }
        return document;
    }

    public Document build(String context, URL xsdURL, Reader xmlReader, URL xuiURL, String rootName) throws SchemaCreationException, DocumentCreationException {
        return this.build(context, xsdURL, xmlReader, xuiURL, rootName, null);
    }

    public Document build(String context, URL xsdURL, Reader xmlReader, URL xuiURL, String rootName, Hashtable buildProps) throws SchemaCreationException, DocumentCreationException {
        org.w3c.dom.Document w3CDOM = null;
        try {
            if (xmlReader != null) {
                w3CDOM = DOMHelper.createDocument(xmlReader);
            }
        }
        catch (Exception ex) {
            throw new DocumentCreationException(ex);
        }
        return this.build(context, xsdURL, w3CDOM, xuiURL, rootName, buildProps);
    }

    private Document buildXUISchemaDOM(String context) {
        block4: {
            try {
                XMLSchemaBuilder builder = this.getSchemaBuilder();
                XMLSchema schema = builder.build(context, this.getXuiXsdURL(), "XUI", null);
                ((XMLSchemaImpl)schema).setXUISchema(true);
                Document document = schema.createDocument();
                document.setAppContext(context);
                AbstractXUIElement.initializeDefaultProperties(document);
                this.bindDefaultXUI(document);
                this._xuiSchemaDOM = document;
            }
            catch (SchemaCreationException ex1) {
                if (JAXFrontProperties.LOG_ENABLED) {
                    LogRegistry.getInstance().error(this.getClass(), ex1);
                }
            }
            catch (XMLParseException e) {
                if (!JAXFrontProperties.LOG_ENABLED) break block4;
                LogRegistry.getInstance().error(this.getClass(), (Exception)((Object)e));
            }
        }
        return this._xuiSchemaDOM;
    }

    public void bindDefaultXUI(Document dom) {
    }

    public URL getXuiXsdURL() {
        if (this._xuiXsdURL == null) {
            this._xuiXsdURL = URLHelper.getXUIXsdURL();
            if (this._xuiXsdURL == null) {
                String error = "ERROR while trying to load: xui.xsd (can not be found).";
                if (JAXFrontProperties.LOG_ENABLED) {
                    LogRegistry.getInstance().error(this.getClass(), error);
                }
                throw new RuntimeException(error);
            }
        }
        return this._xuiXsdURL;
    }

    public static synchronized DOMBuilder getInstance() {
        if (_singleton == null) {
            _singleton = new DOMBuilder();
        }
        return _singleton;
    }

    public XMLSchemaBuilder getSchemaBuilder() throws SchemaCreationException {
        return XMLSchemaBuilderImpl.getInstance();
    }

    public static String extractIncludeXpath(String include) {
        String xpath = null;
        int indexOfIncludeMarker = include.indexOf(INCLUDED_XPATH_START_IDENTIFIER);
        if (indexOfIncludeMarker > 0) {
            int lastIndexOfIncludeMarker = include.lastIndexOf(INCLUDED_XPATH_END_IDENTIFIER);
            xpath = include.substring(indexOfIncludeMarker + INCLUDED_XPATH_START_IDENTIFIER.length(), lastIndexOfIncludeMarker);
            if (xpath.length() == 0) {
                xpath = null;
            }
        }
        return xpath;
    }

    public static String extractIncludeURL(String include) {
        String includeUrl = null;
        int indexOfIncludeMarker = include.indexOf(INCLUDED_XPATH_START_IDENTIFIER);
        includeUrl = indexOfIncludeMarker > 0 ? include.substring(0, indexOfIncludeMarker) : include;
        return includeUrl;
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    private void checkIncludedXUI(String context, org.w3c.dom.Document w3CDOM, FingerPrint fingerPrint, Vector nodesToImport, URL baseURL, Hashtable openedURLs, boolean mergeGlobalDefinition) throws DocumentCreationException {
        Iterator iterator = fingerPrint.getIncludes().iterator();
        while (iterator.hasNext()) {
            String include = (String)iterator.next();
            String xpath = DOMBuilder.extractIncludeXpath(include);
            include = DOMBuilder.extractIncludeURL(include);
            this.checkIncludedXUI(context, include, xpath, w3CDOM, fingerPrint, nodesToImport, baseURL, openedURLs, mergeGlobalDefinition, true);
            if (!JAXFrontProperties.getInstance(context).allowCustomXUI()) continue;
            String cInclude = this.replaceXUIAsCustom(include);
            this.checkIncludedXUI(context, cInclude, xpath, w3CDOM, fingerPrint, nodesToImport, baseURL, openedURLs, mergeGlobalDefinition, false);
        }
    }

    private void checkIncludedXUI(String context, String include, String xpath, org.w3c.dom.Document w3CDOM, FingerPrint fingerPrint, Vector nodesToImport, URL baseURL, Hashtable openedURLs, boolean mergeGlobalDefinition, boolean doDeep) throws DocumentCreationException {
        block10: {
            org.w3c.dom.Document includedDOM;
            URL xuiURL;
            block9: {
                Object is = null;
                xuiURL = null;
                try {
                    URI includeURI = new URI(include);
                    xuiURL = includeURI.isAbsolute() ? URLHelper.getUserURL(include) : URLHelper.getUserURL(fingerPrint.getXUIURL(), include);
                }
                catch (Throwable ex) {
                    if (!JAXFrontProperties.LOG_ENABLED) break block9;
                    LogRegistry.getInstance().error(this.getClass(), ex.toString());
                }
            }
            if (xuiURL == null) {
                xuiURL = URLHelper.getUserURL(include);
            }
            if (xuiURL == null) {
                xuiURL = URLHelper.getUserURL(baseURL, include);
            }
            if ((includedDOM = this.getXUIDoc(context, fingerPrint, include, xuiURL, baseURL, openedURLs)) != null && xuiURL != null) {
                try {
                    FingerPrint includedFingerPrint = new FingerPrint(null, includedDOM, this.getXuiXsdURL(), xuiURL);
                    includedFingerPrint.setEntityResolver(fingerPrint.getEntityResolver());
                    fingerPrint.addIncludedFingerPrint(includedFingerPrint);
                    if (includedFingerPrint.hasIncludes() && doDeep) {
                        this.checkIncludedXUI(context, w3CDOM, includedFingerPrint, nodesToImport, xuiURL, openedURLs, mergeGlobalDefinition);
                    }
                    if (LogRegistry.getInstance().logInfos()) {
                        LogRegistry.getInstance().info(this.getClass(), "loading included xui from:" + xuiURL);
                    }
                    this.convertImpNodesToTarget(xpath, w3CDOM, nodesToImport, mergeGlobalDefinition, includedDOM);
                }
                catch (Exception ex) {
                    if (!LogRegistry.getInstance().logWarnings()) break block10;
                    LogRegistry.getInstance().warn(this.getClass(), "IO error while initializeXUI (" + ex.getMessage() + "): " + xuiURL.getFile());
                }
            }
        }
    }

    private org.w3c.dom.Document getXUIDoc(String context, FingerPrint fingerPrint, String include, URL xuiURL, URL baseURL, Hashtable openedIDs) {
        String cacheKey;
        InputStream is;
        org.w3c.dom.Document includedDOM;
        block18: {
            includedDOM = null;
            is = null;
            cacheKey = null;
            if (fingerPrint.getEntityResolver() != null) {
                XMLEntityResolver resolver = fingerPrint.getEntityResolver();
                XMLInputSource xmlIS = null;
                try {
                    cacheKey = include;
                    if (!this.isCached(context, cacheKey) && (xmlIS = resolver.resolveEntity((XMLResourceIdentifier)new XMLResourceIdentifierImpl(null, include, null, null))) != null) {
                        is = xmlIS.getByteStream();
                    }
                    break block18;
                }
                catch (Exception e) {
                    if (LogRegistry.getInstance().logWarnings()) {
                        LogRegistry.getInstance().warn(this.getClass(), "can't load" + include + " from db!");
                    }
                    break block18;
                }
            }
            if (xuiURL != null) {
                try {
                    cacheKey = xuiURL.toExternalForm();
                    if (!this.isCached(context, cacheKey)) {
                        is = JAXFrontProperties.getInstance().getURLResolver().resolveURL(xuiURL);
                    }
                }
                catch (IOException e) {
                    if (!LogRegistry.getInstance().logWarnings()) break block18;
                    LogRegistry.getInstance().warn(this.getClass(), "can't load" + baseURL.toExternalForm() + " <-> " + xuiURL.toExternalForm() + " message:" + e.getMessage());
                }
            }
        }
        if (cacheKey != null) {
            if (openedIDs.get(cacheKey) == null) {
                openedIDs.put(cacheKey, cacheKey);
                try {
                    if (is != null) {
                        includedDOM = this.createFrom(context, fingerPrint, cacheKey, is);
                    }
                }
                catch (XMLParseException e) {
                    LogRegistry.getInstance().error(this.getClass(), e.getMessage());
                }
                catch (IOException e) {
                    LogRegistry.getInstance().error(this.getClass(), e.getMessage());
                }
                catch (SAXException e) {
                    LogRegistry.getInstance().error(this.getClass(), e.getMessage());
                }
            } else if (LogRegistry.getInstance().logWarnings()) {
                LogRegistry.getInstance().warn(this.getClass(), "Cylclic includes detected in XUI: " + baseURL.toExternalForm() + " <-> " + xuiURL.toExternalForm());
            }
        }
        return includedDOM;
    }

    private void convertImpNodesToTarget(String xpath, org.w3c.dom.Document targetDOM, Vector nodesToImport, boolean mergeGlobalDefinition, org.w3c.dom.Document includedDOM) throws TransformerException {
        int i;
        Element component;
        org.w3c.dom.NodeList components = null;
        if (xpath != null) {
            List acomponentsList = W3CXPathExecuterImpl.getInstance().processXPath(includedDOM.getDocumentElement(), xpath);
            components = new NodeList(acomponentsList);
        } else {
            components = includedDOM.getElementsByTagName("component");
        }
        for (int i2 = 0; components != null && i2 < components.getLength(); ++i2) {
            component = (Element)components.item(i2);
            xpath = component.getAttribute("xpath");
            if (xpath == null || xpath.length() <= 0) continue;
            nodesToImport.add(targetDOM.importNode(component, true));
        }
        components = includedDOM.getElementsByTagName("rule");
        for (i = 0; i < components.getLength(); ++i) {
            component = (Element)components.item(i);
            String id = component.getAttribute("id");
            if (id == null || id.length() <= 0) continue;
            nodesToImport.add(targetDOM.importNode(component, true));
        }
        components = includedDOM.getElementsByTagName("resources");
        Object id = null;
        for (i = 0; i < components.getLength(); ++i) {
            component = (Element)components.item(i);
            nodesToImport.add(targetDOM.importNode(component, true));
        }
        if (JAXFrontProperties.getInstance().useEmbeddedNLS() || NLS.hasIncludedNLS(includedDOM)) {
            components = includedDOM.getElementsByTagName("nls");
            for (i = 0; i < components.getLength(); ++i) {
                component = (Element)components.item(i);
                nodesToImport.add(targetDOM.importNode(component, true));
            }
        }
        if (mergeGlobalDefinition) {
            components = includedDOM.getElementsByTagName("global");
            for (i = 0; i < components.getLength(); ++i) {
                component = (Element)components.item(i);
                DOMHelper.merge(null, targetDOM.getDocumentElement(), component);
            }
        }
    }

    public org.w3c.dom.Document getExpandedXUIDOM(String context, org.w3c.dom.Document w3CDOM, FingerPrint fingerPrint, boolean mergeGlobalDefinition, boolean removeRedundant) throws DocumentCreationException {
        fingerPrint.checkVersionNo();
        if (fingerPrint.hasIncludes() && fingerPrint.getXUIURL() != null) {
            Vector nodesToImport = new Vector();
            Hashtable<String, URL> openedURLs = new Hashtable<String, URL>();
            openedURLs.put(fingerPrint.getXUIURL().toExternalForm(), fingerPrint.getXUIURL());
            this.checkIncludedXUI(context, w3CDOM, fingerPrint, nodesToImport, fingerPrint.getXUIURL(), openedURLs, mergeGlobalDefinition);
            if (removeRedundant) {
                nodesToImport = this.removeRedundantXuiComponents(nodesToImport);
            }
            this.appendIncludedNodes(w3CDOM, nodesToImport);
        }
        return w3CDOM;
    }

    private Vector removeRedundantXuiComponents(Vector comps) {
        int size = comps.size();
        Hashtable<String, String> checkH = new Hashtable<String, String>(size);
        Vector<Element> result = new Vector<Element>(size);
        for (int i = size - 1; i >= 0; --i) {
            Element component = (Element)comps.get(i);
            String xpath = component.getAttribute("xpath");
            if (xpath != null && xpath.length() > 0) {
                if (checkH.containsKey(xpath)) continue;
                result.add(component);
                checkH.put(xpath, "");
                continue;
            }
            result.add(component);
        }
        return result;
    }

    private String replaceXUIAsCustom(String xuiLocation) {
        return TextTools.replace(xuiLocation, ".xui", "_custom.xui");
    }

    private void appendIncludedNodes(org.w3c.dom.Document w3CDOM, Vector nodesToImport) {
        if (nodesToImport.size() > 0) {
            Element xuiRootElement = w3CDOM.getDocumentElement();
            Iterator iterator = nodesToImport.iterator();
            while (iterator.hasNext()) {
                Node nodeToAppend = (Node)iterator.next();
                xuiRootElement.appendChild(nodeToAppend);
                ((Element)nodeToAppend).setAttributeNS("jaxfront", "included", "true");
            }
        }
    }

    private void mergeIncludedNodes(org.w3c.dom.Document w3CDOM, Vector nodesToImport) {
        if (nodesToImport.size() > 0) {
            Element xuiRootElement = w3CDOM.getDocumentElement();
            Iterator iterator = nodesToImport.iterator();
            while (iterator.hasNext()) {
                Element replacement = (Element)iterator.next();
                String repXpath = replacement.getAttribute("xpath");
                if (repXpath == null) continue;
                List childs = DOMHelper.getChildren(null, xuiRootElement);
                for (int i = 0; i < childs.size(); ++i) {
                    Element component = (Element)childs.get(i);
                    String xpath = component.getAttribute("xpath");
                    if (xpath == null || xpath.length() <= 0 || !xpath.equals(repXpath)) continue;
                    NodeImporter.doImport(replacement, (Node)component, 1, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeXUI(String context, Document dom, LSInput xuiInput, boolean mergeGlobalDefinition) {
        org.w3c.dom.Document w3CDOM = null;
        boolean xuiCached = JAXFrontProperties.getInstance(context).isUsingXUICache();
        String cacheKey = null;
        try {
            Document xuiDOM = null;
            cacheKey = xuiInput.getSystemId();
            if (xuiCached) {
                if (XUICache.getInstance().getCached(cacheKey) != null) {
                    CountdownLockManager.getInstance().waitForUnlock(cacheKey);
                } else {
                    boolean success = CountdownLockManager.getInstance().lock(cacheKey);
                    if (!success) {
                        CountdownLockManager.getInstance().waitForUnlock(cacheKey);
                    }
                }
                xuiDOM = XUICache.getInstance().getCached(cacheKey);
            }
            if (xuiDOM == null) {
                org.w3c.dom.Document w3CCustomDOM = null;
                if (JAXFrontProperties.getInstance(context).allowCustomXUI()) {
                    w3CCustomDOM = this.createCustomXUIDom(xuiInput);
                }
                w3CDOM = DOMHelper.createDocument(xuiInput);
                if (w3CCustomDOM != null) {
                    this.convertImpNodesToTarget(null, w3CCustomDOM, new Vector(), true, w3CDOM);
                    w3CDOM = w3CCustomDOM;
                }
                FingerPrint fingerPrint = new FingerPrint(null, w3CDOM, this.getXuiXsdURL(), xuiInput);
                fingerPrint.setEntityResolver(dom.getFingerPrint().getEntityResolver());
                fingerPrint.checkVersionNo();
                xuiDOM = this.getXUISchemaDOM(context).copy();
                xuiDOM.setFingerPrint(fingerPrint);
                org.w3c.dom.Document expXUIDom = this.getExpandedXUIDOM(context, w3CDOM, fingerPrint, mergeGlobalDefinition, !dom.isRunningInXUIEditor());
                xuiDOM.bind(expXUIDom, false);
                if (xuiInput != null && xuiCached) {
                    XUICache.getInstance().cache(cacheKey, xuiDOM);
                }
            }
            if (xuiDOM != null && "true".equals(dom.getClientProperty("debugModus"))) {
                dom.keepXUIDOMinMemory(true);
            }
            dom.getFingerPrint().setEntityResolver(dom.getFingerPrint().getEntityResolver());
            dom.getFingerPrint().setXUIInput(xuiInput);
            dom.initUISpecification(xuiDOM);
        }
        catch (Exception ex) {
            try {
                StringBuffer sb = new StringBuffer();
                sb.append("\n***************************************");
                sb.append("\n*** JAXFront-DOM \t= " + dom.getSchemaLocation());
                sb.append("\n*** xuiDOM\t\t\t= " + w3CDOM);
                sb.append("\n*** xuiURL\t\t\t= " + xuiInput);
                sb.append("\n*** occuredException:" + ex.getLocalizedMessage());
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                sb.append("\n");
                sb.append(sw.getBuffer().toString());
                sb.append("\n--- end stack trace ---");
                sb.append("\n***************************************");
                if (LogRegistry.getInstance().logWarnings()) {
                    LogRegistry.getInstance().warn(this.getClass(), sb.toString());
                }
            }
            catch (Throwable t) {
                ex.printStackTrace();
            }
        }
        finally {
            if (xuiCached) {
                CountdownLockManager.getInstance().unlock(cacheKey);
            }
        }
    }

    private org.w3c.dom.Document createCustomXUIDom(LSInput xuiURL) throws SAXException, IOException {
        org.w3c.dom.Document w3CCustomDOM;
        block5: {
            w3CCustomDOM = null;
            try {
                LSInput cusXuiUrl = null;
                if (xuiURL instanceof JAXFrontLSInput) {
                    cusXuiUrl = ((JAXFrontLSInput)xuiURL).copy();
                    String sysID = cusXuiUrl.getSystemId();
                    cusXuiUrl.setSystemId(this.replaceXUIAsCustom(sysID));
                    w3CCustomDOM = DOMHelper.createDocument(cusXuiUrl);
                } else {
                    String sysID = xuiURL.getSystemId();
                    xuiURL.setSystemId(this.replaceXUIAsCustom(sysID));
                    cusXuiUrl = xuiURL;
                    w3CCustomDOM = DOMHelper.createDocument(cusXuiUrl);
                }
            }
            catch (IOException e) {
            }
            catch (Exception e) {
                if (!JAXFrontProperties.LOG_ENABLED) break block5;
                LogRegistry.getInstance().error(this.getClass(), e);
            }
        }
        return w3CCustomDOM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeXUI(String context, Document dom, org.w3c.dom.Document w3CDOM, URL xuiURL, boolean mergeGlobalDefinition) {
        boolean xuiCached = JAXFrontProperties.getInstance(context).isUsingXUICache();
        if (dom.getClientProperty("useXUICache") != null) {
            xuiCached = (Boolean)dom.getClientProperty("useXUICache");
        }
        String cacheKey = null;
        try {
            Document xuiDOM = null;
            if (w3CDOM == null && xuiURL != null) {
                cacheKey = xuiURL.toExternalForm();
                if (xuiCached) {
                    if (XUICache.getInstance().getCached(cacheKey) != null) {
                        CountdownLockManager.getInstance().waitForUnlock(cacheKey);
                    } else {
                        boolean success = CountdownLockManager.getInstance().lock(cacheKey);
                        if (!success) {
                            CountdownLockManager.getInstance().waitForUnlock(cacheKey);
                        }
                    }
                    xuiDOM = XUICache.getInstance().getCached(cacheKey);
                }
                if (xuiDOM == null) {
                    org.w3c.dom.Document w3CCustomDOM = null;
                    if (JAXFrontProperties.getInstance(context).allowCustomXUI()) {
                        URL cusXuiURL = new URL(this.replaceXUIAsCustom(xuiURL.toExternalForm()));
                        try {
                            w3CCustomDOM = DOMHelper.createDocument(cusXuiURL);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    w3CDOM = DOMHelper.createDocument(xuiURL, JAXFrontProperties.getDefaultFileEncoding());
                    if (w3CCustomDOM != null) {
                        Vector importedNodes = new Vector();
                        this.convertImpNodesToTarget(null, w3CDOM, importedNodes, true, w3CCustomDOM);
                        this.mergeIncludedNodes(w3CDOM, importedNodes);
                    }
                }
            }
            if (xuiDOM == null) {
                if (xuiURL == null) {
                    xuiURL = URLHelper.getDefaultXUILocationURL(dom.getFingerPrint().getXSDURL());
                }
                FingerPrint fingerPrint = new FingerPrint(null, w3CDOM, this.getXuiXsdURL(), xuiURL);
                fingerPrint.setEntityResolver((XMLEntityResolver)dom.getApplicationProperty(XMLEntityResolver.class.getName()));
                fingerPrint.checkVersionNo();
                xuiDOM = this.getXUISchemaDOM(context).copy();
                xuiDOM.setFingerPrint(fingerPrint);
                xuiDOM.bind(this.getExpandedXUIDOM(context, w3CDOM, fingerPrint, mergeGlobalDefinition, !dom.isRunningInXUIEditor()), false);
                if (cacheKey != null && xuiCached) {
                    XUICache.getInstance().cache(cacheKey, xuiDOM);
                }
            }
            if (xuiDOM != null && "true".equals(dom.getClientProperty("debugModus"))) {
                dom.keepXUIDOMinMemory(true);
            }
            xuiDOM.setAppContext(context);
            dom.initUISpecification(xuiDOM);
            dom.getFingerPrint().setXuiURL(xuiURL);
            if (xuiCached) {
                CountdownLockManager.getInstance().unlock(cacheKey);
            }
        }
        catch (Exception ex) {
            try {
                try {
                    StringBuffer sb = new StringBuffer();
                    sb.append("\n***************************************");
                    sb.append("\n*** JAXFront-DOM \t= " + dom.getSchemaLocation());
                    sb.append("\n*** xuiDOM\t\t\t= " + w3CDOM);
                    sb.append("\n*** xuiURL\t\t\t= " + xuiURL);
                    sb.append("\n*** occuredException:" + ex.getLocalizedMessage());
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    ex.printStackTrace(pw);
                    sb.append("\n");
                    sb.append(sw.getBuffer().toString());
                    sb.append("\n--- end stack trace ---");
                    sb.append("\n***************************************");
                    if (LogRegistry.getInstance().logWarnings()) {
                        LogRegistry.getInstance().warn(this.getClass(), sb.toString());
                    }
                }
                catch (Throwable t) {
                    ex.printStackTrace();
                }
                if (xuiCached) {
                    CountdownLockManager.getInstance().unlock(cacheKey);
                }
            }
            catch (Throwable throwable) {
                if (xuiCached) {
                    CountdownLockManager.getInstance().unlock(cacheKey);
                }
                throw throwable;
            }
        }
    }

    public Document getXUISchemaDOM(String context) {
        if (this._xuiSchemaDOM == null) {
            this._xuiSchemaDOM = this.buildXUISchemaDOM(context);
            this._xuiSchemaDOM.keepXUIDOMinMemory(true);
            AbstractXUIElement.getDefaultProperties(context);
        }
        return this._xuiSchemaDOM;
    }

    public URL getDefaultXUILocationURL(URL xsdURL) {
        URL xuiURL;
        block2: {
            xuiURL = null;
            try {
                String schemaFileName = null;
                String xuiFileName = null;
                File baseFile = new File(xsdURL.getPath());
                schemaFileName = baseFile.getName();
                xuiFileName = schemaFileName.substring(0, schemaFileName.lastIndexOf(".")) + ".xui";
                xuiURL = URLHelper.getUserURL(xsdURL, xuiFileName);
            }
            catch (Throwable t) {
                if (!LogRegistry.getInstance().logWarnings()) break block2;
                LogRegistry.getInstance().warn(this.getClass(), "Can not get default xui loation. Reason: " + t.getLocalizedMessage());
            }
        }
        return xuiURL;
    }

    public Document buildImplicit(URL xmlURL) throws SchemaCreationException, DocumentCreationException {
        return this.buildImplicit(xmlURL, null);
    }

    public Document buildImplicit(String xmlContent) throws SchemaCreationException, DocumentCreationException {
        org.w3c.dom.Document xmlDOM;
        try {
            xmlDOM = DOMHelper.createDocument(xmlContent);
        }
        catch (Exception ex) {
            throw new DocumentCreationException(ex);
        }
        return this.buildImplicit(xmlDOM, null, null);
    }

    public Document buildImplicit(URL xmlURL, URL xuiURL) throws SchemaCreationException, DocumentCreationException {
        org.w3c.dom.Document xmlDOM;
        try {
            xmlDOM = DOMHelper.createDocument(xmlURL);
        }
        catch (Exception ex) {
            throw new DocumentCreationException(ex);
        }
        return this.buildImplicit(xmlDOM, xmlURL, xuiURL);
    }

    public Document buildImplicit(org.w3c.dom.Document xmlDOM, URL xmlURL, URL xuiURL) throws SchemaCreationException, DocumentCreationException {
        Document document = null;
        try {
            String xmlSchemaLocation = xmlDOM.getDocumentElement().getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation");
            String errorMessage = "Unable to resolve xmlSchemaLocation from xmlURL: ";
            errorMessage = xmlURL != null ? errorMessage + xmlURL.toExternalForm() : errorMessage + "W3C DOM (" + xmlDOM + ")";
            if (xmlURL != null && (xmlSchemaLocation == null || xmlSchemaLocation.length() == 0)) {
                throw new DocumentCreationException(errorMessage);
            }
            URL xsdURL = null;
            xsdURL = this.isRunningOnWindows() && xmlSchemaLocation.indexOf(":") != -1 ? URLHelper.getUserURL(xmlSchemaLocation) : URLHelper.getUserURL(xmlURL, xmlSchemaLocation);
            String rootName = xmlDOM.getDocumentElement().getNodeName();
            if (xsdURL != null) {
                if (xuiURL == null) {
                    String xuiPI = DOMHelper.getProcessingInstructionValue(xmlDOM, "jaxfront", "xui");
                    if (xuiPI != null && xuiPI.length() > 0) {
                        if (LogRegistry.getInstance().logInfos()) {
                            LogRegistry.getInstance().info(this.getClass(), "Load XUI from PI (" + xuiPI + ").");
                        }
                        xuiURL = URLHelper.getUserURL(xuiPI);
                    }
                    if (xuiURL == null && JAXFrontProperties.getInstance().isUsingXUINameLookup()) {
                        xuiURL = this.getDefaultXUILocationURL(xsdURL);
                    }
                    try {
                        if (xuiURL != null) {
                            JAXFrontProperties.getInstance().getURLResolver().resolveURL(xuiURL);
                        } else if (LogRegistry.getInstance().logWarnings()) {
                            LogRegistry.getInstance().warn(this.getClass(), "can't load xui (" + (xmlURL == null ? "null" : xmlURL.toExternalForm()) + ").");
                        }
                    }
                    catch (IOException ioEx) {
                        xuiURL = null;
                    }
                }
            } else {
                throw new DocumentCreationException(errorMessage);
            }
            document = this.build(null, xsdURL, xmlDOM, xuiURL, rootName);
        }
        catch (Exception ex) {
            throw new DocumentCreationException(ex);
        }
        return document;
    }

    private boolean isRunningOnWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }
}

