/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.dom;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.xpath.W3CXPathExecuterImpl;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeImporter {
    public static final int ENUMERATION_MAPPING_STRATEGY_REPLACE = 1;
    public static final int ENUMERATION_MAPPING_STRATEGY_APPEND = 2;
    public static final int ENUMERATION_MAPPING_STRATEGY_ADDCHILD = 3;
    public static final int ENUMERATION_MAPPING_STRATEGY_INSERTBEFORE = 4;
    public static final int ENUMERATION_MAPPING_STRATEGY_INSERTAFTER = 5;
    static /* synthetic */ Class class$com$jaxfront$core$dom$NodeImporter;

    public static void doImport(NodeList from, Node to, int importStrategy, String xsdPrefix) {
        for (int i = 0; i < from.getLength(); ++i) {
            NodeImporter.doImport(from.item(i), to, importStrategy, xsdPrefix);
        }
    }

    public static void doImport(Node from, Node to, int importStrategy, String xsdPrefix) {
        if (from != null && to != null) {
            Node importedNode = NodeImporter.importNodeToDom(from, to, xsdPrefix);
            if (importStrategy == 1) {
                Node toParent = to.getParentNode();
                toParent.replaceChild(importedNode, to);
            } else if (importStrategy == 2) {
                Node toParent = to.getParentNode();
                toParent.appendChild(importedNode);
            } else if (importStrategy == 3) {
                to.appendChild(importedNode);
            } else if (importStrategy == 4) {
                Node toParent = to.getParentNode();
                toParent.insertBefore(importedNode, to);
            } else if (importStrategy == 5) {
                Node toParent = to.getParentNode();
                Node afterNode = to.getNextSibling();
                if (afterNode != null) {
                    toParent.insertBefore(importedNode, afterNode);
                } else {
                    toParent.appendChild(importedNode);
                }
            }
        }
    }

    public static Node importNodeToDom(Node from, Node to, String xsdPrefix) {
        Node importedNode = NodeImporter.importReferencedNode(to, from);
        NodeImporter.updatePrefix(importedNode, xsdPrefix);
        return importedNode;
    }

    public static Node importNodeToDom(Document ownerDoc, Node from, String xsdPrefix) {
        Node importedNode = NodeImporter.importReferencedNode(ownerDoc, from);
        NodeImporter.updatePrefix(importedNode, xsdPrefix);
        return importedNode;
    }

    public static void updatePrefix(Node importNode, String prefix) {
        try {
            importNode.setPrefix(prefix);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (importNode.getChildNodes().getLength() > 0) {
            for (int i = 0; i < importNode.getChildNodes().getLength(); ++i) {
                NodeImporter.updatePrefix(importNode.getChildNodes().item(i), prefix);
            }
            NamedNodeMap nodeMap = importNode.getAttributes();
            if (nodeMap.getLength() > 0) {
                for (int i = 0; i < nodeMap.getLength(); ++i) {
                    try {
                        nodeMap.item(i).setPrefix(prefix);
                        continue;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static Node importReferencedNode(Node toNode, Node fromNode) {
        return toNode.getOwnerDocument().importNode(fromNode, true);
    }

    public static Node importReferencedNode(Document ownerDoc, Node fromNode) {
        return ownerDoc.importNode(fromNode, true);
    }

    public static Document injectXMLData(Document toDocument, Document fromDocument, String toXPath, String fromXPath, int strategy) {
        Document resultDom = null;
        try {
            if (toXPath == null || toXPath.length() == 0) {
                toXPath = ".";
            }
            if (fromXPath == null || fromXPath.length() == 0) {
                fromXPath = ".";
            }
            List targetNodeList = W3CXPathExecuterImpl.getInstance().processXPath(toDocument.getDocumentElement(), toXPath);
            resultDom = toDocument;
            if (targetNodeList.size() == 0) {
                Element xmlData = toDocument.createElement("jax:xml-data");
                Text textNode = toDocument.createTextNode("");
                xmlData.appendChild(textNode);
                toDocument.getDocumentElement().appendChild(xmlData);
                NodeImporter.doImport(fromDocument.getDocumentElement(), (Node)textNode, strategy, null);
            } else {
                Node targetNode = (Node)targetNodeList.get(0);
                List fromList = W3CXPathExecuterImpl.getInstance().processXPath(fromDocument.getDocumentElement(), fromXPath);
                for (int f = 0; f < fromList.size(); ++f) {
                    NodeImporter.doImport((Node)fromList.get(f), targetNode, strategy, null);
                }
            }
        }
        catch (Exception e) {
            LogRegistry.getInstance().error(class$com$jaxfront$core$dom$NodeImporter == null ? (class$com$jaxfront$core$dom$NodeImporter = NodeImporter.class$("com.jaxfront.core.dom.NodeImporter")) : class$com$jaxfront$core$dom$NodeImporter, e);
        }
        return resultDom;
    }

    public static Document mergeXML(Document toDocument, Document fromDocument, String toXPath, String fromXPath, int strategy, String glue, Node insertTarget) {
        Document resultDom = null;
        ArrayList fromToAdd = null;
        try {
            int f;
            String syncTargetValue;
            int t;
            if (toXPath == null || toXPath.length() == 0) {
                toXPath = ".";
            }
            if (fromXPath == null || fromXPath.length() == 0) {
                fromXPath = ".";
            }
            List toNodeList = W3CXPathExecuterImpl.getInstance().processXPath(toDocument.getDocumentElement(), toXPath);
            List fromNodeList = W3CXPathExecuterImpl.getInstance().processXPath(fromDocument.getDocumentElement(), fromXPath);
            ArrayList<Node> toAdd = new ArrayList<Node>();
            ArrayList<Node> toUpdate = new ArrayList<Node>();
            fromToAdd = new ArrayList();
            ArrayList<Node> result = new ArrayList<Node>();
            resultDom = toDocument;
            for (t = 0; t < toNodeList.size(); ++t) {
                Node targetNode = (Node)toNodeList.get(t);
                syncTargetValue = DOMHelper.getChildText(null, (Element)targetNode, glue);
                Node fromNode = NodeImporter.getNode(fromNodeList, glue, syncTargetValue);
                if (fromNode == null) {
                    toAdd.add(targetNode);
                    continue;
                }
                toUpdate.add(targetNode);
            }
            for (f = 0; f < fromNodeList.size(); ++f) {
                Node fromNode = (Node)fromNodeList.get(f);
                syncTargetValue = DOMHelper.getChildText(null, (Element)fromNode, glue);
                Node toUpdateNode = NodeImporter.getNode(toUpdate, glue, syncTargetValue);
                if (toUpdateNode == null) {
                    result.add(fromNode);
                    continue;
                }
                if (DOMHelper.getChildText(null, (Element)toUpdateNode, "columnName") == null) continue;
                result.add(toUpdateNode);
            }
            for (f = 0; f < toAdd.size(); ++f) {
                result.add((Node)toAdd.get(f));
            }
            for (t = 0; t < toNodeList.size(); ++t) {
                ((Node)toNodeList.get(t)).getParentNode().removeChild((Node)toNodeList.get(t));
            }
            for (int r = 0; r < result.size(); ++r) {
                Node fNode = (Node)result.get(r);
                NodeImporter.doImport(fNode, insertTarget, 5, null);
            }
        }
        catch (Exception e) {
            LogRegistry.getInstance().error(class$com$jaxfront$core$dom$NodeImporter == null ? (class$com$jaxfront$core$dom$NodeImporter = NodeImporter.class$("com.jaxfront.core.dom.NodeImporter")) : class$com$jaxfront$core$dom$NodeImporter, e);
        }
        return resultDom;
    }

    public static Node getNode(List<Node> from, String glue, String key) {
        for (int f = 0; f < from.size(); ++f) {
            Node fromNode = from.get(f);
            String syncFromValue = DOMHelper.getChildText(null, (Element)fromNode, glue);
            if (syncFromValue == null || !syncFromValue.equals(key)) continue;
            return fromNode;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

