/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.error;

import com.jaxfront.core.error.Error;
import com.jaxfront.core.rule.Message;
import com.jaxfront.core.type.AbstractType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.JAXFrontProperties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public abstract class AbstractError
implements Error {
    private static final String ERROR_MESSAGE_IMAGE = "com/jaxfront/core/images/files/error_16x16.gif";
    private static final String INCOMPLETE_MESSAGE_IMAGE = "com/jaxfront/core/images/files/incomplete_16x16.gif";
    private static final String INFO_MESSAGE_IMAGE = "com/jaxfront/core/images/files/info_16x16.gif";
    private static final String WARNING_MESSAGE_IMAGE = "com/jaxfront/core/images/files/warn_16x16.gif";
    private static final String HINT_MESSAGE_IMAGE = "com/jaxfront/core/images/files/hint_16x16.gif";
    private static final String QUESTION_MESSAGE_IMAGE = "com/jaxfront/core/images/files/question_16x16.gif";
    public static final int ALL_ERROR = 0;
    public static final int VALIDATION_ERROR = 1;
    public static final int CONDITIONAL_ERROR = 2;
    public static final int USER_ERROR = 3;
    private Object _identifierObject;
    String _classification;
    private Type _source;
    private Message _message;
    String _messageText;
    boolean _needsUserAcceptance = false;
    boolean _isMandatoryException = false;
    boolean _isCardinalityException = false;
    boolean _showDialog = false;
    private Type _raiser;

    public AbstractError(Type source) {
        this._source = source;
    }

    public AbstractError(Object identifierObject, Type source) {
        this._source = source;
        this.setUniqueIdentification(identifierObject);
    }

    public Type getErrorHolder() {
        return this._source;
    }

    public void release() {
        if (this._message != null) {
            this._message.release();
            this._message = null;
        }
    }

    public void markError() {
        if (TypeVisualizerFactory.getInstance() != null) {
            Vector visualizers = TypeVisualizerFactory.getInstance().getAllVisualizers(this.getErrorHolder());
            if (visualizers.size() == 0) {
                this.getErrorHolder().getStyle().markAsError(true);
            }
            for (int i = 0; i < visualizers.size(); ++i) {
                ((Visualizer)visualizers.get(i)).markError();
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && ((Error)obj).getErrorType() == this.getErrorType()) {
            boolean equals = ((Error)obj).getErrorHolder() == this.getErrorHolder() && ((Error)obj).getUniqueIdentification().equals(this.getUniqueIdentification());
            return equals;
        }
        return super.equals(obj);
    }

    public void resetError() {
        if (TypeVisualizerFactory.getInstance() != null) {
            Vector visualizers = TypeVisualizerFactory.getInstance().getAllVisualizers(this.getErrorHolder());
            for (int i = 0; i < visualizers.size(); ++i) {
                ((Visualizer)visualizers.get(i)).resetError();
            }
        }
    }

    public void setFocus() {
        JComponent visualizer = (JComponent)((Object)TypeVisualizerFactory.getInstance().getVisualizer(this.getErrorHolder()));
        visualizer.requestFocus();
    }

    public String toString() {
        return this.getMessageText();
    }

    public String getMessageClassification() {
        return GUIComponentNLS.getInstance().getNLSText(this.getErrorHolder().getDOM(), "message_classification_" + this.getClassification(), this.getClassification());
    }

    public abstract String getClassification();

    public abstract String getMessageClassificationForIcon();

    public ImageIcon getMessageIcon() {
        String classification = this.getMessageClassificationForIcon();
        ImageIcon icon = null;
        if (classification == null) {
            classification = "warning";
        }
        if (classification.equals("error")) {
            icon = JAXFrontProperties.getImageIcon(ERROR_MESSAGE_IMAGE);
        } else if (classification.equals("info")) {
            icon = JAXFrontProperties.getImageIcon(INFO_MESSAGE_IMAGE);
        } else if (classification.equals("incomplete")) {
            icon = JAXFrontProperties.getImageIcon(INCOMPLETE_MESSAGE_IMAGE);
        } else if (classification.equals("warning")) {
            icon = JAXFrontProperties.getImageIcon(WARNING_MESSAGE_IMAGE);
        } else if (classification.equals("hint")) {
            icon = JAXFrontProperties.getImageIcon(HINT_MESSAGE_IMAGE);
        } else if (classification.equals("question")) {
            icon = JAXFrontProperties.getImageIcon(QUESTION_MESSAGE_IMAGE);
        }
        return icon;
    }

    public String getHolderXPath() {
        if (this.getErrorHolder() != null) {
            String xpath = this.getErrorHolder().getXPathLocation();
            if (this.getErrorHolder().isList()) {
                xpath = xpath + "/" + this.getErrorHolder().getName();
            }
            return xpath;
        }
        return null;
    }

    public String getMessageContext() {
        return this.getErrorHolder().getShortCaption();
    }

    public ImageIcon getMessageContextIcon() {
        return ((AbstractType)this.getErrorHolder()).getMessageContextIcon();
    }

    public Object getUniqueIdentification() {
        return this._identifierObject;
    }

    void setUniqueIdentification(Object identifierObject) {
        this._identifierObject = identifierObject;
    }

    public boolean shouldMarkError() {
        String classification = this.getClassification();
        return classification.equals("error") || classification.equals("incomplete");
    }

    public boolean isMandatoryError() {
        return false;
    }

    public boolean isCardinalityError() {
        return false;
    }

    public void setRaiser(Type raiser) {
        this._raiser = raiser;
    }

    public Type getRaiser() {
        return this._raiser;
    }

    public boolean isXSDError() {
        return false;
    }
}

