/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.error;

import com.jaxfront.core.error.AbstractError;
import com.jaxfront.core.rule.ConditionExpression;
import com.jaxfront.core.rule.Rule;
import com.jaxfront.core.type.Type;

public class ConditionalError
extends AbstractError {
    private Rule _rule;
    private ConditionExpression _conditionExpression;

    public ConditionalError(Rule rule, ConditionExpression condition, Type source) {
        super(rule != null ? rule : condition, source);
        this._rule = rule;
        this._conditionExpression = condition;
    }

    public ConditionalError(Rule rule, ConditionExpression condition, Type source, String messageText, boolean needingUserAcceptance, boolean showDialog, boolean isMandatoryException, String classification) {
        this(rule, condition, source);
        this._messageText = messageText;
        this._needsUserAcceptance = needingUserAcceptance;
        this._showDialog = showDialog;
        this._isMandatoryException = isMandatoryException;
        this._classification = classification;
    }

    public ConditionExpression getCondition() {
        return this._conditionExpression;
    }

    public String getMessageClassificationForIcon() {
        String messageClassification = null;
        messageClassification = this.getCondition() != null ? this.getCondition().getMessage().getClassification() : "";
        if (messageClassification == null) {
            messageClassification = "warning";
        }
        return messageClassification;
    }

    public String getClassification() {
        if (this._classification == null) {
            this._classification = this.getCondition() != null ? this.getCondition().getMessage().getClassification() : "warning";
            if (this._classification == null) {
                this._classification = "warning";
            }
        }
        return this._classification;
    }

    public boolean isNeedingUserAcceptance() {
        return this.getCondition().getMessage().isNeedingUserAcceptance();
    }

    public String getMessageText() {
        String ruleNLS;
        if (this._rule != null && this._rule.getId() != null && (ruleNLS = this.getErrorHolder().getDOM().getNLS().get("rule_" + this._rule.getId())) != null && ruleNLS.length() > 0) {
            return ruleNLS;
        }
        return this.getCondition().getMessage().getText();
    }

    public boolean isShowingDialog() {
        return this._showDialog;
    }

    public int getErrorType() {
        return 2;
    }
}

