/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.error;

import com.jaxfront.core.log.LogRegistry;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Vector;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXValidator {
    public SAXErrorHandler validateAgainstSchema(String xmlDocument, String baseURL) {
        InputSource is = new InputSource(new StringReader(xmlDocument));
        is.setSystemId(baseURL);
        return this.validate(is);
    }

    public SAXErrorHandler validateWellFormedness(String xmlDocument) {
        InputSource is = new InputSource(new StringReader(xmlDocument));
        return this.validateWellFormedness(is);
    }

    public SAXErrorHandler validateWellFormedness(Reader xmlDocument) {
        InputSource is = new InputSource(xmlDocument);
        return this.validateWellFormedness(is);
    }

    private SAXErrorHandler validate(InputSource xmlDocument) {
        SAXErrorHandler errorHandler = new SAXErrorHandler();
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            parser.setErrorHandler(errorHandler);
            parser.parse(xmlDocument);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return errorHandler;
    }

    private SAXErrorHandler validateWellFormedness(InputSource xmlDocument) {
        SAXErrorHandler errorHandler = new SAXErrorHandler();
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            parser.setFeature("http://xml.org/sax/features/validation", false);
            parser.setFeature("http://apache.org/xml/features/validation/schema", false);
            parser.setErrorHandler(errorHandler);
            parser.parse(xmlDocument);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return errorHandler;
    }

    public static void main(String[] args) throws FileNotFoundException {
        SAXValidator val = new SAXValidator();
        SAXErrorHandler handler = val.validateWellFormedness(new FileReader("c:/temp/test.xml"));
        if (!handler.isWellformed()) {
            handler.dump(new PrintWriter(System.out));
        }
    }

    public class SAXErrorHandler
    implements ErrorHandler {
        Vector _errors = new Vector();
        Vector _fatals = new Vector();
        Vector _warnings = new Vector();
        public boolean validationError = false;
        public SAXParseException saxParseException = null;

        public void error(SAXParseException exception) throws SAXException {
            this.validationError = true;
            this.saxParseException = exception;
            boolean addException = true;
            if (exception != null && exception.getMessage().indexOf("has a keyref which refers to a key or unique that is out of scope.") != -1) {
                addException = false;
            }
            if (addException) {
                this.getErrors().add(exception);
            }
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.validationError = true;
            this.saxParseException = exception;
            this.getFatals().add(exception);
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.getWarnings().add(exception);
        }

        public Vector getFatals() {
            if (this._fatals == null) {
                this._fatals = new Vector();
            }
            return this._fatals;
        }

        public boolean isWellformed() {
            if (this.getFatals().size() > 0) {
                return false;
            }
            return this.getErrors().size() <= 0;
        }

        public Vector getWarnings() {
            if (this._warnings == null) {
                this._warnings = new Vector();
            }
            return this._warnings;
        }

        public Vector getErrors() {
            if (this._errors == null) {
                this._errors = new Vector();
            }
            return this._errors;
        }

        public boolean hasMessages() {
            return this.getErrors().size() != 0 || this.getFatals().size() != 0 || this.getWarnings().size() != 0;
        }

        public void dumpToLog() {
            SAXParseException ex = null;
            for (int f = 0; f < this.getFatals().size(); ++f) {
                ex = (SAXParseException)this.getFatals().get(f);
                LogRegistry.getInstance().error(this.getClass(), "XSD Fatal in Line:" + ex.getLineNumber() + " Col:" + ex.getColumnNumber() + " " + ex.getMessage());
            }
            for (int e = 0; e < this.getErrors().size(); ++e) {
                ex = (SAXParseException)this.getErrors().get(e);
                LogRegistry.getInstance().error(this.getClass(), "XSD Error in Line:" + ex.getLineNumber() + " Col:" + ex.getColumnNumber() + " " + ex.getMessage());
            }
            for (int w = 0; w < this.getWarnings().size(); ++w) {
                ex = (SAXParseException)this.getWarnings().get(w);
                LogRegistry.getInstance().error(this.getClass(), "XSD Warning in Line:" + ex.getLineNumber() + " Col:" + ex.getColumnNumber() + " " + ex.getMessage());
            }
        }

        public String dump() {
            StringWriter sw = new StringWriter();
            this.dump(new PrintWriter(sw));
            return sw.toString();
        }

        public void dump(PrintWriter out) {
            SAXParseException ex = null;
            for (int f = 0; f < this.getFatals().size(); ++f) {
                ex = (SAXParseException)this.getFatals().get(f);
                out.println("XSD Fatal in Line:" + ex.getLineNumber() + " Col:" + ex.getColumnNumber() + " " + ex.getMessage());
            }
            for (int e = 0; e < this.getErrors().size(); ++e) {
                ex = (SAXParseException)this.getErrors().get(e);
                out.println("XSD Error in Line:" + ex.getLineNumber() + " Col:" + ex.getColumnNumber() + " " + ex.getMessage());
            }
            for (int w = 0; w < this.getWarnings().size(); ++w) {
                ex = (SAXParseException)this.getWarnings().get(w);
                out.println("XSD Warning in Line:" + ex.getLineNumber() + " Col:" + ex.getColumnNumber() + " " + ex.getMessage());
            }
        }
    }
}

