/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.jep;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.jep.SuperTypeNode;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.rule.MathEvaluator;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.URLHelper;
import com.jaxfront.core.xpath.W3CXPathExecuterImpl;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BindResource
extends SuperTypeNode {
    public BindResource() {
        this.numberOfParameters = -1;
    }

    public void run(MathEvaluator.MathCommunicator communicator, Stack stack) throws ParseException {
        Object type;
        this.checkStack(stack);
        int bindResult = -1;
        switch (this.curNumberOfParameters) {
            case 2: {
                Object url = stack.pop();
                type = stack.pop();
                if (url instanceof String && type instanceof Type) {
                    bindResult = BindResource.bind(url.toString(), (Type)type, null, null);
                    break;
                }
                throw new ParseException(this.getClass() + " Invalid parameter type");
            }
            case 3: {
                Object xpath = stack.pop();
                Object url = stack.pop();
                type = stack.pop();
                if (url instanceof String && type instanceof Type && xpath instanceof String) {
                    bindResult = BindResource.bind(url.toString(), (Type)type, xpath.toString(), null);
                    break;
                }
                throw new ParseException(this.getClass() + " Invalid parameter type");
            }
            case 4: {
                Object innerXpath = stack.pop();
                Object outerXpath = stack.pop();
                Object url = stack.pop();
                type = stack.pop();
                if (url instanceof String && type instanceof Type && innerXpath instanceof String && outerXpath instanceof String) {
                    bindResult = BindResource.bind(url.toString(), (Type)type, innerXpath.toString(), outerXpath.toString());
                    break;
                }
                throw new ParseException(this.getClass() + " Invalid parameter type");
            }
            default: {
                throw new ParseException(this.getClass() + " Invalid parameter type");
            }
        }
        if (bindResult >= 0) {
            ((Type)type).getDOM().reApplyLostComponents();
            TypeVisualizerFactory.getInstance().populateAllVisualizerForType((Type)type);
            stack.push(SuperTypeNode.isTrue);
        } else {
            stack.push(SuperTypeNode.isFalse);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int bind(String resUrl, Type bindTo, String innerXpath, String outerXpath) {
        URL url;
        int result = 0;
        if (bindTo == null) return result;
        try {
            url = new URL(resUrl);
        }
        catch (MalformedURLException e1) {
            url = URLHelper.getUserURL(resUrl);
        }
        url = BindResource.testUrl(url);
        if (url == null) {
            url = URLHelper.getUserURL((URL)bindTo.getDOM().getClientProperty("requestedURL"), resUrl);
            url = BindResource.testUrl(url);
        }
        if (url == null) {
            url = URLHelper.getUserURL(bindTo.getDOM().getFingerPrint().getXUIURL(), resUrl);
            url = BindResource.testUrl(url);
        }
        if (url == null) {
            bindTo.bind(bindTo.getDOM(), (Element)null);
            return result;
        }
        if (LogRegistry.getInstance().logInfos()) {
            LogRegistry.getInstance().info(BindResource.class, "loading ressource from:" + url.toExternalForm());
        }
        try {
            Element rootElement;
            Document bindDom = DOMHelper.createDocument(url);
            if (outerXpath != null && outerXpath.length() > 0) {
                List targets = W3CXPathExecuterImpl.getInstance().processXPath(bindDom.getDocumentElement(), outerXpath);
                if (targets.size() <= 0) {
                    DOMHelper.performLateBind(bindTo, null);
                    return 0;
                }
                String xmlContent = DOMHelper.getText((Element)targets.get(0));
                rootElement = DOMHelper.createDocument(xmlContent).getDocumentElement();
            } else {
                rootElement = bindDom.getDocumentElement();
            }
            if (innerXpath != null && innerXpath.length() > 0) {
                List innerTargets = W3CXPathExecuterImpl.getInstance().processXPath(rootElement, innerXpath);
                if (innerTargets.size() <= 0) {
                    DOMHelper.performLateBind(bindTo, null);
                    return 0;
                }
                rootElement = (Element)innerTargets.get(0);
            } else {
                rootElement = bindDom.getDocumentElement();
            }
            bindTo.getDOM().setRuleEngineBlocked(true);
            DOMHelper.performLateBind(bindTo, rootElement);
            bindTo.getDOM().setRuleEngineBlocked(false);
            return 1;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return result;
        }
    }

    private static URL testUrl(URL url) {
        try {
            if (url != null) {
                InputStream testStream = JAXFrontProperties.getInstance().getURLResolver().resolveURL(url);
                testStream.close();
            }
        }
        catch (Exception e) {
            return null;
        }
        return url;
    }
}

