/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.jep;

import com.jaxfront.core.jep.ArrayResult;
import com.jaxfront.core.jep.SuperTypeNode;
import com.jaxfront.core.rule.MathEvaluator;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypePathExecuter;
import java.util.List;
import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.type.NULL;

public class CodeSetValues
extends SuperTypeNode {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(MathEvaluator.MathCommunicator communicator, Stack stack) throws ParseException {
        this.checkStack(stack);
        Object param = null;
        String xPath = null;
        if (this.curNumberOfParameters != 1) throw new ParseException(this.getClass() + " Invalid parameter type");
        Type baseType = communicator.getRootType();
        param = stack.pop();
        if (param == NULL._null) {
            stack.push(NULL._null);
            return;
        }
        if (param instanceof String) {
            xPath = param;
            Type codeSetType = TypePathExecuter.getInstance().getTypeForXPath(baseType, xPath.trim());
            ArrayResult arrayResult = new ArrayResult();
            this.addToArrayResult(arrayResult, codeSetType);
            stack.push(arrayResult);
            return;
        } else if (param instanceof List) {
            List inputList = param;
            ArrayResult arrayResult = new ArrayResult();
            for (int j = 0; j < inputList.size(); ++j) {
                this.addToArrayResult(arrayResult, (Type)inputList.get(j));
            }
            stack.push(arrayResult);
            return;
        } else {
            if (!(param instanceof Type)) throw new ParseException(this.getClass() + " No Codeset for Complex Types");
            ArrayResult arrayResult = new ArrayResult();
            this.addToArrayResult(arrayResult, param);
            stack.push(arrayResult);
        }
    }

    private void addToArrayResult(ArrayResult arrayResult, Type codeSetType) {
        String[] codeSetValues;
        if (codeSetType != null && codeSetType.isSimple() && (codeSetValues = codeSetType.getXUIDefinition().getStyle().getEnumeration()) != null) {
            arrayResult.addAll(codeSetValues);
        }
        if (arrayResult.size() == 0) {
            arrayResult.add(NULL._null);
        }
    }
}

