/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.jep;

import com.jaxfront.core.jep.JaxfrontMathCommand;
import com.jaxfront.core.jep.SuperTypeNode;
import com.jaxfront.core.rule.MathEvaluator;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.JAXFrontDateTools;
import com.jaxfront.core.util.StringUtil;
import java.util.List;
import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.type.NULL;

public class SetSerializable
extends JaxfrontMathCommand {
    public SetSerializable() {
        this.numberOfParameters = -1;
    }

    public void run(MathEvaluator.MathCommunicator communicator, Stack stack) throws ParseException {
        this.checkStack(stack);
        Object param = null;
        Type aType = null;
        switch (this.curNumberOfParameters) {
            case 1: {
                param = stack.pop();
                if (param == null || param == NULL._null) {
                    stack.push("not definied");
                    return;
                }
                aType = communicator.getRootType();
                aType.setSerializable(StringUtil.isTrue(param.toString()));
                break;
            }
            case 2: {
                param = stack.pop();
                Object param2 = stack.pop();
                if (param == null || param == NULL._null) {
                    stack.push("not definied");
                    return;
                }
                if (param2 instanceof Type) {
                    aType = (Type)param2;
                    aType.setSerializable(StringUtil.isTrue(param.toString()));
                    break;
                }
                if (param2 instanceof List) {
                    List tList = (List)param2;
                    for (int i = 0; i < tList.size(); ++i) {
                        if (!(tList.get(i) instanceof Type)) continue;
                        aType = (Type)tList.get(i);
                        aType.setSerializable(StringUtil.isTrue(param.toString()));
                    }
                    break;
                }
                throw new ParseException(this.getClass() + " Invalid parameter types must be aSimpleType!");
            }
            default: {
                throw new ParseException(this.getClass() + " Invalid parameter types must be Nothing or a SimpleType!");
            }
        }
        stack.push(SuperTypeNode.isTrue);
    }

    public static String translate(int dataType) {
        switch (dataType) {
            case 3: {
                return "Boolean";
            }
            case 4: {
                return "Double";
            }
            case 6: {
                return "Double";
            }
            case 5: {
                return "Float";
            }
            case 34: {
                return "Integer";
            }
            case 30: {
                return "Integer";
            }
            case 33: {
                return "Long";
            }
            case 32: {
                return "Integer";
            }
            case 37: {
                return "Integer";
            }
            case 31: {
                return "Integer";
            }
            case 42: {
                return "Integer";
            }
            case 35: {
                return "Short";
            }
            case 39: {
                return "Integer";
            }
            case 38: {
                return "Long";
            }
            case 40: {
                return "Short";
            }
            case 10: {
                return "Date";
            }
            case 8: {
                return "DateTime";
            }
            case 7: {
                return "Duration";
            }
            case 16: {
                return "HexBinary";
            }
            case 17: {
                return "Base64Binary";
            }
        }
        return "String";
    }

    public static int translateFromString(String dataType) {
        if (dataType.equalsIgnoreCase("String")) {
            return 2;
        }
        if (dataType.equalsIgnoreCase("Boolean")) {
            return 3;
        }
        if (dataType.equalsIgnoreCase("Double")) {
            return 6;
        }
        if (dataType.equalsIgnoreCase("Float")) {
            return 5;
        }
        if (dataType.equalsIgnoreCase("Integer")) {
            return 34;
        }
        if (dataType.equalsIgnoreCase("Long")) {
            return 33;
        }
        if (dataType.equalsIgnoreCase("Short")) {
            return 35;
        }
        if (dataType.equalsIgnoreCase("DateTime")) {
            return 8;
        }
        if (dataType.equalsIgnoreCase("Time")) {
            return 9;
        }
        if (dataType.equalsIgnoreCase("Date")) {
            return 10;
        }
        if (dataType.equalsIgnoreCase("Decimal")) {
            return 4;
        }
        if (dataType.equalsIgnoreCase("byte")) {
            return 36;
        }
        if (dataType.equalsIgnoreCase("int")) {
            return 34;
        }
        if (dataType.equalsIgnoreCase("negativeInteger")) {
            return 32;
        }
        if (dataType.equalsIgnoreCase("nonNegativeInteger")) {
            return 37;
        }
        if (dataType.equalsIgnoreCase("nonPositiveInteger")) {
            return 31;
        }
        if (dataType.equalsIgnoreCase("positiveInteger")) {
            return 42;
        }
        if (dataType.equalsIgnoreCase("unsignedInt")) {
            return 39;
        }
        if (dataType.equalsIgnoreCase("unsignedLong")) {
            return 38;
        }
        if (dataType.equalsIgnoreCase("unsignedShort")) {
            return 40;
        }
        if (dataType.equalsIgnoreCase("HexBinary")) {
            return 16;
        }
        if (dataType.equalsIgnoreCase("Base64Binary")) {
            return 17;
        }
        return 2;
    }

    public static String getDefaultNullValue(String dataType) {
        String value = "";
        if (dataType.equals("Double") || dataType.equals("Float") || dataType.equals("Integer") || dataType.equals("Long") || dataType.equals("Short")) {
            value = "0";
        } else if (dataType.equals("Boolean")) {
            value = "false";
        } else {
            if (dataType.equals("Date")) {
                return JAXFrontDateTools.getCurrentISODate();
            }
            if (dataType.equals("Time")) {
                value = "00:00";
            } else if (dataType.equals("DateTime")) {
                return JAXFrontDateTools.getCurrentISODate() + "T00:00:00";
            }
        }
        return value;
    }
}

