/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.jep;

import com.jaxfront.core.jep.JaxfrontMathCommand;
import com.jaxfront.core.rule.MathEvaluator;
import com.jaxfront.core.util.JAXFrontDateTools;
import java.util.Date;
import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.type.NULL;

public class SimpleDateFormat
extends JaxfrontMathCommand {
    private String _sourceFormat = "yyyy-MM-dd";

    public SimpleDateFormat() {
        this.numberOfParameters = -1;
    }

    public Object format(long number, String pattern) {
        if (pattern.equals("asNumber")) {
            return new Long(number);
        }
        java.text.SimpleDateFormat myFormatter = new java.text.SimpleDateFormat(pattern);
        return myFormatter.format(new Date(number));
    }

    public Object format(String currentDate, String sourcePattern, String destinatioPattern) throws java.text.ParseException {
        java.text.SimpleDateFormat iso = new java.text.SimpleDateFormat(sourcePattern);
        long time = iso.parse(currentDate).getTime();
        if (destinatioPattern.equals("asNumber")) {
            return new Long(time);
        }
        return this.format(time, destinatioPattern);
    }

    public Object format(Object value, Object destinationPattern) throws java.text.ParseException {
        if (value instanceof Number && destinationPattern instanceof String) {
            return this.format(((Number)value).longValue(), (String)destinationPattern);
        }
        if (value instanceof String && destinationPattern instanceof String) {
            String sourcePattern = this._sourceFormat;
            switch (JAXFrontDateTools.getUsedISODateFormat((String)value)) {
                case 0: {
                    sourcePattern = "yyyy-MM-dd";
                    break;
                }
                case 1: {
                    sourcePattern = "yyyy-MM-dd'T'HH:mm:ss";
                    break;
                }
                case 2: {
                    sourcePattern = "HH:mm:ss.SSS";
                    break;
                }
            }
            return this.format((String)value, sourcePattern, (String)destinationPattern);
        }
        if (value instanceof Date && destinationPattern instanceof String) {
            return this.format(((Date)value).getTime(), (String)destinationPattern);
        }
        return NULL._null;
    }

    public void run(MathEvaluator.MathCommunicator communicator, Stack stack) throws ParseException {
        this.checkStack(stack);
        Object param = null;
        Object param2 = null;
        Object param3 = null;
        Object result = "";
        if (this.curNumberOfParameters == 1) {
            param = stack.pop();
            if (param == NULL._null) {
                stack.push(param);
                return;
            }
            try {
                Date date = null;
                if (param instanceof Date) {
                    date = (Date)param;
                } else if (JAXFrontDateTools.isISODateTime((String)param)) {
                    date = JAXFrontDateTools.parseISODate((String)param);
                }
                if (communicator.getDoc().getUser() != null) {
                    result = communicator.getDoc().getUser().getLocale().formatDateTimeShort(date);
                }
                if (date != null) {
                    result = this.format(date.getTime(), communicator.getDoc().getGlobalDefinition().getDateTimeFormatStringPattern(null));
                }
                result = this.format(param, (Object)communicator.getDoc().getGlobalDefinition().getDateTimeFormatStringPattern(null));
            }
            catch (java.text.ParseException e) {
                throw new ParseException(this.getClass() + " Invalid parameter type");
            }
        } else if (this.curNumberOfParameters == 2) {
            param2 = stack.pop();
            param = stack.pop();
            try {
                result = this.format(param, param2);
            }
            catch (java.text.ParseException e) {
                throw new ParseException(this.getClass() + " Invalid parameter type");
            }
        } else if (this.curNumberOfParameters == 3) {
            param3 = stack.pop();
            param2 = stack.pop();
            param = stack.pop();
            if (param instanceof String && param2 instanceof String && param3 instanceof String) {
                try {
                    result = this.format((String)param, param2, param3);
                }
                catch (java.text.ParseException e) {
                    throw new ParseException(this.getClass() + " Invalid parameter type");
                }
            } else if (param2 instanceof String && param3 instanceof String) {
                try {
                    result = this.format(param, param2);
                }
                catch (java.text.ParseException e) {
                    throw new ParseException(this.getClass() + " Invalid parameter type");
                }
            }
        } else {
            throw new ParseException(this.getClass() + " Invalid parameter type");
        }
        if (result == null) {
            throw new ParseException(this.getClass() + " Invalid parameter type");
        }
        stack.push(result);
    }
}

