/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.jep;

import com.jaxfront.core.jep.ArrayResult;
import com.jaxfront.core.jep.JaxfrontMathCommand;
import com.jaxfront.core.rule.MathEvaluator;
import java.util.Stack;
import java.util.Vector;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.TypeObject;
import org.nfunk.jep.type.NULL;

public class Sum
extends JaxfrontMathCommand {
    private static final int numberResultType = 0;
    private static final int stringResultType = 1;
    private static final int undefiendType = -1;

    public Sum() {
        this.numberOfParameters = -1;
    }

    public void run(MathEvaluator.MathCommunicator communicator, Stack stack) throws ParseException {
        if (null == stack) {
            throw new ParseException("Stack argument null");
        }
        Object param = null;
        double result = 0.0;
        StringBuffer stringResult = new StringBuffer();
        int resultType = -1;
        for (int i = 0; i < this.curNumberOfParameters; ++i) {
            param = stack.pop();
            if (param == NULL._null || param == null) {
                result += 0.0;
                continue;
            }
            if (param instanceof Vector && this.curNumberOfParameters == 1) {
                ArrayResult toMinResultVector = (ArrayResult)param;
                for (int j = 0; j < toMinResultVector.size(); ++j) {
                    try {
                        Object sumObject = toMinResultVector.get(j);
                        double num = 0.0;
                        if (sumObject != NULL._null && sumObject != null) {
                            if (sumObject instanceof Number) {
                                num = ((Number)sumObject).doubleValue();
                                resultType = 0;
                            } else if (sumObject instanceof String) {
                                stringResult.append(sumObject.toString());
                                resultType = 1;
                            }
                        }
                        result += num;
                        continue;
                    }
                    catch (ClassCastException e) {
                        throw new ParseException(this.getClass() + " " + e.toString() + " can't cast from: " + toMinResultVector.get(j).getClass());
                    }
                }
                break;
            }
            if (param instanceof Number) {
                result += ((Number)param).doubleValue();
                resultType = 0;
                continue;
            }
            if (param instanceof String) {
                stringResult.append(param.toString());
                resultType = 1;
                continue;
            }
            if (param instanceof TypeObject) {
                Object aVal = ((TypeObject)param).getMathValueTyped();
                if (aVal instanceof Number) {
                    result += ((Number)aVal).doubleValue();
                    resultType = 0;
                    continue;
                }
                if (!(aVal instanceof String)) continue;
                stringResult.append(aVal.toString());
                resultType = 1;
                continue;
            }
            throw new ParseException(this.getClass() + " Invalid parameter type");
        }
        switch (resultType) {
            case 1: {
                stack.push(stringResult.toString());
                break;
            }
            default: {
                stack.push(new Double(result));
            }
        }
    }
}

