/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.jep;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.jep.JaxfrontMathCommand;
import com.jaxfront.core.jep.SuperTypeNode;
import com.jaxfront.core.rule.MathEvaluator;
import com.jaxfront.core.type.Type;
import java.util.List;
import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.type.NULL;

public class Visible
extends JaxfrontMathCommand {
    public Visible() {
        this.numberOfParameters = -1;
    }

    public static boolean checkVisibility(Type aType, boolean childsOnly) {
        return Visible.checkVisibility(aType, childsOnly, true);
    }

    public static boolean checkVisibility(Type aType, boolean childsOnly, boolean choosenOnly) {
        if (aType != null) {
            if (childsOnly) {
                List allTypes = DOMHelper.getAllSelectedVisStructureChilds(aType, choosenOnly);
                if (allTypes != null) {
                    allTypes.remove(aType);
                    int aSize = allTypes.size();
                    if (aSize == 0) {
                        return true;
                    }
                    for (int c = 0; c < aSize; ++c) {
                        Type aCType = (Type)allTypes.get(c);
                        if (!aCType.getStyle().isVisibleAtRuntime()) continue;
                        return true;
                    }
                }
            } else {
                return aType.getStyle().isVisibleAtRuntime();
            }
        }
        return false;
    }

    public void run(MathEvaluator.MathCommunicator communicator, Stack stack) throws ParseException {
        this.checkStack(stack);
        boolean visible = false;
        if (this.curNumberOfParameters == 0) {
            visible = communicator.getRootType().getStyle().isVisibleAtRuntime();
        } else if (this.curNumberOfParameters == 1) {
            Object toSearchFor = stack.pop();
            if (toSearchFor != NULL._null) {
                if (toSearchFor instanceof Boolean) {
                    visible = Visible.checkVisibility(communicator.getRootType(), (Boolean)toSearchFor);
                } else {
                    if (toSearchFor instanceof String) {
                        toSearchFor = communicator.getDoc().getType((String)toSearchFor, communicator.getRootType());
                    }
                    if (toSearchFor != null) {
                        visible = Visible.checkVisibility((Type)toSearchFor, false);
                    } else {
                        stack.push(NULL._null);
                    }
                }
            } else {
                stack.push(NULL._null);
            }
        } else if (this.curNumberOfParameters == 2) {
            Object childsOnly = stack.pop();
            Object toSearchFor = stack.pop();
            if (toSearchFor != NULL._null) {
                if (toSearchFor instanceof String) {
                    toSearchFor = communicator.getDoc().getType((String)toSearchFor, communicator.getRootType());
                }
                if (toSearchFor != null && childsOnly != null) {
                    visible = Visible.checkVisibility((Type)toSearchFor, (Boolean)childsOnly);
                } else {
                    stack.push(NULL._null);
                }
            } else {
                stack.push(NULL._null);
            }
        } else {
            throw new ParseException("wrong number of parameters:" + this.getClass());
        }
        if (visible) {
            stack.push(SuperTypeNode.isTrue);
        } else {
            stack.push(SuperTypeNode.isFalse);
        }
    }
}

