/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.rule;

import com.jaxfront.core.dom.DOMChangeEvent;
import com.jaxfront.core.dom.DOMChangeListener;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.rule.FormulaException;
import com.jaxfront.core.rule.MathEvaluator;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.xui.TableCell;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.nfunk.jep.ParseException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormulaExpression
implements DOMChangeListener,
Serializable {
    private Type _source;
    private String _expression;
    private String _id;
    private boolean _includeOnlySerializable = false;
    private String _formulaResult;
    private TableCell _tableCell;
    private Vector _referencedExpressionNodes;
    private Object _cachedResult;
    private boolean _isReleased;
    private long _lastUpdateTS = 0L;
    private boolean _domRegistered;
    private boolean _isDirty;
    private boolean _isCachable = true;
    public static final String TRUE = "true";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$util$Date;

    public FormulaExpression() {
    }

    public FormulaExpression(Type source, String expression) {
        this(source, expression, false);
    }

    public FormulaExpression(Type source, String expression, String id) {
        this(source, expression, false, false, id);
    }

    public FormulaExpression(Type source, String expression, TableCell cell, boolean registerFormula) {
        this(source, expression, false, registerFormula);
        this.setTableCell(cell);
        this.setCachable(false);
    }

    public FormulaExpression(Type source, String expression, boolean includeOnlySerializable) {
        this(source, expression, includeOnlySerializable, true, null);
    }

    public FormulaExpression(Type source, String expression, boolean includeOnlySerializable, boolean registerFormula) {
        this(source, expression, includeOnlySerializable, registerFormula, null);
    }

    public FormulaExpression(Type source, String expression, boolean includeOnlySerializable, boolean registerFormula, String id) {
        this._source = source;
        this._id = id;
        this.setExpression(expression);
        if (registerFormula && source != null) {
            this._source.getDOM().addFormula(this);
        }
        this._domRegistered = registerFormula;
        this._includeOnlySerializable = includeOnlySerializable;
    }

    public String evaluate() throws FormulaException {
        return this.evaluate(null, null, null);
    }

    public String evaluate(boolean forceEval) throws FormulaException {
        return this.evaluate(null, null, null, forceEval, null);
    }

    public String evaluate(Type target, Object eventSource, Object event) throws FormulaException {
        return this.evaluate(target, eventSource, event, false, null);
    }

    public String evaluate(Type target, Object eventSource, Object event, boolean forceEval, List<Type> targetTypes) throws FormulaException {
        String oldResult = this._formulaResult;
        if (forceEval || this.needsUpdate() || this._formulaResult == null) {
            if (this.getExpression() != null && this.getMathEvaluator() != null) {
                if (this.getMathEvaluator().getCallStack().contains(this)) {
                    return "";
                }
                this.getMathEvaluator().getCallStack().push(this);
                try {
                    String expression = this.getExpression();
                    if (expression.length() > 0 && this.getSource() != null && this.getSource().getDOM() != null) {
                        expression = TextTools.replaceGlobalUserProperties(expression, this.getSource().getDOM());
                    }
                    if (target == null) {
                        target = this.getSource();
                    }
                    this._formulaResult = this.getMathEvaluator().evaluateString(target, eventSource, event, expression, this._includeOnlySerializable, targetTypes);
                }
                catch (ParseException e) {
                    if (LogRegistry.getInstance().logInfos()) {
                        LogRegistry.getInstance().info(this.getClass(), new StringBuffer().append("Source:").append(this.getSource().getXPathLocation()).append(" Expression:").append(this.getExpression()).append(" Reason:").append(e.getErrorInfo()).toString());
                    }
                    this._formulaResult = "0";
                }
                this.getMathEvaluator().getCallStack().pop();
            } else {
                if (this.getSource() != null) {
                    return this.getSource().getDisplayValue();
                }
                this._formulaResult = "";
            }
            if (oldResult == this._formulaResult || oldResult != null && oldResult.equals(this._formulaResult)) {
                this._isDirty = false;
            } else {
                this._isDirty = true;
                this._lastUpdateTS = this.getSource() != null ? this.getSource().getDOM().getLastDomUpdateTimeStamp() : -1L;
            }
            this.setCachedResult(this._formulaResult);
            return this._formulaResult;
        }
        Object aCResult = this.getCachedResult();
        if (aCResult != null) {
            return aCResult.toString();
        }
        return null;
    }

    public boolean needsUpdate() {
        if (this.getSource() == null) {
            return false;
        }
        return this.getSource().getDOM() == null || this._lastUpdateTS == -1L || this._lastUpdateTS != this.getSource().getDOM().getLastDomUpdateTimeStamp();
    }

    public boolean isDirty() {
        return this._isDirty;
    }

    public Object evaluateObject() throws FormulaException {
        return this.evaluateObject(null);
    }

    public Object evaluateObject(Type target) throws FormulaException {
        Object eval = null;
        if (this.getSource() != null) {
            if (this.getExpression() != null && this.getMathEvaluator() != null) {
                try {
                    String expression = this.getExpression();
                    if (expression.length() > 0 && this.getSource() != null && this.getSource().getDOM() != null) {
                        expression = TextTools.replaceGlobalUserProperties(expression, this.getSource().getDOM());
                    }
                    Type source = this.getSource();
                    if (target != null) {
                        source = target;
                    }
                    eval = this.getMathEvaluator().evaluateObject(source, expression, this._includeOnlySerializable);
                }
                catch (ParseException e) {
                    if (LogRegistry.getInstance().logInfos()) {
                        LogRegistry.getInstance().info(this.getClass(), new StringBuffer().append("Source:").append(this.getSource().getXPathLocation()).append(" Expression:").append(this.getExpression()).append(" Reason:").append(e.getErrorInfo()).toString());
                    }
                }
            } else {
                eval = this.getSource().getDisplayValue();
            }
        }
        this.setCachedResult(eval);
        return eval;
    }

    public Type getSource() {
        return this._source;
    }

    public void setSource(Type newSource) {
        this._source = newSource;
    }

    private MathEvaluator getMathEvaluator() {
        if (this._source != null && this._source.getDOM() != null && !this._source.getDOM().isSCReleased() && !this._source.getDOM().isReleased()) {
            return this._source.getDOM().getController().getMathEvaluator();
        }
        return null;
    }

    public boolean isTrue(Type source, Object event, boolean useEventSourceAsBase) throws FormulaException {
        return this.isTrue(source, event, useEventSourceAsBase, false);
    }

    public boolean isTrue(Type source, Object event, boolean useEventSourceAsBase, boolean forceEval) throws FormulaException {
        String evaluationResult;
        Type base = source;
        if (!useEventSourceAsBase) {
            base = null;
        }
        if ((evaluationResult = this.evaluate(base, source, event, forceEval, null)).equals("") || evaluationResult.equals(TRUE)) {
            return true;
        }
        try {
            double d = Double.parseDouble(evaluationResult);
            return d > 0.0;
        }
        catch (NumberFormatException e) {
            throw new FormulaException(e);
        }
    }

    public boolean isTrue(Type sourceType) throws FormulaException {
        this._source = sourceType;
        return this.isTrue(sourceType, null, false);
    }

    public String getErrorInfo() {
        if (this.getMathEvaluator() != null) {
            return this.getMathEvaluator().getErrorInfo();
        }
        return "";
    }

    public boolean doesConcern(Type sourceType, boolean checkTargets) {
        if (sourceType == this.getSource()) {
            return true;
        }
        Vector targts = this.getReferencedExpressionNodes();
        if (checkTargets && targts != null && targts.contains(sourceType)) {
            return true;
        }
        if (this.getExpression() != null) {
            return this.checkExpression(sourceType);
        }
        return false;
    }

    private boolean checkExpression(Type sourceType) {
        boolean isConcerned = false;
        Vector targets = this.getReferencedExpressionNodes();
        if (targets != null) {
            ListType parentList;
            boolean bl = isConcerned = targets.indexOf(sourceType) != -1;
            if (sourceType.getParent() != null && sourceType.getParent().isList() && (parentList = (ListType)sourceType.getParent()).getList().indexOf(sourceType) == -1) {
                Iterator iterator = this.getReferencedExpressionNodes().iterator();
                Type refType = null;
                while (iterator.hasNext()) {
                    refType = (Type)iterator.next();
                    if (!refType.isDerivedFrom(sourceType)) continue;
                    isConcerned = true;
                    break;
                }
            }
        }
        return isConcerned;
    }

    public void checkSyntax() throws ParseException {
        if (this.getExpression() != null && this.getMathEvaluator() != null) {
            String expression = this.getExpression();
            if (expression.length() > 0 && this.getSource() != null && this.getSource().getDOM() != null) {
                expression = TextTools.replaceGlobalUserProperties(expression, this.getSource().getDOM());
            }
            this.getMathEvaluator().evaluateObject(this.getSource(), expression, this._includeOnlySerializable);
        }
    }

    public Vector getReferencedExpressionNodes() {
        if (this._referencedExpressionNodes == null) {
            HashSet result;
            block4: {
                result = null;
                try {
                    result = this.getSource().getDOM().getController().getMathEvaluator().evaluateReferencedNodes(this.getSource(), this.getExpression());
                }
                catch (ParseException e) {
                    this.getSource().getDOM().notifyDebug(3, new StringBuffer().append("Eval referenced nodes Source:").append(this.getSource().getXPathLocation()).append(" Expression:").append(this.getExpression()).append(" Reason:").append(e.getErrorInfo()).toString());
                    if (!LogRegistry.getInstance().logInfos()) break block4;
                    LogRegistry.getInstance().info(this.getClass(), new StringBuffer().append("Source:").append(this.getSource().getXPathLocation()).append(" Expression:").append(this.getExpression()).append(" Reason:").append(e.getErrorInfo()).toString());
                }
            }
            if (result != null) {
                this._referencedExpressionNodes = new Vector(result.size());
                this._referencedExpressionNodes.addAll(result);
            }
        }
        return this._referencedExpressionNodes;
    }

    public void release() {
        if (this._source != null && this._domRegistered) {
            this._source.getDOM().removeFormula(this);
        }
        this._isReleased = true;
        this._source = null;
        if (this._tableCell != null) {
            this._tableCell.release();
        }
    }

    public boolean isReleased() {
        return this._isReleased;
    }

    public void setExpression(String expression) {
        this._expression = expression;
    }

    public String getExpression() {
        return this._expression;
    }

    public void setCachedResult(Object cachedResult) {
        this._cachedResult = cachedResult;
    }

    public Object getCachedResult() {
        if (this._cachedResult == null) {
            try {
                this.evaluateObject();
            }
            catch (FormulaException formulaException) {
                // empty catch block
            }
        }
        return this._cachedResult;
    }

    public Class getResultClassForSort() {
        Type ref;
        Class resultClass = class$java$lang$String == null ? (class$java$lang$String = FormulaExpression.class$("java.lang.String")) : class$java$lang$String;
        Vector targets = this.getReferencedExpressionNodes();
        if (targets != null && targets.size() == 1 && (ref = (Type)this.getReferencedExpressionNodes().firstElement()).isSimple()) {
            if (((SimpleType)ref).isNumber()) {
                resultClass = class$java$lang$Number == null ? (class$java$lang$Number = FormulaExpression.class$("java.lang.Number")) : class$java$lang$Number;
            } else if (((SimpleType)ref).isDate()) {
                resultClass = class$java$util$Date == null ? (class$java$util$Date = FormulaExpression.class$("java.util.Date")) : class$java$util$Date;
            }
        }
        return resultClass;
    }

    @Override
    public void domChanged(DOMChangeEvent event) {
        if (event.isAddingNode()) {
            this._referencedExpressionNodes = null;
        }
    }

    public void setReferencedExpressionNodes(Vector expressionNodes) {
        this._referencedExpressionNodes = expressionNodes;
    }

    public boolean doesIncludeOnlySerializableNodes() {
        return this._includeOnlySerializable;
    }

    public void setDoesIncludeOnlySerializableNodes(boolean doesInclude) {
        this._includeOnlySerializable = doesInclude;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FormulaExpression) {
            FormulaExpression formObj = (FormulaExpression)obj;
            if (formObj._source == this._source && formObj._includeOnlySerializable == this._includeOnlySerializable && formObj._tableCell == this._tableCell) {
                if (formObj._expression == this._expression) {
                    return true;
                }
                return formObj._expression != null && formObj._expression.equals(this._expression);
            }
        }
        return false;
    }

    public int hashCode() {
        return 1;
    }

    public void setTableCell(TableCell cell) {
        this._tableCell = cell;
    }

    public TableCell getTableCell() {
        return this._tableCell;
    }

    public long getLastUpdateTS() {
        return this._lastUpdateTS;
    }

    public String getID() {
        return this._id;
    }

    public String toString() {
        String toString = this.getClass().getName();
        if (this.getExpression() != null) {
            toString = new StringBuffer().append(toString).append("\n formula: ").append(this.getExpression()).toString();
        }
        if (this.getSource() != null) {
            toString = new StringBuffer().append(toString).append("\n source : ").append(this.getSource().getXPathLocation()).toString();
        }
        return toString;
    }

    public void setCachable(boolean isCachable) {
        this._isCachable = isCachable;
    }

    public boolean isCachable() {
        return this._isCachable;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

