/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.rule;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.rule.AbstractAction;
import com.jaxfront.core.rule.ActionPerformEvent;
import com.jaxfront.core.rule.RuleInvocationException;
import com.jaxfront.core.type.MethodParameter;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;

public class UIAction
extends AbstractAction {
    private Method _method;
    private String _methodName;
    private Class[] _parameterTypes;
    private MethodParameter[] _params;
    public static final String METHOD_SET_ENABLED = "setEnabled";
    public static final String METHOD_SHOW_MESSAGE = "showMessage";
    public static final String METHOD_SET_CHOICE_ENABLED = "setChoiceEnabled";
    public static final String METHOD_SET_EDITABLE = "setEditable";
    public static final String METHOD_SET_CODESET_VALUES = "setCodeSetValues";
    static /* synthetic */ Class class$java$lang$Boolean;

    public UIAction(Document DOM, Type sourceType, Type xuiType, String targetXPath, String methodName, MethodParameter[] params, String className) {
        super(DOM, sourceType, xuiType, targetXPath, className);
        this._methodName = methodName;
        this._params = params;
    }

    protected Method getMethod(Object targetType) throws RuleInvocationException {
        Class<?> targetClass = null;
        RuleInvocationException riE = null;
        try {
            targetClass = targetType.getClass();
            this._method = targetClass.getMethod(this._methodName, this.getParameterTypes());
        }
        catch (Exception e) {
            riE = new RuleInvocationException(e, this, targetType);
        }
        if (this._method == null && riE != null) {
            throw riE;
        }
        return this._method;
    }

    public void check(Document dom, Type target) throws RuleInvocationException {
        List possibleTargets = this.getTargetTypes();
        for (int i = 0; i < possibleTargets.size(); ++i) {
            Type aPossibleTarget = (Type)possibleTargets.get(i);
            this.getMethod(aPossibleTarget);
        }
    }

    public String getMethodName() {
        return this._methodName;
    }

    private Class[] getParameterTypes() {
        if (this._parameterTypes == null) {
            this.initializeParameterTypes();
        }
        return this._parameterTypes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append(" on Type: ");
        sb.append(this.getSource().getXPathLocation());
        sb.append(" apply method: " + this._methodName);
        if (this.getParameterTypes() != null) {
            sb.append(" with : ");
            for (int i = 0; i < this.getParameterValues().length; ++i) {
                sb.append(" Type: ");
                sb.append(this.getParameterTypes()[i]);
                sb.append(" Value: ");
                sb.append(this.getParameterValues()[i]);
            }
        }
        return sb.toString();
    }

    public Object[] getParameterValues() {
        Object[] values = null;
        if (this._params != null) {
            values = new Object[this._params.length];
            for (int i = 0; i < this._params.length; ++i) {
                values[i] = this._params[i].getParameterValue();
            }
        }
        return values;
    }

    private void initializeParameterTypes() {
        if (this._params != null) {
            this._parameterTypes = new Class[this._params.length];
            for (int i = 0; i < this._params.length; ++i) {
                this._parameterTypes[i] = this._params[i].getParameterClass();
            }
        }
    }

    public boolean isInversable() {
        if (super.isInversable()) {
            return true;
        }
        Class[] types = this.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == (class$java$lang$Boolean == null ? UIAction.class$("java.lang.Boolean") : class$java$lang$Boolean) || types[i] == Boolean.TYPE) continue;
            return false;
        }
        return true;
    }

    protected void perform(Type eventSource, Object target, Stack callStack) throws RuleInvocationException {
        try {
            if (target != null && target instanceof Type) {
                Type performTarget = (Type)target;
                boolean visualizerNotInitialized = false;
                Vector<Object> targets = new Vector<Object>();
                if (TypeVisualizerFactory.getInstance() != null) {
                    Vector allVisualizers = TypeVisualizerFactory.getInstance().getAllVisualizers(performTarget);
                    if (allVisualizers.size() == 0) {
                        Visualizer newVis;
                        visualizerNotInitialized = true;
                        if (performTarget.getParent() != null && performTarget.getParent().getXUIDefinition().getStyle().isTabHolder() && TypeVisualizerFactory.getInstance().getAllVisualizers(performTarget.getParent()).size() > 0 && (newVis = TypeVisualizerFactory.getInstance().getVisualizer(performTarget)) != null) {
                            allVisualizers.add(newVis);
                        }
                    }
                    if (allVisualizers.size() > 0) {
                        Iterator visualizerIterator = allVisualizers.iterator();
                        while (visualizerIterator.hasNext()) {
                            targets.add(((Visualizer)visualizerIterator.next()).getImplementation());
                        }
                    } else {
                        targets.add(target);
                    }
                } else {
                    targets.add(target);
                }
                boolean typeDelegate = false;
                Iterator iter = targets.iterator();
                while (iter.hasNext()) {
                    Object iterationTarget = iter.next();
                    this.invoke(this.getDOM(), iterationTarget, this.getParameterValues());
                    typeDelegate = true;
                }
                if (visualizerNotInitialized && !typeDelegate) {
                    throw new RuleInvocationException(new Exception("visualizer for type: " + ((Type)target).getXPathLocation() + " has not been created yet. Invoke later."), this, target);
                }
            }
        }
        catch (RuleInvocationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuleInvocationException(e);
        }
    }

    protected void performDefaultInverse(Type eventSource, Object target) throws RuleInvocationException {
        if (target != null) {
            if (target instanceof Type && TypeVisualizerFactory.getInstance() != null) {
                Vector visualizers = TypeVisualizerFactory.getInstance().getAllVisualizers((Type)target);
                Iterator iter = visualizers.iterator();
                while (iter.hasNext()) {
                    Visualizer visualizer = (Visualizer)iter.next();
                    this.performDefaultInverse(eventSource, visualizer.getImplementation());
                }
            }
            Object[] origParamValues = this.getParameterValues();
            Object[] paramValues = new Object[origParamValues.length];
            for (int i = 0; i < origParamValues.length; ++i) {
                paramValues[i] = new Boolean((Boolean)origParamValues[i] == false);
            }
            try {
                this.invoke(this.getDOM(), target, paramValues);
            }
            catch (Exception e) {
                throw new RuleInvocationException(e);
            }
        }
    }

    public void invoke(Document dom, Object target, Object[] values) throws RuleInvocationException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = this.getMethod(target);
        if (method != null) {
            method.invoke(target, values);
            dom.fireActionPerformed(new ActionPerformEvent(target, method, values));
        }
    }

    protected void performInverse(Type eventSource, Type targetType, Stack callStack) throws RuleInvocationException {
        if (this.isInversable()) {
            if (this.getInverseAction() == null || this.getInverseAction().isEmpty()) {
                this.performDefaultInverse(eventSource, targetType);
            } else {
                this.getInverseAction().perform(eventSource, targetType, callStack);
            }
        }
    }

    public void release() {
        this._method = null;
        this._parameterTypes = null;
        this._params = null;
        super.release();
    }

    protected void perform(Type eventSource, Object target) throws RuleInvocationException {
        this.perform(eventSource, target, null);
    }

    public int getActionType() {
        return 3;
    }
}

