/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.schema.impl;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.schema.SchemaCreationException;
import com.jaxfront.core.schema.XMLSchema;
import com.jaxfront.core.schema.XMLSchemaBuilder;
import com.jaxfront.core.schema.impl.XMLSchemaImpl;
import com.jaxfront.core.util.IntroSpectionHelper;
import com.jaxfront.core.util.JAXFrontURLEntityResolver;
import com.jaxfront.core.util.JAXFrontXMLCatalogResolver;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.util.io.cache.XMLSchemaCache;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaNamespaceSupport;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.impl.xs.XSImplementationImpl;
import org.apache.xerces.impl.xs.XSLoaderImpl;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSNamespaceItemList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.LSInput;

public class XMLSchemaBuilderImpl
implements XMLSchemaBuilder {
    private Hashtable _namespaceMapping;
    public static String version;
    public static String versionNumber;
    private static XMLSchemaBuilderImpl _singleton;

    public XMLSchema build(String context, LSInput input, XMLEntityResolver entityResolver, String rootName, boolean keepInMemory) throws SchemaCreationException {
        try {
            XMLSchema cachedSchema = XMLSchemaCache.getInstance().getCached(input.getSystemId());
            if (cachedSchema != null) {
                if (rootName != null) {
                    cachedSchema.setRootName(rootName);
                }
                return cachedSchema;
            }
            XSImplementationImpl impl = null;
            try {
                System.setProperty("org.w3c.dom.DOMImplementationSourceList", "org.apache.xerces.dom.DOMXSImplementationSourceImpl");
                DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
                impl = (XSImplementation)registry.getDOMImplementation("XS-Loader");
            }
            catch (Throwable t) {
                impl = new XSImplementationImpl();
            }
            XSLoader schemaLoader = impl.createXSLoader(null);
            if (entityResolver != null) {
                if (!(schemaLoader instanceof XMLSchemaLoader)) {
                    if (schemaLoader instanceof XSLoaderImpl) {
                        Object nestedLoader = IntroSpectionHelper.getPrivateFieldValue("fSchemaLoader", schemaLoader);
                        ((XMLSchemaLoader)nestedLoader).setEntityResolver(entityResolver);
                    } else if (LogRegistry.getInstance().logWarnings()) {
                        LogRegistry.getInstance().warn(this.getClass(), "can't set EntityResolver");
                    }
                } else {
                    ((XMLSchemaLoader)schemaLoader).setEntityResolver(entityResolver);
                }
            }
            try {
                schemaLoader.getConfig().setParameter("validate", Boolean.TRUE);
            }
            catch (Throwable t) {
                // empty catch block
            }
            XSModel model = schemaLoader.load(input);
            if (model == null) {
                throw new SchemaCreationException("Unable to create xsd (" + input.getSystemId() + ").");
            }
            Hashtable docNameSpaces = this.initializeNamespaces(model, schemaLoader);
            Hashtable allSchemaBasedAttribs = null;
            cachedSchema = new XMLSchemaImpl(model, input, rootName, docNameSpaces, allSchemaBasedAttribs);
            cachedSchema.setKeepInMemory(keepInMemory);
            return XMLSchemaCache.getInstance().cache(context, input.getSystemId(), cachedSchema);
        }
        catch (Exception ex) {
            throw new SchemaCreationException(ex);
        }
    }

    public XMLSchema build(String context, URL xsdURL, String rootName, Hashtable args) throws SchemaCreationException {
        try {
            XSModel model;
            XMLSchema cachedSchema = XMLSchemaCache.getInstance().getCached(xsdURL);
            if (cachedSchema != null) {
                if (rootName != null) {
                    cachedSchema.setRootName(rootName);
                }
                return cachedSchema;
            }
            XSImplementationImpl impl = null;
            try {
                System.setProperty("org.w3c.dom.DOMImplementationSourceList", "org.apache.xerces.dom.DOMXSImplementationSourceImpl");
                DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
                impl = (XSImplementation)registry.getDOMImplementation("XS-Loader");
            }
            catch (Throwable t) {
                impl = new XSImplementationImpl();
            }
            XSLoader schemaLoader = impl.createXSLoader(null);
            if (args != null) {
                XMLEntityResolver entityResolver;
                if (!xsdURL.getProtocol().equalsIgnoreCase("file") && xsdURL.toExternalForm().indexOf("/eforms") != -1) {
                    JAXFrontXMLCatalogResolver resolver = new JAXFrontXMLCatalogResolver((XMLEntityResolver)new JAXFrontURLEntityResolver(xsdURL));
                    args.put("XMLEntityResolver", resolver);
                }
                if ((entityResolver = (XMLEntityResolver)args.get("XMLEntityResolver")) != null) {
                    if (schemaLoader instanceof XSLoaderImpl) {
                        XMLSchemaLoader schemaLoader2 = (XMLSchemaLoader)IntroSpectionHelper.getPrivateFieldValue("fSchemaLoader", schemaLoader);
                        schemaLoader2.setEntityResolver(entityResolver);
                        IntroSpectionHelper.callFunktion((Object)schemaLoader2, "setEntityResolver", entityResolver);
                    } else {
                        IntroSpectionHelper.callFunktion((Object)schemaLoader, "setEntityResolver", entityResolver);
                    }
                }
            }
            try {
                schemaLoader.getConfig().setParameter("validate", Boolean.TRUE);
            }
            catch (Throwable t) {
                // empty catch block
            }
            String uri = xsdURL.toExternalForm();
            if (uri.indexOf("file://") != -1) {
                uri = TextTools.replace(uri, "file://", "file:/");
            }
            if ((model = schemaLoader.loadURI(uri)) == null) {
                throw new SchemaCreationException("Unable to create xsd (" + uri + ").");
            }
            Hashtable docNameSpaces = this.initializeNamespaces(model, schemaLoader);
            cachedSchema = new XMLSchemaImpl(model, xsdURL, rootName, docNameSpaces, DOMHelper.getAllSchemaBaseAttributes(xsdURL));
            return XMLSchemaCache.getInstance().cache(context, xsdURL, cachedSchema);
        }
        catch (Exception ex) {
            throw new SchemaCreationException(ex);
        }
    }

    public XMLSchema build(String xsdString, String rootName) throws SchemaCreationException {
        try {
            XSImplementationImpl impl = null;
            try {
                System.setProperty("org.w3c.dom.DOMImplementationSourceList", "org.apache.xerces.dom.DOMXSImplementationSourceImpl");
                DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
                impl = (XSImplementation)registry.getDOMImplementation("XS-Loader");
            }
            catch (Throwable t) {
                impl = new XSImplementationImpl();
            }
            XSLoader schemaLoader = impl.createXSLoader(null);
            try {
                schemaLoader.getConfig().setParameter("validate", Boolean.TRUE);
            }
            catch (Throwable t) {
                // empty catch block
            }
            StringReader reader = new StringReader(xsdString);
            DOMInputImpl input = new DOMInputImpl(null, null, null, (Reader)reader, null);
            XSModel model = schemaLoader.load((LSInput)input);
            if (model == null) {
                throw new SchemaCreationException(IntroSpectionHelper.getClassName(schemaLoader.getClass()) + " can't build XSModel!");
            }
            Hashtable nameSpaces = this.initializeNamespaces(model, schemaLoader);
            XMLSchemaImpl schema = new XMLSchemaImpl(model, (URL)null, rootName, nameSpaces, DOMHelper.getAllSchemaBaseAttributes(xsdString));
            return schema;
        }
        catch (Exception ex) {
            LogRegistry.getInstance().error(this.getClass(), ex);
            throw new SchemaCreationException(ex);
        }
    }

    private Hashtable getNamespaceMapping() {
        return this._namespaceMapping;
    }

    private void addNsSupportToMapping(SchemaNamespaceSupport sns, Hashtable nameSpaces) {
        if (nameSpaces != null && sns != null) {
            Enumeration enumeration = sns.getAllPrefixes();
            while (enumeration.hasMoreElements()) {
                String prefix = (String)enumeration.nextElement();
                String uri = sns.getURI(prefix);
                if (uri == null) continue;
                if (prefix != null && prefix.length() > 0) {
                    if (LogRegistry.getInstance().logInfos()) {
                        LogRegistry.getInstance().info(this.getClass(), "add mapping:" + uri + " prefix:" + prefix);
                    }
                    nameSpaces.put(uri, prefix);
                    continue;
                }
                if (!LogRegistry.getInstance().logWarnings()) continue;
                LogRegistry.getInstance().warn(this.getClass(), "don't add nsuri " + uri + " with empty prefix:" + prefix);
            }
        }
    }

    private void initializeSchemaGrammar(SchemaGrammar schemaGrammar, XSLoader schemaLoader, Hashtable analysedGrammars) {
        block5: {
            block6: {
                if (schemaGrammar == null) break block5;
                Vector importedGrammars = schemaGrammar.getImportedGrammars();
                if (importedGrammars == null) break block6;
                Iterator iterator = importedGrammars.iterator();
                if (schemaGrammar.getSchemaNamespace() != null) {
                    analysedGrammars.put(schemaGrammar.getSchemaNamespace(), "");
                }
                while (iterator.hasNext()) {
                    SchemaGrammar nextSchemaGrammar = (SchemaGrammar)iterator.next();
                    if (nextSchemaGrammar.getSchemaNamespace() == null || analysedGrammars.containsKey(nextSchemaGrammar.getSchemaNamespace())) continue;
                    this.initializeSchemaGrammar(nextSchemaGrammar, schemaLoader, analysedGrammars);
                }
                if (schemaGrammar.getDocumentLocations() == null) break block5;
                for (int b = 0; b < schemaGrammar.getDocumentLocations().getLength(); ++b) {
                    String documentLocation = schemaGrammar.getDocumentLocations().item(b);
                    if (documentLocation == null) continue;
                    schemaLoader.loadURI(documentLocation);
                    SchemaNamespaceSupport sns = this.getFNamespaceSupport(this.getFRoot(this.getFSchemaHandler(schemaLoader)));
                    this.addNsSupportToMapping(sns, this.getNamespaceMapping());
                }
                break block5;
            }
            if (schemaGrammar.getDocumentLocations() != null) {
                for (int b = 0; b < schemaGrammar.getDocumentLocations().getLength(); ++b) {
                    String documentLocation = schemaGrammar.getDocumentLocations().item(b);
                    if (documentLocation == null) continue;
                    schemaLoader.loadURI(documentLocation);
                    SchemaNamespaceSupport sns = this.getFNamespaceSupport(this.getFRoot(this.getFSchemaHandler(schemaLoader)));
                    this.addNsSupportToMapping(sns, this.getNamespaceMapping());
                }
            }
        }
    }

    private XSDHandler getFSchemaHandler(Object schemaLoader) {
        try {
            if (versionNumber.startsWith("2.6")) {
                return (XSDHandler)IntroSpectionHelper.getPrivateFieldValue("fSchemaHandler", schemaLoader);
            }
            if (versionNumber.startsWith("2.8")) {
                Object fSchemaLoader = IntroSpectionHelper.getPrivateFieldValue("fSchemaLoader", schemaLoader);
                return (XSDHandler)IntroSpectionHelper.getPrivateFieldValue("fSchemaHandler", fSchemaLoader);
            }
            Object fSchemaLoader = IntroSpectionHelper.getPrivateFieldValue("fSchemaLoader", schemaLoader);
            return (XSDHandler)IntroSpectionHelper.getPrivateFieldValue("fSchemaHandler", fSchemaLoader);
        }
        catch (Exception e) {
            LogRegistry.getInstance().error(schemaLoader.getClass(), "Wrong Xerces Version! JAXFront is unable to resolve the fSchemaHandler from schemaLoader. You use Xerces:" + version);
            return null;
        }
    }

    private Object getFRoot(Object xsdHandler) {
        try {
            return IntroSpectionHelper.getPrivateFieldValue("fRoot", xsdHandler);
        }
        catch (Exception e) {
            LogRegistry.getInstance().error(xsdHandler.getClass(), "Wrong Xerces Version! JAXFront is unable to resolve the fRoot field from xsdHandler.");
            return null;
        }
    }

    private SchemaNamespaceSupport getFNamespaceSupport(Object xSDocumentInfo) {
        try {
            return (SchemaNamespaceSupport)IntroSpectionHelper.getPrivateFieldValue("fNamespaceSupport", xSDocumentInfo);
        }
        catch (Exception e) {
            LogRegistry.getInstance().error(xSDocumentInfo.getClass(), "Wrong Xerces Version! JAXFront is unable to resolve the fNamespaceSupport from DocumentInfo.");
            return null;
        }
    }

    private Hashtable initializeNamespaces(XSModel model, XSLoader schemaLoader) {
        Hashtable nameSpaces = null;
        XSNamespaceItemList nsList = null;
        if (model != null) {
            nsList = model.getNamespaceItems();
        }
        if (nsList != null && nsList.getLength() > 0) {
            nameSpaces = new Hashtable();
            try {
                Hashtable depMap = (Hashtable)IntroSpectionHelper.getPrivateFieldValue("fDependencyMap", this.getFSchemaHandler(schemaLoader));
                Enumeration denum = depMap.keys();
                while (denum.hasMoreElements()) {
                    Object element = denum.nextElement();
                    SchemaNamespaceSupport sns = this.getFNamespaceSupport(element);
                    this.addNsSupportToMapping(sns, nameSpaces);
                }
            }
            catch (Exception e) {
                LogRegistry.getInstance().error(this.getClass(), e.getLocalizedMessage());
            }
        }
        return nameSpaces;
    }

    public static XMLSchemaBuilderImpl getInstance() {
        if (_singleton == null) {
            _singleton = new XMLSchemaBuilderImpl();
            XMLSchemaBuilderImpl.getXercesVersion();
            if (LogRegistry.getInstance().logInfos()) {
                LogRegistry.getInstance().info(XMLSchemaBuilderImpl.class, XMLSchemaBuilderImpl.getXercesVersion());
            }
        }
        return _singleton;
    }

    public static String getXercesVersion() {
        versionNumber = "1.0";
        try {
            Class<?> versionClass = Class.forName("org.apache.xerces.impl.Version");
            version = (String)IntroSpectionHelper.callStaticFunktion(versionClass, "getVersion", (Class[])null, (Object[])null);
            versionNumber = version.substring("Xerces-J".length(), version.lastIndexOf(".")).trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }
}

