/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.type;

import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.StringUtil;
import java.util.Comparator;

public class TypeElementComparator
implements Comparator {
    public static final int ASC = 0;
    public static final int DES = 1;
    private int _direction = 0;
    private String _childToCompare;
    private boolean _useParent = false;

    public TypeElementComparator(int direction, String childToCompare) {
        this._direction = direction;
        if (childToCompare.startsWith("../")) {
            this._useParent = true;
            childToCompare = childToCompare.substring(3);
        }
        this._childToCompare = childToCompare;
    }

    public int compare(Object o1, Object o2) {
        return this.compareTuples((Type)o1, (Type)o2);
    }

    protected int compareTuples(Type source, Type dest) {
        if (this._useParent) {
            source = source.getParent();
            dest = dest.getParent();
        }
        String srcVal = source.getDirectChildValue(this._childToCompare);
        String destVal = dest.getDirectChildValue(this._childToCompare);
        int comp = 0;
        if (srcVal == destVal) {
            return 0;
        }
        comp = srcVal == null ? -1 : (destVal == null ? 1 : StringUtil.compareNatural(srcVal, destVal));
        if (0 == this._direction) {
            return comp;
        }
        return -1 * comp;
    }
}

