/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.type;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.schema.SchemaNode;
import com.jaxfront.core.schema.XMLSchema;
import com.jaxfront.core.type.AbstractCompositeType;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.TextTools;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TypeMatcher {
    public static void main(String[] args) {
        String[] dest = new String[5];
        String sp = "(mike){1}(otto){0,1}(juergen){0,1}(leber){1}";
        dest[0] = "mikeleber";
        dest[2] = "mikeottoleber";
        dest[3] = "mikejuergenleber";
        dest[4] = "leber";
        dest[1] = "mike";
        System.out.println("found:" + TypeMatcher.bestMatch(sp, dest));
    }

    public static boolean match(Type a, Type b) {
        StringBuffer sb = new StringBuffer();
        TypeMatcher.extractStringPattern(a, sb);
        String destPattern = TypeMatcher.extractString(b);
        return TypeMatcher.match(sb.toString(), destPattern);
    }

    public static Type bestMatchBaseType(Type template, Element element) {
        List baseTypes = template.getDirectChildren();
        int index = TypeMatcher.bestMatch(template, baseTypes, element);
        if (index >= 0 && index < baseTypes.size()) {
            return (Type)baseTypes.get(index);
        }
        return null;
    }

    public static int bestMatch(Type template, List baseTypes, Element element) {
        String[] patterns = new String[baseTypes.size()];
        for (int i = 0; i < patterns.length; ++i) {
            StringBuffer sb = new StringBuffer();
            TypeMatcher.extractStringPattern((Type)baseTypes.get(i), sb);
            patterns[i] = sb.toString();
        }
        String destPattern = TypeMatcher.extractString(template, element);
        return TypeMatcher.bestMatch(patterns, destPattern);
    }

    public static boolean match(String sourcePattern, String destPattern) {
        Pattern p = Pattern.compile(sourcePattern);
        Matcher m = p.matcher(destPattern);
        return m.matches();
    }

    public static int bestMatch(String[] sourcePatterns, String destPattern) {
        int highestGroup = -1;
        int bestIndex = -1;
        for (int i = sourcePatterns.length - 1; i >= 0; --i) {
            String aDesPattern;
            Pattern p = Pattern.compile(sourcePatterns[i]);
            Matcher m = p.matcher(aDesPattern = destPattern);
            boolean match = m.matches();
            if (!match) continue;
            int rating = 0;
            int gc = m.groupCount();
            for (int g = 0; g < gc; ++g) {
                if (m.group(g) == null) continue;
                ++rating;
            }
            if (rating <= highestGroup) continue;
            bestIndex = i;
            highestGroup = rating;
        }
        return bestIndex;
    }

    public static Object bestMatch(String sourcePattern, String[] destPatterns) {
        int highestGroup = -1;
        String result = null;
        Pattern p = Pattern.compile(sourcePattern);
        for (int i = destPatterns.length - 1; i >= 0; --i) {
            String aDesPattern = destPatterns[i];
            Matcher m = p.matcher(aDesPattern);
            boolean match = m.matches();
            if (!match) continue;
            int rating = 0;
            int gc = m.groupCount();
            for (int g = 0; g < gc; ++g) {
                if (m.group(g) == null) continue;
                ++rating;
            }
            if (rating <= highestGroup) continue;
            result = aDesPattern;
            highestGroup = rating;
        }
        return result;
    }

    public static void extractStringPattern(Type t, StringBuffer pattern) {
        if (t.isAnonymous()) {
            List childs = t.getDirectChildren();
            for (int c = 0; c < childs.size(); ++c) {
                Type child = (Type)childs.get(c);
                if (child.isAnonymous()) {
                    TypeMatcher.extractStringPattern(child, pattern);
                    continue;
                }
                SchemaNode chScNode = child.getSchemaElement();
                int chMax = chScNode.getMaxOccurs();
                int chMin = chScNode.getMinOccurs();
                pattern.append("(");
                pattern.append(child.getName());
                pattern.append(")");
                if (child.isList()) {
                    String maxOccurs = String.valueOf(chMax);
                    String minOccurs = String.valueOf(chMin);
                    if (maxOccurs.equals("-1")) {
                        maxOccurs = "";
                    }
                    if (minOccurs.equals("-1")) {
                        minOccurs = "";
                    }
                    pattern.append("{" + minOccurs + "," + maxOccurs + "}");
                    continue;
                }
                if (child.isChoice()) {
                    pattern.append("{0,1}");
                    continue;
                }
                if (chMin > 0) {
                    pattern.append("{1}");
                    continue;
                }
                pattern.append("{0,1}");
            }
        } else {
            pattern.append(t.getName());
        }
    }

    public static String extractString(Type template, Element element) {
        StringBuffer pattern = new StringBuffer();
        NodeList nl = element.getChildNodes();
        int nlSize = nl.getLength();
        Object found = null;
        for (int ne = 0; found == null && ne < nlSize; ++ne) {
            int dopPos;
            Node nextElement = nl.item(ne);
            if (nextElement.getNodeType() != 1) continue;
            String elementName = nextElement.getNodeName();
            if (elementName != null && (dopPos = elementName.indexOf(":")) >= 0) {
                elementName = elementName.substring(dopPos + 1);
            }
            if (template.isChoice() && template.isAnonymous()) {
                if (template.getParent().getDirectChild(elementName) != null) continue;
                pattern.append(elementName);
                continue;
            }
            pattern.append(elementName);
        }
        return pattern.toString();
    }

    public static String extractString(Type t) {
        List childs = t.getDirectChildren();
        StringBuffer pattern = new StringBuffer();
        for (int c = 0; c < childs.size(); ++c) {
            Type child = (Type)childs.get(c);
            pattern.append(child.getName());
        }
        return pattern.toString();
    }

    public static Element getInstancFromPossibles(XMLSchema schema, CompositeType composite, Element instanceElement) {
        String[] possibleNames = TypeMatcher.buildPossibleGroupNames(composite);
        Element choosenElement = null;
        for (int p = 0; p < possibleNames.length; ++p) {
            String possibleName = possibleNames[p];
            if (possibleName.indexOf("|") != -1) {
                String[] names = TextTools.tokenize(possibleName, "|");
                choosenElement = DOMHelper.getChild(schema, instanceElement, names);
            } else {
                choosenElement = DOMHelper.getChild(schema, instanceElement, possibleName);
            }
            if (choosenElement != null) break;
        }
        return choosenElement;
    }

    public static String[] buildPossibleGroupNames(CompositeType composite) {
        String[] relevantChoiceNames = composite.getRelevantChoiceNames();
        String[] groupNames = new String[relevantChoiceNames.length];
        if (relevantChoiceNames != null) {
            for (int i = 0; i < relevantChoiceNames.length; ++i) {
                if (relevantChoiceNames[i].startsWith("UNNAMED")) {
                    Type choiceOption = composite.getDirectChild(relevantChoiceNames[i]);
                    if (choiceOption == null) {
                        choiceOption = ((AbstractCompositeType)composite).createChoiceType(relevantChoiceNames[i]);
                    }
                    if (choiceOption == null) continue;
                    groupNames[i] = "";
                    for (int j = 0; j < choiceOption.getDirectChildren().size(); ++j) {
                        int n = i;
                        groupNames[n] = groupNames[n] + ((Type)choiceOption.getDirectChildren().get(j)).getName();
                        if (j >= choiceOption.getDirectChildren().size() - 1) continue;
                        int n2 = i;
                        groupNames[n2] = groupNames[n2] + "|";
                    }
                    continue;
                }
                groupNames[i] = relevantChoiceNames[i];
            }
        }
        return groupNames;
    }
}

