/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.ui;

import com.jaxfront.core.type.AbstractCompositeType;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.GUIComponentNLS;

public class ChoiceName {
    private String _typeName;
    private String _visualName;
    private String _toolTip;
    public static final String NAME_NONE = "None_";

    public ChoiceName(String typeName, String visualName) {
        this._typeName = typeName;
        this._visualName = visualName;
    }

    public ChoiceName(String typeName, String visualName, String tooltip) {
        this._typeName = typeName;
        this._visualName = visualName;
        this._toolTip = tooltip;
    }

    public String getTypeName() {
        return this._typeName;
    }

    public String getVisualName() {
        return this._visualName;
    }

    public String getTooltip() {
        return this._toolTip;
    }

    public static ChoiceName[] get(Type holder, String[] typeNames) {
        return ChoiceName.get(holder, typeNames, null);
    }

    public static ChoiceName[] getEnums(Type holder, String[] typeNames, String[] nlsNames) {
        boolean hasEmptyEntry = false;
        if (holder.getStyle().allowEmptyChoice() && holder.isSimple() && !holder.isRequired()) {
            hasEmptyEntry = true;
        }
        ChoiceName noneChoice = null;
        if (hasEmptyEntry) {
            String noneTxt = GUIComponentNLS.getInstance().getNLSText(holder.getDOM(), "button_none", "None");
            String noneName = holder.getStyle().isChoiceAsRadioButton() ? NAME_NONE : "";
            noneChoice = new ChoiceName(noneName, noneTxt);
        }
        int off = 0;
        ChoiceName[] choices = null;
        if (noneChoice != null) {
            off = 1;
            choices = new ChoiceName[typeNames.length + 1];
            choices[0] = noneChoice;
        } else {
            choices = new ChoiceName[typeNames.length];
        }
        for (int i = 0; i < typeNames.length; ++i) {
            choices[i + off] = new ChoiceName(typeNames[i], typeNames[i], typeNames[i]);
        }
        return choices;
    }

    public static ChoiceName[] get(Type holder, String[] typeNames, String[] nlsNames) {
        ChoiceName[] choices = new ChoiceName[typeNames.length];
        String nlsName = null;
        Type subType = null;
        if (holder.isComposite() && holder.isChoice()) {
            ((AbstractCompositeType)holder).createChoices();
        }
        for (int i = 0; i < typeNames.length; ++i) {
            String nlsSubTypeToolTip = null;
            if (nlsNames == null && holder.isComposite()) {
                subType = holder.getDirectChild(typeNames[i]);
                nlsName = typeNames[i];
                if (subType != null) {
                    nlsName = subType.getStyle().getLabelChoiceText();
                    nlsSubTypeToolTip = subType.getStyle().getCaptionTitleToolTip();
                } else {
                    subType = ((CompositeType)holder).getParentEditingTypeForName(nlsName);
                    if (subType != null) {
                        nlsName = subType.getStyle().getLabelChoiceText();
                    }
                }
            } else {
                nlsName = nlsNames != null ? nlsNames[i] : (holder.isSimple() ? holder.getStyle().getLabelText() : holder.getName());
            }
            choices[i] = new ChoiceName(typeNames[i], nlsName, nlsSubTypeToolTip);
        }
        boolean hasEmptyEntry = false;
        if (holder.getStyle().allowEmptyChoice()) {
            if (holder.isComposite() && ((CompositeType)holder).getEmptyType() != null && !holder.getStyle().isSingleChoiceAndSerialize()) {
                hasEmptyEntry = true;
            } else if (holder.isSimple() && !holder.isRequired()) {
                hasEmptyEntry = true;
            }
        }
        if (hasEmptyEntry) {
            ChoiceName[] choicesWithNone = new ChoiceName[typeNames.length + 1];
            String noneTxt = GUIComponentNLS.getInstance().getNLSText(holder.getDOM(), "button_none", "None");
            String noneName = holder.getStyle().isChoiceAsRadioButton() ? NAME_NONE : "";
            choicesWithNone[0] = new ChoiceName(noneName, noneTxt);
            for (int i = 1; i < choices.length + 1; ++i) {
                choicesWithNone[i] = choices[i - 1];
            }
            choices = choicesWithNone;
        }
        return choices;
    }

    public static ChoiceName[] get(CompositeType choiceType) {
        return ChoiceName.get(choiceType, choiceType.getRelevantChoiceNames());
    }

    public static ChoiceName[] get(Type enumType) {
        return ChoiceName.getEnums(enumType, enumType.getStyle().getEnumeration(), null);
    }

    public static ChoiceName[] getAbstract(Type abstractType) {
        String[] derivateNames = new String[abstractType.getDerivedTypes().size()];
        String[] nlsNames = new String[derivateNames.length];
        Type derivate = null;
        for (int i = 0; i < derivateNames.length; ++i) {
            derivate = (Type)abstractType.getDerivedTypes().get(i);
            derivateNames[i] = derivate.getName();
            nlsNames[i] = derivate.getStyle().getCaptionTitleLabel();
            if (nlsNames[i] != null) continue;
            nlsNames[i] = derivate.getName();
        }
        return ChoiceName.get(abstractType, derivateNames, nlsNames);
    }

    public String toString() {
        if (this.getVisualName() != null) {
            return this.getVisualName();
        }
        return " ";
    }
}

