/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.ui;

import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.util.io.cache.FontCache;
import com.jaxfront.core.xui.TableCell;
import java.awt.Color;
import java.awt.Font;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class FontParams {
    private static final String CONST_FONT_PARAM_SEPARATOR = ",";
    private static final String CONST_FONT_COLOR_SEPARATOR = ".";
    private String _fontName;
    private int _fontStyle = -1;
    private int _fontSize = -1;
    private Color _fontColor = null;
    private Color _defaultFontColor = Color.black;
    private int _defaultFontStyle = 0;
    private int _defaultFontSize = ((FontUIResource)UIManager.getDefaults().get("Label.font")).getSize();
    private static Hashtable _defaultFontParamsCache;
    public static final String TEXTFIELD_FONT_PROPERTY = "TextField.font";
    public static final String LABEL_FONT_PROPERTY = "Label.font";
    public static final String TREE_FONT_PROPERTY = "Tree.font";
    public static final String CHECKBOX_FONT_PROPERTY = "CheckBox.font";
    public static final String VIEWPORT_FONT_PROPERTY = "Viewport.font";
    public static final String PROGRESSBAR_FONT_PROPERTY = "ProgressBar.font";
    public static final String RADIOBUTTONMENUITEM_FONT_PROPERTY = "RadioButtonMenuItem.font";
    public static final String FORMATTTEDTEXTFIELD_FONT_PROPERTY = "FormattedTextField.font";
    public static final String TOOLBAR_FONT_PROPERTY = "ToolBar.font";
    public static final String COLORCHOOSER_FONT_PROPERTY = "ColorChooser.font";
    public static final String TOGGLEBUTTON_FONT_PROPERTY = "ToggleButton.font";
    public static final String MENUITEM_ACCEL_FONT_PROPERTY = "MenuItem.acceleratorFont";
    public static final String PANEL_FONT_PROPERTY = "Panel.font";
    public static final String TEXTAREA_FONT_PROPERTY = "TextArea.font";
    public static final String MENU_FONT_PROPERTY = "Menu.font";
    public static final String SPINNER_FONT_PROPERTY = "Spinner.font";
    public static final String MENU_ACCEL_FONT_PROPERTY = "Menu.acceleratorFont";
    public static final String CHECKBOXMENUITEM_ACCEL_FONT_PROPERTY = "CheckBoxMenuItem.acceleratorFont";
    public static final String TABLEHEADER_FONT_PROPERTY = "TableHeader.font";
    public static final String OPTIONPANE_FONT_PROPERTY = "OptionPane.font";
    public static final String MENUBAR_FONT_PROPERTY = "MenuBar.font";
    public static final String BUTTON_FONT_PROPERTY = "Button.font";
    public static final String PASSWORDFIELD_FONT_PROPERTY = "PasswordField.font";
    public static final String INTERNALFRAME_FONT_PROPERTY = "InternalFrame.titleFont";
    public static final String SCROLLPANE_FONT_PROPERTY = "ScrollPane.font";
    public static final String MENUITEM_FONT_PROPERTY = "MenuItem.font";
    public static final String TOOLTIP_FONT_PROPERTY = "ToolTip.font";
    public static final String LIST_FONT_PROPERTY = "List.font";
    public static final String OPTIONPANE_MESSAGE_FONT_PROPERTY = "OptionPane.messageFont";
    public static final String EDITORPANE_FONT_PROPERTY = "EditorPane.font";
    public static final String TABLE_FONT_PROPERTY = "Table.font";
    public static final String TABBEDPANE_FONT_PROPERTY = "TabbedPane.font";
    public static final String RADIOBUTTON_FONT_PROPERTY = "RadioButton.font";
    public static final String CHECKBOXMENUITEM_FONT_PROPERTY = "CheckBoxMenuItem.font";
    public static final String TEXTPANE_FONT_PROPERTY = "TextPane.font";
    public static final String POPUPMENU_FONT_PROPERTY = "PopupMenu.font";
    public static final String TITLEBORDER_FONT_PROPERTY = "TitledBorder.font";
    public static final String COMBOBOX_FONT_PROPERTY = "ComboBox.font";

    public FontParams(String fontName, int fontStyle, int fontSize) {
        this.setFontName(fontName);
        this.setFontStyle(fontStyle);
        this.setFontSize(fontSize);
    }

    public FontParams(String fontName, int fontStyle, int fontSize, Color color) {
        this.setFontName(fontName);
        this.setFontStyle(fontStyle);
        this.setFontSize(fontSize);
        this.setFontColor(color);
    }

    public FontParams(String fontDefinition) {
        this.initFromDefiniton(fontDefinition);
    }

    public FontParams copy() {
        return new FontParams(this.getFontName(), this.getFontStyle(), this.getFontSize(), this.getFontColor());
    }

    public void initFromDefiniton(String fontDefinition) {
        StringTokenizer fontDefTokenizer = new StringTokenizer(fontDefinition, CONST_FONT_PARAM_SEPARATOR);
        switch (fontDefTokenizer.countTokens()) {
            case 1: {
                this.setFontName(fontDefTokenizer.nextToken());
                this.setFontStyle(this._defaultFontStyle);
                this.setFontSize(this._defaultFontSize);
                this.setFontColor(this._defaultFontColor);
                break;
            }
            case 2: {
                this.setFontName(fontDefTokenizer.nextToken());
                String maybeStyleOrSize = fontDefTokenizer.nextToken();
                try {
                    this.setFontSize(Integer.parseInt(maybeStyleOrSize));
                    this.setFontStyle(this._defaultFontStyle);
                }
                catch (NumberFormatException e) {
                    this.setFontStyle(FontParams.getFontStyleAsInt(maybeStyleOrSize));
                    this.setFontSize(this._defaultFontSize);
                }
                break;
            }
            case 3: {
                this.setFontName(fontDefTokenizer.nextToken());
                this.setFontStyle(FontParams.getFontStyleAsInt(fontDefTokenizer.nextToken()));
                this.setFontSize(Integer.parseInt(fontDefTokenizer.nextToken()));
                break;
            }
            case 4: {
                this.setFontName(fontDefTokenizer.nextToken());
                this.setFontStyle(FontParams.getFontStyleAsInt(fontDefTokenizer.nextToken()));
                this.setFontSize(Integer.parseInt(fontDefTokenizer.nextToken()));
                this.setFontColor(fontDefTokenizer.nextToken());
                break;
            }
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Name:");
        result.append(this.getFontName());
        result.append(" Style:");
        result.append(this.getFontStyle());
        result.append(" Size:");
        result.append(this.getFontSize());
        result.append(" Color:");
        result.append(this.getFontColor());
        return result.toString();
    }

    public Font createFont() {
        return this.createFont(TEXTFIELD_FONT_PROPERTY);
    }

    public static FontParams getDefaultParams(String uiProperty) {
        FontParams result = null;
        result = (FontParams)FontParams.getDefaultFontParamsCache().get(uiProperty);
        if (result == null) {
            result = new FontParams(FontParams.getUIManagerFontName(uiProperty), FontParams.getUIManagerFontStyle(uiProperty), FontParams.getUIManagerFontSize(uiProperty));
            FontParams.getDefaultFontParamsCache().put(uiProperty, result);
        }
        return result.copy();
    }

    public static int getUIManagerFontStyle(String uiProperty) {
        return ((FontUIResource)UIManager.getDefaults().get(uiProperty)).getStyle();
    }

    public static int getUIManagerFontSize(String uiProperty) {
        return ((FontUIResource)UIManager.getDefaults().get(uiProperty)).getSize();
    }

    public static String getUIManagerFontName(String uiProperty) {
        return ((FontUIResource)UIManager.getDefaults().get(uiProperty)).getFamily();
    }

    public Font createFont(String componentType) {
        String fontKey = this.getFontName() + this.getFontStyle() + this.getFontSize();
        Font cachedFont = FontCache.getInstance().getCached(fontKey);
        if (cachedFont == null) {
            if (this.getFontStyle() < 0) {
                this.setFontStyle(((FontUIResource)UIManager.getDefaults().get(componentType)).getStyle());
            }
            if (this.getFontSize() < 0) {
                this.setFontStyle(((FontUIResource)UIManager.getDefaults().get(componentType)).getSize());
            }
            cachedFont = new Font(this.getFontName(), this.getFontStyle(), this.getFontSize());
            FontCache.getInstance().cache(fontKey, cachedFont);
        }
        return cachedFont;
    }

    public static int getFontStyleAsInt(String labelFontStyle) {
        if (labelFontStyle == null) {
            return -1;
        }
        if (labelFontStyle.equalsIgnoreCase("bold")) {
            return 1;
        }
        if (labelFontStyle.equalsIgnoreCase("italic")) {
            return 2;
        }
        if (labelFontStyle.equalsIgnoreCase("normal")) {
            return 0;
        }
        if (labelFontStyle.equalsIgnoreCase("underline")) {
            return 1;
        }
        if (labelFontStyle.equalsIgnoreCase("bolditalic")) {
            return 3;
        }
        if (labelFontStyle.equalsIgnoreCase("ROMAN_BASELINE")) {
            return 0;
        }
        return -1;
    }

    public static String getFontStyleAsString(int labelFontStyle) {
        switch (labelFontStyle) {
            case 0: {
                return "normal";
            }
            case 1: {
                return "bold";
            }
            case 2: {
                return "italic";
            }
            case 3: {
                return "bolditalic";
            }
        }
        return "normal";
    }

    public static int getFontSizeAsInt(String labelFontSize) {
        if (labelFontSize != null && !labelFontSize.equals("")) {
            return FontParams.getFontSizeAsInt(new Integer(labelFontSize));
        }
        return FontParams.getFontSizeAsInt((Integer)null);
    }

    public static int getFontSizeAsInt(Integer labelFontSize) {
        if (labelFontSize != null) {
            return labelFontSize;
        }
        return -1;
    }

    public void setFontName(String fontName) {
        this._fontName = fontName;
    }

    public void setFontColor(String color) {
        if (color.indexOf(CONST_FONT_COLOR_SEPARATOR) == -1) {
            this.setFontColor(this._defaultFontColor);
        } else {
            this.setFontColor(TextTools.createColor(color));
        }
    }

    public void setFontColor(Color color) {
        this._fontColor = color;
    }

    public Color getFontColor() {
        return this._fontColor;
    }

    public String getFontName() {
        return this._fontName;
    }

    public void setFontSize(int fontSize) {
        this._fontSize = fontSize;
    }

    public int getFontSize() {
        return this._fontSize;
    }

    public void setFontStyle(int fontStyle) {
        this._fontStyle = fontStyle;
    }

    public int getFontStyle() {
        return this._fontStyle;
    }

    public FontParams updateFontDefinition(String family, int style, int size) {
        if (family != null && !family.equals("")) {
            this.setFontName(family);
        }
        if (style >= 0) {
            this.setFontStyle(style);
        }
        if (size >= 0) {
            this.setFontSize(size);
        }
        return this;
    }

    public FontParams updateFontDefinition(String family, int style, int size, Color color) {
        this.updateFontDefinition(family, style, size);
        if (color != null && !color.equals("")) {
            this.setFontColor(color);
        }
        return this;
    }

    public FontParams updateFont(TableCell tableCell) {
        String family = tableCell.getLabelFontName();
        int fontStyle = FontParams.getFontStyleAsInt(tableCell.getLabelFontStyle());
        int fontSize = FontParams.getFontSizeAsInt(tableCell.getLabelFontSize());
        Color color = tableCell.getLabelFontColor();
        return this.updateFontDefinition(family, fontStyle, fontSize);
    }

    public static void printUIDefaults() {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.getDefaults().get(key);
            System.out.println(key + " -> " + value);
        }
    }

    private static Hashtable getDefaultFontParamsCache() {
        if (_defaultFontParamsCache == null) {
            _defaultFontParamsCache = new Hashtable();
        }
        return _defaultFontParamsCache;
    }
}

