/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.ui;

import com.jaxfront.core.ui.Md5;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class UUID {
    private int unique;
    private long time;
    private static String address;
    private static int hostUnique;
    private static Object mutex;
    private static long lastTime;
    private static long DELAY;

    private static String generateNoNetworkID() {
        Thread current = Thread.currentThread();
        String nid = Thread.activeCount() + System.getProperty("os.version") + System.getProperty("user.name") + System.getProperty("java.version");
        System.out.println(nid);
        Md5 md5 = new Md5(nid);
        md5.processString();
        return md5.getStringDigest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID() {
        Object object = mutex;
        synchronized (object) {
            boolean done = false;
            while (!done) {
                this.time = System.currentTimeMillis();
                if (this.time < lastTime + DELAY) {
                    try {
                        Thread.sleep(DELAY);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                lastTime = this.time;
                done = true;
            }
            this.unique = hostUnique;
        }
    }

    public String toString() {
        return Integer.toString(this.unique, 16) + "-" + Long.toString(this.time, 16) + "-" + address;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof UUID) {
            UUID uuid = (UUID)obj;
            return this.unique == uuid.unique && this.time == uuid.time && address.equals(address);
        }
        return false;
    }

    public static void main(String[] args) {
        System.out.println(new UUID());
        System.out.println(new UUID());
        System.out.println(new UUID());
        System.out.println(new UUID());
    }

    static {
        hostUnique = new Object().hashCode();
        mutex = new Object();
        lastTime = System.currentTimeMillis();
        DELAY = 10L;
        try {
            String s = InetAddress.getLocalHost().getHostAddress();
            Md5 md5 = new Md5(s);
            md5.processString();
            address = md5.getStringDigest();
        }
        catch (UnknownHostException ex) {
            address = UUID.generateNoNetworkID();
        }
    }
}

