/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.ui;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Hashtable;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class WindowWrapper {
    private Window _windowHolder;
    private JInternalFrame _IFrameHolder;
    Hashtable _iFrameDelegates;
    Hashtable _windowDelegate;

    public WindowWrapper(JInternalFrame internalFrame) {
        this._IFrameHolder = internalFrame;
    }

    public WindowWrapper(Window window) {
        this._windowHolder = window;
    }

    public synchronized void removeWindowListener(WindowListener l) {
        if (l == null) {
            return;
        }
        if (this._windowHolder != null) {
            this._windowHolder.removeWindowListener(l);
        } else if (this._IFrameHolder != null && this.getIFrameDelegates().get(l) != null) {
            InternalFrameEventDelegate iFrameDelegate = (InternalFrameEventDelegate)this.getIFrameDelegates().get(l);
            this.getIFrameDelegates().remove(l);
            this._IFrameHolder.removeInternalFrameListener(iFrameDelegate);
        }
    }

    public synchronized void addWindowListener(WindowListener l) {
        if (l == null) {
            return;
        }
        if (this._windowHolder != null) {
            this._windowHolder.addWindowListener(l);
        } else if (this._IFrameHolder != null) {
            InternalFrameEventDelegate iFrameDelegate = new InternalFrameEventDelegate(l);
            this.getIFrameDelegates().put(l, iFrameDelegate);
            this._IFrameHolder.addInternalFrameListener(iFrameDelegate);
        }
    }

    public synchronized void removeInteralFrameListener(InternalFrameListener l) {
        if (l == null) {
            return;
        }
        if (this._IFrameHolder != null) {
            this._IFrameHolder.removeInternalFrameListener(l);
        } else if (this._windowHolder != null && this.getWindowDelegates().get(l) != null) {
            WindowEventDelegate windowDelegate = (WindowEventDelegate)this.getWindowDelegates().get(l);
            this.getWindowDelegates().remove(l);
            this._windowHolder.removeWindowListener(windowDelegate);
        }
    }

    public synchronized void addInternalFrameListener(InternalFrameListener l) {
        if (l == null) {
            return;
        }
        if (this._IFrameHolder != null) {
            this._IFrameHolder.addInternalFrameListener(l);
        } else if (this._windowHolder != null) {
            WindowEventDelegate windowDelegate = new WindowEventDelegate(l);
            this.getWindowDelegates().put(l, windowDelegate);
            this._windowHolder.addWindowListener(windowDelegate);
        }
    }

    private Hashtable getIFrameDelegates() {
        if (this._iFrameDelegates == null) {
            this._iFrameDelegates = new Hashtable(5);
        }
        return this._iFrameDelegates;
    }

    private Hashtable getWindowDelegates() {
        if (this._windowDelegate == null) {
            this._windowDelegate = new Hashtable(5);
        }
        return this._windowDelegate;
    }

    public Component getHolder() {
        if (this._IFrameHolder != null) {
            return this._IFrameHolder;
        }
        return this._windowHolder;
    }

    class WindowEventDelegate
    implements WindowListener {
        InternalFrameListener _IFrameListener;

        public WindowEventDelegate(InternalFrameListener iFrameListener) {
            this._IFrameListener = iFrameListener;
        }

        public void windowActivated(WindowEvent e) {
            this._IFrameListener.internalFrameActivated(new InternalFrameEvent(WindowWrapper.this._IFrameHolder, 25554));
        }

        public void windowClosed(WindowEvent e) {
            this._IFrameListener.internalFrameClosed(new InternalFrameEvent(WindowWrapper.this._IFrameHolder, 25551));
        }

        public void windowClosing(WindowEvent e) {
            this._IFrameListener.internalFrameClosing(new InternalFrameEvent(WindowWrapper.this._IFrameHolder, 25550));
        }

        public void windowDeactivated(WindowEvent e) {
            this._IFrameListener.internalFrameDeactivated(new InternalFrameEvent(WindowWrapper.this._IFrameHolder, 25555));
        }

        public void windowDeiconified(WindowEvent e) {
            this._IFrameListener.internalFrameDeiconified(new InternalFrameEvent(WindowWrapper.this._IFrameHolder, 25553));
        }

        public void windowIconified(WindowEvent e) {
            this._IFrameListener.internalFrameIconified(new InternalFrameEvent(WindowWrapper.this._IFrameHolder, 25552));
        }

        public void windowOpened(WindowEvent e) {
            this._IFrameListener.internalFrameOpened(new InternalFrameEvent(WindowWrapper.this._IFrameHolder, 25549));
        }
    }

    class InternalFrameEventDelegate
    implements InternalFrameListener {
        WindowListener _windowListener;

        public InternalFrameEventDelegate(WindowListener windowListener) {
            this._windowListener = windowListener;
        }

        public void internalFrameActivated(InternalFrameEvent e) {
            this._windowListener.windowActivated(new WindowEvent(WindowWrapper.this._windowHolder, 205));
        }

        public void internalFrameClosed(InternalFrameEvent e) {
            this._windowListener.windowClosed(new WindowEvent(WindowWrapper.this._windowHolder, 202));
        }

        public void internalFrameClosing(InternalFrameEvent e) {
            this._windowListener.windowClosing(new WindowEvent(WindowWrapper.this._windowHolder, 201));
        }

        public void internalFrameDeactivated(InternalFrameEvent e) {
            this._windowListener.windowDeactivated(new WindowEvent(WindowWrapper.this._windowHolder, 206));
        }

        public void internalFrameDeiconified(InternalFrameEvent e) {
            this._windowListener.windowDeiconified(new WindowEvent(WindowWrapper.this._windowHolder, 204));
        }

        public void internalFrameIconified(InternalFrameEvent e) {
            this._windowListener.windowIconified(new WindowEvent(WindowWrapper.this._windowHolder, 203));
        }

        public void internalFrameOpened(InternalFrameEvent e) {
            this._windowListener.windowOpened(new WindowEvent(WindowWrapper.this._windowHolder, 25549));
        }
    }
}

