/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.ui.tableModel;

import com.jaxfront.core.ui.tableModel.FilterableTableModel;
import com.jaxfront.core.util.TextTools;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class FilteredJTableExample
extends JFrame {
    FilterableJTable table;
    JTextField txtFilter;
    JTextField txtFilterB;
    JTextField txtA;
    JTextField txtB;
    JButton btnAddRow;
    JComboBox cboSelectFilterColumn;
    static final String DEFAULT_FILTER = "^#.*";
    JPopupMenu popupMenu;

    public FilteredJTableExample() {
        super("FilteredJTableExample");
        this.setDefaultCloseOperation(3);
        this.popupMenu = this.createPopupMenu();
        this.table = new FilterableJTable(this.createFilterableTableModel());
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    Point point = e.getPoint();
                    FilteredJTableExample.this.popupMenu.show(FilteredJTableExample.this.table, point.x, point.y);
                }
            }
        });
        this.txtFilter = new JTextField(10);
        this.txtFilterB = new JTextField(10);
        this.txtFilter.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                String[][] filterDef = new String[2][1];
                filterDef[0][0] = TextTools.replace(FilteredJTableExample.DEFAULT_FILTER, "#", FilteredJTableExample.this.txtFilter.getText());
                filterDef[1][0] = TextTools.replace(FilteredJTableExample.DEFAULT_FILTER, "#", FilteredJTableExample.this.txtFilterB.getText());
                FilteredJTableExample.this.table.setFilter(filterDef);
                FilteredJTableExample.this.table.updateUI();
            }
        });
        this.txtFilterB.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                String[][] filterDef = new String[2][1];
                filterDef[0][0] = TextTools.replace(FilteredJTableExample.DEFAULT_FILTER, "#", FilteredJTableExample.this.txtFilter.getText());
                filterDef[1][0] = TextTools.replace(FilteredJTableExample.DEFAULT_FILTER, "#", FilteredJTableExample.this.txtFilterB.getText());
                FilteredJTableExample.this.table.setFilter(filterDef);
                FilteredJTableExample.this.table.updateUI();
            }
        });
        this.cboSelectFilterColumn = new JComboBox<Object>(this.createHeaderNames());
        this.cboSelectFilterColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilteredJTableExample.this.table.setFilterColumn(new int[]{FilteredJTableExample.this.cboSelectFilterColumn.getSelectedIndex(), 1});
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.table);
        JPanel addRowPanel = new JPanel(new GridLayout(1, 5));
        this.txtA = new JTextField(5);
        this.txtB = new JTextField(5);
        this.btnAddRow = new JButton("add");
        this.btnAddRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String strA = FilteredJTableExample.this.txtA.getText();
                String strB = FilteredJTableExample.this.txtB.getText();
                if (!"".equals(strA) && !"".equals(strB)) {
                    FilteredJTableExample.this.table.addRow(new Object[]{strA, strB});
                    FilteredJTableExample.this.table.updateUI();
                    FilteredJTableExample.this.txtA.setText("");
                    FilteredJTableExample.this.txtB.setText("");
                }
            }
        });
        addRowPanel.add(new JLabel("A:"));
        addRowPanel.add(this.txtA);
        addRowPanel.add(new JLabel("B:"));
        addRowPanel.add(this.txtB);
        addRowPanel.add(this.btnAddRow);
        this.add((Component)addRowPanel, "North");
        this.add((Component)this.cboSelectFilterColumn, "West");
        JPanel fPanel = new JPanel();
        fPanel.add((Component)this.txtFilter, "East");
        fPanel.add((Component)this.txtFilterB, "West");
        this.add((Component)fPanel, "East");
        this.add((Component)scrollPane, "South");
        this.pack();
        this.setVisible(true);
    }

    JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem deleteItem = new JMenuItem("delete");
        deleteItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int[] selectedRows = FilteredJTableExample.this.table.getSelectedRows();
                if (selectedRows.length == 0) {
                    JOptionPane.showMessageDialog(FilteredJTableExample.this, "No row selected!", "Error", 0);
                    return;
                }
                for (int s = selectedRows.length - 1; s >= 0; --s) {
                    FilteredJTableExample.this.table.deleteRow(selectedRows[s]);
                }
                FilteredJTableExample.this.table.updateUI();
            }
        });
        menu.add(deleteItem);
        return menu;
    }

    private TableModel createFilterableTableModel() {
        return new DefaultTableModel(this.createRowData(), this.createHeaderNames());
    }

    private Object[][] createRowData() {
        return new Object[][]{{"aaa", "121"}, {"aab", "111"}, {"abc", "123"}, {"xabc", "4123"}};
    }

    private Object[] createHeaderNames() {
        return new Object[]{"A", "B"};
    }

    public static void main(String[] args) {
        new FilteredJTableExample();
    }

    static class FilterableJTable
    extends JTable {
        public FilterableJTable(TableModel model) {
            super(new FilterableTableModel(model));
        }

        public void deleteRow(int selectedRow) {
            ((FilterableTableModel)this.getModel()).deleteRow(selectedRow);
        }

        public void setFilterColumn(int[] filterColumn) {
            ((FilterableTableModel)this.getModel()).setFilterColumns(filterColumn);
        }

        public int getFilterColumn() {
            return ((FilterableTableModel)this.getModel()).getFilterColumns()[0];
        }

        public void setFilter(String[][] filter) {
            ((FilterableTableModel)this.getModel()).setFilter(filter);
        }

        public void setFilter(String colName, String[][] filter) {
            ((FilterableTableModel)this.getModel()).setFilter(filter);
        }

        public void setFilter(int colIndex, String[][] filter) {
            ((FilterableTableModel)this.getModel()).setFilter(filter);
        }

        public void addRow(Object[] rowColumns) {
            ((FilterableTableModel)this.getModel()).addRow(rowColumns);
        }
    }
}

