/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.ui.tableModel;

import com.jaxfront.core.dom.DOMBuilder;
import com.jaxfront.core.dom.DOMChangeEvent;
import com.jaxfront.core.dom.DOMChangeListener;
import com.jaxfront.core.rule.FormulaException;
import com.jaxfront.core.rule.FormulaExpression;
import com.jaxfront.core.type.AbstractCompositeType;
import com.jaxfront.core.type.AbstractType;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypeHelper;
import com.jaxfront.core.type.TypePathExecuter;
import com.jaxfront.core.ui.PrimitiveRowHeaderLabellingStrategy;
import com.jaxfront.core.ui.RowHeaderLabellingStrategy;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.ui.tableModel.StackableTableModel;
import com.jaxfront.core.util.IntroSpectionHelper;
import com.jaxfront.core.xui.ColumnInfo;
import com.jaxfront.core.xui.TableInfo;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class ListTypeTableModel
extends AbstractTableModel
implements DOMChangeListener,
StackableTableModel {
    private Boolean _isComplexList;
    protected List _columns;
    private ListType _listType = null;
    private TableInfo _tableInfo = null;
    private RowHeaderLabellingStrategy _strategy = null;
    private Vector _rowHeaders;

    public ListTypeTableModel(ListType listType) {
        this._listType = listType;
        this._tableInfo = listType.getStyle().getTableInfo();
        this.initializeTableInfo();
        this.initializeRowHeaderStrategy();
        this._listType.getDOM().addDOMChangeListener(this);
    }

    public ListTypeTableModel(AbstractType listType) {
        this((ListType)((Object)listType));
    }

    protected void addRow(Type type) {
        this.addRow(type, false);
    }

    protected void addRow(Type type, boolean isFlipped) {
        if (isFlipped) {
            this.fireTableStructureChanged();
        } else {
            this.fireTableDataChanged();
        }
    }

    protected void removeRow(Type type, boolean isFlipped) {
        if (isFlipped) {
            this.fireTableStructureChanged();
        } else {
            this.fireTableDataChanged();
        }
    }

    private void initializeTableInfo() {
        if (this._tableInfo == null || this._tableInfo.getLineInfos().size() == 0) {
            if (this._tableInfo == null) {
                this._tableInfo = this.createTableInfo();
            } else if (this._tableInfo.getLineInfos().size() == 0) {
                this._tableInfo.createDefaultLineInfos(this._listType);
            }
        }
        this._columns = this._tableInfo.getLineInfos();
        this._tableInfo.updateLineInfos(this._listType);
    }

    private TableInfo createTableInfo() {
        List list = TypePathExecuter.getInstance().processXPath(DOMBuilder.getInstance().getXUISchemaDOM(this.getListType().getDOM().getAppContext()).getRootType(), "./component/style/list", true);
        Type xuiListType = (Type)list.get(0);
        TableInfo tableInfo = new TableInfo(xuiListType, this._listType, 1, true);
        tableInfo.setIsXUIControlled(false);
        return tableInfo;
    }

    public void domChanged(DOMChangeEvent event) {
        Type type = (Type)event.getSource();
        AbstractCompositeType representiveParent = null;
        if (type.getParent() != null && !type.getParent().isList()) {
            return;
        }
        representiveParent = this.isComplexList() ? TypeHelper.getComplexGroupParent(type) : TypeHelper.getSimpleGroupParent(type);
        if (representiveParent == null && type.isComposite()) {
            representiveParent = (AbstractCompositeType)type;
        }
        if (this.isComplexList()) {
            if (TypeHelper.getDirectComplexGroupParent(type) == this._listType) {
                this.performEvent(event, representiveParent);
            } else {
                boolean isTemplateOrDialogMode = false;
                if (this._listType.getStyle().getTableInfo() != null && this._listType.getStyle().getTableInfo().isDialogEditMode()) {
                    isTemplateOrDialogMode = true;
                }
                if (!this.getTableInfo().isUsingDefaultRendering() && !isTemplateOrDialogMode) {
                    this.fireTableDataChanged();
                }
            }
        } else {
            this.performEvent(event, representiveParent);
        }
    }

    private Object evaluate(int line, int col, boolean useCached) {
        ColumnInfo lineInfo = this._tableInfo.getLineInfo(col);
        Object value = null;
        value = useCached ? lineInfo.getCachedValue(line) : lineInfo.evalFormulaObject(line);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public Class getColumnClass(int columnIndex) {
        if (this.isComplexList()) {
            if (this.getListType().isKey()) {
                return SimpleType.class;
            }
            return super.getColumnClass(columnIndex);
        }
        return SimpleType.class;
    }

    public int getColumnCount() {
        return this.getColumns().size();
    }

    public String getColumnName(int col) {
        return ((ColumnInfo)this.getColumns().get(col)).getName();
    }

    public String getExcelTableData() {
        StringBuffer buf = new StringBuffer();
        String value = null;
        int rows = this.getRowCount();
        int columns = this.getColumnCount();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                value = (String)this.getValueAt(i, j);
                buf.append(value == null ? "" : value);
                buf.append("\t");
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    public int getIndexFor(Type type) {
        int index = -1;
        for (int i = 0; i < this._listType.getList().size(); ++i) {
            CompositeType composite = (CompositeType)this._listType.getList().get(i);
            if (composite != type) continue;
            index = i;
            break;
        }
        return index;
    }

    public ListType getListType() {
        return this._listType;
    }

    public int getRowCount() {
        return this._listType.getList().size();
    }

    public SimpleType getSimpleTypeAt(int row, int col) {
        SimpleType type;
        block7: {
            type = null;
            ColumnInfo lineInfo = null;
            try {
                if (this.isComplexList()) break block7;
                lineInfo = this._tableInfo.getLineInfo(col);
                Vector formulaExpressions = lineInfo.getFormulaExpressions();
                FormulaExpression expression = (FormulaExpression)formulaExpressions.get(row);
                if (expression != null && expression.getExpression() != null) {
                    try {
                        Object eval = expression.evaluateObject();
                        if (eval != null && eval instanceof SimpleType) {
                            type = (SimpleType)eval;
                        }
                        break block7;
                    }
                    catch (FormulaException ex) {}
                    break block7;
                }
                if (expression.getSource() != null && expression.getSource().getTypeClassification() == 1) {
                    type = (SimpleType)expression.getSource();
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return type;
    }

    private boolean isContextNavigationField(int row, int col) {
        ColumnInfo lineInfo = this._tableInfo.getLineInfo(col);
        return lineInfo.allowContextNavigation();
    }

    public TableInfo getTableInfo() {
        return this._tableInfo;
    }

    public Object getValueAt(int row, int col) {
        return this.evaluate(row, col, false);
    }

    public int getViewToModel(int rowIndex) {
        return rowIndex;
    }

    public List getRowFormulas(int col) {
        return (List)this._tableInfo.getLineInfo(col).getFormulaExpressions().clone();
    }

    public String getRowName(int index) {
        return ((ColumnInfo)this._columns.get(index)).getName();
    }

    public Vector getRowHeaders() {
        if (this._rowHeaders == null || this._rowHeaders.size() == 0) {
            this.fillRowHeaders();
        }
        return this._rowHeaders;
    }

    public boolean isCellEditable(int row, int column) {
        if (this.isCellEditableEnabled()) {
            boolean isEditable = false;
            if (column > 0) {
                --column;
            }
            if (this.getListType().isKey() && this.isContextNavigationField(row, column)) {
                return true;
            }
            if (this.getListType().getStyle().isDialogMode()) {
                return false;
            }
            if (this.getListType().getTypeClassification() == 193 && this.getListType().getStyle().getTableInfo() != null && !this.getListType().getStyle().getTableInfo().isDefaultPanelEditMode()) {
                return false;
            }
            isEditable = this.getSimpleTypeAt(row, column) != null;
            return isEditable;
        }
        return false;
    }

    public boolean isCellEditableEnabled() {
        if (this.getListType().isKey()) {
            return true;
        }
        if (this.isComplexList()) {
            return false;
        }
        if (this.getListType().getStyle().getTableInfo() != null && this.getListType().getStyle().getTableInfo().isSelectionOnly()) {
            return false;
        }
        return !this.getListType().getStyle().isDialogMode() && !this.getListType().getStyle().isPanelMode();
    }

    private boolean isComplexList() {
        if (this._isComplexList == null) {
            this._isComplexList = new Boolean(this.getListType().getTypeClassification() == 194);
        }
        return this._isComplexList;
    }

    protected void performEvent(DOMChangeEvent event, AbstractCompositeType representiveParent) {
        Type type = (Type)event.getSource();
        if (event.isChangingNode()) {
            this.fireTableDataChanged();
        } else if (event.isAddingNode()) {
            Type typeToAdd = representiveParent;
            if (representiveParent == null && type.isSimple()) {
                typeToAdd = type;
                this.getTableInfo().createFormula((SimpleType)type);
            } else {
                this.getTableInfo().createFormulas(representiveParent);
            }
            this.addRow(typeToAdd);
        } else if (event.isRemovingNode()) {
            this.getTableInfo().updateLineInfo(type, event.getType());
            this.removeRow(type, false);
        }
        if (!event.isListItemSelected() && !event.isListItemDeselected()) {
            this.fireTableDataChanged();
        }
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        SimpleType type = this.getSimpleTypeAt(rowIndex, columnIndex);
        if (!(type == null || type.getStyle().isUsingPlugIn() || type.getValue() != null && aValue != null && ((String)aValue).equals(type.getValue()))) {
            Visualizer vis = TypeVisualizerFactory.getInstance().getVisualizer((Type)type, false);
            type.setValue(vis, (String)aValue, false);
        }
    }

    public List getColumns() {
        if (this._columns == null) {
            this._columns = this._tableInfo.getLineInfos();
        }
        return this._columns;
    }

    public void swapFormula(int from, int to) {
        if (from == -1 || to == -1) {
            return;
        }
        for (int j = 0; j < this.getColumns().size(); ++j) {
            ColumnInfo o = (ColumnInfo)this.getColumns().get(j);
            o.swapFormula(from, to);
        }
    }

    public void release() {
        this._isComplexList = null;
        this._columns = null;
        if (this._listType != null && this._listType.getDOM() != null) {
            this._listType.getDOM().removeDOMChangeListener(this);
            this._listType = null;
        }
        this._tableInfo = null;
    }

    public RowHeaderLabellingStrategy getStrategy() {
        if (this._strategy == null) {
            this._strategy = new PrimitiveRowHeaderLabellingStrategy();
        }
        return this._strategy;
    }

    private void initializeRowHeaderStrategy() {
        String strategyName = "";
        if (this._tableInfo == null || this._tableInfo.getLineInfos().size() == 0) {
            this._strategy = new PrimitiveRowHeaderLabellingStrategy();
            if (this._tableInfo == null) {
                this._tableInfo = this.createTableInfo();
            } else if (this._tableInfo.getLineInfos().size() == 0) {
                this.createDefaultLineInfos(this._tableInfo);
            }
            if (this._tableInfo.getColumnHeaderLabellingStrategy() == null) {
                strategyName = this._strategy.getClass().getName();
            }
        } else {
            strategyName = this._tableInfo.getColumnHeaderLabellingStrategy();
        }
        this._strategy = RowHeaderLabellingStrategy.create(strategyName, this._listType);
        this.fillRowHeaders();
        this._columns = this._tableInfo.getLineInfos();
        this._tableInfo.updateLineInfos(this._listType);
    }

    private void createDefaultLineInfos(TableInfo tableInfo) {
        if (this._listType.getEditingType().isSimple()) {
            ColumnInfo lineInfo = new ColumnInfo(this._listType.getEditingType(), 0, this._listType.getEditingType().getStyle().getLabelText());
            lineInfo.setUsingDefaultRendering(true);
            tableInfo.addLineInfo(lineInfo);
            return;
        }
        CompositeType composite = (CompositeType)this._listType.getEditingType();
        Iterator compositeIterator = composite.getComposites().iterator();
        int counter = 0;
        tableInfo.releaseLineInfos();
        while (compositeIterator.hasNext()) {
            Type type = (Type)compositeIterator.next();
            if (!type.isSimple() && type.getTypeClassification() != 128 && type.getTypeClassification() != 65) continue;
            ColumnInfo lineInfo = new ColumnInfo(type, counter, type.getStyle().getLabelText());
            lineInfo.setUsingDefaultRendering(true);
            tableInfo.addLineInfo(lineInfo);
            ++counter;
        }
        if (tableInfo.size() == 0) {
            tableInfo.addLineInfo(new ColumnInfo(composite, 0, "no name"));
        }
    }

    protected void fillRowHeaders() {
        this._rowHeaders = new Vector();
        for (int rowCounter = 0; rowCounter < this._listType.getList().size(); ++rowCounter) {
            this._rowHeaders.add(this._strategy.getRowHeader((Type)this._listType.getList().get(rowCounter)));
        }
    }

    public static int evaluateParentTableRowIndex(TableModel parentModel, int index) {
        try {
            Object result = IntroSpectionHelper.callFunktion(parentModel, "getViewToModel", new Class[]{Integer.TYPE}, new Object[]{new Integer(index)});
            if (result != null) {
                return Integer.parseInt(result.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return index;
    }
}

