/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import [Ljava.lang.String;;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.StringUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;

public class ArrayUtil {
    public static Object[] addToArray(Object[] array, Object o) {
        if (array == null) {
            array = new Object[]{};
        }
        int s = array.length;
        Object[] newArray = new Object[s + 1];
        System.arraycopy(array, 0, newArray, 0, s);
        newArray[s] = o;
        return newArray;
    }

    public static String[] addToArray(String[] array, String o) {
        int s = array.length;
        String[] newArray = new String[s + 1];
        System.arraycopy(array, 0, newArray, 0, s);
        newArray[s] = o;
        return newArray;
    }

    public static int[] zeroArray(int[] data) {
        if (data == null) {
            return null;
        }
        for (int i = 0; i < data.length; ++i) {
            data[i] = 0;
        }
        return data;
    }

    public static int[] addToGrowArray(int[] array, int o, int gf) {
        if (array == null) {
            array = new int[gf];
            array[gf - 1] = -1;
        }
        int s = array.length;
        int lastIdx = -1;
        if (s > 0) {
            lastIdx = array[s - 1];
            array[s - 1] = 0;
        }
        if (++lastIdx < s - 2) {
            array[lastIdx] = o;
            array[s - 1] = lastIdx;
            return array;
        }
        int[] newArray = new int[s + gf];
        System.arraycopy(array, 0, newArray, 0, s);
        newArray[lastIdx] = o;
        newArray[newArray.length - 1] = lastIdx;
        return newArray;
    }

    public static int[] removeFromGrowArray(int[] array) {
        if (array == null) {
            return array;
        }
        int s = array.length;
        int lastIdx = -1;
        if (s > 0) {
            lastIdx = array[s - 1];
            array[s - 1] = 0;
        }
        if (--lastIdx < s - 2) {
            array[s - 1] = lastIdx;
        }
        return array;
    }

    public static Object[] addToGrowArray(Object[] array, Object o, int gf) {
        if (array == null) {
            array = new Object[gf];
        }
        int s = array.length;
        int lastIdx = -1;
        if (s > 0) {
            Integer iVal = (Integer)array[s - 1];
            lastIdx = iVal != null ? iVal : -1;
            array[s - 1] = new Integer(0);
        }
        if (++lastIdx < s - 2) {
            array[lastIdx] = o;
            array[s - 1] = new Integer(lastIdx);
            return array;
        }
        Object[] newArray = new Object[s + gf];
        System.arraycopy(array, 0, newArray, 0, s);
        newArray[lastIdx] = o;
        newArray[newArray.length - 1] = new Integer(lastIdx);
        return newArray;
    }

    public static long[] addToGrowArray(long[] array, long o, int gf) {
        if (array == null) {
            array = new long[gf];
            array[gf - 1] = -1L;
        }
        int s = array.length;
        int lastIdx = -1;
        if (s > 0) {
            lastIdx = (int)array[s - 1];
            array[s - 1] = 0L;
        }
        if (++lastIdx < s - 2) {
            array[lastIdx] = o;
            array[s - 1] = lastIdx;
            return array;
        }
        long[] newArray = new long[s + gf];
        System.arraycopy(array, 0, newArray, 0, s);
        newArray[lastIdx] = o;
        newArray[newArray.length - 1] = lastIdx;
        return newArray;
    }

    public static Object[] finalizeGrowArray(Object[] array) {
        if (array == null || array.length == 0) {
            return array;
        }
        int s = array.length;
        int lastIdx = -1;
        if (s > 0) {
            Integer iVal = (Integer)array[s - 1];
            lastIdx = (iVal != null ? iVal : 0) + 1;
        }
        Object[] newArray = new Object[lastIdx];
        System.arraycopy(array, 0, newArray, 0, lastIdx);
        return newArray;
    }

    public static Object[] finalizeGrowArray(Class clazz, Object[] array) {
        if (array == null || array.length == 0) {
            return array;
        }
        int s = array.length;
        int lastIdx = -1;
        if (s > 0) {
            Integer iVal = (Integer)array[s - 1];
            lastIdx = (iVal != null ? iVal : 0) + 1;
        }
        Object[] newArray = (Object[])Array.newInstance(clazz, lastIdx);
        System.arraycopy(array, 0, newArray, 0, lastIdx);
        return newArray;
    }

    public static long[] finalizeGrowArray(long[] array) {
        if (array == null || array.length == 0) {
            return array;
        }
        int s = array.length;
        int lastIdx = -1;
        if (s > 0) {
            lastIdx = (int)array[s - 1] + 1;
        }
        long[] newArray = new long[lastIdx];
        System.arraycopy(array, 0, newArray, 0, lastIdx);
        return newArray;
    }

    public static int[] finalizeGrowArray(int[] array) {
        if (array == null || array.length == 0) {
            return array;
        }
        int s = array.length;
        int lastIdx = -1;
        if (s > 0) {
            lastIdx = array[s - 1] + 1;
        }
        int[] newArray = new int[lastIdx];
        System.arraycopy(array, 0, newArray, 0, lastIdx);
        return newArray;
    }

    public static Type[] addToArray(Type[] array, Type o) {
        int s = array.length;
        Type[] newArray = new Type[s + 1];
        System.arraycopy(array, 0, newArray, 0, s);
        newArray[s] = o;
        return newArray;
    }

    public static int[] addToArray(int[] array, int o) {
        if (array == null) {
            array = new int[]{};
        }
        int s = array.length;
        int[] newArray = new int[s + 1];
        System.arraycopy(array, 0, newArray, 0, s);
        newArray[s] = o;
        return newArray;
    }

    public static String toXPath(Stack stack) {
        int sCount = stack.size();
        StringBuffer result = new StringBuffer();
        for (int s = sCount - 1; s >= 0; --s) {
            result.append("/");
            result.append(stack.get(s));
        }
        return result.toString();
    }

    public static String toPath(Stack stack) {
        int sCount = stack.size();
        StringBuffer result = new StringBuffer();
        for (int s = sCount - 1; s >= 0; --s) {
            result.append("/");
            result.append(stack.get(s));
        }
        return result.toString();
    }

    public static int[] mergeArray(int[] what, int[] with, int overWrite) {
        int[] result = new int[what.length];
        int div = what.length - with.length;
        for (int i = what.length - 1; i >= 0; --i) {
            int wa = what[i];
            if (i - div >= 0) {
                int wi = with[i - div];
                if (wa == overWrite) {
                    result[i] = wi;
                    continue;
                }
                result[i] = wa;
                continue;
            }
            result[i] = wa;
        }
        return result;
    }

    public static short[] addToArray(short[] array, short o) {
        int s = array.length;
        short[] newArray = new short[s + 1];
        System.arraycopy(array, 0, newArray, 0, s);
        newArray[s] = o;
        return newArray;
    }

    public static int[] copy(int[] array) {
        int s = array.length;
        int[] newArray = new int[array.length];
        System.arraycopy(array, 0, newArray, 0, s);
        return newArray;
    }

    public static Object[] copy(Class aClass, Object[] array) {
        int s = array.length;
        Object[] newArray = (Object[])Array.newInstance(aClass, s);
        System.arraycopy(array, 0, newArray, 0, s);
        return newArray;
    }

    public static String[] copy(String[] array) {
        int s = array.length;
        String[] newArray = new String[array.length];
        System.arraycopy(array, 0, newArray, 0, s);
        return newArray;
    }

    public static String[] copy(String[] array, int newLength) {
        int s = array.length;
        if (s > newLength) {
            s = newLength;
        }
        String[] newArray = new String[newLength];
        System.arraycopy(array, 0, newArray, 0, s);
        return newArray;
    }

    public static short[] addAtStartToArray(short[] array, short o) {
        int s = array.length;
        short[] newArray = new short[s + 1];
        System.arraycopy(array, 0, newArray, 1, s);
        newArray[0] = o;
        return newArray;
    }

    public static String[] addAtStartToArray(String[] array, String o) {
        int s = array.length;
        String[] newArray = new String[s + 1];
        System.arraycopy(array, 0, newArray, 1, s);
        newArray[0] = o;
        return newArray;
    }

    public static int[] addToArray(int[] array, int[] array2) {
        if (array2 == null || array2.length == 0) {
            return array;
        }
        int s = array.length;
        int s2 = array2.length;
        int[] newArray = new int[s + s2];
        System.arraycopy(array, 0, newArray, 0, s);
        System.arraycopy(array2, 0, newArray, s, s2);
        return newArray;
    }

    public static Object[] addToArray(Object[] array, Object[] array2) {
        if (array2 == null || array2.length == 0) {
            return array;
        }
        int s = array.length;
        int s2 = array2.length;
        Object[] newArray = new Object[s + s2];
        System.arraycopy(array, 0, newArray, 0, s);
        System.arraycopy(array2, 0, newArray, s, s2);
        return newArray;
    }

    public static Object[] addToArray(Class aClass, Object[] array, Object o) {
        int s = array.length;
        Object[] newArray = (Object[])Array.newInstance(aClass, s + 1);
        System.arraycopy(array, 0, newArray, 0, s);
        newArray[s] = o;
        return newArray;
    }

    public static Object[] addToArray(Class aClass, Object[] array, Object o, int pos) {
        if (pos > array.length) {
            pos = array.length;
        }
        int s = array.length + 1;
        Object[] newArray = (Object[])Array.newInstance(aClass, s);
        System.arraycopy(array, 0, newArray, 0, pos);
        newArray[pos] = o;
        System.arraycopy(array, pos, newArray, pos + 1, array.length - pos);
        return newArray;
    }

    public static Object addToArray(Class aClass, Object[] array, Object[] array2) {
        if (array == null) {
            array = (Object[])Array.newInstance(aClass, 0);
        }
        int s = array.length;
        int s2 = array2.length;
        Object newArray = Array.newInstance(aClass, s + s2);
        System.arraycopy(array, 0, newArray, 0, s);
        System.arraycopy(array2, 0, newArray, s, s2);
        return newArray;
    }

    public static String[] addToArray(String[] where, String[] what) {
        if (what == null || what.length == 0) {
            return where;
        }
        if (where == null) {
            return what;
        }
        int s = where.length;
        int s2 = what.length;
        String[] newArray = new String[s + s2];
        System.arraycopy(where, 0, newArray, 0, s);
        System.arraycopy(what, 0, newArray, s, s2);
        return newArray;
    }

    public static String[] addToArray(String[] array, int arraylength, String[] array2, int array2length) {
        String[] newArray = new String[arraylength + array2length];
        System.arraycopy(array, 0, newArray, 0, arraylength);
        System.arraycopy(array2, 0, newArray, arraylength, array2length);
        return newArray;
    }

    public static Object[] removeNullFromArray(Class clazz, Object[] fields) {
        ArrayList<Object> res = new ArrayList<Object>(fields.length);
        for (int f = 0; f < fields.length; ++f) {
            Object afield = fields[f];
            if (afield == null) continue;
            res.add(afield);
        }
        return ArrayUtil.toArray(clazz, res);
    }

    public static Object[] removeFromArray(Class clazz, Object[] fields, Object value) {
        ArrayList<Object> res = new ArrayList<Object>(fields.length);
        for (int f = 0; f < fields.length; ++f) {
            Object afield = fields[f];
            if (afield == value || afield.equals(value)) continue;
            res.add(afield);
        }
        return ArrayUtil.toArray(clazz, res);
    }

    public static void main(String[] args) {
        int i;
        String[] copToLen = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"};
        copToLen = ArrayUtil.copy(copToLen, 14);
        copToLen = ArrayUtil.copy(copToLen, 12);
        int[] gitest = null;
        for (i = 0; i < 10; ++i) {
            gitest = ArrayUtil.addToGrowArray(gitest, i + 1, 10);
        }
        for (i = 0; i < 10; ++i) {
            gitest = ArrayUtil.removeFromGrowArray(gitest);
        }
        gitest = ArrayUtil.addToGrowArray(gitest, 111, 10);
        gitest = ArrayUtil.finalizeGrowArray(gitest);
        int[] intVals = new int[]{1, 2, 3, 4, 5, 1, 2, 4, 5, 11, 22, 33, 9};
        int[] intSVals = new int[]{1, 2, 7, 3, 4, 5, 6, 9};
        ArrayUtil.removePos(intVals, intSVals);
        Object[] remoEv = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"};
        ArrayUtil.invert(String;.class, (Object[])ArrayUtil.split((String[])remoEv, 3));
        System.out.println(ArrayUtil.toString(ArrayUtil.keepEvery(remoEv, 2), ","));
        System.out.println(ArrayUtil.toString(ArrayUtil.keepEvery(remoEv, 3), ","));
        System.out.println(ArrayUtil.toString(ArrayUtil.keepEvery(remoEv, 4), ","));
        System.out.println(ArrayUtil.toString(ArrayUtil.removeEvery(remoEv, 2), ","));
        System.out.println(ArrayUtil.toString(ArrayUtil.removeEvery(remoEv, 3), ","));
        System.out.println(ArrayUtil.toString(ArrayUtil.removeEvery(remoEv, 4), ","));
        System.out.println(ArrayUtil.toString(ArrayUtil.indexOf(intVals, intSVals)));
        Vector<String> testv1 = new Vector<String>();
        testv1.add("1");
        testv1.add("2");
        testv1.add("3");
        testv1.add("4");
        testv1.add("5");
        ArrayUtil.move(testv1, (Object)"1", false, true);
        ArrayUtil.move(testv1, (Object)"1", true, true);
        ArrayUtil.move(testv1, (Object)"1", true, true);
        ArrayUtil.move(testv1, (Object)"1", false, true);
        ArrayUtil.move(testv1, (Object)"1", false, true);
        ArrayUtil.move(testv1, (Object)"1", false, true);
        ArrayUtil.move(testv1, (Object)"1", false, true);
        ArrayUtil.move(testv1, (Object)"1", false, true);
        ArrayUtil.move(testv1, (Object)"1", false, true);
        Vector<String> testv = new Vector<String>();
        testv.add(0, "1");
        Object[] test2 = new String[]{"1", "2", null, "4", "5"};
        String[] test1 = new String[]{"1", "", "3", "", null};
        System.out.println(ArrayUtil.toString(test2, ",", true));
        System.out.println(ArrayUtil.toString(ArrayUtil.merge((String[])test2, test1)));
        System.out.println(ArrayUtil.toString(ArrayUtil.addToArray(String.class, test2, "2.1", 2)));
        System.out.println(ArrayUtil.toString(ArrayUtil.addToArray(String.class, test2, "2.1", 0)));
        System.out.println(ArrayUtil.toString(ArrayUtil.addToArray(String.class, test2, "2.1", test2.length)));
        Object[] test0 = new String[]{"1", "3", "4"};
        System.out.println(ArrayUtil.toString(ArrayUtil.intersection(test2, test0)));
        System.out.println(ArrayUtil.toString(ArrayUtil.move((String[])test2, "3", true, false), ","));
        System.out.println(ArrayUtil.toString(ArrayUtil.move((String[])test2, "3", false, false), ","));
        System.out.println(ArrayUtil.toString(ArrayUtil.move((String[])test2, "1", true, false), ","));
        System.out.println(ArrayUtil.toString(ArrayUtil.move((String[])test2, "1", false, false), ","));
        System.out.println(ArrayUtil.toString(ArrayUtil.move((String[])test2, "5", true, false), ","));
        System.out.println(ArrayUtil.toString(ArrayUtil.move((String[])test2, "5", false, false), ","));
        System.out.println(ArrayUtil.toString(ArrayUtil.move((String[])test2, "5", false, false), ","));
        String[][] test2Dim = new String[][]{{"1", "2", "3", "4", "5"}, {"1", "2", "3", "4", "5"}, {"1", "2", "3", "4", "5"}};
        int[] test3 = new int[]{1, 2, 3, 4, 5};
        String[] toRemove = new String[]{"6"};
        System.out.println(ArrayUtil.toString(ArrayUtil.removeFromArray((String[])test2, toRemove), ","));
        System.out.println(ArrayUtil.toString(ArrayUtil.removeFromArray(test3, 1), ","));
        ArrayUtil.copyPos(test2Dim, new int[]{2, 4});
        ArrayUtil.removePos(test3, new int[]{2, 4});
        System.out.println(ArrayUtil.toString(ArrayUtil.removeFromArray(test3, 3), ","));
        System.out.println(ArrayUtil.toString(ArrayUtil.removeFromArray(test3, 4), ","));
        int[] test = new int[]{};
        for (int i2 = 0; i2 < 10; ++i2) {
            test = ArrayUtil.addToGrowArray(test, i2 + 1, 10);
        }
        test = ArrayUtil.finalizeGrowArray(test);
        long[] ltest = null;
        for (int i3 = 0; i3 < 10; ++i3) {
            ltest = ArrayUtil.addToGrowArray(ltest, (long)(i3 + 1), 10);
        }
        ltest = ArrayUtil.finalizeGrowArray(ltest);
        Object[] otest = null;
        for (int i4 = 0; i4 < 10; ++i4) {
            otest = ArrayUtil.addToGrowArray(otest, i4 + 1 + "", 10);
        }
        otest = ArrayUtil.finalizeGrowArray(otest);
    }

    public static char[] addToArray(char[] array, char[] array2) {
        int s = array.length;
        int s2 = array2.length;
        char[] newArray = new char[s + s2];
        System.arraycopy(array, 0, newArray, 0, s);
        System.arraycopy(array2, 0, newArray, s, s2);
        return newArray;
    }

    public static Class[] addToClassArray(Class[] array, Class[] array2) {
        int s = array.length;
        int s2 = array2.length;
        int i = s + s2;
        Class[] newArray = new Class[i];
        System.arraycopy(array, 0, newArray, 0, s);
        System.arraycopy(array2, 0, newArray, s, s2);
        return newArray;
    }

    public static short[] removeFromArray(short[] array, short o) {
        int s = array.length;
        int ns = s - 1;
        boolean found = false;
        short[] newArray = new short[ns];
        int pos = 0;
        for (int i = 0; i < s; ++i) {
            if (array[i] == o) {
                found = true;
                continue;
            }
            if (pos >= ns) continue;
            newArray[pos++] = array[i];
        }
        if (found) {
            return newArray;
        }
        return array;
    }

    public static int[] removeFromArray(int[] array, int o) {
        int s = array.length;
        int count = 0;
        for (int i = 0; i < s; ++i) {
            if (array[i] != o) continue;
            ++count;
        }
        if (count == 0) {
            return array;
        }
        int ns = s - count;
        int[] newArray = new int[ns];
        int pos = 0;
        for (int i = 0; i < s; ++i) {
            if (array[i] == o) continue;
            newArray[pos++] = array[i];
        }
        return newArray;
    }

    public static String[] removePos(String[] array, int pos) {
        String[] res = array;
        if (pos >= 0 && pos < array.length) {
            res = new String[array.length - 1];
            System.arraycopy(array, 0, res, 0, pos);
            System.arraycopy(array, pos + 1, res, pos, res.length - pos);
        }
        return res;
    }

    public static int[] removePos(int[] array, int pos) {
        int[] res = array;
        if (pos >= 0 && pos < array.length) {
            res = new int[array.length - 1];
            System.arraycopy(array, 0, res, 0, pos);
            System.arraycopy(array, pos + 1, res, pos, res.length - pos);
        }
        return res;
    }

    public static String[] removePos(String[] array, int[] poses) {
        String[] res = new String[array.length - poses.length];
        int idx = 0;
        for (int p = 0; p < array.length; ++p) {
            boolean add = true;
            for (int o = 0; o < poses.length; ++o) {
                if (poses[o] != p) continue;
                add = false;
                break;
            }
            if (!add) continue;
            res[idx++] = array[p];
        }
        return res;
    }

    public static int[] removePos(int[] array, int[] poses) {
        int[] res = new int[array.length - poses.length];
        int idx = 0;
        for (int p = 0; p < array.length; ++p) {
            boolean add = true;
            for (int o = 0; o < poses.length; ++o) {
                if (poses[o] != p) continue;
                add = false;
                break;
            }
            if (!add) continue;
            res[idx++] = array[p];
        }
        return res;
    }

    public static Object[] copyPos(Object[] array, int[] poses) {
        Object[] res = new Object[poses.length];
        for (int p = 0; p < poses.length; ++p) {
            if (poses[p] < 0) continue;
            res[p] = array[poses[p]];
        }
        return res;
    }

    public static String[] copyPos(String[] array, int[] poses) {
        if (poses == null) {
            return array;
        }
        String[] res = new String[poses.length];
        for (int p = 0; p < poses.length; ++p) {
            if (poses[p] == -1) continue;
            res[p] = array[poses[p]];
        }
        return res;
    }

    public static int[] copyPos(int[] array, int[] poses) {
        if (poses == null) {
            return array;
        }
        int[] res = new int[poses.length];
        for (int p = 0; p < poses.length; ++p) {
            res[p] = array[poses[p]];
        }
        return res;
    }

    public static Object[][] copyPos(Object[][] array, int[] poses) {
        Object[][] res = new Object[array.length][poses.length];
        for (int r = 0; r < array.length; ++r) {
            for (int p = 0; p < poses.length; ++p) {
                res[r][p] = array[r][poses[p]];
            }
        }
        return res;
    }

    public static String[][] copyPos(String[][] array, int[] poses) {
        String[][] res = new String[array.length][poses.length];
        for (int r = 0; r < array.length; ++r) {
            for (int p = 0; p < poses.length; ++p) {
                res[r][p] = array[r][poses[p]];
            }
        }
        return res;
    }

    public static Object[] keepEvery(Object[] array, int every) {
        if (array == null || array.length == 0 || every == 1) {
            return array;
        }
        int newLength = array.length / every;
        Object[] result = (Object[])Array.newInstance(array[0].getClass(), newLength);
        int pos = 0;
        for (int i = 0; i < array.length; ++i) {
            if ((i + 1) % every == 0) {
                result[pos++] = array[i];
            }
            if (pos == result.length) break;
        }
        return result;
    }

    public static Object[] removeEvery(Object[] array, int every) {
        if (array == null || array.length == 0) {
            return array;
        }
        Class<?> resClass = array[0].getClass();
        if (every == 1) {
            return (Object[])Array.newInstance(resClass, 0);
        }
        int newLength = array.length - array.length / every;
        Object[] result = (Object[])Array.newInstance(resClass, newLength);
        int pos = 0;
        for (int i = 0; i < array.length; ++i) {
            if ((i + 1) % every == 0) continue;
            result[pos++] = array[i];
        }
        return result;
    }

    public static Object[] removeFromArray(Object[] array, Object o) {
        int s = array.length;
        int ns = s - 1;
        Object[] newArray = new Object[ns];
        boolean found = false;
        int pos = 0;
        for (int i = 0; i < s; ++i) {
            if (array[i] == o) {
                found = true;
                continue;
            }
            if (pos >= ns) continue;
            newArray[pos++] = array[i];
        }
        if (found) {
            return newArray;
        }
        return array;
    }

    public static String[] removeFromArray(String[] array, String o) {
        return ArrayUtil.removeFromArray(array, o, false);
    }

    public static String[] removeFromArray(String[] array, String o, boolean ignoreCase) {
        int s = array.length;
        String[] newArray = new String[s];
        boolean found = false;
        int foundCount = 0;
        int pos = 0;
        for (int i = 0; i < s; ++i) {
            if (array[i] == o || o != null && (ignoreCase ? o.equalsIgnoreCase(array[i]) : o.equals(array[i]))) {
                ++foundCount;
                found = true;
                continue;
            }
            if (pos >= s) continue;
            newArray[pos++] = array[i];
        }
        if (found) {
            String[] result = new String[s - foundCount];
            System.arraycopy(newArray, 0, result, 0, s - foundCount);
            return result;
        }
        return array;
    }

    public static String[] removeFromArray(String[] array, String[] vals) {
        return ArrayUtil.removeFromArray(array, vals, false);
    }

    public static String[] removeFromArray(String[] array, String[] vals, boolean equalsIgnoreCase) {
        if (array == null || vals == null || vals.length == 0) {
            return array;
        }
        int s = array.length;
        String[] newArray = new String[s];
        boolean found = false;
        boolean addValue = true;
        int foundCount = 0;
        int pos = 0;
        for (int i = 0; i < s; ++i) {
            for (int v = 0; v < vals.length; ++v) {
                if (array[i] != vals[v] && vals[v] == null) continue;
                if (equalsIgnoreCase) {
                    if (!vals[v].equalsIgnoreCase(array[i])) continue;
                    ++foundCount;
                    found = true;
                    addValue = false;
                    break;
                }
                if (!vals[v].equals(array[i])) continue;
                ++foundCount;
                found = true;
                addValue = false;
                break;
            }
            if (addValue && pos < s) {
                newArray[pos++] = array[i];
            }
            addValue = true;
        }
        if (found) {
            String[] result = new String[s - foundCount];
            System.arraycopy(newArray, 0, result, 0, s - foundCount);
            return result;
        }
        return array;
    }

    public static void addToVector(List list, Object[] array) {
        int s = array.length;
        for (int i = 0; i < s; ++i) {
            list.add(array[i]);
        }
    }

    public static void addToVector(List list, Object[] array, boolean unique) {
        int s = array.length;
        for (int i = 0; i < s; ++i) {
            if (unique && list.contains(array[i])) {
                list.add(array[i]);
                continue;
            }
            list.add(array[i]);
        }
    }

    public static synchronized String[] toStringArray(List list) {
        if (list == null) {
            return null;
        }
        int s = list.size();
        String[] result = new String[s];
        for (int i = 0; i < s; ++i) {
            Object o = list.get(i);
            if (o == null) continue;
            result[i] = list.get(i) != null ? list.get(i).toString() : null;
        }
        return result;
    }

    public static synchronized String[] toStringArray(String[][] values, int col) {
        String[] result = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i][col];
        }
        return result;
    }

    public static synchronized String[][] toStringArrayArray(List list) {
        int s = list.size();
        String[][] result = new String[s][];
        for (int i = 0; i < s; ++i) {
            int oa;
            String[] resLine;
            Object o = list.get(i);
            if (o instanceof Object[]) {
                Object[] oarr = (Object[])o;
                resLine = new String[oarr.length];
                for (oa = 0; oa < oarr.length; ++oa) {
                    resLine[oa] = oarr[oa] != null ? oarr[oa].toString() : null;
                }
                result[i] = resLine;
                continue;
            }
            if (!(o instanceof List[])) continue;
            List oList = (List)o;
            resLine = new String[oList.size()];
            for (oa = 0; oa < oList.size(); ++oa) {
                resLine[oa] = oList.get(oa) != null ? oList.get(oa).toString() : null;
            }
            result[i] = resLine;
        }
        return result;
    }

    public static String[] toStringArray(Object[] list) {
        int s = list.length;
        String[] result = new String[s];
        for (int i = 0; i < s; ++i) {
            result[i] = list[i] == null ? null : list[i].toString();
        }
        return result;
    }

    public static int[] toIntArray(Object[] aList) {
        int s = aList.length;
        int[] result = new int[s];
        for (int i = 0; i < s; ++i) {
            result[i] = Integer.parseInt(aList[i].toString());
        }
        return result;
    }

    public static int[] toIntArray(List aList) {
        int s = aList.size();
        int[] result = new int[s];
        for (int i = 0; i < s; ++i) {
            result[i] = Integer.parseInt(aList.get(i).toString());
        }
        return result;
    }

    public static int getMaxSegment(int[] seqs, int value) {
        if (seqs != null) {
            for (int s = 0; s < seqs.length; ++s) {
                if (value >= seqs[s]) continue;
                return seqs[s];
            }
        }
        return value;
    }

    public static Object[] toArray(Class aClass, List list) {
        int s = list.size();
        Object[] newArray = (Object[])Array.newInstance(aClass, s);
        for (int i = 0; i < s; ++i) {
            Object o = list.get(i);
            if (o == null) continue;
            newArray[i] = o;
        }
        return newArray;
    }

    public static String toString(Object list, String delim, String qual) {
        return ArrayUtil.toString(list, delim, qual, null, null);
    }

    public static String toString(Object list, String delim, String qual, String prefix, String suffix) {
        if (list == null) {
            return null;
        }
        if (list instanceof List) {
            return ArrayUtil.toString((List)list, delim, qual, prefix, suffix);
        }
        if (list instanceof String[]) {
            return ArrayUtil.toString((Object[])list, delim, qual, prefix, suffix);
        }
        return (qual == null ? "" : qual) + (prefix != null ? prefix : "" + list.toString()) + (suffix != null ? suffix : "") + (qual == null ? "" : qual);
    }

    public static String toString(Object[] list) {
        return ArrayUtil.toString(list, ",");
    }

    public static String toString(Iterator it, String delim, String qual, String prefix, String suffix) {
        StringBuffer rs = new StringBuffer();
        while (it.hasNext()) {
            Object o = it.next();
            if (o == null) continue;
            rs.append((qual == null ? "" : qual) + (prefix != null ? prefix : "" + o.toString()) + (suffix != null ? suffix : "") + (qual == null ? "" : qual));
        }
        return rs.toString();
    }

    public static String toString(Object[] list, String delim) {
        return ArrayUtil.toString(list, delim, false);
    }

    public static String toString(Object[] list, String delim, boolean skipNull) {
        if (list == null) {
            return null;
        }
        int s = list.length;
        boolean first = true;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s; ++i) {
            if (skipNull && list[i] == null) continue;
            if (first) {
                first = false;
            } else {
                result.append(delim);
            }
            result.append(list[i]);
        }
        return result.toString();
    }

    public static String toString(int[] itemsPos, Object[] list, String delim) {
        int s = itemsPos.length;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s; ++i) {
            result.append(list[itemsPos[i]]);
            if (i >= s - 1) continue;
            result.append(delim);
        }
        return result.toString();
    }

    public static Object[] merge(Object[] target, Object[] with) {
        for (int i = 0; i < target.length; ++i) {
            Object ar1Obj = target[i];
            Object ar2Obj = with[i];
            if (ar1Obj != null) continue;
            target[i] = ar2Obj;
        }
        return target;
    }

    public static String[] merge(String[] target, String[] with) {
        for (int i = 0; i < target.length; ++i) {
            String ar1Obj = target[i];
            String ar2Obj = with[i];
            if (ar1Obj != null && ar1Obj.length() != 0) continue;
            target[i] = ar2Obj;
        }
        return target;
    }

    public static String toString(Object[][] list, String delim) {
        int s = list.length;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s; ++i) {
            Object[] line = list[i];
            for (int j = 0; j < line.length; ++j) {
                result.append(line[j]);
                if (j >= line.length - 1) continue;
                result.append(delim);
            }
            result.append("\n");
        }
        return result.toString();
    }

    public static String toString(Object[] list, String delim, String qualifier, String prefix, String suffix) {
        return ArrayUtil.toString(list, delim, qualifier, prefix, suffix, null, false);
    }

    public static String toString(Object[] list, String delim, String qualifier, String prefix, String suffix, String nullValue) {
        return ArrayUtil.toString(list, delim, qualifier, prefix, suffix, nullValue, false);
    }

    public static String toString(Object[] list, String delim, String qualifier, String prefix, String suffix, String nullValue, boolean skipNull) {
        int s = list.length;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s; ++i) {
            if (list[i] == null && skipNull) continue;
            if (qualifier != null) {
                result.append(qualifier);
            }
            if (prefix != null) {
                result.append(prefix);
            }
            if (list[i] == null) {
                if (nullValue != null) {
                    result.append(nullValue);
                } else {
                    result.append(list[i]);
                }
            } else {
                result.append(list[i]);
            }
            if (suffix != null) {
                result.append(suffix);
            }
            if (qualifier != null) {
                result.append(qualifier);
            }
            if (i + 1 >= s) continue;
            result.append(delim);
        }
        return result.toString();
    }

    public static String toString(Enumeration list, String delim) {
        StringBuffer result = new StringBuffer();
        while (list.hasMoreElements()) {
            Object object = list.nextElement();
            if (object != null) {
                result.append(object.toString());
            }
            if (!list.hasMoreElements()) continue;
            result.append(delim);
        }
        return result.toString();
    }

    public static String toString(byte[] list, String delim) {
        int s = list.length;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s; ++i) {
            result.append(list[i]);
            if (i >= s) continue;
            result.append(delim);
        }
        return result.toString();
    }

    public static String toString(short[] list) {
        int s = list.length;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s; ++i) {
            result.append(list[i]);
            if (i >= s) continue;
            result.append(",");
        }
        return result.toString();
    }

    public static String toString(int[] list) {
        if (list == null) {
            return null;
        }
        int s = list.length;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s; ++i) {
            result.append(list[i]);
            if (i >= s) continue;
            result.append(",");
        }
        return result.toString();
    }

    public static String toString(int[] list, String delim) {
        int s = list.length;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s; ++i) {
            result.append(list[i]);
            if (i + 1 >= s) continue;
            result.append(delim);
        }
        return result.toString();
    }

    public static String toString(List list) {
        return ArrayUtil.toString(list, ",");
    }

    public static String toString(List list, String delim, String qual, String prefix, String suffix) {
        return ArrayUtil.toString(list, delim, qual, prefix, suffix, null);
    }

    public static String toString(List list, String delim, String qual, String prefix, String suffix, String nullVal) {
        if (list == null) {
            return null;
        }
        int s = list.size();
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s; ++i) {
            if (qual != null) {
                result.append(qual);
            }
            if (prefix != null) {
                result.append(prefix);
            }
            if (list.get(i) == null) {
                if (nullVal != null) {
                    result.append(nullVal);
                } else {
                    result.append(list.get(i));
                }
            } else {
                result.append(list.get(i));
            }
            if (suffix != null) {
                result.append(suffix);
            }
            if (qual != null) {
                result.append(qual);
            }
            if (i + 1 >= s || delim == null) continue;
            result.append(delim);
        }
        return result.toString();
    }

    public static String toString(List list, String delim) {
        return ArrayUtil.toString(list, delim, null);
    }

    public static String toString(Collection collection) {
        return ArrayUtil.toString(collection.toArray());
    }

    public static int contains(Object[][] array, int col, Object value) {
        return ArrayUtil.contains(array, col, value, false);
    }

    public static int contains(Object[][] array, int col, Object value, boolean isRowColumn) {
        int foundAt = -1;
        if (array == null || array.length <= 0 || value == null) {
            return foundAt;
        }
        int length = 0;
        length = isRowColumn ? array.length - 1 : array[0].length - 1;
        for (int r = length; r >= 0; --r) {
            if (isRowColumn) {
                if (!value.equals(array[r][col])) continue;
                foundAt = r;
                break;
            }
            if (!value.equals(array[col][r])) continue;
            foundAt = r;
            break;
        }
        return foundAt;
    }

    public static int contains(Object[] array, Object value) {
        int length;
        int foundAt = -1;
        int s = array.length;
        if (s <= 0) {
            return foundAt;
        }
        for (int y = length = s - 1; y >= 0; --y) {
            if (value != array[y] && (value == null || !value.equals(array[y]))) continue;
            foundAt = y;
            break;
        }
        return foundAt;
    }

    public static int containsOne(Object[] array, Object[] oneOf) {
        int length;
        int foundAt = -1;
        int s = array.length;
        if (s <= 0) {
            return foundAt;
        }
        for (int y = length = s - 1; y >= 0; --y) {
            for (int o = 0; o < oneOf.length; ++o) {
                if (oneOf[o] != array[y] && (oneOf[o] == null || !oneOf[o].equals(array[y]))) continue;
                foundAt = y;
                return foundAt;
            }
        }
        return foundAt;
    }

    public static int containsOne(List array, List oneOf) {
        int length;
        int foundAt = -1;
        int s = array.size();
        if (s <= 0) {
            return foundAt;
        }
        for (int y = length = s - 1; y >= 0; --y) {
            for (int o = 0; o < oneOf.size(); ++o) {
                if (oneOf.get(o) != array.get(y) && (oneOf.get(o) == null || !oneOf.get(o).equals(array.get(y)))) continue;
                foundAt = y;
                return foundAt;
            }
        }
        return foundAt;
    }

    public static int containsIgnoreCase(String[] array, String value) {
        int length;
        int foundAt = -1;
        int s = array.length;
        if (s <= 0 || value == null) {
            return foundAt;
        }
        for (int y = length = s - 1; y >= 0; --y) {
            if (!value.equalsIgnoreCase(array[y])) continue;
            foundAt = y;
            break;
        }
        return foundAt;
    }

    public static boolean contains(int[] array, int value) {
        int length;
        int s = array.length;
        if (s <= 0) {
            return false;
        }
        for (int y = length = s - 1; y >= 0; --y) {
            if (value != array[y]) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(char[] array, char value) {
        int length;
        int s = array.length;
        if (s <= 0) {
            return false;
        }
        for (int y = length = s - 1; y >= 0; --y) {
            if (value != array[y]) continue;
            return true;
        }
        return false;
    }

    public static Object get(Object[][] array, int keyCol, Object keyValue, int resultCol) {
        int arrayXLength = array.length;
        if (arrayXLength <= 0 || keyValue == null) {
            return null;
        }
        int length = array[0].length;
        for (int y = 0; y < length; ++y) {
            if (!keyValue.equals(array[keyCol][y]) || arrayXLength <= resultCol) continue;
            return array[resultCol][y];
        }
        return null;
    }

    public static Object[][] addToArray(Object[][] array, Object[][] array2) {
        int y;
        int foundAt = ArrayUtil.contains(array, 0, array2[0][0]);
        if (foundAt >= 0) {
            array[0][foundAt] = array2[0][0];
            array[1][foundAt] = array2[1][0];
            return array;
        }
        int ax = array.length;
        int ay = 0;
        if (ax > 0) {
            ay = array[0].length;
        }
        int a2x = array2.length;
        int a2y = 0;
        if (a2x > 0) {
            a2y = array2[0].length;
        }
        int newLength = ay + a2y;
        int newWidth = ax;
        if (newWidth <= 0) {
            newWidth = a2x;
        }
        Object[][] newArray = new Object[newWidth][newLength];
        for (y = 0; y < ay; ++y) {
            for (int x = 0; x < ax; ++x) {
                newArray[x][y] = array[x][y];
            }
        }
        int y2 = 0;
        while (y < newLength) {
            for (int x = 0; x < a2x; ++x) {
                newArray[x][y] = array2[x][y2];
            }
            ++y;
            ++y2;
        }
        return newArray;
    }

    public static Object[][] removeFromArray(Object[][] array, Object o) {
        if (ArrayUtil.contains(array, 0, o) >= 0) {
            int s = array.length;
            Object[][] newArray = new Object[s][array[0].length - 1];
            int pos = 0;
            for (int i = 0; i < array[0].length; ++i) {
                if (array[0][i] == o) continue;
                for (int x = 0; x < s; ++x) {
                    newArray[x][pos] = array[x][i];
                }
                ++pos;
            }
            return newArray;
        }
        return array;
    }

    public static Object[][] removeFrom2DimArray(Object[][] array, Object o) {
        if (ArrayUtil.contains(array, 0, o) >= 0) {
            int s = array.length;
            int s2 = array[0].length;
            Object[][] newArray = new Object[s][s2 - 1];
            int pos = 0;
            for (int i = 0; i < s2; ++i) {
                if (array[0][i] == o) continue;
                newArray[0][pos] = array[0][i];
                newArray[1][pos] = array[1][i];
                ++pos;
            }
            return newArray;
        }
        return array;
    }

    public static Object get2Dim(Object[][] array, int keyCol, Object keyValue) {
        int arrayXLength = array.length;
        if (arrayXLength <= 0 || keyValue == null) {
            return null;
        }
        int length = array[0].length;
        for (int y = 0; y < length; ++y) {
            if (!keyValue.equals(array[keyCol][y])) continue;
            return array[1][y];
        }
        return null;
    }

    public static int[] compare(Object[][] a1, Object[][] a2) {
        if (a1.length != a2.length) {
            return new int[]{a1.length, -1};
        }
        if (a1.length > 0 && a2.length > 0 && a1[0].length != a2[0].length) {
            return new int[]{-1, a1[0].length};
        }
        for (int i = 0; i < a1.length; ++i) {
            for (int j = 0; j < a1[i].length; ++j) {
                if (a1[i][j] == null) continue;
                if (!a1[i][j].equals(a2[i][j])) {
                    return new int[]{i, j};
                }
                if (a2[i][j] == null || a2[i][j].equals(a1[i][j])) continue;
                return new int[]{i, j};
            }
        }
        return new int[]{-1, -1};
    }

    public static boolean equals(int[] a1, int[] a2) {
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean compare(Object[] a1, Object[] a2) {
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            if (a1[i] != null && !a1[i].equals(a2[i])) {
                return false;
            }
            if (a1[i] != null || a2[i] == null) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(Object[] a1, Object[] a2) {
        if (a1.length < a2.length) {
            return false;
        }
        for (int i = 0; i < a2.length; ++i) {
            if (a1[i] == a2[i]) continue;
            if (a2[i] != null && !a2[i].equals(a1[i])) {
                return false;
            }
            if (a1[i] != null || a2[i] == null) continue;
            return false;
        }
        return true;
    }

    public static String[][] addTo2DimArrayX(String[][] array, String[][] array2) {
        int y;
        int foundAt = ArrayUtil.contains(array, 0, array2[0][0]);
        if (foundAt >= 0) {
            array[0][foundAt] = array2[0][0];
            array[1][foundAt] = array2[1][0];
            return array;
        }
        int ax = array.length;
        int ay = 0;
        if (ax > 0) {
            ay = array[0].length;
        }
        int a2x = array2.length;
        int a2y = 0;
        if (a2x > 0) {
            a2y = array2[0].length;
        }
        int newLength = ay + a2y;
        int newWidth = ax;
        if (newWidth <= 0) {
            newWidth = a2x;
        }
        String[][] newArray = new String[newWidth][newLength];
        for (y = 0; y < ay; ++y) {
            newArray[0][y] = array[0][y];
            newArray[1][y] = array[1][y];
        }
        int y2 = 0;
        while (y < newLength) {
            newArray[0][y] = array2[0][y2];
            newArray[1][y] = array2[1][y2];
            ++y;
            ++y2;
        }
        return newArray;
    }

    public static String[][] addTo2DimArrayY(String[][] array, String[][] array2) {
        if (array.length == 0) {
            return array2;
        }
        if (array2.length == 0) {
            return array;
        }
        int newLength = array.length + array2.length;
        int w1 = array[0].length;
        int w2 = array2[0].length;
        int width = Math.max(w1, w2);
        String[][] newArray = new String[newLength][width];
        System.arraycopy(array, 0, newArray, 0, array.length);
        System.arraycopy(array2, 0, newArray, array.length, array2.length);
        return newArray;
    }

    public static Object[][] addTo2DimArray(Object[][] array, Object[][] array2) {
        int y;
        int foundAt;
        if (array == null) {
            array = new Object[][]{};
        }
        if ((foundAt = ArrayUtil.contains(array, 0, array2[0][0])) >= 0) {
            array[0][foundAt] = array2[0][0];
            array[1][foundAt] = array2[1][0];
            return array;
        }
        int ax = array.length;
        int ay = 0;
        if (ax > 0) {
            ay = array[0].length;
        }
        int a2x = array2.length;
        int a2y = 0;
        if (a2x > 0) {
            a2y = array2[0].length;
        }
        int newLength = ay + a2y;
        int newWidth = ax;
        if (newWidth <= 0) {
            newWidth = a2x;
        }
        Object[][] newArray = new Object[newWidth][newLength];
        for (y = 0; y < ay; ++y) {
            newArray[0][y] = array[0][y];
            newArray[1][y] = array[1][y];
        }
        int y2 = 0;
        while (y < newLength) {
            newArray[0][y] = array2[0][y2];
            newArray[1][y] = array2[1][y2];
            ++y;
            ++y2;
        }
        return newArray;
    }

    public static Hashtable toHashTable(String[] what) {
        if (what == null) {
            return null;
        }
        Hashtable<String, String> result = new Hashtable<String, String>(what.length / 2);
        for (int i = 0; i < what.length; i += 2) {
            result.put(what[i], what[i + 1]);
        }
        return result;
    }

    public static List toList(String[][] what) {
        if (what == null) {
            return null;
        }
        Vector<String[]> result = new Vector<String[]>(what.length);
        for (int c = 0; c < what.length; ++c) {
            result.add(what[c]);
        }
        return result;
    }

    public static List toList(Object[] what) {
        if (what == null) {
            return null;
        }
        ArrayList<Object> res = new ArrayList<Object>(what.length);
        for (int w = 0; w < what.length; ++w) {
            res.add(what[w]);
        }
        return res;
    }

    public static List createListContaining(Object value) {
        ArrayList<Object> nList = new ArrayList<Object>(1);
        nList.add(value);
        return nList;
    }

    public static List invert(List what) {
        Vector result = new Vector(what.size());
        for (int i = what.size() - 1; i >= 0; --i) {
            result.add(what.get(i));
        }
        return result;
    }

    public static String[] invert(String[] what) {
        String[] result = new String[what.length];
        int r = 0;
        for (int i = what.length - 1; i >= 0; --i) {
            result[r++] = what[i];
        }
        return result;
    }

    public static int sum(int[] intValues) {
        int result = 0;
        for (int i = intValues.length - 1; i >= 0; --i) {
            result += intValues[i];
        }
        return result;
    }

    public static int sum(String[] intValues) {
        int result = 0;
        for (int i = intValues.length - 1; i >= 0; --i) {
            if (!StringUtil.isInteger(intValues[i])) continue;
            result += StringUtil.getInt(intValues[i]);
        }
        return result;
    }

    public static String[][] split(String[] vals, int size) {
        int vLen = vals.length;
        int outerSize = (int)Math.ceil((double)vLen / (double)size);
        int oPos = 0;
        String[][] outer = new String[outerSize][];
        for (int v = 0; v < vLen; ++v) {
            int rest = v % size;
            if (rest != 0) continue;
            String[] segment = new String[size];
            int lenSizeDif = vLen - v;
            size = size > lenSizeDif ? lenSizeDif : size;
            System.arraycopy(vals, v, segment, 0, size);
            outer[oPos++] = segment;
            v += size - 1;
        }
        return outer;
    }

    public static char[] invert(char[] what) {
        char[] result = new char[what.length];
        int r = 0;
        for (int i = what.length - 1; i >= 0; --i) {
            result[r++] = what[i];
        }
        return result;
    }

    public static byte[] invert(byte[] what) {
        byte[] result = new byte[what.length];
        int r = 0;
        for (int i = what.length - 1; i >= 0; --i) {
            result[r++] = what[i];
        }
        return result;
    }

    public static Object[] invert(Object[] what) {
        Object[] result = new Object[what.length];
        int r = 0;
        for (int i = what.length - 1; i >= 0; --i) {
            result[r++] = what[i];
        }
        return result;
    }

    public static Object[] invert(Class clazz, Object[] what) {
        int len = what.length;
        Object[] result = (Object[])Array.newInstance(clazz, len);
        int r = 0;
        for (int i = len - 1; i >= 0; --i) {
            result[r++] = what[i];
        }
        return result;
    }

    public static Hashtable toHashTable(String[][] what) {
        Hashtable<String, String> result = new Hashtable<String, String>(what.length);
        for (int i = 0; i < what.length; i += 2) {
            for (int j = 0; j < 2; ++j) {
                result.put(what[i][0], what[i][1]);
            }
        }
        return result;
    }

    public static Object[][] copy(Object[][] source) {
        Object[][] result = null;
        if (source != null) {
            result = new Object[source.length][];
            for (int s = 0; s < source.length; ++s) {
                result[s] = source[s] == null ? null : (Object[])source[s].clone();
            }
        }
        return result;
    }

    public static int getIndex(String find, String[] data) {
        for (int d = 0; d < data.length; ++d) {
            if (!find.equals(data[d])) continue;
            return d;
        }
        return -1;
    }

    public static int getKeyValueIndex(String key, String[] data) {
        for (int d = 0; d < data.length; d += 2) {
            if (!key.equals(data[d])) continue;
            return d;
        }
        return -1;
    }

    public static List toList(Iterator it) {
        Vector result = new Vector();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public static List toList(Enumeration vals) {
        Vector result = new Vector();
        while (vals.hasMoreElements()) {
            result.add(vals.nextElement());
        }
        return result;
    }

    public static String[][] meltArray(String[] what, String[] with) {
        int maxL = Math.max(what.length, with.length);
        String[][] result = new String[maxL][2];
        for (int i = maxL - 1; i >= 0; --i) {
            result[i][0] = what[i];
            result[i][1] = with[i];
        }
        return result;
    }

    public static int[] toIntArray(char[] charArray) {
        int[] result = new int[charArray.length];
        for (int c = 0; c < charArray.length; ++c) {
            result[c] = Character.digit(charArray[c], 10);
        }
        return result;
    }

    public static boolean isEmptyStringArray(String[] values) {
        if (values == null || values.length == 0) {
            return true;
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || values[i].length() <= 0) continue;
            return false;
        }
        return true;
    }

    public static int count(String[] allIDs, String id) {
        int count = 0;
        for (int i = 0; i < allIDs.length; ++i) {
            if (allIDs[i] == null || id == null) {
                if (allIDs[i] != null || id != null) continue;
                ++count;
                continue;
            }
            if (!allIDs[i].equals(id)) continue;
            ++count;
        }
        return count;
    }

    public static int[] createAscIntArray(int start, int length) {
        int j;
        int[] result = new int[length];
        int end = j + length;
        for (j = start; j < end; ++j) {
            result[j] = j;
        }
        return result;
    }

    public static float[] initArray(int length, float defaultVal) {
        float[] result = new float[length];
        for (int j = 0; j < length; ++j) {
            result[j] = defaultVal;
        }
        return result;
    }

    public static int[] initArray(int length, int defaultVal) {
        int[] result = new int[length];
        for (int j = 0; j < length; ++j) {
            result[j] = defaultVal;
        }
        return result;
    }

    public static String[] removeDuplicates(String[] ids) {
        return ArrayUtil.removeDuplicates(ids, false);
    }

    public static String[] removeDuplicates(String[] ids, boolean skipNull) {
        if (ids == null) {
            return null;
        }
        boolean nullAdded = false;
        ArrayList<Object> result = null;
        HashMap<String, String> found = new HashMap<String, String>(ids.length / 2);
        for (int i = 0; i < ids.length; ++i) {
            String item = ids[i];
            if (item == null) {
                if (nullAdded) continue;
                if (result == null) {
                    result = new ArrayList<Object>();
                }
                if (!skipNull) {
                    result.add(null);
                }
                nullAdded = true;
                continue;
            }
            if (found.containsKey(item)) continue;
            if (result == null) {
                result = new ArrayList();
            }
            if (item == null) continue;
            result.add(item);
            found.put(item, item);
        }
        if (result == null) {
            return new String[0];
        }
        return ArrayUtil.toStringArray(result);
    }

    public static String[] createStringArray(int start, int length, String val) {
        int j;
        String[] result = new String[length];
        int end = j + length;
        for (j = start; j < end; ++j) {
            result[j] = val;
        }
        return result;
    }

    public static int[] getIDxForNames(String[] colNames, String[] names) {
        int[] result = null;
        if (colNames != null && names != null) {
            result = new int[names.length];
            int pos = 0;
            for (int c = 0; c < names.length; ++c) {
                int nPos = ArrayUtil.containsIgnoreCase(colNames, names[c]);
                if (nPos < 0) continue;
                result[pos++] = nPos;
            }
        }
        return result;
    }

    public static int indexOf(int[] data, int val, int offset) {
        int idx = -1;
        for (int i = offset; i < data.length; ++i) {
            if (data[i] != val) continue;
            return i;
        }
        return idx;
    }

    public static int[] indexOf(int[] data, int[] vals) {
        int[] result = null;
        if (data != null && vals != null) {
            result = new int[vals.length];
            int pos = 0;
            int len = vals.length;
            for (int c = 0; c < len; ++c) {
                int nPos = ArrayUtil.indexOf(data, vals[c], pos);
                if (nPos >= 0) {
                    ++pos;
                    result[c] = nPos;
                    continue;
                }
                result[c] = -1;
            }
        }
        return result;
    }

    public static int[] indexOf(String[] data, String[] vals) {
        int[] result = null;
        if (data != null && vals != null) {
            result = new int[vals.length];
            int pos = 0;
            int len = vals.length;
            for (int c = 0; c < len; ++c) {
                int nPos = ArrayUtil.contains(data, vals[c]);
                if (nPos >= 0) {
                    ++pos;
                    result[c] = nPos;
                    continue;
                }
                result[c] = -1;
            }
        }
        return result;
    }

    public static Object[] switchElement(Object[] elements, int pos, boolean left) {
        if (left) {
            Object oldVal = elements[pos - 1];
            elements[pos - 1] = elements[pos];
            elements[pos] = oldVal;
        } else {
            Object oldVal = elements[pos + 1];
            elements[pos + 1] = elements[pos];
            elements[pos] = oldVal;
        }
        return elements;
    }

    public static Object[] switchElement(Object[] elements, int pos, int pos2) {
        Object oldVal = elements[pos];
        elements[pos] = elements[pos2];
        elements[pos2] = oldVal;
        return elements;
    }

    public static Object[] shiftLeft(Object[] overlayCols, Object[] baseCols) {
        int v;
        int[] poses = new int[overlayCols.length];
        for (v = 0; v < overlayCols.length; ++v) {
            poses[v] = ArrayUtil.contains(baseCols, overlayCols[v]);
        }
        for (v = 1; v < poses.length; ++v) {
            ArrayUtil.switchElement(baseCols, poses[v - 1], poses[v]);
        }
        return baseCols;
    }

    public static Object[] shiftRight(Object[] overlayCols, Object[] baseCols) {
        int v;
        int[] poses = new int[overlayCols.length];
        for (v = 0; v < overlayCols.length; ++v) {
            poses[v] = ArrayUtil.contains(baseCols, overlayCols[v]);
        }
        for (v = poses.length - 1; v > 0; --v) {
            ArrayUtil.switchElement(baseCols, poses[v], poses[v - 1]);
        }
        return baseCols;
    }

    public static List switchElement(List elements, Object fromVal, Object toVal) {
        int from = elements.indexOf(fromVal);
        int to = elements.indexOf(toVal);
        if (from == -1 || to == -1) {
            return elements;
        }
        elements.remove(from);
        elements.add(from, toVal);
        elements.remove(to);
        elements.add(to, fromVal);
        return elements;
    }

    public static List switchElement(List elements, int from, int to) {
        Object fromVal = elements.get(from);
        Object toVal = elements.get(to);
        elements.remove(from);
        elements.add(from, toVal);
        elements.remove(to);
        elements.add(to, fromVal);
        return elements;
    }

    public static List moveElement(List elements, int pos, boolean left) {
        if (left) {
            Object oldVal = elements.get(pos);
            elements.remove(pos);
            elements.add(pos - 1, oldVal);
        } else {
            Object oldVal = elements.get(pos);
            elements.remove(pos);
            elements.add(pos + 1, oldVal);
        }
        return elements;
    }

    public static Object[] intersection(Object[] seq1, Object[] seq2) {
        return ArrayUtil.intersection(seq1, seq2, null);
    }

    public static Object[] intersection(Object[] seq1, Object[] seq2, Class clazz) {
        ArrayList<Object> result = new ArrayList<Object>();
        block0: for (int i = 0; i < seq1.length; ++i) {
            Object s1 = seq1[i];
            if (s1 == null) continue;
            for (int j = 0; j < seq2.length; ++j) {
                Object s2 = seq2[j];
                if (!s1.equals(s2) || result.contains(s2)) continue;
                result.add(s2);
                continue block0;
            }
        }
        if (clazz != null) {
            if (result.size() == 0) {
                return (Object[])Array.newInstance(clazz, result.size());
            }
            Object[] newArray = (Object[])Array.newInstance(clazz, result.size());
            System.arraycopy(result.toArray(), 0, newArray, 0, 1);
            return newArray;
        }
        return result.toArray();
    }

    public static String[] move(String[] columnSequence, String colID, boolean left, boolean isRoling) {
        int pos = ArrayUtil.getIndex(colID, columnSequence);
        if (pos >= 0) {
            if (left) {
                if (pos == 0) {
                    if (isRoling) {
                        return (String[])ArrayUtil.switchElement((Object[])columnSequence, 0, columnSequence.length - 1);
                    }
                    return columnSequence;
                }
                return (String[])ArrayUtil.switchElement((Object[])columnSequence, pos, true);
            }
            if (pos == columnSequence.length - 1) {
                if (isRoling) {
                    return (String[])ArrayUtil.switchElement((Object[])columnSequence, columnSequence.length - 1, 0);
                }
                return columnSequence;
            }
            return (String[])ArrayUtil.switchElement((Object[])columnSequence, pos, false);
        }
        return columnSequence;
    }

    public static List move(List aList, Object what, boolean left, boolean isRoling) {
        int pos = aList.indexOf(what);
        if (pos >= 0) {
            if (left) {
                if (pos == 0) {
                    if (isRoling) {
                        return ArrayUtil.switchElement(aList, 0, aList.size() - 1);
                    }
                    return aList;
                }
                return ArrayUtil.moveElement(aList, pos, true);
            }
            if (pos == aList.size() - 1) {
                if (isRoling) {
                    return ArrayUtil.switchElement(aList, aList.size() - 1, 0);
                }
                return aList;
            }
            return ArrayUtil.moveElement(aList, pos, false);
        }
        return aList;
    }

    public static List toList(Collection errors) {
        return ArrayUtil.toList(errors.iterator());
    }

    public static byte[] getBytesFrom(Object value, String charsetName) {
        byte[] res = null;
        try {
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                res = ((String)value).getBytes(charsetName);
            } else if (value instanceof byte[]) {
                res = (byte[])value;
            } else if (value instanceof Number) {
                res = ((Number)value).toString().getBytes(charsetName);
            }
        }
        catch (Exception e) {
            LogRegistry.getInstance().error(Array.class, e);
        }
        return res;
    }
}

