/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.TextTools;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class EventUtil {
    public static String[] parseAccelDefinitions(String nlsName) {
        String[] accelDef = new String[2];
        int accelPos = nlsName.indexOf("${");
        if (accelPos >= 0) {
            int accelToPos = nlsName.indexOf("}", accelPos);
            accelDef[0] = nlsName.substring(0, accelPos);
            accelDef[1] = nlsName.substring(accelPos + 2, accelToPos);
        } else {
            accelDef[0] = nlsName;
            accelDef[1] = null;
        }
        return accelDef;
    }

    public static int[] extractKeyAndModifier(String[] def) {
        int key = -1;
        int modifier = -1;
        int[] result = new int[2];
        if (def.length > 1) {
            modifier = StringUtil.isNumeric(def[0]) ? Integer.parseInt(def[0]) : EventUtil.translateEventToInt(def[0]);
            key = StringUtil.isNumeric(def[1]) ? Integer.parseInt(def[1]) : EventUtil.translateEventToInt(def[1]);
        } else if (def.length > 0) {
            modifier = StringUtil.isNumeric(def[0]) ? Integer.parseInt(def[0]) : EventUtil.translateEventToInt(def[0]);
        }
        result[0] = key;
        result[1] = modifier;
        return result;
    }

    public static void createKeyStrokes(Action aAction, String mnemonicDefinition) {
        String[] def = TextTools.tokenize(mnemonicDefinition, "+");
        int[] keyMod = EventUtil.extractKeyAndModifier(def);
        if (keyMod[0] >= 0 && keyMod[1] >= 0) {
            aAction.putValue("MnemonicKey", new Integer(keyMod[0]));
            aAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(keyMod[0], keyMod[1]));
        }
    }

    public static void createKeyStrokes(JButton aButton, String mnemonicDefinition) {
        String[] def = TextTools.tokenize(mnemonicDefinition, "+");
        int[] keyMod = EventUtil.extractKeyAndModifier(def);
        if (keyMod[0] >= 0 && keyMod[1] >= 0) {
            aButton.registerKeyboardAction(aButton.getAction(), KeyStroke.getKeyStroke(keyMod[0], keyMod[1]), 0);
        }
    }

    public static void addKeyboardBinding(JComponent addTo, Action aAction, String mnemonicDefinition, int condition) {
        String[] def;
        int[] keyMod;
        if (mnemonicDefinition != null && mnemonicDefinition.length() > 0 && (keyMod = EventUtil.extractKeyAndModifier(def = TextTools.tokenize(mnemonicDefinition, "+")))[0] >= 0 && keyMod[1] >= 0) {
            addTo.registerKeyboardAction(aAction, KeyStroke.getKeyStroke(keyMod[0], keyMod[1]), condition);
        }
    }

    public static int translateEventToInt(String eventDef) {
        String def = eventDef.trim();
        if (def.length() > 1) {
            if (def.equalsIgnoreCase("ALT_GRAPH")) {
                return 65406;
            }
            if (def.equalsIgnoreCase("ENTER")) {
                return 10;
            }
            if (def.equalsIgnoreCase("TAB")) {
                return 9;
            }
            if (def.equalsIgnoreCase("SHIFT")) {
                return 1;
            }
            if (def.equalsIgnoreCase("CONTROL")) {
                return 2;
            }
            if (def.equalsIgnoreCase("CTRL")) {
                return 2;
            }
            if (def.equalsIgnoreCase("STRG")) {
                return 2;
            }
            if (def.equalsIgnoreCase("ALT")) {
                return 8;
            }
            if (def.equalsIgnoreCase("SPACE")) {
                return 1;
            }
        } else if (def.length() > 0) {
            return def.charAt(0);
        }
        return -1;
    }
}

