/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.util.JAXFrontProperties;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.X509TrustManager;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.apache.xerces.impl.dv.util.Base64;

public class HTTPSHelper {
    public static URLConnection buildHttpsConnection(URL serverURL) throws IOException {
        HttpsURLConnection connection = null;
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }

            public boolean isClientTrusted(X509Certificate[] arg0) {
                return true;
            }

            public boolean isServerTrusted(X509Certificate[] arg0) {
                return true;
            }
        }};
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance((String)"SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            LogRegistry.getInstance().error(HTTPSHelper.class, "exception when disabling trust authentication ###");
            e.printStackTrace();
        }
        HostnameVerifier hv = new HostnameVerifier(){

            public boolean verify(String urlHostName, SSLSession session) {
                LogRegistry.getInstance().error(class$com$jaxfront$core$util$HTTPSHelper == null ? (class$com$jaxfront$core$util$HTTPSHelper = HTTPSHelper.class$("com.jaxfront.core.util.HTTPSHelper")) : class$com$jaxfront$core$util$HTTPSHelper, "Warning: URL Host: " + urlHostName + " vs. " + session.getPeerHost());
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
        connection = (HttpsURLConnection)serverURL.openConnection();
        return connection;
    }

    public static URLConnection buildHttpConnection(URL serverURL) throws IOException {
        URLConnection connection = serverURL.openConnection();
        return connection;
    }

    public static URLConnection buildConnection(String serverURL) throws IOException {
        try {
            return HTTPSHelper.buildConnection(new URL(serverURL));
        }
        catch (MalformedURLException e) {
            LogRegistry.getInstance().error(HTTPSHelper.class, e);
            return null;
        }
    }

    public static URLConnection buildConnection(URL serverURL) throws IOException {
        URLConnection connection = null;
        connection = serverURL.toString().startsWith("https") || serverURL.toString().startsWith("HTTPS") ? HTTPSHelper.buildHttpsConnection(serverURL) : HTTPSHelper.buildHttpConnection(serverURL);
        return connection;
    }

    public static String requestServer(String serverURL, String content, boolean isZipped, String cookies) throws IOException {
        return HTTPSHelper.requestServer(new URL(serverURL), content, isZipped, cookies);
    }

    public static String requestServer(URL serverURL, String content, boolean isZipped, String cookies) throws IOException {
        String str;
        Date startTime = new Date();
        Date currentTime = new Date();
        long curTime = 0L;
        String responseString = "";
        URLConnection connection = HTTPSHelper.buildConnection(serverURL);
        if (connection == null) {
            LogRegistry.getInstance().error(HTTPSHelper.class, "Connection is null");
            return responseString;
        }
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        connection.setRequestProperty("Content-Type", "text/plain; charset=UTF-8");
        connection.setRequestProperty("Connection", "close");
        if (cookies != null) {
            connection.setRequestProperty("Cookie", cookies);
        }
        if (serverURL.getUserInfo() != null) {
            String hostName = serverURL.getHost();
            String authUser = serverURL.getUserInfo().substring(0, serverURL.getUserInfo().lastIndexOf(":"));
            String authPass = serverURL.getUserInfo().substring(serverURL.getUserInfo().lastIndexOf(":") + 1);
            String userAuth = authUser + ":" + authPass;
            connection.setRequestProperty("Authorization", "Basic " + Base64.encode((byte[])userAuth.getBytes()));
        }
        currentTime = new Date();
        curTime = currentTime.getTime() - startTime.getTime();
        if (LogRegistry.getInstance().logInfos()) {
            LogRegistry.getInstance().info(HTTPSHelper.class, "start sending data to:" + serverURL.toString() + " " + curTime);
        }
        DataOutputStream printout = new DataOutputStream(connection.getOutputStream());
        byte[] raw = content.getBytes("UTF-8");
        if (isZipped) {
            raw = JAXFrontProperties.zip(raw);
        }
        printout.write(raw);
        printout.flush();
        printout.close();
        currentTime = new Date();
        curTime = currentTime.getTime() - startTime.getTime();
        if (LogRegistry.getInstance().logInfos()) {
            LogRegistry.getInstance().info(HTTPSHelper.class, "data sent:" + curTime);
        }
        String encoding = connection.getContentEncoding();
        InputStream inputStream = null;
        inputStream = encoding != null && encoding.equalsIgnoreCase("gzip") ? new GZIPInputStream(connection.getInputStream()) : (encoding != null && encoding.equalsIgnoreCase("deflate") ? new InflaterInputStream(connection.getInputStream(), new Inflater(true)) : connection.getInputStream());
        DataInputStream input = new DataInputStream(inputStream);
        BufferedReader inputReader = new BufferedReader(new InputStreamReader(input));
        StringBuffer buffer = new StringBuffer();
        currentTime = new Date();
        curTime = currentTime.getTime() - startTime.getTime();
        if (LogRegistry.getInstance().logInfos()) {
            LogRegistry.getInstance().info(HTTPSHelper.class, "start reading server response:" + curTime);
        }
        while (null != (str = inputReader.readLine())) {
            buffer.append(str);
        }
        currentTime = new Date();
        curTime = currentTime.getTime() - startTime.getTime();
        if (LogRegistry.getInstance().logInfos()) {
            LogRegistry.getInstance().info(HTTPSHelper.class, "server response received:" + curTime);
        }
        input.close();
        return buffer.toString();
    }
}

