/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.jep.ArrayResult;
import com.jaxfront.core.log.Log4JLogRegistry;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.log.Logger;
import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.DefaultURLResourceResolver;
import com.jaxfront.core.util.DoubleKeyHashtable;
import com.jaxfront.core.util.DoubleKeyHashtableUnsynced;
import com.jaxfront.core.util.ImageHelper;
import com.jaxfront.core.util.LanguageEnhancedProperties;
import com.jaxfront.core.util.LastFile;
import com.jaxfront.core.util.Queue;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.util.URLHelper;
import com.jaxfront.core.util.URLResourceResolver;
import com.jaxfront.core.util.io.FileHelper;
import com.jaxfront.core.xui.NLS;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.apache.xerces.xni.parser.XMLParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JAXFrontProperties {
    private static final String CONST_VERSION_VARIABLE = "$version";
    private static final String CONST_DEPLOYMENT_TYPE = "$deployment";
    public static final String CONST_FIELD_SEPARATOR = ";";
    public static final String CONST_FIELD_PARAM_SEPARATOR = ",";
    private static final String CONST_LICENCE_TXT = "licence.txt";
    private static final String XML_CONST_VALUE_END = "</value>";
    private static final String XML_CONST_VALUE = "<value>";
    private static final String XML_CONST_KEY = "<key>";
    private static final String XML_CONST_KEY_END = "</key>";
    private static final String XML_CONST_PROPERTY_END = "</property>";
    private static final String XML_CONST_PROPERTIES_END = "</properties>";
    private static final String CONST_TRUE = "true";
    private static final String CONST_VALUE = "value";
    private static final String CONST_MUTABLE = "mutable";
    private static final String CONST_KEY = "key";
    private static final String CONST_PROPERTY = "property";
    private static final String CONST_PROPERTIES = "properties";
    private static final String CONST_NEWLINE = System.getProperty("line.separator");
    private static final String CONST_USER_DIR = System.getProperty("user.dir");
    private static final String CONST_USER_HOME = System.getProperty("user.home");
    private static String _license;
    private static Hashtable _nls;
    private boolean _isRunningAsXuiEditor = false;
    private boolean _ignoreNamespace = false;
    private int _handleOnlySpacesAsNull = -1;
    private boolean _ignoreXMLNamespaceDeclaration = false;
    private static JAXFrontProperties _singleton;
    private static Hashtable _singletons;
    private LanguageEnhancedProperties _userProperties;
    private Hashtable _properties;
    private Hashtable _mutableProperties;
    private DoubleKeyHashtable _localizedProperties = new DoubleKeyHashtableUnsynced();
    private Vector _lastFiles;
    private URL _lastOpenedFolder;
    private String[] _languages;
    private char _nLSTagDelimiter = (char)37;
    private Hashtable _guiMetrics = new Hashtable();
    public static boolean LOG_ENABLED;
    public String _logLevel = "error";
    private String[] _nlsLangSequence;
    public static final String PROPERTY_HTML_JAVASCRIPT_JAXFRONT = "jaxforms.html.jaxfrontJavaScript";
    public static final String PROPERTY_HTML_JAVASCRIPT_JAXFORMS = "jaxforms.html.jaxformsJavaScript";
    public static final String PROPERTY_HTML_STYLE_NAME_JAXFRONT = "jaxforms.html.jaxfrontStyleName";
    public static final String JAXFRONT_PROPERTY_LOCATION = "jaxfront.properties";
    public static final String JAXFRONT_RESOURCE_BASE = "jaxfront.resourceBase";
    public static final String PROPERTY_PROPERTY_FILE = "jaxfront.propertyFile";
    public static final String PROPERTY_URL_BASE = "jaxfront.urlbase";
    public static final String PROPERTY_IGNORE_NAMESPACE = "jaxfront.ignoreNameSpace";
    public static final String PROPERTY_URL_RESOLVER = "jaxfront.urlResolver";
    public static final String PROPERTY_USE_EMBEDDED_NLS = "jaxfront.useEmbeddedNLS";
    public static final String PROPERTY_LANGUAGES = "jaxfront.languages";
    public static final String PROPERTY_NLS_TAGDELiMITER = "jaxfront.nlsTagDelimiter";
    public static final String PROPERTY_PATTERN_DATE_TIME = "jaxfront.dateTime.pattern";
    public static final String PROPERTY_PATTERN_DATE = "jaxfront.date.pattern";
    public static final String PROPERTY_PATTERN_TIME = "jaxfront.time.pattern";
    public static final String PROPERTY_PATTERN_NUMBER_FORMAT = "jaxfront.number.pattern";
    public static final String PROPERTY_LANGUAGE_COUNTRY = "jaxfront.language.country";
    public static final String PROPERTY_LANGUAGE = "jaxfront.language";
    public static final String PROPERTY_FORCEDLANGUAGE = "jaxfront.forcedLanguage";
    public static final String PROPERTY_BIND_ONLY_AVAILABLE = "jaxfront.bindOnlyAvailable";
    public static final String PROPERTY_DEFAULT_FILE_ENCODING = "jaxfront.defaultFileEncoding";
    public static final String PROPERTY_DEFAULT_XMLFILE_ENCODING = "jaxfront.defaultXMLFileEncoding";
    public static final String PROPERTY_USE_NLS = "jaxfront.useNLS";
    public static final String PROPERTY_UI_FACTORY = "jaxfront.uiFactory";
    public static final String PROPERTY_DIRECTORY_LOCATION = "jaxfront.directory.location";
    public static final String PROPERTY_DIRECTORY_LOCATION_OFFLINE = "jaxfront.directory.location.offline";
    public static final String PROPERTY_DIRECTORY_XSD = "jaxfront.directory.xsd";
    public static final String PROPERTY_UI_USEGLOBALUIDEFINITIONS = "jaxfront.ui.useGlobalUIDefinitions";
    public static final String PROPERTY_UI_USE_XUICACHE = "jaxfront.ui.useXUICache";
    public static final String PROPERTY_UI_USE_XSDCACHE = "jaxfront.ui.useXSDCache";
    public static final String PROPERTY_SERIALIZE_XSD_URL_RELATIVE = "jaxfront.serialize.xsdURLRelative";
    public static final String PROPERTY_UI_USE_XUI_NAME_LOOKUP = "jaxfront.ui.useXUINameLookup";
    public static final String PROPERTY_UI_USE_EDITINGTYPE_CACHE = "jaxfront.useEditingTypeCache";
    public static final String PROPERTY_UI_USE_SQL_QUERY_CACHE = "jaxfront.useSQLQueryCache";
    public static final String PROPERTY_UI_SQL_QUERY_CACHE_SURVIVE_TIME = "jaxfront.SQLQueryCacheSurviveTime";
    public static final String PROPERTY_UI_USE_PERSISTENTIDGENERATOR = "jaxfront.usePersistentIdGenerator";
    public static final String PROPERTY_UI_USE_OPTIMIZED_XPATH_ENGINE = "jaxfront.useOptimizedXPathEngine";
    public static final String PROPERTY_UI_USE_XUI_PI_NAME_LOOKUP = "jaxfront.ui.useXUIPiNameLookup";
    public static final String PROPERTY_XUI_VERSION_CHECK_DISABLED = "jaxfront.xuiVersionCheckDisabled";
    public static final String PROPERTY_HTML_STYLE_NAME = "jaxfront.html.styleName";
    public static final String PROPERTY_UI_DISPLAY_ERROR_TEXT = "jaxfront.ui.displayErrorText";
    public static final String PROPERTY_HTML_USE_MDI = "jaxfront.html.useMDI";
    public static final String PROPERTY_HTML_SHOW_MDI = "jaxfront.html.showMDI";
    public static final String PROPERTY_HTML_USE_XSD_CONTROLLER_LOOKUP = "jaxfront.html.useXSDControllerLookup";
    public static final String PROPERTY_HTML_SERVLET_IMAGE_ROOTPATH = "jaxfront.html.servletImageRootPath";
    public static final String PROPERTY_UI_TOOLTIP_MAX_LENGTH = "jaxfront.ui.tooltipMaxLength";
    public static final String PROPERTY_UI_ALLOW_CUSTOM_XUI = "jaxfront.allowCustomXUI";
    public static final String PROPERTY_FONT_LABEL = "jaxfront.labelFont";
    public static final String PROPERTY_FONT_CAPTION = "jaxfront.captionFont";
    public static final String PROPERTY_FONT_HEADER = "jaxfront.headerFont";
    public static final String PROPERTY_FONT_HEADER_MODERN = "jaxfront.headerFontModern";
    public static final String PROPERTY_FONT_HEADER_CLASSIC = "jaxfront.headerFontClassic";
    public static final String PROPERTY_FONT_TREEENTRY = "jaxfront.treeEntryFont";
    public static final String PROPERTY_FONT_TREE_FOLDER = "jaxfront.treeFolderFont";
    public static final String PROPERTY_FONT_TAB = "jaxfront.tabFont";
    public static final String PROPERTY_FONT_TEXT = "jaxfront.textFont";
    public static final String PROPERTY_FONT_HINT = "jaxfront.hintFont";
    public static final String PROPERTY_FONT_MESSAGE = "jaxfront.messageFont";
    public static final String PROPERTY_FONT_COMBOBOX = "jaxfront.comboboxFont";
    public static final String PROPERTY_FONT_CHECKBOX = "jaxfront.checkboxFont";
    public static final String PROPERTY_FONT_CHECKBOX_ITEM = "jaxfront.checkboxItemFont";
    public static final String PROPERTY_FONT_BUTTON = "jaxfront.buttonFont";
    public static final String PROPERTY_FONT_RADIOBUTTON = "jaxfront.radioButtonFont";
    public static final String PROPERTY_FONT_LIST = "jaxfront.listFont";
    public static final String PROPERTY_FONT_TITLEBORDER = "jaxfront.titleBorderFont";
    public static final String PROPERTY_FONT_TABLE = "jaxfront.tableFont";
    public static final String PROPERTY_FONT_POPUP = "jaxfront.popupFont";
    public static final String PROPERTY_FONT_OPTIONPANE = "jaxfront.optionPaneFont";
    public static final String PROPERTY_FONT_MENU = "jaxfront.menuFont";
    public static final String PROPERTY_FONT_MENU_ITEM = "jaxfront.menuItemFont";
    public static final String PROPERTY_GUI_PERSISTENCY = "jaxfront.guiPersistency";
    public static final String PROPERTY_GUI_TOOLTIP_DELAY_TIME = "jaxfront.tooltipDelayTime";
    public static final String PROPERTY_GUI_TOOLTIP_DISCARD_TIME = "jaxfront.tooltipDiscardTime";
    public static final String PROPERTY_HTML_CONTROLLER = "jaxfront.html.controller";
    public static final String PROPERTY_HTML_POPUP_ACTION = "jaxfront.html.popUpAction";
    public static final String PROPERTY_HTML_POPUPANCHOR_ACTION = "jaxfront.html.popUpAnchorAction";
    public static final String PROPERTY_SYSTEM_EXIT = "jaxfront.systemExit";
    public static final String PROPERTY_ASK_FOREXIT = "jaxfront.askForExit";
    public static final String PROPERTY_FUNCTIONS_FILE = "jaxfront.functionsFile";
    public static String PROPERTY_DOC_URL;
    public static final String PROPERTY_LICENSE_LOCATION = "jaxfront.license.location";
    public static final String PROPERTY_HTML_LOCATION = "jaxfront.html.location";
    public static final String PROPERTY_FILESHARE_TEMP_LOCATION = "jaxfront.html.fileshare.templocation";
    public static final String PROPERTY_HTML_SERVER = "jaxfront.html.server";
    public static final String XUIEDITOR_RELEASE_SCHEMA_CACHE = "xuiEditor.releaseSchemaCache";
    public static final String XUIEDITOR_GLOBAL_TYPE_SETTINGS = "xuiEditor.showGlobalTypes";
    public static final String XUIEDITOR_SHOW_RULES_TREE = "xuiEditor.showRulesTree";
    public static final String XUIEDITOR_LOOK_AND_FEEL = "xuiEditor.lookAndFeel";
    public static final String XUIEDITOR_FRAME_BOUNDS = "xuiEditor.frameBounds";
    public static final String XUIEDITOR_EXPERT_MODE = "xuiEditor.expertMode";
    public static final String XUIEDITOR_SORT_XUICOMPONENTS = "xuieditor.sortXUIDefinitions";
    public static final String XUIEDITOR_TREE_SHOW_INSTANCE_DATA = "xuiEditor.tree.showInstanceData";
    public static final String XUIEDITOR_TREE_USE_ELEMENT_NAME_ONLY = "xuiEditor.tree.useElementNameOnly";
    public static final String XUIEDITOR_FORMLAYOUT_ROW_DEF = "xuiEditor.formlayout.rowDef";
    public static final String XUIEDITOR_FORMLAYOUT_COL_DEF = "xuiEditor.formlayout.colDef";
    public static final String XUIEDITOR_FORMLAYOUT_HEADER_DEF = "xuiEditor.formlayout.headerDef";
    public static final String XUIEDITOR_FORMLAYOUT_SEPCLASS_DEF = "xuiEditor.formlayout.sepClassicDef";
    public static final String XUIEDITOR_FORMLAYOUT_SEPMODERN_DEF = "xuiEditor.formlayout.sepModernDef";
    public static final String PROPERTY_SMTP_SERVER = "jaxfront.mail.smtpServer";
    public static final String PROPERTY_SMTP_SENDER_EMAIL = "jaxfront.mail.smtpSenderEmail";
    public static final String PROPERTY_SMTP_USER = "jaxfront.mail.smtpUser";
    public static final String PROPERTY_DEFAULT_VALUE_STARTMARKER = "jaxfront.defaultValue.startMarker";
    public static final String PROPERTY_DEFAULT_VALUE_ENDMARKER = "jaxfront.defaultValue.endMarker";
    public static final String PROPERTY_SMTP_PWD = "jaxfront.mail.smtpPWD";
    public static final String PROPERTY_JNDI_MAIL_LOOKUP = "jaxfront.jndiMailLookup";
    public static final String PROPERTY_SESSION_TIMEOUT = "jaxfront.html.sessionTimeout";
    public static final String XUIEDITOR_XUI_SCHEMA = "xuiEditor.schema";
    public static final String XUIEDITOR_XUI_XUI = "xuiEditor.xui";
    public static final String XUIEDITOR_XUI_ROOT = "xuiEditor.root";
    public static final String PROPERTY_LOGGING_TOOL = "jaxfront.logTool";
    public static final String PROPERTY_LOGGING_ENABLED = "jaxfront.log.enabled";
    public static final String PROPERTY_LOGGING_LEVEL = "jaxfront.log.level";
    public static final String PROPERTY_LAST_FILE = "jaxfront.lastFile";
    public static final String PROPERTY_LAST_TABLELAYOUTS = "jaxfront.lastTableLayouts";
    public static final String JAXFRONT_PROPERTIES_FILE_ENCODING = "UTF-8";
    public static final String PROPERTY_LAST_FILE_COUNTER = "jaxfront.lastFileCounter";
    private final String DEFAULT_FACTORY_CLASS_NAME = "com.jaxfront.swing.ui.visualizers.JavaSwingFactory";
    private static String _oSSystemEncoding;
    public static final String PROPERTY_INFO_PANE_AT_END = "eclipse.infoPaneAtEnd";
    private URL _jaxfrontXMLURL;
    private boolean _nlsReadingFieldScope = false;
    private static Boolean _isRunningAsServer;
    private Boolean _useGlobalUIDefinitions;
    private Boolean _useElementNameOnly;
    private Boolean _useEmbeddedNLS;
    private Boolean _useOptimizedXpathEngine = null;
    private Boolean _useEdTypeCache = null;
    private Boolean _usePersistentIDGenerator = null;
    private Boolean _useSQLQueryCache;
    private int _sQLQueryCacheSurviveTime = -1;
    public static final String PROPERTY_SERIALIZEPREVIEW_INSAMEWINDOW = "jaxfront.serializePreviewInSameWindow";
    public static final String PROPERTY_URL_COMMON_ADDITION = "url.common.addition";
    public static final String PROPERTY_USE_SECURE_PWD = "jaxforms.user.useSecurePWD";
    public static final String PROPERTY_PWD_PASSWORD_VALIDITY = "jaxforms.user.pwdValidity";
    public static final String PROPERTY_HTML_STYLE_NAME_JAXFORMS = "jaxforms.html.styleName";
    public static final String PROPERTY_USE_FEEDBACK = "jaxforms.useFeedback";
    private static final String PROPERTY_HANDLE_ONLY_SPACES_AS_NULL = "jaxfront.handleOnlySpacesAsNull";
    private static String DEFAULT_CONTEXT;
    private static boolean GLOBAL_USE_XUI_CACHE;
    private static boolean GLOBAL_USE_XSD_CACHE;
    private static boolean GLOBAL_USE_CODES_CACHE;
    private static boolean _registered;
    public static final String PROPERTY_MESSAGE_TABLE_CELL_RENDERER = "jaxfront.messageTableCellRenderer";
    public static final String DEFAULT_FORMS_JAXFRONT_CSS = "?action=getCSS&id=jaxfront.css";
    public static final String DEFAULT_FORMS_JAXFORMS_CSS = "?action=getCSS&id=jaxforms.css";
    public static final String DEFAULT_FORMS_JAXFRONT_JS = "?action=getJavaScript&id=jaxfront.js";
    public static final String DEFAULT_FORMS_JAXFORMS_JS = "?action=getJavaScript&id=jaxforms.js";

    public JAXFrontProperties() {
        this.init();
    }

    public URL getJAXFrontXMLURL() {
        return this._jaxfrontXMLURL;
    }

    private void initLocalProperties() {
        try {
            File propertiesFile = this.getLocalPropertyLocation();
            if (propertiesFile.exists()) {
                try {
                    System.out.println("JAXFront Property URL:" + propertiesFile.toString());
                    this.initProperties(propertiesFile.toURL());
                }
                catch (Exception ex) {
                    System.err.println(ex.getMessage());
                }
            } else if (this.isRunningAsXUIEditor()) {
                float version = Float.parseFloat("2.77");
                double previousVersion = (double)version - 0.1;
                String newVersion = TextTools.replace("2.77", ".", "_") + ".xml";
                String oldVersion = TextTools.replace(String.valueOf(previousVersion), ".", "_") + "0.xml";
                String oldFileName = TextTools.replace(propertiesFile.toURL().toExternalForm(), newVersion, oldVersion);
                URL oldURL = URLHelper.getUserURL(oldFileName);
                File oldFile = new File(oldURL.getFile());
                if (oldFile.exists()) {
                    try {
                        FileHelper.copy(oldFile, propertiesFile);
                        System.out.println("JAXFront Property URL:" + propertiesFile.toString());
                        this.initProperties(propertiesFile.toURL());
                    }
                    catch (Exception ex) {
                        System.err.println(ex.getMessage());
                    }
                }
            }
        }
        catch (Throwable t) {
            LogRegistry.getInstance().warn(this.getClass(), t.getMessage());
        }
    }

    public static String getDefaultValuePostFix() {
        return "";
    }

    public static String getDefaultValuePreFix() {
        return "";
    }

    public static String getFileVersion() {
        String version = "2.77";
        version = StringUtil.replace(version, ".", "_");
        return version;
    }

    public File getLocalPropertyLocation() {
        File propertyFile = null;
        String localPropertyLocation = null;
        String systemProperty = System.getProperty(PROPERTY_PROPERTY_FILE);
        localPropertyLocation = systemProperty == null ? this.getValue(PROPERTY_PROPERTY_FILE) : systemProperty;
        if (localPropertyLocation != null) {
            String fileName = localPropertyLocation;
            if (fileName.indexOf(CONST_VERSION_VARIABLE) >= 0) {
                fileName = StringUtil.replace(fileName, CONST_VERSION_VARIABLE, JAXFrontProperties.getFileVersion());
            }
            if (fileName.indexOf(CONST_DEPLOYMENT_TYPE) >= 0) {
                String systemDeploymentProperty = System.getProperty(CONST_DEPLOYMENT_TYPE);
                if (systemDeploymentProperty == null) {
                    systemDeploymentProperty = "";
                }
                fileName = StringUtil.replace(fileName, CONST_DEPLOYMENT_TYPE, systemDeploymentProperty);
            }
            String pathName = CONST_USER_HOME + File.separator + fileName;
            propertyFile = new File(pathName);
        }
        return propertyFile;
    }

    public void addProperty(String key, Object value) {
        this.addProperty(key, value, false);
    }

    public void addProperty(String key, Object value, boolean isMutable) {
        Vector temp = this.getProperties().containsKey(key) ? (Vector)this.getProperties().get(key) : new Vector();
        temp.addElement(value);
        this.getProperties().put(key, temp);
        if (isMutable) {
            this.getMutableProperties().put(key, key);
        }
    }

    public static String parseCountry(String languageDefinition) {
        int uSPos = languageDefinition.indexOf("_");
        String country = null;
        country = uSPos >= 0 ? languageDefinition.substring(uSPos + 1) : (languageDefinition.equals("en") ? Locale.US.getCountry() : (languageDefinition.equals("de") ? Locale.GERMANY.getCountry() : (languageDefinition.equals("fr") ? Locale.FRANCE.getCountry() : (languageDefinition.equals("it") ? Locale.ITALY.getCountry() : Locale.US.getCountry()))));
        return country;
    }

    public static String parseLanguage(String languageDefinition) {
        int uSPos = languageDefinition.indexOf("_");
        String language = null;
        language = uSPos >= 0 ? languageDefinition.substring(0, uSPos) : languageDefinition;
        return language;
    }

    private String createPropertyString(String key) {
        String indent = "        ";
        StringBuffer buffer = new StringBuffer();
        buffer.append("<property mutable=\"true\">");
        buffer.append(CONST_NEWLINE);
        buffer.append(indent);
        buffer.append(XML_CONST_KEY);
        buffer.append(key);
        buffer.append(XML_CONST_KEY_END);
        buffer.append(CONST_NEWLINE);
        List values = (List)this.getProperties().get(key);
        for (int i = 0; values != null && i < values.size(); ++i) {
            Object aValue = values.get(i);
            if (aValue == null) continue;
            StringTokenizer valueTokenizer = new StringTokenizer(aValue.toString(), CONST_FIELD_SEPARATOR);
            while (valueTokenizer.hasMoreElements()) {
                buffer.append(indent);
                buffer.append(XML_CONST_VALUE);
                buffer.append(valueTokenizer.nextElement().toString());
                buffer.append(XML_CONST_VALUE_END);
                buffer.append(CONST_NEWLINE);
            }
        }
        buffer.append(XML_CONST_PROPERTY_END);
        buffer.append(CONST_NEWLINE);
        return buffer.toString();
    }

    private String createPropertyString(Hashtable properties, String key) {
        if (properties.size() > 0) {
            String indent = "        ";
            StringBuffer buffer = new StringBuffer();
            buffer.append("<property mutable=\"true\">");
            buffer.append(CONST_NEWLINE);
            buffer.append(indent);
            buffer.append(XML_CONST_KEY);
            buffer.append(key);
            buffer.append(XML_CONST_KEY_END);
            buffer.append(CONST_NEWLINE);
            Enumeration guiKeys = this._guiMetrics.keys();
            while (guiKeys.hasMoreElements()) {
                String propertyKey = (String)guiKeys.nextElement();
                Object valObje = properties.get(propertyKey);
                buffer.append(indent);
                buffer.append(XML_CONST_VALUE);
                buffer.append(propertyKey);
                buffer.append(":");
                buffer.append(this.createPropertyRepresentationFromMem(valObje));
                buffer.append(XML_CONST_VALUE_END);
                buffer.append(CONST_NEWLINE);
            }
            buffer.append(XML_CONST_PROPERTY_END);
            buffer.append(CONST_NEWLINE);
            return buffer.toString();
        }
        return "";
    }

    public String createPropertyRepresentationFromMem(Object property) {
        if (property instanceof Rectangle) {
            Rectangle rprop = (Rectangle)property;
            return "x=" + rprop.x + ",y=" + rprop.y + ",width=" + rprop.width + ",height=" + rprop.height;
        }
        return property.toString();
    }

    public Rectangle createRectangleFromFile(String fileDefinition) {
        StringTokenizer rectDef = new StringTokenizer(fileDefinition, CONST_FIELD_PARAM_SEPARATOR);
        String defFragment = rectDef.nextToken();
        String x = defFragment.substring(defFragment.indexOf("=") + 1);
        defFragment = rectDef.nextToken();
        String y = defFragment.substring(defFragment.indexOf("=") + 1);
        defFragment = rectDef.nextToken();
        String width = defFragment.substring(defFragment.indexOf("=") + 1);
        defFragment = rectDef.nextToken();
        String height = defFragment.substring(defFragment.indexOf("=") + 1);
        return new Rectangle(Integer.parseInt(x), Integer.parseInt(y), Integer.parseInt(width), Integer.parseInt(height));
    }

    public boolean getBooleanProperty(String key) {
        String value = this.getStringProperty(key);
        return value != null && value.equals(CONST_TRUE);
    }

    public String getLabelFontDefinition() {
        return this.getStringProperty(PROPERTY_FONT_LABEL);
    }

    public String getTabFontDefinition() {
        return this.getStringProperty(PROPERTY_FONT_TAB);
    }

    public String getCheckboxFontDefinition() {
        return this.getStringProperty(PROPERTY_FONT_CHECKBOX);
    }

    public String getCheckboxItemFontDefinition() {
        return this.getStringProperty(PROPERTY_FONT_CHECKBOX_ITEM);
    }

    public String getTableFontDefinition() {
        return this.getStringProperty(PROPERTY_FONT_TABLE);
    }

    public String getPopupFontDefinition() {
        return this.getStringProperty(PROPERTY_FONT_POPUP);
    }

    public String getOptionPaneFontDefinition() {
        return this.getStringProperty(PROPERTY_FONT_OPTIONPANE);
    }

    public String getMenuFontDefinition() {
        return this.getStringProperty(PROPERTY_FONT_MENU);
    }

    public String getMenuItemFontDefinition() {
        return this.getStringProperty(PROPERTY_FONT_MENU_ITEM);
    }

    public String getComboboxFontDefinition() {
        return this.getStringProperty(PROPERTY_FONT_COMBOBOX);
    }

    public List getLogLevels() {
        return null;
    }

    public void setLogLevels(List logLevels) {
        this.getProperties().put(PROPERTY_LOGGING_LEVEL, logLevels);
    }

    public String getButtonFontDefinition() {
        return this.getStringProperty(PROPERTY_FONT_BUTTON);
    }

    public String getListFontDefinition() {
        return this.getStringProperty(PROPERTY_FONT_LIST);
    }

    public char getNLSTagDelimiter() {
        return this._nLSTagDelimiter;
    }

    public String getRadioButtonFontDefinition() {
        return this.getStringProperty(PROPERTY_FONT_RADIOBUTTON);
    }

    public String getHeaderFontDefinition() {
        return this.getStringProperty(PROPERTY_FONT_HEADER);
    }

    public String getHeaderFontModernDefinition() {
        return this.getStringProperty(PROPERTY_FONT_HEADER_MODERN);
    }

    public String getHeaderFontClassicDefinition() {
        return this.getStringProperty(PROPERTY_FONT_HEADER_CLASSIC);
    }

    public String getTitleBorderFontDefinition() {
        return this.getStringProperty(PROPERTY_FONT_TITLEBORDER);
    }

    public String getHintFontDefinition() {
        return this.getStringProperty(PROPERTY_FONT_HINT);
    }

    public String getMessageFontDefinition() {
        return this.getStringProperty(PROPERTY_FONT_MESSAGE);
    }

    public String getCaptionFontDefinition() {
        return this.getStringProperty(PROPERTY_FONT_CAPTION);
    }

    public String getTreeEntryFontDefinition() {
        return this.getStringProperty(PROPERTY_FONT_TREEENTRY);
    }

    public String getTreeEntryFolderFontDefinition() {
        return this.getStringProperty(PROPERTY_FONT_TREE_FOLDER);
    }

    public String getTextFieldFontDefinition() {
        return this.getStringProperty(PROPERTY_FONT_TEXT);
    }

    public String getDBVersionStoreName() {
        String version = TextTools.replace("2.77", ".", "");
        if (version.length() == 2) {
            version = version + "0";
        }
        return version;
    }

    public static synchronized JAXFrontProperties getInstance() {
        if (DEFAULT_CONTEXT != null) {
            return JAXFrontProperties.getInstance(DEFAULT_CONTEXT);
        }
        if (_singleton == null) {
            _singleton = new JAXFrontProperties();
        }
        return _singleton;
    }

    public static void setDefaultContext(String defaultContext) {
        DEFAULT_CONTEXT = defaultContext;
    }

    private static Hashtable getSingletons() {
        if (_singletons == null) {
            _singletons = new Hashtable();
        }
        return _singletons;
    }

    public static synchronized JAXFrontProperties getInstance(String context) {
        if (context == null) {
            return JAXFrontProperties.getInstance();
        }
        JAXFrontProperties props = (JAXFrontProperties)JAXFrontProperties.getSingletons().get(context);
        if (props == null) {
            props = new JAXFrontProperties();
            JAXFrontProperties.getSingletons().put(context, props);
        }
        return props;
    }

    public void registerDOMHandler(String xsd, String xml, String className) {
        String key = xsd + "__" + xml;
        this.getProperties().put(key, className);
    }

    public String getDOMHandler(String xsd, String xml) {
        String key = xsd + "__" + xml;
        return (String)this.getProperties().get(key);
    }

    public static boolean hasBeenRegistered(String context) {
        return _registered || JAXFrontProperties.getSingletons().get(context) != null;
    }

    public static void registerProperties(String context, Document dom) {
        try {
            if (dom != null) {
                if (context == null) {
                    _singleton = null;
                    JAXFrontProperties.getInstance().initProperties(dom);
                } else {
                    JAXFrontProperties properties = new JAXFrontProperties();
                    properties._properties = new Hashtable();
                    properties._properties.putAll(JAXFrontProperties.getInstance().getProperties());
                    properties.initProperties(dom);
                    JAXFrontProperties.getSingletons().put(context, properties);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void registerProperties(String context, URL url) {
        try {
            if (url != null) {
                if (context == null) {
                    _singleton = null;
                    _registered = true;
                    JAXFrontProperties.getInstance().initProperties(url);
                } else {
                    JAXFrontProperties properties = new JAXFrontProperties();
                    properties._properties = new Hashtable();
                    properties.initProperties(url);
                    JAXFrontProperties.getSingletons().put(context, properties);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LastFile getLastFile(String key) {
        Iterator iterator = this.getLastFiles().iterator();
        LastFile found = null;
        LastFile toCompare = null;
        while (iterator.hasNext() && found == null) {
            toCompare = (LastFile)iterator.next();
            if (toCompare.getXsdURL() == null || !toCompare.getXsdURL().toExternalForm().equals(key)) continue;
            found = toCompare;
        }
        return found;
    }

    public int getLastFileCounter() {
        String counter = this.getStringProperty(PROPERTY_LAST_FILE_COUNTER);
        if (counter != null) {
            try {
                return Integer.parseInt(counter);
            }
            catch (NumberFormatException ex) {
                return 5;
            }
        }
        return 5;
    }

    public Vector getLastFiles() {
        if (this._lastFiles == null) {
            this._lastFiles = new Vector();
        }
        return this._lastFiles;
    }

    public Queue getLastTableLayouts() {
        Object object = this.getProperties().get(PROPERTY_LAST_TABLELAYOUTS);
        Queue lastTLs = null;
        if (object instanceof Queue) {
            lastTLs = (Queue)object;
        } else {
            lastTLs = new Queue(10);
            this.getProperties().put(PROPERTY_LAST_TABLELAYOUTS, lastTLs);
        }
        return lastTLs;
    }

    public String getLicenseLocation() {
        return this.getStringProperty(PROPERTY_LICENSE_LOCATION);
    }

    private Hashtable getMutableProperties() {
        if (this._mutableProperties == null) {
            this._mutableProperties = new Hashtable();
        }
        return this._mutableProperties;
    }

    public boolean hasLanguageBeenChoosen() {
        return this.getMutableProperties().get(PROPERTY_LANGUAGE) != null;
    }

    private Hashtable getProperties() {
        if (this._properties == null) {
            InputStream tempStream;
            this._properties = new Hashtable();
            URL jaxfrontXML = null;
            String systemProperty = System.getProperty(JAXFRONT_PROPERTY_LOCATION);
            try {
                if (systemProperty != null) {
                    jaxfrontXML = URLHelper.getUserURL(systemProperty);
                    tempStream = jaxfrontXML.openStream();
                    tempStream.close();
                    System.out.println("jaxfront.xml loaded from: " + systemProperty);
                }
            }
            catch (Exception e) {
                System.out.println("Unable to load jaxfront.xml from: " + systemProperty);
            }
            if (!_registered && jaxfrontXML == null) {
                try {
                    jaxfrontXML = URLHelper.getUserURL(JAXFrontProperties.getPROPERTY_DOC_URL());
                    tempStream = jaxfrontXML.openStream();
                    tempStream.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                if (!_registered && jaxfrontXML == null) {
                    jaxfrontXML = URLHelper.getInternalURL(PROPERTY_DOC_URL);
                }
                if (jaxfrontXML != null) {
                    System.out.println("JAXFront Property URL:" + jaxfrontXML.toExternalForm());
                    this.initProperties(jaxfrontXML);
                }
                if (!JAXFrontProperties.isRunningAsServer()) {
                    this.initLocalProperties();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                LogRegistry.getInstance().error(this.getClass(), "unable to locate jaxfront.xml properties");
            }
        }
        return this._properties;
    }

    public static InputStream getRessource(String propertyPath) {
        InputStream ressourceStream = null;
        try {
            ressourceStream = URLHelper.openStream(new URL(propertyPath));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (ressourceStream == null) {
            ressourceStream = JAXFrontProperties.class.getClassLoader().getResourceAsStream(URLHelper.extractFileName(propertyPath));
        }
        return ressourceStream;
    }

    public String getStringProperty(String key) {
        String temp = this.getValue(key);
        return temp;
    }

    public String getUIFactoryClassName() {
        if (this.getStringProperty(PROPERTY_UI_FACTORY) == null) {
            this.setProperty(PROPERTY_UI_FACTORY, "com.jaxfront.swing.ui.visualizers.JavaSwingFactory", false);
        }
        return this.getStringProperty(PROPERTY_UI_FACTORY);
    }

    public String getURLBase() {
        return this.getStringProperty(PROPERTY_URL_BASE);
    }

    public URLResourceResolver getURLResolver() {
        Object urlResolverObj = this.getProperties().get("jaxfront.urlResolver_resolved");
        URLResourceResolver urlResolver = null;
        if (urlResolverObj instanceof List && ((List)urlResolverObj).size() > 0) {
            urlResolverObj = ((List)urlResolverObj).get(0);
        }
        if (urlResolverObj instanceof URLResourceResolver) {
            urlResolver = (URLResourceResolver)urlResolverObj;
        }
        if (urlResolver == null) {
            String urlResolverClassName = this.getStringProperty(PROPERTY_URL_RESOLVER);
            try {
                if (urlResolverClassName != null) {
                    Class<?> urlResolverClass = Class.forName(urlResolverClassName);
                    urlResolver = (URLResourceResolver)urlResolverClass.newInstance();
                } else {
                    urlResolver = new DefaultURLResourceResolver();
                }
            }
            catch (Throwable t) {
                if (LogRegistry.getInstance().logWarnings()) {
                    LogRegistry.getInstance().warn(this.getClass(), "Unable to instantiate own urlResolver: " + urlResolverClassName + " --> reason: " + t.getLocalizedMessage());
                }
                urlResolver = new DefaultURLResourceResolver();
            }
            this.getProperties().put("jaxfront.urlResolver_resolved", urlResolver);
        }
        return urlResolver;
    }

    public String getDirectoryXSD() {
        return this.getStringProperty(PROPERTY_DIRECTORY_XSD);
    }

    public String getDirectoryLocation() {
        return this.getStringProperty(PROPERTY_DIRECTORY_LOCATION);
    }

    public String getDirectoryLocationOffline() {
        return this.getStringProperty(PROPERTY_DIRECTORY_LOCATION_OFFLINE);
    }

    public String[] getLanguages() {
        if (this._languages == null) {
            Vector languages = this.getValues(PROPERTY_LANGUAGES);
            if (languages != null && languages.size() > 0) {
                this._languages = new String[languages.size()];
                languages.toArray(this._languages);
            } else {
                this._languages = new String[]{"de"};
            }
        }
        return this._languages;
    }

    public DoubleKeyHashtable getLocalizedProperties() {
        return this._localizedProperties;
    }

    public void setLanguages(String[] languages) {
        this._languages = languages;
    }

    public String getLanguage() {
        return this.getStringProperty(PROPERTY_LANGUAGE);
    }

    public String getLanguageCountry() {
        return this.getStringProperty(PROPERTY_LANGUAGE_COUNTRY);
    }

    public String getForcedLanguage() {
        return this.getStringProperty(PROPERTY_FORCEDLANGUAGE);
    }

    public int getToolTipMaxLength() {
        int max = 150;
        try {
            String toolTipMaxLengthString = this.getStringProperty(PROPERTY_UI_TOOLTIP_MAX_LENGTH);
            if (toolTipMaxLengthString != null) {
                max = Integer.parseInt(toolTipMaxLengthString);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return max;
    }

    public String getHTMLMandantStyleName() {
        return this.getStringProperty(PROPERTY_HTML_STYLE_NAME);
    }

    public String getJAXFormsMandantHTMLStyleName() {
        String style = this.getStringProperty(PROPERTY_HTML_STYLE_NAME_JAXFORMS);
        return style;
    }

    public boolean showTreeInstanceData() {
        return this.getBooleanProperty(XUIEDITOR_TREE_SHOW_INSTANCE_DATA);
    }

    public boolean serializeXSDUrlRelative() {
        return this.getBooleanProperty(PROPERTY_SERIALIZE_XSD_URL_RELATIVE);
    }

    public void setSerializeXSDUrlRelative(boolean relative) {
        this.setProperty(PROPERTY_SERIALIZE_XSD_URL_RELATIVE, Boolean.toString(relative), false);
    }

    public boolean sortXUIDefinitions() {
        return this.getBooleanProperty(XUIEDITOR_SORT_XUICOMPONENTS);
    }

    public void setSortXUIDefinitions(boolean sort) {
        this.setProperty(XUIEDITOR_SORT_XUICOMPONENTS, sort + "", false);
    }

    public boolean useElementNameOnly() {
        if (this._useElementNameOnly == null) {
            this._useElementNameOnly = new Boolean(this.getBooleanProperty(XUIEDITOR_TREE_USE_ELEMENT_NAME_ONLY));
        }
        return this._useElementNameOnly;
    }

    public boolean useEmbeddedNLS() {
        if (this._useEmbeddedNLS == null) {
            this._useEmbeddedNLS = new Boolean(this.getBooleanProperty(PROPERTY_USE_EMBEDDED_NLS));
        }
        return this._useEmbeddedNLS;
    }

    public static byte[] zip(byte[] value) throws IOException {
        int read = 0;
        byte[] data = new byte[1024];
        ByteArrayInputStream byteIn = new ByteArrayInputStream(value);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPOutputStream out = new GZIPOutputStream(bos);
        while ((read = byteIn.read(data, 0, 1024)) != -1) {
            out.write(data, 0, read);
        }
        byteIn.close();
        out.close();
        bos.close();
        bos.flush();
        return bos.toByteArray();
    }

    public static byte[] unZip(byte[] value) throws IOException {
        ByteArrayInputStream byteIn = new ByteArrayInputStream(value);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPInputStream zipIn = new GZIPInputStream(byteIn);
        byte[] rgb = new byte[1024];
        int readCounter = 0;
        while ((readCounter = zipIn.read(rgb)) > -1) {
            bos.write(rgb, 0, readCounter);
        }
        bos.flush();
        return bos.toByteArray();
    }

    public static void printSwingDefaults() {
        String lineSep = System.getProperty("line.separator");
        UIDefaults uid = UIManager.getDefaults();
        Enumeration uidKeys = uid.keys();
        StringBuffer buff = null;
        buff = new StringBuffer();
        while (uidKeys.hasMoreElements()) {
            Object aKey = uidKeys.nextElement();
            Object aValue = uid.get(aKey);
            String str = "KEY: " + aKey + ", VALUE: " + aValue + lineSep;
            buff.append(str);
        }
        System.out.println(buff.toString());
    }

    public static void printSystemProperties() {
        String lineSep = System.getProperty("line.separator");
        Properties props = System.getProperties();
        Enumeration<Object> uidKeys = props.keys();
        StringBuffer buff = null;
        buff = new StringBuffer();
        while (uidKeys.hasMoreElements()) {
            Object aKey = uidKeys.nextElement();
            Object aValue = props.get(aKey);
            String str = "KEY: " + aKey + ", VALUE: " + aValue + lineSep;
            buff.append(str);
        }
        System.out.println(buff.toString());
    }

    public String getHTMLServletLocation() {
        return this.getStringProperty(PROPERTY_HTML_LOCATION);
    }

    public String getFileShareTempLocation() {
        return this.getStringProperty(PROPERTY_FILESHARE_TEMP_LOCATION);
    }

    public void setFileShareTempLocation(String tempLocation) {
        this.setMutableProperty(PROPERTY_FILESHARE_TEMP_LOCATION, tempLocation);
    }

    public String getServletImageRootPath() {
        return this.getStringProperty(PROPERTY_HTML_SERVLET_IMAGE_ROOTPATH);
    }

    public String getHTMLController() {
        return this.getStringProperty(PROPERTY_HTML_CONTROLLER);
    }

    public String getSMTPServer() {
        return this.getStringProperty(PROPERTY_SMTP_SERVER);
    }

    public String getSMTPSenderEmail() {
        return this.getStringProperty(PROPERTY_SMTP_SENDER_EMAIL);
    }

    public String getSMTPUser() {
        return this.getStringProperty(PROPERTY_SMTP_USER);
    }

    public String getSMTPPWD() {
        return this.getStringProperty(PROPERTY_SMTP_PWD);
    }

    public String getHTMLPopUpAction() {
        return this.getStringProperty(PROPERTY_HTML_POPUP_ACTION);
    }

    public String getHTMLPopUpAnchorAction() {
        return this.getStringProperty(PROPERTY_HTML_POPUPANCHOR_ACTION);
    }

    public String getHTMLServerLocation() {
        String location = this.getStringProperty(PROPERTY_HTML_SERVER);
        if (location == null) {
            location = System.getProperty("user.dir") + File.separator + "html-renderer";
        }
        return location;
    }

    public LanguageEnhancedProperties getUserProperties() {
        if (this._userProperties == null) {
            this._userProperties = new LanguageEnhancedProperties();
            this._userProperties.put("JAXFRONT_VERSION", "2.77");
            this._userProperties.put("LANGUAGES", new ArrayResult(this.getLanguages()));
        }
        return this._userProperties;
    }

    public String getUserProperty(String key) {
        return this.getUserProperties().getProperty(key);
    }

    public String getValue(String key) {
        Vector values = (Vector)this.getProperties().get(key);
        if (values != null && values.size() > 0) {
            return values.get(0).toString();
        }
        return null;
    }

    public Vector getValues(String key) {
        return (Vector)this.getProperties().get(key);
    }

    private void initLastFiles(Vector values) {
        if (this.isRunningAsXUIEditor() && values != null) {
            LastFile defaultLastFile = null;
            if (this.getLastFiles().size() > 0) {
                defaultLastFile = (LastFile)this.getLastFiles().remove(0);
            }
            for (int i = 0; i < values.size(); ++i) {
                LastFile lastFile = new LastFile((String)values.get(i));
                this.setLastFile(lastFile);
            }
            if (defaultLastFile != null) {
                this.setLastFile(defaultLastFile);
            }
        }
    }

    private void initLastTableLayouts(Vector values) {
        if (this.isRunningAsXUIEditor()) {
            Queue lastTLs = new Queue(10);
            if (values != null) {
                for (int i = 0; i < values.size(); ++i) {
                    try {
                        String tll = (String)values.get(i);
                        StringTokenizer st = new StringTokenizer(tll, CONST_FIELD_PARAM_SEPARATOR);
                        while (st.hasMoreElements()) {
                            lastTLs.enqueue(new URL(st.nextToken()));
                        }
                        continue;
                    }
                    catch (MalformedURLException e) {
                        // empty catch block
                    }
                }
            }
            this.getProperties().put(PROPERTY_LAST_TABLELAYOUTS, lastTLs);
            this.getMutableProperties().put(PROPERTY_LAST_TABLELAYOUTS, PROPERTY_LAST_TABLELAYOUTS);
        }
    }

    private void init() {
        String saxDriverProperty = null;
        try {
            saxDriverProperty = System.getProperty("org.xml.sax.driver");
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (saxDriverProperty == null) {
            try {
                Class<?> stringClass = Class.forName("java.lang.String");
                Class.forName("java.lang.System").getMethod("setProperty", stringClass, stringClass).invoke(null, "org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private synchronized void initProperties(Document dom) throws XMLParseException, SAXException, IOException {
        NodeList nodes = null;
        if (dom != null) {
            Vector lastFiles;
            nodes = dom.getElementsByTagName(CONST_PROPERTIES);
            if (nodes != null && nodes.getLength() > 0) {
                Element properties = (Element)nodes.item(0);
                NodeList childs = properties.getElementsByTagName(CONST_PROPERTY);
                for (int i = 0; i < childs.getLength(); ++i) {
                    Node property = childs.item(i);
                    if (property.getNodeType() != 1) continue;
                    NodeList keys = ((Element)property).getElementsByTagName(CONST_KEY);
                    String mutable = ((Element)property).getAttribute(CONST_MUTABLE);
                    NodeList values = ((Element)property).getElementsByTagName(CONST_VALUE);
                    Vector<String> temp = new Vector<String>();
                    Vector<String> tempLangs = new Vector<String>();
                    for (int j = 0; j < values.getLength(); ++j) {
                        if (values.item(j) == null || values.item(j).getFirstChild() == null) continue;
                        tempLangs.addElement(((Element)values.item(j)).getAttribute("language"));
                        temp.addElement(values.item(j).getFirstChild().getNodeValue());
                    }
                    if (keys == null || keys.getLength() <= 0) continue;
                    String keyValue = keys.item(0).getFirstChild().getNodeValue();
                    System.out.println("Initialize JAXFront Property: " + keyValue + " value: " + temp);
                    if (!this.dispatchSpezial(keyValue, temp, tempLangs)) {
                        this.getProperties().put(keyValue, temp);
                    }
                    if (mutable == null || !mutable.equals(CONST_TRUE)) continue;
                    this.getMutableProperties().put(keyValue, keyValue);
                }
            }
            if ((lastFiles = (Vector)this._properties.get(PROPERTY_LAST_FILE)) == null) {
                this._properties.put(PROPERTY_LAST_FILE, new Vector());
            }
        }
    }

    private synchronized void initProperties(URL propertyLocation) throws XMLParseException, SAXException, IOException {
        System.out.println("init properties from:" + propertyLocation.toExternalForm());
        Document dom = null;
        InputStream is = URLHelper.openStream(propertyLocation);
        if (is != null) {
            dom = DOMHelper.createDocument(is);
        }
        this.initProperties(dom);
    }

    private void initLocalizedPatterns(String key, Vector values, Vector langs) {
        for (int i = 0; i < values.size(); ++i) {
            String entry = (String)values.get(i);
            String langEntry = (String)langs.get(i);
            this._localizedProperties.put(key, langEntry, entry);
        }
    }

    private void applyLogging(String keyValue, Vector values) {
        String[] logLevels = ArrayUtil.toStringArray(values);
        Logger logger = LogRegistry.getInstance().getLogger();
        LOG_ENABLED = true;
        if (logger instanceof Log4JLogRegistry) {
            ((Log4JLogRegistry)logger).setLogLevels(logLevels);
        } else {
            logger.setLogLevels(logLevels);
        }
    }

    private boolean dispatchSpezial(String keyValue, Vector values, Vector langs) {
        boolean dispatched = false;
        try {
            if (values.size() > 0) {
                if (keyValue.equals(PROPERTY_NLS_TAGDELiMITER)) {
                    if (values.firstElement().toString().length() > 0) {
                        this._nLSTagDelimiter = values.firstElement().toString().charAt(0);
                    }
                    dispatched = true;
                } else if (keyValue.equals(PROPERTY_IGNORE_NAMESPACE)) {
                    this._ignoreNamespace = CONST_TRUE.equalsIgnoreCase(values.get(0).toString());
                    dispatched = true;
                } else if (keyValue.equals(PROPERTY_LAST_FILE)) {
                    this.initLastFiles(values);
                    dispatched = true;
                } else if (keyValue.equals(PROPERTY_PATTERN_DATE)) {
                    this.initLocalizedPatterns(keyValue, values, langs);
                    dispatched = true;
                } else if (keyValue.equals(PROPERTY_PATTERN_TIME)) {
                    this.initLocalizedPatterns(keyValue, values, langs);
                    dispatched = true;
                } else if (keyValue.equals(PROPERTY_PATTERN_DATE_TIME)) {
                    this.initLocalizedPatterns(keyValue, values, langs);
                    dispatched = true;
                } else if (keyValue.equals(PROPERTY_PATTERN_NUMBER_FORMAT)) {
                    this.initLocalizedPatterns(keyValue, values, langs);
                    dispatched = true;
                } else if (keyValue.equals(PROPERTY_LAST_TABLELAYOUTS)) {
                    this.initLastTableLayouts(values);
                    dispatched = true;
                } else if (keyValue.equals(PROPERTY_LOGGING_ENABLED)) {
                    LOG_ENABLED = CONST_TRUE.equalsIgnoreCase(values.get(0).toString());
                    dispatched = true;
                } else if (keyValue.equals(PROPERTY_LOGGING_LEVEL)) {
                    if (values.size() > 0) {
                        this._logLevel = values.get(0).toString();
                        if (this._logLevel == null || this._logLevel.equals("")) {
                            this._logLevel = "error";
                        }
                        this.getProperties().put(keyValue, values);
                        this.applyLogging(keyValue, values);
                    }
                    dispatched = true;
                } else if (keyValue.equals(PROPERTY_GUI_PERSISTENCY)) {
                    for (int i = 0; i < values.size(); ++i) {
                        String propLine = (String)values.get(i);
                        int valueStartPos = propLine.indexOf(":");
                        String key = propLine.substring(0, valueStartPos);
                        this._guiMetrics.put(key, this.createRectangleFromFile(propLine.substring(valueStartPos + 1)));
                    }
                    dispatched = true;
                }
            }
        }
        catch (Exception e) {
            LogRegistry.getInstance().error(this.getClass(), e);
        }
        return dispatched;
    }

    public boolean isRunningAsXUIEditor() {
        return this._isRunningAsXuiEditor;
    }

    public boolean isUsingDefaultUIFactory() {
        return this.getStringProperty(PROPERTY_UI_FACTORY).equals("com.jaxfront.swing.ui.visualizers.JavaSwingFactory");
    }

    public void cleanupUserProperties() {
        try {
            File propertyFile = this.getLocalPropertyLocation();
            this.removeFile(propertyFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.getMutableProperties().clear();
    }

    public void releaseUserProperties() {
        this._userProperties = null;
    }

    public void removeFile(File file) throws IOException {
        if (file.exists()) {
            if (file.canWrite()) {
                file.delete();
            } else {
                throw new IOException("Can't write file:" + file.toURL().toExternalForm());
            }
        }
    }

    public void save() throws IOException {
        File propertyFile = this.getLocalPropertyLocation();
        LogRegistry.getInstance().log(this.getClass(), "UPDATE PROPERTIES: " + propertyFile.getPath());
        this.removeFile(propertyFile);
        this.updateProperties();
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"" + JAXFrontProperties.getDefaultXMLFileEncoding() + "\"?>\n");
        buffer.append("<properties xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"property.xsd\">");
        buffer.append(CONST_NEWLINE);
        Enumeration mutableProps = this.getMutableProperties().keys();
        while (mutableProps.hasMoreElements()) {
            Object keyObject = mutableProps.nextElement();
            if (keyObject == null) continue;
            buffer.append(this.createPropertyString(keyObject.toString()));
        }
        buffer.append(this.createPropertyString(this._guiMetrics, PROPERTY_GUI_PERSISTENCY));
        buffer.append(XML_CONST_PROPERTIES_END);
        DOMHelper.write(buffer, propertyFile);
    }

    public void setLastFile(LastFile lastFile) {
        if (lastFile != null) {
            LastFile found;
            if (lastFile.getXsdURL() != null && (found = this.getLastFile(lastFile.getXsdURL().toExternalForm())) != null) {
                this.getLastFiles().remove(found);
            }
            this.getLastFiles().add(lastFile);
        }
    }

    public void setLicenseLocaction(String fileLocation) {
        this.setProperty(PROPERTY_LICENSE_LOCATION, fileLocation, false, true);
    }

    public void setUseEmbeddedNLS(boolean useEmbeddedNLS) {
        this._useEmbeddedNLS = useEmbeddedNLS;
        this.setProperty(PROPERTY_USE_EMBEDDED_NLS, String.valueOf(useEmbeddedNLS), false, false);
        if (useEmbeddedNLS) {
            this.setUsingXUICache(true);
        }
    }

    public void setRunningAsXUIEditor(boolean runningAsXUIEditor) {
        this._isRunningAsXuiEditor = runningAsXUIEditor;
    }

    public void setProperty(String key, Object value) {
        this.setProperty(key, value, false);
    }

    private void setProperty(String key, Object value, boolean allowMultiple) {
        this.setProperty(key, value, allowMultiple, false);
    }

    private void setProperty(String key, Object value, boolean allowMultiple, boolean isMutable) {
        if (allowMultiple) {
            this.addProperty(key, value);
        } else {
            Vector<Object> tempVector = new Vector<Object>();
            tempVector.add(value);
            this.getProperties().put(key, tempVector);
        }
        if (isMutable) {
            this.getMutableProperties().put(key, key);
        }
    }

    public void setUIFactoryClassName(String className) {
        this.setProperty(PROPERTY_UI_FACTORY, className, false);
    }

    public boolean allowCustomXUI() {
        return this.getBooleanProperty(PROPERTY_UI_ALLOW_CUSTOM_XUI);
    }

    public void setURLBase(String urlBase) {
        this.setProperty(PROPERTY_URL_BASE, urlBase, false);
    }

    public void setLastOpenedFolder(URL lastOpenedFolder) {
        if (lastOpenedFolder != null) {
            try {
                this._lastOpenedFolder = new File(new File(lastOpenedFolder.getFile()).getPath()).toURL();
            }
            catch (MalformedURLException e) {
                LogRegistry.getInstance().error(this.getClass(), e);
            }
        }
    }

    public URL getLastOpenedFolder() {
        if (this._lastOpenedFolder == null) {
            try {
                this._lastOpenedFolder = new File(new File(CONST_USER_DIR).getPath()).toURL();
            }
            catch (MalformedURLException e) {
                LogRegistry.getInstance().error(this.getClass(), e);
            }
        }
        return this._lastOpenedFolder;
    }

    public void setUserProperty(String key, String value) {
        this.getUserProperties().setProperty(key, value);
    }

    public void setUserProperties(Map values) {
        this.getUserProperties().putAll(values);
    }

    public boolean systemExitOnClose() {
        String value;
        if (this._properties.containsKey(PROPERTY_SYSTEM_EXIT) && (value = this.getStringProperty(PROPERTY_SYSTEM_EXIT)) != null) {
            return new Boolean(value);
        }
        return true;
    }

    public boolean askForExit() {
        String value;
        if (this._properties.containsKey(PROPERTY_ASK_FOREXIT) && (value = this.getStringProperty(PROPERTY_ASK_FOREXIT)) != null) {
            Boolean booleanValue = new Boolean(value);
            return booleanValue;
        }
        return true;
    }

    public void setAskForExit(boolean ask) {
        this.setProperty(PROPERTY_ASK_FOREXIT, ask + "", false);
    }

    private void updateLastFileProperties() {
        if (!this.getLastFiles().isEmpty()) {
            Vector sort = new Vector();
            for (int i = this.getLastFiles().size() - 1; i >= 0; --i) {
                sort.add(this.getLastFiles().get(i));
            }
            Vector lastFiles = (Vector)this._properties.get(PROPERTY_LAST_FILE);
            if (lastFiles != null) {
                lastFiles.removeAllElements();
                int index = Math.min(this.getLastFileCounter(), sort.size());
                for (int i = 0; i < index; ++i) {
                    lastFiles.add(sort.get(i));
                }
                this.getMutableProperties().put(PROPERTY_LAST_FILE, lastFiles);
            }
        } else {
            this.getMutableProperties().remove(PROPERTY_LAST_FILE);
        }
    }

    private void updateProperties() {
        this.updateLastFileProperties();
    }

    public NLS getNLS() {
        return this.getNLS(null);
    }

    public NLS getNLS(String language) {
        NLS nls;
        block6: {
            if (language == null) {
                language = this.getLanguage();
            }
            if (_nls == null) {
                _nls = new Hashtable();
            }
            if ((nls = (NLS)_nls.get(language)) == null) {
                nls = new NLS();
                String nlsFileName = "xui_" + language + ".nls";
                URL nlsURL = URLHelper.getInternalURL(nlsFileName);
                if (nlsURL != null) {
                    try {
                        nls.load(new InputStreamReader(JAXFrontProperties.getRessource(nlsURL.toString()), JAXFrontProperties.getDefaultFileEncoding()));
                        _nls.put(language, nls);
                    }
                    catch (IOException ex) {
                        if (!LogRegistry.getInstance().logWarnings()) break block6;
                        LogRegistry.getInstance().warn(JAXFrontProperties.class, "unable to load NLS (" + nlsFileName + ") --> using default language (en) instead");
                    }
                }
            }
        }
        return nls;
    }

    public static String getLicenceText() {
        ClassLoader cl;
        URL textURL;
        if (_license == null && (textURL = (cl = JAXFrontProperties.class.getClassLoader()).getResource(CONST_LICENCE_TXT)) != null) {
            try {
                int ch;
                InputStream is = URLHelper.openStream(textURL);
                BufferedReader in = new BufferedReader(new InputStreamReader(is));
                char[] data = new char[is.available()];
                int index = 0;
                while ((ch = in.read()) != -1) {
                    data[index] = (char)ch;
                    ++index;
                }
                _license = new String(data, 0, index);
                in.close();
            }
            catch (IOException ex) {
                _license = "no licence text available.";
            }
        }
        return _license;
    }

    public void setMutableProperty(String key, String value) {
        this.setProperty(key, value, false, true);
    }

    public void removeMutableProperty(String key) {
        this.getMutableProperties().remove(key);
    }

    public boolean isUsingGlobalUIDefinitions() {
        if (this._useGlobalUIDefinitions == null) {
            this._useGlobalUIDefinitions = new Boolean(this.getBooleanProperty(PROPERTY_UI_USEGLOBALUIDEFINITIONS));
        }
        return this._useGlobalUIDefinitions;
    }

    public void setUsingGlobalUIDefinitions(boolean use) {
        this._useGlobalUIDefinitions = use;
    }

    public boolean isUsingXUICache() {
        if (!GLOBAL_USE_XUI_CACHE) {
            return false;
        }
        return this.getBooleanProperty(PROPERTY_UI_USE_XUICACHE);
    }

    public static boolean isUsingCodesCacheGlobal() {
        return GLOBAL_USE_CODES_CACHE;
    }

    public boolean isUsingXSDCache() {
        if (!GLOBAL_USE_XSD_CACHE) {
            return false;
        }
        String value = this.getStringProperty(PROPERTY_UI_USE_XSDCACHE);
        return value == null || value.equals(CONST_TRUE);
    }

    public boolean isUsingMDI() {
        return this.getBooleanProperty(PROPERTY_HTML_USE_MDI);
    }

    public boolean displayErrorText() {
        return this.getBooleanProperty(PROPERTY_UI_DISPLAY_ERROR_TEXT);
    }

    public boolean isUsingFeedback() {
        return this.getBooleanProperty(PROPERTY_USE_FEEDBACK);
    }

    public boolean isShowingMDI() {
        return this.getBooleanProperty(PROPERTY_HTML_SHOW_MDI);
    }

    public boolean isUsingXSDControllerLookup() {
        return this.getBooleanProperty(PROPERTY_HTML_USE_XSD_CONTROLLER_LOOKUP);
    }

    public static void setUsingXUICacheGlobal(boolean useCache) {
        GLOBAL_USE_XUI_CACHE = useCache;
    }

    public static void setUsingCODESCacheGlobal(boolean useCache) {
        GLOBAL_USE_CODES_CACHE = useCache;
    }

    public static void setUsingXSDCacheGlobal(boolean useCache) {
        GLOBAL_USE_XSD_CACHE = useCache;
    }

    public void setUsingXUICache(boolean useXUICache) {
        this.setProperty(PROPERTY_UI_USE_XUICACHE, String.valueOf(useXUICache), false);
    }

    public void setUsingXSDCache(boolean useCache) {
        this.setProperty(PROPERTY_UI_USE_XSDCACHE, String.valueOf(useCache), false);
    }

    public void setUsingMDI(boolean useMDI) {
        this.setProperty(PROPERTY_HTML_USE_MDI, String.valueOf(useMDI), false);
    }

    public void setDisplayErrorText(boolean display) {
        this.setProperty(PROPERTY_UI_DISPLAY_ERROR_TEXT, String.valueOf(display), false);
    }

    public void setShowingMDI(boolean show) {
        this.setProperty(PROPERTY_HTML_SHOW_MDI, String.valueOf(show), false);
    }

    public void setHTMLController(String domHandlerClass) {
        this.setProperty(PROPERTY_HTML_CONTROLLER, domHandlerClass, false);
    }

    public void setUsingXSDControllerLookup(boolean useXSDControllerLookup) {
        this.setProperty(PROPERTY_HTML_USE_XSD_CONTROLLER_LOOKUP, String.valueOf(useXSDControllerLookup), false);
    }

    public void setNLSTagDelimiter(char tagDelimiter) {
        this._nLSTagDelimiter = tagDelimiter;
    }

    public static String getOSSystemEncoding() {
        if (_oSSystemEncoding == null) {
            _oSSystemEncoding = new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding();
        }
        return _oSSystemEncoding;
    }

    public static String getDefaultFileEncoding() {
        String encoding = JAXFrontProperties.getInstance().getStringProperty(PROPERTY_DEFAULT_FILE_ENCODING);
        encoding = encoding != null ? encoding : JAXFRONT_PROPERTIES_FILE_ENCODING;
        return encoding;
    }

    public void putGUIMetrics(Component comp) {
        Rectangle compBounds = comp.getBounds();
        if (!(comp instanceof Window) && comp.getParent() != null) {
            Rectangle parentBounds = comp.getParent().getBounds();
            int minX = compBounds.x - parentBounds.x;
            int minY = compBounds.y - parentBounds.y;
            int width = compBounds.width;
            int height = compBounds.height;
            compBounds = new Rectangle(minX < 0 ? 0 : minX, minY < 0 ? 0 : minY, width, height);
            System.out.println(compBounds);
        }
        this._guiMetrics.put(comp.getName(), compBounds);
    }

    public Rectangle getGUIMetrics(Component comp) {
        Rectangle rect = this.getGUIMetrics(comp.getName());
        return rect;
    }

    public void removeGUIMetrics(Component comp) {
        this._guiMetrics.remove(comp.getName());
    }

    public Rectangle getGUIMetrics(String compName) {
        return (Rectangle)this._guiMetrics.get(compName);
    }

    public void releaseGUIMetrics() {
        this._guiMetrics.clear();
        this._guiMetrics = new Hashtable();
    }

    public static String getDefaultXMLFileEncoding() {
        String encoding = JAXFrontProperties.getInstance().getStringProperty(PROPERTY_DEFAULT_XMLFILE_ENCODING);
        encoding = encoding != null ? encoding : JAXFRONT_PROPERTIES_FILE_ENCODING;
        return encoding;
    }

    public boolean isUsingNLS() {
        return this.getBooleanProperty(PROPERTY_USE_NLS);
    }

    public boolean isReleaseSchemaChache() {
        return this.getBooleanProperty(XUIEDITOR_RELEASE_SCHEMA_CACHE);
    }

    public String getFunctionFileLocation() {
        return this.getStringProperty(PROPERTY_FUNCTIONS_FILE);
    }

    public boolean isShowingGloablTree() {
        return this.getBooleanProperty(XUIEDITOR_GLOBAL_TYPE_SETTINGS);
    }

    public boolean isShowingRulesTree() {
        return this.getBooleanProperty(XUIEDITOR_SHOW_RULES_TREE);
    }

    public boolean isBindingOnlyAvailable() {
        return this.getBooleanProperty(PROPERTY_BIND_ONLY_AVAILABLE);
    }

    public boolean isExpertMode() {
        return this.getBooleanProperty(XUIEDITOR_EXPERT_MODE);
    }

    public void setExpertMode(boolean expert) {
        this.setMutableProperty(XUIEDITOR_EXPERT_MODE, String.valueOf(expert));
    }

    public String getLookAndFeel() {
        return this.getStringProperty(XUIEDITOR_LOOK_AND_FEEL);
    }

    public JFrame createDialogFrame() {
        JFrame _dialogFrame = new JFrame();
        ImageIcon iconWhite = ImageHelper.getInstance().getImageIcon("com/jaxfront/core/images/files/xcentric_16x16.gif");
        _dialogFrame.setIconImage(iconWhite.getImage());
        return _dialogFrame;
    }

    public Rectangle getFrameBounds(String bounds) {
        if (bounds != null) {
            StringTokenizer st = new StringTokenizer(bounds, CONST_FIELD_PARAM_SEPARATOR);
            String[] boundArray = new String[st.countTokens()];
            int counter = 0;
            while (st.hasMoreElements()) {
                boundArray[counter] = st.nextToken();
                ++counter;
            }
            if (boundArray.length == 4) {
                int x = Integer.valueOf(boundArray[0]);
                int y = Integer.valueOf(boundArray[1]);
                int width = Integer.valueOf(boundArray[2]);
                int height = Integer.valueOf(boundArray[3]);
                return new Rectangle(x, y, width, height);
            }
        }
        return new Rectangle(0, 0, 800, 600);
    }

    public Rectangle getFrameBounds() {
        return this.getFrameBounds(this.getStringProperty(XUIEDITOR_FRAME_BOUNDS));
    }

    public void setFrameBounds(Rectangle bounds) {
        if (bounds != null) {
            String frameBounds = bounds.x + CONST_FIELD_PARAM_SEPARATOR + bounds.y + CONST_FIELD_PARAM_SEPARATOR + bounds.width + CONST_FIELD_PARAM_SEPARATOR + bounds.height;
            this.setMutableProperty(XUIEDITOR_FRAME_BOUNDS, frameBounds);
        } else {
            this.setMutableProperty(XUIEDITOR_FRAME_BOUNDS, "");
        }
    }

    public void setStateReleaseSchemaCache(boolean state) {
        this.setMutableProperty(XUIEDITOR_RELEASE_SCHEMA_CACHE, String.valueOf(state));
    }

    public void setShowingGlobalTree(boolean state) {
        this.setMutableProperty(XUIEDITOR_GLOBAL_TYPE_SETTINGS, String.valueOf(state));
    }

    public void setShowingInstanceDataInTree(boolean state) {
        this.setMutableProperty(XUIEDITOR_TREE_SHOW_INSTANCE_DATA, String.valueOf(state));
    }

    public void setShowingRulesTree(boolean state) {
        this.setMutableProperty(XUIEDITOR_SHOW_RULES_TREE, String.valueOf(state));
    }

    public void setLanguage(String language) {
        this.setMutableProperty(PROPERTY_LANGUAGE, language);
    }

    public void setHTMLServerLocation(String location) {
        this.setMutableProperty(PROPERTY_HTML_LOCATION, location);
    }

    public void setForcedLanguage(String language) {
        this.setMutableProperty(PROPERTY_FORCEDLANGUAGE, language);
    }

    public void setLookAndFeel(String lookAndFeel) {
        this.setMutableProperty(XUIEDITOR_LOOK_AND_FEEL, lookAndFeel);
    }

    public boolean isUsingXUINameLookup() {
        return this.getBooleanProperty(PROPERTY_UI_USE_XUI_NAME_LOOKUP);
    }

    public String getXUIXsdName() {
        URL xuiXsdUrl;
        String xuiXsdName = "xui.xsd";
        String xuiXsdPath = this.getStringProperty(XUIEDITOR_XUI_SCHEMA);
        if (xuiXsdPath != null && xuiXsdPath.length() > 0 && (xuiXsdUrl = URLHelper.getInternalURL(xuiXsdPath)) != null) {
            String filePath = xuiXsdUrl.getFile();
            xuiXsdName = filePath.substring(filePath.lastIndexOf("/") + 1);
        }
        return xuiXsdName;
    }

    public String getXuiXsdPath() {
        return this.getStringProperty(XUIEDITOR_XUI_SCHEMA);
    }

    public static boolean isRunningAsServer() {
        if (_isRunningAsServer == null) {
            _isRunningAsServer = Boolean.FALSE;
        }
        return _isRunningAsServer;
    }

    public void setIsRunningAsServer(boolean isRunningAsServer) {
        _isRunningAsServer = new Boolean(isRunningAsServer);
    }

    public String getXuiXsdUrl() {
        return this.getStringProperty(XUIEDITOR_XUI_SCHEMA);
    }

    public String getXuiXuiUrl() {
        return this.getStringProperty(XUIEDITOR_XUI_XUI);
    }

    public String getXuiRootName() {
        return this.getStringProperty(XUIEDITOR_XUI_ROOT);
    }

    public static String getPROPERTY_DOC_URL() {
        return PROPERTY_DOC_URL;
    }

    public static void setPROPERTY_DOC_URL(String propertyDocURL) {
        PROPERTY_DOC_URL = propertyDocURL;
    }

    public String getMessageTableCellRenderer() {
        return this.getStringProperty(PROPERTY_MESSAGE_TABLE_CELL_RENDERER);
    }

    public String getXuiEditorFormLayoutRowDefaults() {
        return this.getStringProperty(XUIEDITOR_FORMLAYOUT_ROW_DEF);
    }

    public String getXuiEditorFormLayoutColDefaults() {
        return this.getStringProperty(XUIEDITOR_FORMLAYOUT_COL_DEF);
    }

    public String getXuiEditorFormLayoutHeaderDefaults() {
        return this.getStringProperty(XUIEDITOR_FORMLAYOUT_HEADER_DEF);
    }

    public String getXuiEditorFormLayoutSepClassicDefaults() {
        return this.getStringProperty(XUIEDITOR_FORMLAYOUT_SEPCLASS_DEF);
    }

    public String getXuiEditorFormLayoutSepModernDefaults() {
        return this.getStringProperty(XUIEDITOR_FORMLAYOUT_SEPMODERN_DEF);
    }

    public boolean isSerializePreviewInSameWindow() {
        return this.getBooleanProperty(PROPERTY_SERIALIZEPREVIEW_INSAMEWINDOW);
    }

    public boolean isVersionCheckDisabled() {
        return this.getBooleanProperty(PROPERTY_XUI_VERSION_CHECK_DISABLED);
    }

    public static Image getImage(String imageName) {
        return ImageHelper.getInstance().getImage(imageName);
    }

    public static ImageIcon getImageIcon(URL baseURL, String imageName) {
        return ImageHelper.getInstance().getImageIcon(baseURL, imageName);
    }

    public static ImageIcon getImageIcon(String imageName) {
        return JAXFrontProperties.getImageIcon(null, imageName);
    }

    public boolean ignoreNamespace() {
        return this._ignoreNamespace;
    }

    public void setIgnoreNamespace(boolean ignore) {
        this._ignoreNamespace = ignore;
    }

    public boolean ignoreXMLNamespaceDeclaration() {
        return this._ignoreXMLNamespaceDeclaration;
    }

    public void setIgnoreXMLNamespaceDeclaration(boolean ignore) {
        this._ignoreXMLNamespaceDeclaration = ignore;
    }

    private void clearInstance() {
        _isRunningAsServer = null;
        this._useGlobalUIDefinitions = null;
        this._useElementNameOnly = null;
        this._useEmbeddedNLS = null;
        this._useOptimizedXpathEngine = null;
        this._useEdTypeCache = null;
        this._usePersistentIDGenerator = null;
        this._useSQLQueryCache = null;
        this._sQLQueryCacheSurviveTime = -1;
        this._properties = null;
        this._mutableProperties = null;
    }

    public void reload(URL propertyURL) {
        this.clearInstance();
        try {
            if (propertyURL != null) {
                this.initProperties(propertyURL);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reload(Document dom) {
        this.clearInstance();
        try {
            this.initProperties(dom);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setUseOptimizedXpathEngine(boolean optimized) {
        this._useOptimizedXpathEngine = new Boolean(optimized);
    }

    public boolean useOptimizedXpathEngine() {
        if (this._useOptimizedXpathEngine == null) {
            this._useOptimizedXpathEngine = this.getBooleanProperty(PROPERTY_UI_USE_OPTIMIZED_XPATH_ENGINE);
        }
        return this._useOptimizedXpathEngine;
    }

    public boolean useEditingTypeCache() {
        if (this._useEdTypeCache == null) {
            this._useEdTypeCache = this.getBooleanProperty(PROPERTY_UI_USE_EDITINGTYPE_CACHE);
            if (this.getStringProperty(PROPERTY_UI_USE_EDITINGTYPE_CACHE) == null) {
                this._useEdTypeCache = Boolean.TRUE;
            }
        }
        return this._useEdTypeCache;
    }

    public boolean useSQLQueryCache() {
        if (this._useSQLQueryCache == null) {
            this._useSQLQueryCache = this.getBooleanProperty(PROPERTY_UI_USE_SQL_QUERY_CACHE);
        }
        return this._useSQLQueryCache;
    }

    public int getSQLQuerySurviveTime() {
        if (this._sQLQueryCacheSurviveTime == -1) {
            this._sQLQueryCacheSurviveTime = StringUtil.getInt(this.getStringProperty(PROPERTY_UI_SQL_QUERY_CACHE_SURVIVE_TIME));
            if (this._sQLQueryCacheSurviveTime == 0) {
                this._sQLQueryCacheSurviveTime = 180;
            }
            this._sQLQueryCacheSurviveTime *= 1000;
        }
        return this._sQLQueryCacheSurviveTime;
    }

    public boolean usePersistentIDGenerator() {
        if (this._usePersistentIDGenerator == null) {
            this._usePersistentIDGenerator = this.getBooleanProperty(PROPERTY_UI_USE_PERSISTENTIDGENERATOR);
        }
        return this._usePersistentIDGenerator;
    }

    public void setUseEditingTypeCache(boolean cache) {
        this._useEdTypeCache = cache;
    }

    public boolean validateOptimizedXpathEngine() {
        return false;
    }

    public boolean isDBMode() {
        return true;
    }

    public String getJNDIMailLookup() {
        return this.getStringProperty(PROPERTY_JNDI_MAIL_LOOKUP);
    }

    public boolean handleOnlySpacesAsNull() {
        if (this._handleOnlySpacesAsNull == -1) {
            this._handleOnlySpacesAsNull = this.getBooleanProperty(PROPERTY_HANDLE_ONLY_SPACES_AS_NULL) ? 1 : 0;
        }
        return this._handleOnlySpacesAsNull == 1;
    }

    public void setHandleOnlySpacesAsNull(boolean asNull) {
        this._handleOnlySpacesAsNull = asNull ? 1 : 0;
    }

    public void setNLSReadingSequence(String[] langSeq) {
        this._nlsLangSequence = langSeq;
    }

    public String[] getNLSReadingSequence(String defaultLang) {
        if (this._nlsLangSequence == null) {
            String[] availableLanguages = this.getLanguages();
            availableLanguages = ArrayUtil.removeFromArray(availableLanguages, defaultLang);
            return ArrayUtil.addAtStartToArray(availableLanguages, defaultLang);
        }
        return this._nlsLangSequence;
    }

    public boolean isNLSReadingFieldScope() {
        return this._nlsReadingFieldScope;
    }

    public void setNLSReadingFieldScope(boolean fieldScope) {
        this._nlsReadingFieldScope = fieldScope;
    }

    public int getToolTipDelayTime() {
        int delayTime = 500;
        String delay = this.getStringProperty(PROPERTY_GUI_TOOLTIP_DELAY_TIME);
        if (delay != null) {
            try {
                delayTime = Integer.valueOf(delay);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return delayTime;
    }

    public int getToolTipDiscardTime() {
        int discardTime = 2000;
        String discard = this.getStringProperty(PROPERTY_GUI_TOOLTIP_DISCARD_TIME);
        if (discard != null) {
            try {
                discardTime = Integer.valueOf(discard);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return discardTime;
    }

    public String getJAXFormsCSS() {
        String style = this.getStringProperty(PROPERTY_HTML_STYLE_NAME_JAXFORMS);
        if (style == null) {
            style = "style/default/css/jaxforms.css";
        }
        return style;
    }

    public String getPasswordValidity() {
        String pwdValidity = this.getStringProperty(PROPERTY_PWD_PASSWORD_VALIDITY);
        if (pwdValidity == null) {
            pwdValidity = "90";
        }
        return pwdValidity;
    }

    public String getJAXFrontCSS() {
        String style = this.getStringProperty(PROPERTY_HTML_STYLE_NAME_JAXFRONT);
        if (style == null) {
            style = "style/default/css/jaxfront.css";
        }
        return style;
    }

    public String getJAXFrontJavaScript() {
        String style = this.getStringProperty(PROPERTY_HTML_JAVASCRIPT_JAXFRONT);
        if (style == null) {
            style = "js/jaxfront.js";
        }
        return style;
    }

    public String getJAXFormsJavaScript() {
        String style = this.getStringProperty(PROPERTY_HTML_JAVASCRIPT_JAXFORMS);
        if (style == null) {
            style = "js/jaxforms.css";
        }
        return style;
    }

    public void setJAXFormsCSS(String value) {
        if (value == null) {
            this.getProperties().remove(PROPERTY_HTML_STYLE_NAME_JAXFORMS);
        } else {
            this.setProperty(PROPERTY_HTML_STYLE_NAME_JAXFORMS, value, false);
        }
    }

    public void setJAXFrontCSS(String value) {
        if (value == null) {
            this.getProperties().remove(PROPERTY_HTML_STYLE_NAME_JAXFRONT);
        } else {
            this.setProperty(PROPERTY_HTML_STYLE_NAME_JAXFRONT, value, false);
        }
    }

    public void setJAXFrontJavaScript(String value) {
        if (value == null) {
            this.getProperties().remove(PROPERTY_HTML_JAVASCRIPT_JAXFRONT);
        } else {
            this.setProperty(PROPERTY_HTML_JAVASCRIPT_JAXFRONT, value, false);
        }
    }

    public void setJAXFormsJavaScript(String value) {
        if (value == null) {
            this.getProperties().remove(PROPERTY_HTML_JAVASCRIPT_JAXFORMS);
        } else {
            this.setProperty(PROPERTY_HTML_JAVASCRIPT_JAXFORMS, value, false);
        }
    }

    public int getSessionTimeout() {
        return StringUtil.getInt(this.getStringProperty(PROPERTY_SESSION_TIMEOUT), -1);
    }

    public void setSQLQuerySurviveTime(int time) {
        this._sQLQueryCacheSurviveTime = time;
    }

    public String[] getJMXClusterURLs() {
        String[] names = new String[]{};
        Iterator jaxProps = this.getProperties().entrySet().iterator();
        while (jaxProps.hasNext()) {
            Map.Entry propEntry = jaxProps.next();
            String pName = (String)propEntry.getKey();
            if (!pName.startsWith("JMX_CLUSTER_") || !pName.endsWith("_URL")) continue;
            String url = this.getValue(pName);
            String user = this.getValue(pName.substring(0, pName.length() - 4) + "_USER");
            String pwd = this.getValue(pName.substring(0, pName.length() - 4) + "_PWD");
            names = ArrayUtil.addToArray(names, new String[]{pName, url, user, pwd});
        }
        return names;
    }

    static {
        LOG_ENABLED = true;
        PROPERTY_DOC_URL = "jaxfront.xml";
        _oSSystemEncoding = null;
        DEFAULT_CONTEXT = null;
        GLOBAL_USE_XUI_CACHE = true;
        GLOBAL_USE_XSD_CACHE = true;
        GLOBAL_USE_CODES_CACHE = true;
        _registered = false;
    }
}

