/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.util.HTTPSHelper;
import com.jaxfront.core.util.JAXFrontBaseEntityResolver;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.util.URLHelper;
import com.jaxfront.core.util.io.FileHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLInputSource;

public class JAXFrontURLEntityResolver
extends JAXFrontBaseEntityResolver {
    private URL _baseURL = null;

    public JAXFrontURLEntityResolver(URL baseURL) {
        this._baseURL = baseURL;
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws XNIException, IOException {
        URL currentURL = this._baseURL;
        String newURL = null;
        if (currentURL == null) {
            return super.resolveEntity(resourceIdentifier);
        }
        if (resourceIdentifier.getBaseSystemId() != null) {
            String baseKey = this.createBaseKey(resourceIdentifier);
            String key = this.createKey(resourceIdentifier);
            JAXFrontBaseEntityResolver.ResourceLocation currentLocation = this.getBaseLocation(key);
            JAXFrontBaseEntityResolver.ResourceLocation parentLocation = this.getBaseLocation(baseKey);
            if (parentLocation == null) {
                this.setBaseLocation(baseKey, null, resourceIdentifier.getBaseSystemId());
                parentLocation = this.getBaseLocation(baseKey);
            }
            if (currentLocation == null) {
                String baseLocation = parentLocation.getBasePath();
                URL newBaseURI = new URL(JAXFrontURLEntityResolver.newURL(baseLocation, resourceIdentifier.getLiteralSystemId()));
                this.setBaseLocation(key, baseKey, newBaseURI.toString());
                currentURL = newBaseURI;
                newURL = currentURL.toString();
            } else {
                currentURL = new URL(currentLocation.getBasePath());
                newURL = JAXFrontURLEntityResolver.newURL(currentURL.toString(), resourceIdentifier.getLiteralSystemId());
            }
        } else {
            newURL = JAXFrontURLEntityResolver.newURL(currentURL.toString(), resourceIdentifier.getLiteralSystemId());
        }
        int idStart = currentURL.toString().indexOf("&id=");
        if (idStart >= 0) {
            InputStream input = HTTPSHelper.buildConnection(newURL).getInputStream();
            byte[] isBytes = FileHelper.read(input);
            ByteArrayInputStream bis = new ByteArrayInputStream(new String(isBytes, "UTF-8").getBytes());
            if (bis.available() == 0) {
                URL intURL = URLHelper.getInternalURL(resourceIdentifier.getLiteralSystemId());
                if (intURL != null) {
                    input = URLHelper.openStream(URLHelper.getInternalURL(resourceIdentifier.getLiteralSystemId()));
                }
                bis = new ByteArrayInputStream(FileHelper.read(input));
            }
            if (bis.available() > 0) {
                XMLInputSource inputSource = new XMLInputSource(resourceIdentifier.getPublicId(), resourceIdentifier.getExpandedSystemId(), resourceIdentifier.getLiteralSystemId(), input, "UTF-8");
                inputSource.setByteStream((InputStream)bis);
                return inputSource;
            }
            return null;
        }
        return super.resolveEntity(resourceIdentifier);
    }

    public static String getIDParam(String baseURL) {
        String newURL = baseURL;
        String idParam = null;
        int idStart = newURL.indexOf("&id=");
        if (idStart >= 0) {
            int idEnd = newURL.indexOf("&", idStart + 1);
            if (idEnd == -1) {
                idEnd = newURL.length();
            }
            idParam = newURL.substring(idStart + 4, idEnd);
        }
        return idParam;
    }

    public static String newURL(String baseURL, String relativeName) {
        String newURL = baseURL;
        String oldID = JAXFrontURLEntityResolver.getIDParam(baseURL);
        if (oldID != null) {
            URI newURI = URLHelper.resolve(oldID, relativeName);
            String newID = newURI.toString();
            newURL = TextTools.replace(newURL, oldID, newID);
        }
        return newURL;
    }

    public static String newURL(String baseURL, String id, String relativeName) {
        String newURL = baseURL;
        String oldId = JAXFrontURLEntityResolver.getIDParam(baseURL);
        if (id != null) {
            URI newURI = URLHelper.resolve(id, relativeName);
            String newID = newURI.toString();
            newURL = TextTools.replace(newURL, oldId, newID);
        }
        return newURL;
    }

    public String getBasePath() {
        return this._baseURL.toExternalForm();
    }
}

