/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class MRUHashtable
implements Runnable {
    public static final Comparator CACHE_ENTRY_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            int returnComp = 0;
            if (o1 != null && o2 != null) {
                returnComp = ((CacheEntry)o2).getHits() - ((CacheEntry)o1).getHits();
                if (returnComp == 0) {
                    returnComp = (int)(((CacheEntry)o2).getTime() - ((CacheEntry)o1).getTime());
                }
            } else if (o1 != null) {
                returnComp = -1;
            } else if (o2 != null) {
                returnComp = -1;
            }
            return returnComp;
        }
    };
    protected CacheEntry mru;
    protected CacheEntry lru;
    protected Hashtable lookupIndex = new Hashtable();
    protected long requests = 0L;
    protected long hitCount = 0L;
    protected int size = 0;
    protected int capacity;
    private boolean _running = false;
    private int _clearingInterval = 30000;
    private int _surviveTime = 30000;

    public MRUHashtable(int capacity) {
        this.setCapacity(capacity);
    }

    public synchronized void put(Object key, Object obj) {
        if (this.capacity == 0) {
            return;
        }
        if (this.lookupIndex.containsKey(key)) {
            this.remove(key);
        }
        if (this.isFull()) {
            this.remove(this.lru.key);
        }
        CacheEntry added = new CacheEntry();
        added.object = obj;
        added.key = key;
        added.time = System.currentTimeMillis();
        this.lookupIndex.put(key, added);
        if (this.isEmpty()) {
            this.lru = this.mru = added;
        } else {
            added.before = this.mru;
            this.mru.after = added;
        }
        ++this.size;
        this.mru = added;
    }

    public synchronized void put(Object key, Object obj, Object context) {
        this.put(key, obj, context, -1);
    }

    public synchronized void put(Object key, Object obj, Object context, int surviveTime) {
        if (this.capacity == 0) {
            return;
        }
        if (this.lookupIndex.containsKey(key)) {
            this.remove(key);
        }
        if (this.isFull()) {
            this.remove(this.lru.key);
        }
        CacheEntry added = new CacheEntry();
        added.object = obj;
        added.key = key;
        added.context = context;
        added.time = System.currentTimeMillis();
        added.surviveTime = surviveTime;
        this.lookupIndex.put(key, added);
        if (this.isEmpty()) {
            this.lru = this.mru = added;
        } else {
            added.before = this.mru;
            this.mru.after = added;
        }
        ++this.size;
        this.mru = added;
    }

    public synchronized void remove(Object key) {
        if (!this.lookupIndex.containsKey(key)) {
            return;
        }
        CacheEntry removed = (CacheEntry)this.lookupIndex.get(key);
        if (removed == this.lru) {
            this.lru = removed.after;
        } else {
            removed.before.after = removed.after;
        }
        if (removed == this.mru) {
            this.mru = removed.before;
        } else {
            removed.after.before = removed.before;
        }
        removed.object = null;
        removed.key = null;
        removed.time = 0L;
        removed.before = null;
        removed.after = null;
        this.lookupIndex.remove(key);
        --this.size;
    }

    public synchronized Object get(Object key) {
        ++this.requests;
        if (!this.lookupIndex.containsKey(key)) {
            return null;
        }
        ++this.hitCount;
        CacheEntry found = (CacheEntry)this.lookupIndex.get(key);
        if (found != this.mru) {
            found.after.before = found.before;
            if (found == this.lru) {
                this.lru = found.after;
            } else {
                found.before.after = found.after;
            }
            found.after = null;
            found.before = this.mru;
            this.mru.after = found;
            ++found.hits;
            this.mru = found;
        }
        return found.object;
    }

    public int getSizeInByte() {
        int size = 0;
        if (this.lru != null) {
            CacheEntry entry = this.lru;
            while (entry != null && entry != null) {
                Object o = entry.object;
                if (o instanceof byte[]) {
                    size += ((byte[])o).length;
                } else {
                    return -1;
                }
                entry = entry.after;
            }
        }
        return size;
    }

    public synchronized Object returnIfUpToDat(Object key, long time) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        CacheEntry found = (CacheEntry)this.lookupIndex.get(key);
        if (found.time >= time) {
            return value;
        }
        this.remove(key);
        return null;
    }

    public synchronized int getCurrentSize() {
        return this.size;
    }

    public synchronized int getCapacity() {
        return this.capacity;
    }

    public synchronized void setCapacity(int capacity) {
        if (capacity <= 0) {
            System.out.println("cache capacity must be >= 0");
        }
        while (this.size > capacity) {
            this.remove(this.lru.key);
        }
        this.capacity = capacity;
    }

    public synchronized boolean isFull() {
        return this.size == this.capacity;
    }

    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    public synchronized double getFillRate() {
        return this.capacity == 0 ? 1.0 : (double)this.size / (double)this.capacity;
    }

    public synchronized double getHitRate() {
        return this.requests == 0L ? 1.0 : (double)this.hitCount / (double)this.requests;
    }

    public synchronized void clear() {
        this.lookupIndex = new Hashtable();
        this.size = 0;
        this.lru = null;
        this.mru = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Total Capacity:").append(this.capacity).append("\n");
        sb.append(" Actual size:      ").append(this.size).append("\n");
        sb.append(" Actual fill rate: ").append(this.getFillRate()).append("\n");
        sb.append(" Actual hit rate:  ").append(this.getHitRate());
        sb.append(" Cache cleanup thread:").append(this.isRunning()).append("\n");
        sb.append(" ClearingInterval:").append(this._clearingInterval).append("ms.\n");
        sb.append(" ObjectSurviveTime:").append(this.getSurviveTime()).append("ms. \n");
        return sb.toString();
    }

    public Enumeration getKeyEntries() {
        return this.lookupIndex.elements();
    }

    public Object[] getKeyObjects() {
        return this.lookupIndex.values().toArray();
    }

    public Set keySet() {
        return this.lookupIndex.keySet();
    }

    public static void main(String[] args) throws Exception {
        MRUHashtable cache = new MRUHashtable(4);
        System.out.println(cache);
        cache.put("a", "Anton");
        cache.put("b", "Bohnen");
        cache.put("c", "Cache");
        System.out.println(cache);
        cache.get("d");
        cache.get("c");
        cache.put("d", "Dieter");
        cache.put("e", "Egon");
        cache.put("f", "Frank");
        cache.get("c");
        System.out.println(cache);
        cache.setPeriodicClear(true, 2000, 20);
    }

    public void setPeriodicClear(boolean removePeriodic, int interval, int surviveTime) {
        if (surviveTime <= 0 || interval <= 0) {
            return;
        }
        boolean wasRunning = this._running;
        this._running = removePeriodic;
        this._clearingInterval = interval;
        this._surviveTime = surviveTime;
        if (!wasRunning) {
            Thread t = new Thread(this);
            t.setName("MRU Periodic clear");
            t.start();
        }
    }

    public int getSlearingInterval() {
        return this._clearingInterval;
    }

    public int getSurviveTime() {
        return this._surviveTime;
    }

    public void stopPeriodicClear() {
        this._running = false;
    }

    public boolean isRunning() {
        return this._running;
    }

    public synchronized void run() {
        while (this.isRunning()) {
            try {
                this.wait(this._clearingInterval);
                if (this.isEmpty()) continue;
                if (this._surviveTime == 0) {
                    this.clear();
                    continue;
                }
                long now = System.currentTimeMillis();
                Object[] entries = this.lookupIndex.entrySet().toArray();
                for (int e = 0; e < entries.length; ++e) {
                    CacheEntry aEntry = (CacheEntry)((Map.Entry)entries[e]).getValue();
                    long duration = now - aEntry.getTime();
                    int sTime = this._surviveTime;
                    if (aEntry.surviveTime != -1) {
                        sTime = aEntry.surviveTime;
                    }
                    if (duration <= (long)sTime) continue;
                    this.remove(aEntry.getKey());
                }
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        }
    }

    public class CacheEntry {
        CacheEntry before;
        CacheEntry after;
        Object key;
        long time;
        Object object;
        Object context;
        int surviveTime = -1;
        int hits = 0;

        public Object getKey() {
            return this.key;
        }

        public long getTime() {
            return this.time;
        }

        public Object getContext() {
            return this.context;
        }

        public Object getValue() {
            return this.object;
        }

        public int getSurviveTime() {
            return this.surviveTime;
        }

        public int getHits() {
            return this.hits;
        }
    }
}

